/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.res2.DuplicateDataException;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ResourceMerger;
import com.android.ide.common.res2.ResourceSet;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.LogWrapper;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.RDotTxtParser;
import com.android.utils.ILogger;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileResourceRepository
extends LocalResourceRepository {
    private static final Logger LOG = Logger.getInstance(FileResourceRepository.class);
    protected final Map<ResourceType, ListMultimap<String, ResourceItem>> myItems;
    protected Collection<String> myAarDeclaredIds;
    private final File myFile;
    @Nullable
    private File myResourceTextFile;
    private static final Map<File, FileResourceRepository> ourCache = ContainerUtil.createSoftValueMap();

    private FileResourceRepository(@NotNull File file) {
        if (file == null) {
            FileResourceRepository.$$$reportNull$$$0(0);
        }
        super(file.getName());
        this.myItems = Maps.newEnumMap(ResourceType.class);
        this.myFile = file;
    }

    @NotNull
    static FileResourceRepository get(@NotNull File file, @Nullable String libraryName) {
        FileResourceRepository repository;
        if (file == null) {
            FileResourceRepository.$$$reportNull$$$0(1);
        }
        if ((repository = ourCache.get(file)) == null) {
            repository = FileResourceRepository.create(file, libraryName);
            ourCache.put(file, repository);
        }
        FileResourceRepository fileResourceRepository = repository;
        if (fileResourceRepository == null) {
            FileResourceRepository.$$$reportNull$$$0(2);
        }
        return fileResourceRepository;
    }

    @Nullable
    static FileResourceRepository getCached(@NotNull File file) {
        if (file == null) {
            FileResourceRepository.$$$reportNull$$$0(3);
        }
        return ourCache.get(file);
    }

    @NotNull
    private static FileResourceRepository create(@NotNull File file, @Nullable String libraryName) {
        if (file == null) {
            FileResourceRepository.$$$reportNull$$$0(4);
        }
        FileResourceRepository repository = new FileResourceRepository(file);
        try {
            ResourceMerger resourceMerger = FileResourceRepository.createResourceMerger(file, libraryName);
            resourceMerger.mergeData(repository.createMergeConsumer(), true);
        }
        catch (Exception e) {
            LOG.error("Failed to initialize resources", (Throwable)e);
        }
        File rDotTxt = new File(file.getParentFile(), "R.txt");
        if (rDotTxt.exists()) {
            repository.myResourceTextFile = rDotTxt;
            repository.myAarDeclaredIds = RDotTxtParser.getIdNames(rDotTxt);
        }
        FileResourceRepository fileResourceRepository = repository;
        if (fileResourceRepository == null) {
            FileResourceRepository.$$$reportNull$$$0(5);
        }
        return fileResourceRepository;
    }

    @Nullable
    File getResourceTextFile() {
        return this.myResourceTextFile;
    }

    public static void reset() {
        ourCache.clear();
    }

    public File getResourceDirectory() {
        return this.myFile;
    }

    private static ResourceMerger createResourceMerger(File file, String libraryName) {
        LogWrapper logger = new LogWrapper(LOG);
        ResourceMerger merger = new ResourceMerger(0);
        ResourceSet resourceSet = new ResourceSet(file.getName(), libraryName, false);
        resourceSet.addSource(file);
        resourceSet.setTrackSourcePositions(false);
        try {
            resourceSet.loadFromFiles((ILogger)logger);
        }
        catch (DuplicateDataException e) {
            assert (false);
        }
        catch (MergingException e) {
            LOG.warn((Throwable)e);
        }
        merger.addDataSet(resourceSet);
        return merger;
    }

    protected Map<ResourceType, ListMultimap<String, ResourceItem>> getMap() {
        return this.myItems;
    }

    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(ResourceType type, boolean create) {
        ArrayListMultimap multimap = this.myItems.get(type);
        if (multimap == null && create) {
            multimap = ArrayListMultimap.create();
            this.myItems.put(type, (ListMultimap<String, ResourceItem>)multimap);
        }
        return multimap;
    }

    @Nullable
    protected Collection<String> getAllDeclaredIds() {
        return this.myAarDeclaredIds;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " for " + this.myFile + ": @" + Integer.toHexString(System.identityHashCode((Object)this));
    }

    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)this.myFile, (!ApplicationManager.getApplication().isReadAccessAllowed() ? 1 : 0) != 0);
        if (virtualFile == null) {
            ImmutableSet immutableSet = ImmutableSet.of();
            if (immutableSet == null) {
                FileResourceRepository.$$$reportNull$$$0(6);
            }
            return immutableSet;
        }
        ImmutableSet immutableSet = ImmutableSet.of((Object)virtualFile);
        if (immutableSet == null) {
            FileResourceRepository.$$$reportNull$$$0(7);
        }
        return immutableSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/FileResourceRepository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/FileResourceRepository";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeResourceDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCached";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

