/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class DeployIapkTask
implements LaunchTask {
    @NotNull
    private final Collection<ApkInfo> myApks;

    public DeployIapkTask(@NotNull Collection<ApkInfo> apks) {
        if (apks == null) {
            DeployIapkTask.$$$reportNull$$$0(0);
        }
        this.myApks = apks;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Uploading and registering IAPK" == null) {
            DeployIapkTask.$$$reportNull$$$0(1);
        }
        return "Uploading and registering IAPK";
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        if (device == null) {
            DeployIapkTask.$$$reportNull$$$0(2);
        }
        if (launchStatus == null) {
            DeployIapkTask.$$$reportNull$$$0(3);
        }
        if (printer == null) {
            DeployIapkTask.$$$reportNull$$$0(4);
        }
        if (!this.myApks.iterator().hasNext()) {
            printer.stderr("No Iapk provided.");
            return false;
        }
        ApkInfo iapk = this.myApks.iterator().next();
        File localFile = iapk.getFile();
        if (!localFile.exists()) {
            String message = "The APK file " + localFile.getPath() + " does not exist on disk.";
            printer.stderr(message);
            return false;
        }
        String remotePath = "/sdcard/instantapps/" + localFile.getName();
        printer.stdout("$ adb push " + localFile + " " + remotePath);
        try {
            device.pushFile(localFile.getPath(), remotePath);
            CountDownLatch latch = new CountDownLatch(3);
            CollectingOutputReceiver receiver = new CollectingOutputReceiver(latch);
            printer.stdout("Starting / refreshing Instant App services");
            device.executeShellCommand("am startservice -a \"com.google.android.instantapps.devman.iapk.LOAD\" --es \"com.google.android.instantapps.devman.iapk.IAPK_PATH\" \"" + remotePath + "\" -n \"com.google.android.instantapps.devman\"/.iapk.IapkLoadService", (IShellOutputReceiver)receiver);
            device.executeShellCommand("pm clear com.google.android.instantapps.supervisor", (IShellOutputReceiver)receiver);
            device.executeShellCommand("am force-stop com.google.android.instantapps.supervisor", (IShellOutputReceiver)receiver);
            latch.await(3000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            printer.stderr(e.toString());
            return false;
        }
        printer.stdout("IAPK upload complete");
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/tasks/DeployIapkTask";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/tasks/DeployIapkTask";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

