/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.fd.client.InstantRunClient;
import com.android.tools.fd.client.InstantRunPushFailedException;
import com.android.tools.fd.client.UpdateMode;
import com.android.tools.idea.fd.DeployType;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunStatsService;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class HotSwapTask
implements LaunchTask {
    private final Project myProject;
    private final InstantRunContext myInstantRunContext;
    private final boolean myRestartActivity;

    public HotSwapTask(@NotNull Project project, @NotNull InstantRunContext context, boolean restartActivity) {
        if (project == null) {
            HotSwapTask.$$$reportNull$$$0(0);
        }
        if (context == null) {
            HotSwapTask.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myInstantRunContext = context;
        this.myRestartActivity = restartActivity;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Hotswapping changes" == null) {
            HotSwapTask.$$$reportNull$$$0(2);
        }
        return "Hotswapping changes";
    }

    @Override
    public int getDuration() {
        return 8;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        if (device == null) {
            HotSwapTask.$$$reportNull$$$0(3);
        }
        if (launchStatus == null) {
            HotSwapTask.$$$reportNull$$$0(4);
        }
        if (printer == null) {
            HotSwapTask.$$$reportNull$$$0(5);
        }
        InstantRunManager manager = InstantRunManager.get(this.myProject);
        UpdateMode updateMode = null;
        try {
            InstantRunClient instantRunClient = InstantRunManager.getInstantRunClient(this.myInstantRunContext);
            if (instantRunClient == null) {
                return HotSwapTask.terminateLaunch(launchStatus, "Unable to connect to application. Press Run or Debug to rebuild and install the app.");
            }
            updateMode = manager.pushArtifacts(device, this.myInstantRunContext, this.myRestartActivity ? UpdateMode.WARM_SWAP : UpdateMode.HOT_SWAP);
            printer.stdout("Hot swapped changes, activity " + (updateMode == UpdateMode.HOT_SWAP ? "not restarted" : "restarted"));
        }
        catch (InstantRunPushFailedException | IOException e) {
            return HotSwapTask.terminateLaunch(launchStatus, "Error installing hot swap patches: " + e);
        }
        InstantRunStatsService.get(this.myProject).notifyDeployType(DeployType.HOTSWAP, this.myInstantRunContext, device);
        return true;
    }

    private static boolean terminateLaunch(LaunchStatus launchStatus, String msg) {
        launchStatus.terminateLaunch(msg);
        InstantRunManager.LOG.info("Terminating launch: " + msg);
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/tasks/HotSwapTask";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/tasks/HotSwapTask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

