/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.repository.api.InstallerFactory;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.install.StudioSdkInstallerUtil;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.ThrottledProgressWrapper;
import com.android.tools.idea.sdk.wizard.InstallTask;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.validation.Validator;
import com.android.tools.idea.ui.validation.ValidatorPanel;
import com.android.tools.idea.ui.validation.validators.FalseValidator;
import com.android.tools.idea.ui.validation.validators.TrueValidator;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InstallSelectedPackagesStep
extends ModelWizardStep.WithoutModel {
    private final BoolProperty myInstallFailed;
    private final BoolProperty myInstallationFinished;
    private final StudioWizardStepPanel myStudioPanel;
    private final ValidatorPanel myValidatorPanel;
    private final AndroidSdkHandler mySdkHandler;
    private JPanel myContentPanel;
    private JBLabel myLabelSdkPath;
    private JBLabel myProgressOverallLabel;
    private JTextArea mySdkManagerOutput;
    private JProgressBar myProgressBar;
    private JBLabel myProgressDetailLabel;
    private List<UpdatablePackage> myInstallRequests;
    private Collection<LocalPackage> myUninstallRequests;
    private final RepoManager myRepoManager;
    private com.android.repository.api.ProgressIndicator myLogger;
    private static final Object LOGGER_LOCK = new Object();
    private final BackgroundAction myBackgroundAction;
    private final boolean myBackgroundable;

    public InstallSelectedPackagesStep(@NotNull List<UpdatablePackage> installRequests, @NotNull Collection<LocalPackage> uninstallRequests, @NotNull AndroidSdkHandler sdkHandler, boolean backgroundable) {
        if (installRequests == null) {
            InstallSelectedPackagesStep.$$$reportNull$$$0(0);
        }
        if (uninstallRequests == null) {
            InstallSelectedPackagesStep.$$$reportNull$$$0(1);
        }
        if (sdkHandler == null) {
            InstallSelectedPackagesStep.$$$reportNull$$$0(2);
        }
        super("Component Installer");
        this.$$$setupUI$$$();
        this.myInstallFailed = new BoolValueProperty();
        this.myInstallationFinished = new BoolValueProperty();
        this.myBackgroundAction = new BackgroundAction();
        this.myInstallRequests = installRequests;
        this.myUninstallRequests = uninstallRequests;
        this.myRepoManager = sdkHandler.getSdkManager((com.android.repository.api.ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass()));
        this.myValidatorPanel = new ValidatorPanel(this, this.myContentPanel);
        this.myStudioPanel = new StudioWizardStepPanel(this.myValidatorPanel, "Installing Requested Components");
        this.myBackgroundable = backgroundable;
        this.mySdkHandler = sdkHandler;
    }

    @Override
    public Action getExtraAction() {
        return this.myBackgroundable ? this.myBackgroundAction : null;
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            InstallSelectedPackagesStep.$$$reportNull$$$0(3);
        }
        String finishedText = "Please wait until the installation finishes";
        this.myValidatorPanel.registerValidator(this.myInstallationFinished, new TrueValidator(Validator.Severity.INFO, finishedText));
        String installError = "Installation did not complete successfully. See the IDE log for details";
        this.myValidatorPanel.registerValidator(this.myInstallFailed, new FalseValidator(installError));
        this.myBackgroundAction.setWizard(wizard);
    }

    @Override
    protected void onEntering() {
        this.mySdkManagerOutput.setText("");
        this.myLabelSdkPath.setText(this.myRepoManager.getLocalPath().getPath());
        this.startSdkInstall();
    }

    @Override
    protected boolean shouldShow() {
        return !this.myInstallRequests.isEmpty() || !this.myUninstallRequests.isEmpty();
    }

    @Override
    public boolean canGoBack() {
        return false;
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        BoolProperty boolProperty = this.myInstallationFinished;
        if (boolProperty == null) {
            InstallSelectedPackagesStep.$$$reportNull$$$0(4);
        }
        return boolProperty;
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        StudioWizardStepPanel studioWizardStepPanel = this.myStudioPanel;
        if (studioWizardStepPanel == null) {
            InstallSelectedPackagesStep.$$$reportNull$$$0(5);
        }
        return studioWizardStepPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = LOGGER_LOCK;
        synchronized (object) {
            if (this.myLogger != null && !this.myBackgroundAction.isBackgrounded()) {
                this.myLogger.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSdkInstall() {
        CustomLogger customLogger = new CustomLogger();
        Object object = LOGGER_LOCK;
        synchronized (object) {
            this.myLogger = new ThrottledProgressWrapper(customLogger);
        }
        Function<List<RepoPackage>, Void> completeCallback = failures -> {
            UIUtil.invokeLaterIfNeeded(() -> {
                this.myProgressBar.setValue(100);
                this.myProgressOverallLabel.setText("");
                if (!failures.isEmpty()) {
                    this.myInstallFailed.set(true);
                    this.myProgressBar.setEnabled(false);
                } else {
                    this.myProgressDetailLabel.setText("Done");
                    InstallSelectedPackagesStep.checkForUpgrades(this.myInstallRequests);
                }
                this.myInstallationFinished.set(true);
            });
            return null;
        };
        InstallerFactory factory = StudioSdkInstallerUtil.createInstallerFactory(this.mySdkHandler);
        InstallTask task = new InstallTask(factory, this.mySdkHandler, StudioSettingsController.getInstance(), this.myLogger);
        task.setInstallRequests(this.myInstallRequests);
        task.setUninstallRequests(this.myUninstallRequests);
        task.setCompleteCallback(completeCallback);
        task.setPrepareCompleteCallback(() -> this.myBackgroundAction.setEnabled(false));
        boolean hasOpenProjects = ProjectManager.getInstance().getOpenProjects().length > 0;
        Object indicator = hasOpenProjects ? new BackgroundableProcessIndicator((Task.Backgroundable)task) : new EmptyProgressIndicator();
        customLogger.setIndicator((ProgressIndicator)indicator);
        this.myLogger.logInfo("To install:");
        for (UpdatablePackage p : this.myInstallRequests) {
            this.myLogger.logInfo(String.format("- %1$s (%2$s)", p.getRemote().getDisplayName(), p.getRemote().getPath()));
        }
        this.myLogger.logInfo("");
        ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task, (ProgressIndicator)indicator);
    }

    private static void checkForUpgrades(@Nullable List<UpdatablePackage> completedChanges) {
        if (completedChanges == null) {
            return;
        }
        int highestNewApiLevel = 0;
        for (UpdatablePackage updated : completedChanges) {
            int api;
            TypeDetails details = updated.getRepresentative().getTypeDetails();
            if (!(details instanceof DetailsTypes.PlatformDetailsType) || (api = ((DetailsTypes.PlatformDetailsType)details).getApiLevel()) <= highestNewApiLevel) continue;
            highestNewApiLevel = api;
        }
        if (highestNewApiLevel > 0) {
            PropertiesComponent.getInstance().setValue(WizardConstants.NEWLY_INSTALLED_API_KEY.name, highestNewApiLevel, -1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installRequests";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uninstallRequests";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/sdk/wizard/InstallSelectedPackagesStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/sdk/wizard/InstallSelectedPackagesStep";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "canGoForward";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onWizardStarting";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JProgressBar jProgressBar;
        JBLabel jBLabel2;
        JTextArea jTextArea;
        JBLabel jBLabel3;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("SDK Path:");
        jPanel.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLabelSdkPath = jBLabel3 = new JBLabel();
        jBLabel3.setText("<placeholder path>");
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setVerticalScrollBarPolicy(22);
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        this.mySdkManagerOutput = jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jBScrollPane.setViewportView(jTextArea);
        this.myProgressOverallLabel = jBLabel2 = new JBLabel();
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myProgressBar = jProgressBar = new JProgressBar();
        jPanel.add((Component)jProgressBar, new GridConstraints(3, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        this.myProgressDetailLabel = jBLabel = new JBLabel();
        jBLabel.setBackground(new Color(-3355444));
        jBLabel.setHorizontalTextPosition(10);
        jBLabel.setVerticalAlignment(1);
        jPanel.add((Component)jBLabel, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 2, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private static class BackgroundAction
    extends AbstractAction {
        private boolean myIsBackgrounded = false;
        private ModelWizard.Facade myWizard;

        public BackgroundAction() {
            super("Background");
        }

        public void setWizard(@NotNull ModelWizard.Facade wizard) {
            if (wizard == null) {
                BackgroundAction.$$$reportNull$$$0(0);
            }
            this.myWizard = wizard;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myIsBackgrounded = true;
            this.myWizard.cancel();
        }

        public boolean isBackgrounded() {
            return this.myIsBackgrounded;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizard", "com/android/tools/idea/sdk/wizard/InstallSelectedPackagesStep$BackgroundAction", "setWizard"));
        }
    }

    private final class CustomLogger
    implements com.android.repository.api.ProgressIndicator {
        private ProgressIndicator myIndicator;
        private boolean myCancelled;
        private Logger myLogger = Logger.getInstance(this.getClass());

        private CustomLogger() {
        }

        public void setText(@Nullable String s) {
            UIUtil.invokeLaterIfNeeded(() -> InstallSelectedPackagesStep.this.myProgressOverallLabel.setText(s));
            if (this.myIndicator != null) {
                this.myIndicator.setText(s);
            }
        }

        public boolean isCanceled() {
            return this.myCancelled;
        }

        public void cancel() {
            this.myCancelled = true;
            if (this.myIndicator != null) {
                this.myIndicator.cancel();
            }
        }

        public void setCancellable(boolean cancellable) {
        }

        public boolean isCancellable() {
            return true;
        }

        public void setIndeterminate(boolean indeterminate) {
            UIUtil.invokeLaterIfNeeded(() -> InstallSelectedPackagesStep.this.myProgressBar.setIndeterminate(indeterminate));
            if (this.myIndicator != null) {
                this.myIndicator.setIndeterminate(indeterminate);
            }
        }

        public boolean isIndeterminate() {
            return InstallSelectedPackagesStep.this.myProgressBar.isIndeterminate();
        }

        public void setFraction(double v) {
            UIUtil.invokeLaterIfNeeded(() -> {
                InstallSelectedPackagesStep.this.myProgressBar.setIndeterminate(false);
                InstallSelectedPackagesStep.this.myProgressBar.setValue((int)(v * (double)(InstallSelectedPackagesStep.this.myProgressBar.getMaximum() - InstallSelectedPackagesStep.this.myProgressBar.getMinimum())));
            });
            if (this.myIndicator != null) {
                this.myIndicator.setFraction(v);
            }
        }

        public double getFraction() {
            return InstallSelectedPackagesStep.this.myProgressBar.getPercentComplete();
        }

        public void setSecondaryText(@Nullable String s) {
            UIUtil.invokeLaterIfNeeded(() -> InstallSelectedPackagesStep.this.myProgressDetailLabel.setText(s));
            if (this.myIndicator != null) {
                this.myIndicator.setText2(s);
            }
        }

        public void logWarning(@NotNull String s) {
            if (s == null) {
                CustomLogger.$$$reportNull$$$0(0);
            }
            this.appendText(s);
            this.myLogger.warn(s);
        }

        public void logWarning(@NotNull String s, @Nullable Throwable e) {
            if (s == null) {
                CustomLogger.$$$reportNull$$$0(1);
            }
            this.appendText(s);
            this.myLogger.warn(s, e);
        }

        public void logError(@NotNull String s) {
            if (s == null) {
                CustomLogger.$$$reportNull$$$0(2);
            }
            this.appendText(s);
            this.myLogger.error(s);
        }

        public void logError(@NotNull String s, @Nullable Throwable e) {
            if (s == null) {
                CustomLogger.$$$reportNull$$$0(3);
            }
            this.appendText(s);
            this.myLogger.error(s, e);
        }

        public void logInfo(@NotNull String s) {
            if (s == null) {
                CustomLogger.$$$reportNull$$$0(4);
            }
            this.appendText(s);
            this.myLogger.info(s);
        }

        private void appendText(@NotNull String s) {
            if (s == null) {
                CustomLogger.$$$reportNull$$$0(5);
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (s == null) {
                    CustomLogger.$$$reportNull$$$0(6);
                }
                String current = InstallSelectedPackagesStep.this.mySdkManagerOutput.getText();
                String separator = "\n";
                if (current == null) {
                    current = "";
                } else if (current.endsWith("\n")) {
                    separator = "";
                }
                InstallSelectedPackagesStep.this.mySdkManagerOutput.setText(current + separator + s);
            });
        }

        public void setIndicator(ProgressIndicator indicator) {
            this.myIndicator = indicator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "s";
            objectArray2[1] = "com/android/tools/idea/sdk/wizard/InstallSelectedPackagesStep$CustomLogger";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "logWarning";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "logError";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "logInfo";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$appendText$4";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

