/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.actions.AndroidActionGroupRemover;
import com.android.tools.idea.actions.AndroidImportModuleAction;
import com.android.tools.idea.actions.AndroidImportProjectAction;
import com.android.tools.idea.actions.AndroidNewModuleAction;
import com.android.tools.idea.actions.AndroidNewModuleInGroupAction;
import com.android.tools.idea.actions.AndroidNewProjectAction;
import com.android.tools.idea.actions.AndroidOpenFileAction;
import com.android.tools.idea.actions.CreateLibraryFromFilesAction;
import com.android.tools.idea.gradle.actions.AndroidTemplateProjectSettingsGroup;
import com.android.tools.idea.gradle.actions.AndroidTemplateProjectStructureAction;
import com.android.tools.idea.gradle.util.PropertiesFiles;
import com.android.tools.idea.npw.WizardUtils;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.VersionCheck;
import com.android.tools.idea.startup.Actions;
import com.android.tools.idea.startup.AndroidCodeStyleSettingsModifier;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.wizard.AndroidStudioWelcomeScreenProvider;
import com.android.utils.Pair;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.actions.TemplateProjectSettingsGroup;
import com.intellij.ide.projectView.actions.MarkRootGroup;
import com.intellij.ide.projectView.impl.MoveModuleToGroupTopLevel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Properties;
import javax.swing.event.HyperlinkEvent;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.jetbrains.android.AndroidPlugin;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleSpecificInitializer
implements Runnable {
    private static final Logger LOG = Logger.getInstance(GradleSpecificInitializer.class);
    @NonNls
    private static final String ANDROID_SDK_FOLDER_NAME = "sdk";
    private static final String[] ANDROID_SDK_RELATIVE_PATHS = new String[]{"sdk", File.separator + ".." + File.separator + "sdk"};

    @Override
    public void run() {
        CodeStyleSettings settings;
        GradleSpecificInitializer.setUpNewProjectActions();
        GradleSpecificInitializer.setUpWelcomeScreenActions();
        GradleSpecificInitializer.replaceProjectPopupActions();
        GradleSpecificInitializer.checkInstallPath();
        ActionManager actionManager = ActionManager.getInstance();
        AnAction pluginAction = actionManager.getAction("StartupWizard");
        pluginAction.getTemplatePresentation().setVisible(false);
        if (AndroidSdkUtils.isAndroidSdkManagerEnabled()) {
            try {
                GradleSpecificInitializer.setupSdks();
                GradleSpecificInitializer.checkAndroidSdkHome();
            }
            catch (Exception e) {
                LOG.error("Unexpected error while setting up SDKs: ", (Throwable)e);
            }
            GradleSpecificInitializer.checkAndSetAndroidSdkSources();
        }
        GradleSpecificInitializer.registerAppClosing();
        CodeStyleScheme scheme = CodeStyleSchemes.getInstance().getDefaultScheme();
        if (scheme != null && (settings = scheme.getCodeStyleSettings()) != null) {
            AndroidCodeStyleSettingsModifier.modify(settings);
        }
    }

    private static void checkInstallPath() {
        if (PathManager.getHomePath().contains("!")) {
            final Application app = ApplicationManager.getApplication();
            app.getMessageBus().connect((Disposable)app).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

                public void appStarting(Project project) {
                    app.invokeLater(() -> {
                        String message = String.format("%1$s must not be installed in a path containing '!' or Gradle sync will fail!", ApplicationNamesInfo.getInstance().getProductName());
                        Notification notification = GradleSpecificInitializer.getNotificationGroup().createNotification(message, NotificationType.ERROR);
                        notification.setImportant(true);
                        Notifications.Bus.notify((Notification)notification);
                    });
                }
            });
        }
    }

    private static void setUpNewProjectActions() {
        Actions.replaceAction("OpenFile", (AnAction)new AndroidOpenFileAction());
        Actions.replaceAction("NewProject", new AndroidNewProjectAction());
        Actions.replaceAction("NewModule", new AndroidNewModuleAction());
        Actions.replaceAction("NewModuleInGroup", new AndroidNewModuleInGroupAction());
        Actions.replaceAction("ImportProject", new AndroidImportProjectAction());
        Actions.replaceAction("CreateLibraryFromFile", new CreateLibraryFromFilesAction());
        Actions.replaceAction("ImportModule", new AndroidImportModuleAction());
        Actions.hideAction("GenerateAntBuild");
        Actions.hideAction("AddFrameworkSupport");
        Actions.hideAction("BuildArtifact");
        Actions.hideAction("RunTargetAction");
    }

    private static void setUpWelcomeScreenActions() {
        AnAction child;
        DefaultActionGroup settingsGroup;
        AnAction[] children;
        AnAction configureIdeaAction;
        System.setProperty("ide.new.welcome.screen.force", "true");
        Actions.replaceAction("WelcomeScreen.OpenProject", (AnAction)new AndroidOpenFileAction("Open an existing Android Studio project"));
        Actions.replaceAction("WelcomeScreen.CreateNewProject", new AndroidNewProjectAction("Start a new Android Studio project"));
        Actions.replaceAction("WelcomeScreen.ImportProject", new AndroidImportProjectAction("Import project (Eclipse ADT, Gradle, etc.)"));
        Actions.replaceAction("TemplateProjectStructure", (AnAction)new AndroidTemplateProjectStructureAction("Default Project Structure..."));
        Actions.moveAction("WelcomeScreen.ImportProject", "WelcomeScreen.QuickStart.IDEA", "WelcomeScreen.QuickStart", new Constraints(Anchor.AFTER, "WelcomeScreen.GetFromVcs"));
        ActionManager actionManager = ActionManager.getInstance();
        AnAction getFromVcsAction = actionManager.getAction("WelcomeScreen.GetFromVcs");
        if (getFromVcsAction != null) {
            getFromVcsAction.getTemplatePresentation().setText("Check out project from Version Control");
        }
        if ((configureIdeaAction = actionManager.getAction("WelcomeScreen.Configure.IDEA")) instanceof DefaultActionGroup && (children = (settingsGroup = (DefaultActionGroup)configureIdeaAction).getChildren(null)).length == 1 && (child = children[0]) instanceof TemplateProjectSettingsGroup) {
            settingsGroup.replaceAction(child, (AnAction)new AndroidTemplateProjectSettingsGroup());
        }
    }

    private static void replaceProjectPopupActions() {
        ArrayDeque<Pair> stack = new ArrayDeque<Pair>();
        stack.add(Pair.of(null, (Object)ActionManager.getInstance().getAction("ProjectViewPopupMenu")));
        while (!stack.isEmpty()) {
            Pair entry = (Pair)stack.pop();
            DefaultActionGroup parent = (DefaultActionGroup)entry.getFirst();
            AnAction action = (AnAction)entry.getSecond();
            if (action instanceof DefaultActionGroup) {
                DefaultActionGroup actionGroup = (DefaultActionGroup)action;
                for (AnAction child : actionGroup.getChildActionsOrStubs()) {
                    stack.push(Pair.of((Object)actionGroup, (Object)child));
                }
            }
            if (action instanceof MoveModuleToGroupTopLevel) {
                parent.remove(action);
                parent.add((AnAction)new AndroidActionGroupRemover((ActionGroup)action, "Move Module to Group"), new Constraints(Anchor.AFTER, "OpenModuleSettings"));
                continue;
            }
            if (!(action instanceof MarkRootGroup)) continue;
            parent.remove(action);
            parent.add((AnAction)new AndroidActionGroupRemover((ActionGroup)action, "Mark Directory As"), new Constraints(Anchor.AFTER, "OpenModuleSettings"));
        }
    }

    private static void notifyInvalidSdk() {
        String key = "android.invalid.sdk.message";
        String message = AndroidBundle.message(key, new Object[0]);
        NotificationListener.Adapter listener = new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                ActionManager actionManager = ActionManager.getInstance();
                AnAction sdkManagerAction = actionManager.getAction("Android.RunAndroidSdkManager");
                sdkManagerAction.actionPerformed(null);
                notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/startup/GradleSpecificInitializer$2";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        GradleSpecificInitializer.addStartupWarning(message, (NotificationListener)listener);
    }

    private static void addStartupWarning(final @NotNull String message, final @Nullable NotificationListener listener) {
        if (message == null) {
            GradleSpecificInitializer.$$$reportNull$$$0(0);
        }
        final Application app = ApplicationManager.getApplication();
        app.getMessageBus().connect((Disposable)app).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            public void appStarting(Project project) {
                app.invokeLater(() -> {
                    if (message == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    Notification notification = GradleSpecificInitializer.getNotificationGroup().createNotification("SDK Validation", message, NotificationType.WARNING, listener);
                    notification.setImportant(true);
                    Notifications.Bus.notify((Notification)notification);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/startup/GradleSpecificInitializer$3", "lambda$appStarting$0"));
            }
        });
    }

    private static NotificationGroup getNotificationGroup() {
        NotificationGroup group = NotificationGroup.findRegisteredGroup((String)"System Health");
        if (group == null) {
            group = new NotificationGroup("Gradle Initializer", NotificationDisplayType.STICKY_BALLOON, true);
        }
        return group;
    }

    private static void setupSdks() {
        IdeSdks ideSdks = IdeSdks.getInstance();
        File androidHome = ideSdks.getAndroidSdkPath();
        if (androidHome != null) {
            String androidHomePath = androidHome.getAbsolutePath();
            WizardUtils.ValidationResult result = WizardUtils.validateLocation(androidHomePath, "Android SDK location", false, WizardUtils.WritableCheckMode.DO_NOT_CHECK);
            if (result.isError()) {
                GradleSpecificInitializer.notifyInvalidSdk();
            }
            return;
        }
        if (AndroidPlugin.isGuiTestingMode()) {
            return;
        }
        Sdk sdk = GradleSpecificInitializer.findFirstCompatibleAndroidSdk();
        if (sdk != null) {
            String sdkHomePath = sdk.getHomePath();
            assert (sdkHomePath != null);
            ideSdks.createAndroidSdkPerAndroidTarget(new File(FileUtil.toSystemDependentName((String)sdkHomePath)));
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            File androidSdkPath = GradleSpecificInitializer.getAndroidSdkPath();
            if (androidSdkPath == null) {
                return;
            }
            FirstRunWizardMode wizardMode = AndroidStudioWelcomeScreenProvider.getWizardMode();
            boolean promptSdkSelection = wizardMode == null;
            Sdk sdk1 = AndroidSdkUtils.createNewAndroidPlatform(androidSdkPath.getPath(), promptSdkSelection);
            if (sdk1 != null) {
                String sdkNamePrefix = "Android ";
                if (sdk1.getName().startsWith(sdkNamePrefix)) {
                    Sdk jdk;
                    SdkModificator sdkModificator = sdk1.getSdkModificator();
                    sdkModificator.setName(sdkNamePrefix + sdk1.getName().substring(sdkNamePrefix.length()));
                    sdkModificator.commitChanges();
                    AndroidSdkAdditionalData additionalData = AndroidSdks.getInstance().getAndroidSdkAdditionalData(sdk1);
                    if (additionalData != null && (jdk = additionalData.getJavaSdk()) != null) {
                        sdkModificator = jdk.getSdkModificator();
                        sdkModificator.setName("JDK");
                        sdkModificator.commitChanges();
                    }
                    ideSdks.createAndroidSdkPerAndroidTarget(androidSdkPath);
                }
            }
        });
    }

    private static void checkAndroidSdkHome() {
        try {
            AndroidLocation.checkAndroidSdkHome();
        }
        catch (AndroidLocation.AndroidLocationException e) {
            GradleSpecificInitializer.addStartupWarning(e.getMessage(), null);
        }
    }

    @Nullable
    private static Sdk findFirstCompatibleAndroidSdk() {
        List<Sdk> sdks = AndroidSdks.getInstance().getAllAndroidSdks();
        for (Sdk sdk : sdks) {
            String sdkPath = sdk.getHomePath();
            if (!VersionCheck.isCompatibleVersion(sdkPath)) continue;
            return sdk;
        }
        if (!sdks.isEmpty()) {
            return sdks.get(0);
        }
        return null;
    }

    @Nullable
    private static File getAndroidSdkPath() {
        String studioHome = PathManager.getHomePath();
        if (StringUtil.isEmpty((String)studioHome)) {
            LOG.info("Unable to find Studio home directory");
        } else {
            LOG.info(String.format("Found Studio home directory at: '%1$s'", studioHome));
            for (String path : ANDROID_SDK_RELATIVE_PATHS) {
                File dir = new File(studioHome, path);
                String absolutePath = FileUtil.toCanonicalPath((String)dir.getAbsolutePath());
                LOG.info(String.format("Looking for Android SDK at '%1$s'", absolutePath));
                if (!AndroidSdkType.getInstance().isValidSdkHome(absolutePath)) continue;
                LOG.info(String.format("Found Android SDK at '%1$s'", absolutePath));
                return new File(absolutePath);
            }
        }
        LOG.info("Unable to locate SDK within the Android studio installation.");
        String androidHomeValue = System.getenv("ANDROID_HOME");
        String msg = String.format("Checking if ANDROID_HOME is set: '%1$s' is '%2$s'", "ANDROID_HOME", androidHomeValue);
        LOG.info(msg);
        if (!StringUtil.isEmpty((String)androidHomeValue) && AndroidSdkType.getInstance().isValidSdkHome(androidHomeValue)) {
            LOG.info("Using Android SDK specified by the environment variable.");
            return new File(FileUtil.toSystemDependentName((String)androidHomeValue));
        }
        String toolsPreferencePath = AndroidLocation.getFolderWithoutWrites();
        String sdkPath = GradleSpecificInitializer.getLastSdkPathUsedByAndroidTools(toolsPreferencePath);
        msg = !StringUtil.isEmpty((String)sdkPath) && AndroidSdkType.getInstance().isValidSdkHome(androidHomeValue) ? String.format("Last SDK used by Android tools: '%1$s'", sdkPath) : "Unable to locate last SDK used by Android tools";
        LOG.info(msg);
        return sdkPath == null ? null : new File(FileUtil.toSystemDependentName((String)sdkPath));
    }

    @Nullable
    private static String getLastSdkPathUsedByAndroidTools(@Nullable String path) {
        if (path == null) {
            return null;
        }
        File file = new File(path, "ddms.cfg");
        if (!file.exists()) {
            return null;
        }
        try {
            Properties properties = PropertiesFiles.getProperties(file);
            return properties.getProperty("lastSdkPath");
        }
        catch (IOException e) {
            return null;
        }
    }

    private static void registerAppClosing() {
        Application app = ApplicationManager.getApplication();
        MessageBusConnection connection = app.getMessageBus().connect((Disposable)app);
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            public void appClosing() {
                try {
                    DefaultGradleConnector.close();
                }
                catch (RuntimeException e) {
                    LOG.info("Failed to stop Gradle daemons during IDE shutdown", (Throwable)e);
                }
            }
        });
    }

    private static void checkAndSetAndroidSdkSources() {
        for (Sdk sdk : AndroidSdks.getInstance().getAllAndroidSdks()) {
            GradleSpecificInitializer.checkAndSetSources(sdk);
        }
    }

    private static void checkAndSetSources(@NotNull Sdk sdk) {
        VirtualFile[] storedSources;
        if (sdk == null) {
            GradleSpecificInitializer.$$$reportNull$$$0(1);
        }
        if ((storedSources = sdk.getRootProvider().getFiles(OrderRootType.SOURCES)).length > 0) {
            return;
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(sdk);
        if (platform != null) {
            SdkModificator sdkModificator = sdk.getSdkModificator();
            IAndroidTarget target = platform.getTarget();
            AndroidSdks.getInstance().findAndSetPlatformSources(target, sdkModificator);
            sdkModificator.commitChanges();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = ANDROID_SDK_FOLDER_NAME;
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/startup/GradleSpecificInitializer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addStartupWarning";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAndSetSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

