/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.scopes;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaArtifact;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.SourceProvider;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependencySet;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.testartifacts.scopes.ExcludedModules;
import com.android.utils.FileUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExcludedRoots {
    @NotNull
    private final Module myModule;
    @NotNull
    private final ExcludedModules myExcludedModules;
    private final boolean myAndroidTest;
    @NotNull
    private final Set<File> myExcludedRoots;
    @NotNull
    private final Set<String> myIncludedRootNames;

    ExcludedRoots(@NotNull Module module, @NotNull ExcludedModules excludedModules, @NotNull DependencySet dependenciesToExclude, @NotNull DependencySet dependenciesToInclude, boolean isAndroidTest) {
        if (module == null) {
            ExcludedRoots.$$$reportNull$$$0(0);
        }
        if (excludedModules == null) {
            ExcludedRoots.$$$reportNull$$$0(1);
        }
        if (dependenciesToExclude == null) {
            ExcludedRoots.$$$reportNull$$$0(2);
        }
        if (dependenciesToInclude == null) {
            ExcludedRoots.$$$reportNull$$$0(3);
        }
        this.myExcludedRoots = new HashSet<File>();
        this.myIncludedRootNames = new HashSet<String>();
        this.myModule = module;
        this.myExcludedModules = excludedModules;
        this.myAndroidTest = isAndroidTest;
        this.addFolderPathsFromExcludedModules();
        this.addRemainingModelsIfNecessary();
        for (LibraryDependency libraryDependency : dependenciesToInclude.onLibraries()) {
            File[] binaryPaths;
            for (File binaryPath : binaryPaths = libraryDependency.getPaths(LibraryDependency.PathType.BINARY)) {
                this.myIncludedRootNames.add(binaryPath.getName());
            }
        }
        this.addLibraryPaths(dependenciesToExclude);
        this.removeLibraryPaths(dependenciesToInclude);
    }

    private void addFolderPathsFromExcludedModules() {
        for (Module module : this.myExcludedModules) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            for (ContentEntry entry : rootManager.getContentEntries()) {
                for (SourceFolder sourceFolder : entry.getSourceFolders()) {
                    this.myExcludedRoots.add(ExcludedRoots.urlToFilePath(sourceFolder.getUrl()));
                }
                CompilerModuleExtension compiler = (CompilerModuleExtension)rootManager.getModuleExtension(CompilerModuleExtension.class);
                String url = compiler.getCompilerOutputUrl();
                if (!StringUtil.isNotEmpty((String)url)) continue;
                this.myExcludedRoots.add(ExcludedRoots.urlToFilePath(url));
            }
            AndroidModuleModel androidModuleModel = AndroidModuleModel.get(module);
            if (androidModuleModel == null) continue;
            this.myExcludedRoots.add(androidModuleModel.getMainArtifact().getJavaResourcesFolder());
        }
    }

    @Nullable
    private static File urlToFilePath(@NotNull String url) {
        if (url == null) {
            ExcludedRoots.$$$reportNull$$$0(4);
        }
        if (url.startsWith("jar://")) {
            return FilePaths.getJarFromJarUrl(url);
        }
        String path = VfsUtilCore.urlToPath((String)url);
        return new File(FileUtils.toSystemDependentPath((String)path));
    }

    private void addRemainingModelsIfNecessary() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myExcludedModules.getProject());
        for (Module module : moduleManager.getModules()) {
            if (this.myExcludedModules.contains(module)) continue;
            this.addModuleIfNecessary(module);
        }
    }

    private void addModuleIfNecessary(@NotNull Module module) {
        AndroidModuleModel androidModel;
        if (module == null) {
            ExcludedRoots.$$$reportNull$$$0(5);
        }
        if ((androidModel = AndroidModuleModel.get(module)) != null) {
            AndroidArtifact includeArtifact;
            JavaArtifact unitTestArtifact = androidModel.getUnitTestArtifactInSelectedVariant();
            AndroidArtifact androidTestArtifact = androidModel.getAndroidTestArtifactInSelectedVariant();
            JavaArtifact excludeArtifact = this.myAndroidTest ? unitTestArtifact : androidTestArtifact;
            Object object = includeArtifact = this.myAndroidTest ? androidTestArtifact : unitTestArtifact;
            if (excludeArtifact != null) {
                ExcludedRoots.processFolders((BaseArtifact)excludeArtifact, androidModel, this.myExcludedRoots::add);
            }
            if (includeArtifact != null) {
                ExcludedRoots.processFolders((BaseArtifact)includeArtifact, androidModel, this.myExcludedRoots::remove);
            }
        }
    }

    private static void processFolders(@NotNull BaseArtifact artifact, @NotNull AndroidModuleModel androidModel, @NotNull Consumer<File> action) {
        if (artifact == null) {
            ExcludedRoots.$$$reportNull$$$0(6);
        }
        if (androidModel == null) {
            ExcludedRoots.$$$reportNull$$$0(7);
        }
        if (action == null) {
            ExcludedRoots.$$$reportNull$$$0(8);
        }
        action.accept(artifact.getClassesFolder());
        for (File file : GradleUtil.getGeneratedSourceFolders(artifact)) {
            action.accept(file);
        }
        String artifactName = artifact.getName();
        List<SourceProvider> testSourceProviders = androidModel.getTestSourceProviders(artifactName);
        for (SourceProvider sourceProvider : testSourceProviders) {
            for (File file : IdeaSourceProvider.getAllSourceFolders(sourceProvider)) {
                action.accept(file);
            }
        }
    }

    private void addLibraryPaths(@NotNull DependencySet dependencies) {
        if (dependencies == null) {
            ExcludedRoots.$$$reportNull$$$0(9);
        }
        for (LibraryDependency dependency : dependencies.onLibraries()) {
            Collections.addAll(this.myExcludedRoots, dependency.getPaths(LibraryDependency.PathType.BINARY));
        }
    }

    void removeLibraryPaths(@NotNull DependencySet dependencies) {
        if (dependencies == null) {
            ExcludedRoots.$$$reportNull$$$0(10);
        }
        for (LibraryDependency dependency : dependencies.onLibraries()) {
            for (File path : dependency.getPaths(LibraryDependency.PathType.BINARY)) {
                this.myExcludedRoots.remove(path);
            }
        }
        Project project = this.myModule.getProject();
        for (ModuleDependency dependency : dependencies.onModules()) {
            Module module = dependency.getModule(project);
            if (module == null) continue;
            this.addLibraryPaths(module);
        }
    }

    private void addLibraryPaths(@NotNull Module module) {
        AndroidModuleModel model;
        if (module == null) {
            ExcludedRoots.$$$reportNull$$$0(11);
        }
        if ((model = AndroidModuleModel.get(module)) != null) {
            AndroidArtifact include;
            JavaArtifact exclude = this.myAndroidTest ? model.getUnitTestArtifactInSelectedVariant() : model.getAndroidTestArtifactInSelectedVariant();
            Object object = include = this.myAndroidTest ? model.getAndroidTestArtifactInSelectedVariant() : model.getUnitTestArtifactInSelectedVariant();
            if (exclude != null) {
                this.addLibraryPaths((BaseArtifact)exclude, model);
            }
            if (include != null) {
                this.removeLibraryPaths((BaseArtifact)include, model);
            }
        }
    }

    private void addLibraryPaths(@NotNull BaseArtifact artifact, @NotNull AndroidModuleModel model) {
        if (artifact == null) {
            ExcludedRoots.$$$reportNull$$$0(12);
        }
        if (model == null) {
            ExcludedRoots.$$$reportNull$$$0(13);
        }
        Dependencies dependencies = GradleUtil.getDependencies(artifact, model.getModelVersion());
        for (AndroidLibrary library : dependencies.getLibraries()) {
            if (!StringUtil.isEmpty((String)library.getProject())) continue;
            for (File file : library.getLocalJars()) {
                if (this.isAlreadyIncluded(file)) continue;
                this.myExcludedRoots.add(file);
            }
        }
        for (AndroidLibrary library : dependencies.getJavaLibraries()) {
            File jarFile;
            if (!StringUtil.isEmpty((String)ExcludedRoots.getProject((JavaLibrary)library)) || this.isAlreadyIncluded(jarFile = library.getJarFile())) continue;
            this.myExcludedRoots.add(jarFile);
        }
    }

    private boolean isAlreadyIncluded(@NotNull File file) {
        if (file == null) {
            ExcludedRoots.$$$reportNull$$$0(14);
        }
        return this.myIncludedRootNames.contains(file.getName());
    }

    private void removeLibraryPaths(@NotNull BaseArtifact artifact, @NotNull AndroidModuleModel model) {
        if (artifact == null) {
            ExcludedRoots.$$$reportNull$$$0(15);
        }
        if (model == null) {
            ExcludedRoots.$$$reportNull$$$0(16);
        }
        Dependencies dependencies = GradleUtil.getDependencies(artifact, model.getModelVersion());
        for (AndroidLibrary library : dependencies.getLibraries()) {
            if (!StringUtil.isEmpty((String)library.getProject())) continue;
            for (File file : library.getLocalJars()) {
                this.myExcludedRoots.remove(file);
            }
        }
        for (AndroidLibrary library : dependencies.getJavaLibraries()) {
            if (!StringUtil.isEmpty((String)ExcludedRoots.getProject((JavaLibrary)library))) continue;
            this.myExcludedRoots.remove(library.getJarFile());
        }
    }

    @Nullable
    private static String getProject(@NotNull JavaLibrary library) {
        if (library == null) {
            ExcludedRoots.$$$reportNull$$$0(17);
        }
        try {
            return library.getProject();
        }
        catch (UnsupportedMethodException e) {
            return null;
        }
    }

    @NotNull
    public Set<File> get() {
        Set<File> set = this.myExcludedRoots;
        if (set == null) {
            ExcludedRoots.$$$reportNull$$$0(18);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedModules";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesToExclude";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesToInclude";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/testartifacts/scopes/ExcludedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/testartifacts/scopes/ExcludedRoots";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "urlToFilePath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addModuleIfNecessary";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processFolders";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addLibraryPaths";
                break;
            }
            case 10: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeLibraryPaths";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAlreadyIncluded";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getProject";
                break;
            }
            case 18: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

