/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.scopes;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.JavaArtifact;
import com.android.builder.model.SourceProvider;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependenciesExtractor;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependencySet;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.android.tools.idea.testartifacts.scopes.ExcludedModules;
import com.android.tools.idea.testartifacts.scopes.ExcludedRoots;
import com.android.tools.idea.testartifacts.scopes.FileRootSearchScope;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestArtifactSearchScopes
implements Disposable {
    private static final Key<TestArtifactSearchScopes> SEARCH_SCOPES_KEY = Key.create((String)"TEST_ARTIFACT_SEARCH_SCOPES");
    private boolean alreadyResolved;
    @NotNull
    private final Module myModule;
    private FileRootSearchScope myAndroidTestSourceScope;
    private FileRootSearchScope myUnitTestSourceScope;
    private FileRootSearchScope myAndroidTestExcludeScope;
    private FileRootSearchScope myUnitTestExcludeScope;
    private FileRootSearchScope myAndroidTestDependencyExcludeScope;
    private FileRootSearchScope mySharedTestsExcludeScope;
    private FileRootSearchScope myUnitTestDependencyExcludeScope;
    private DependencySet mainDependencies;
    private DependencySet unitTestDependencies;
    private DependencySet androidTestDependencies;

    @Nullable
    public static TestArtifactSearchScopes get(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(0);
        }
        if (project == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(1);
        }
        if (GradleSyncState.getInstance(project).lastSyncFailed()) {
            return null;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        Module module = projectFileIndex.getModuleForFile(file);
        return module != null ? TestArtifactSearchScopes.get(module) : null;
    }

    @Nullable
    public static TestArtifactSearchScopes get(@NotNull Module module) {
        if (module == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(2);
        }
        return (TestArtifactSearchScopes)module.getUserData(SEARCH_SCOPES_KEY);
    }

    public static void initializeScope(@NotNull Module module) {
        AndroidModuleModel androidModel;
        if (module == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(3);
        }
        TestArtifactSearchScopes scopes = (androidModel = AndroidModuleModel.get(module)) != null ? new TestArtifactSearchScopes(module) : null;
        module.putUserData(SEARCH_SCOPES_KEY, (Object)scopes);
    }

    private TestArtifactSearchScopes(@NotNull Module module) {
        if (module == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(4);
        }
        this.myModule = module;
        Disposer.register((Disposable)module, (Disposable)this);
        module.putUserData(SEARCH_SCOPES_KEY, (Object)this);
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(5);
        }
        return module;
    }

    public boolean isAndroidTestSource(@NotNull VirtualFile file) {
        if (file == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(6);
        }
        return this.getAndroidTestSourceScope().accept(file);
    }

    public boolean isUnitTestSource(@NotNull VirtualFile file) {
        if (file == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(7);
        }
        return this.getUnitTestSourceScope().accept(file);
    }

    @NotNull
    public FileRootSearchScope getAndroidTestSourceScope() {
        if (this.myAndroidTestSourceScope == null) {
            this.myAndroidTestSourceScope = this.getSourceScope("_android_test_");
        }
        FileRootSearchScope fileRootSearchScope = this.myAndroidTestSourceScope;
        if (fileRootSearchScope == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(8);
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getUnitTestSourceScope() {
        if (this.myUnitTestSourceScope == null) {
            this.myUnitTestSourceScope = this.getSourceScope("_unit_test_");
        }
        FileRootSearchScope fileRootSearchScope = this.myUnitTestSourceScope;
        if (fileRootSearchScope == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(9);
        }
        return fileRootSearchScope;
    }

    @NotNull
    private FileRootSearchScope getSourceScope(@NotNull String artifactName) {
        if (artifactName == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(10);
        }
        Set<File> roots = Collections.emptySet();
        AndroidModuleModel androidModel = this.getAndroidModel();
        if (androidModel != null) {
            roots = new HashSet();
            for (SourceProvider sourceProvider : androidModel.getTestSourceProviders(artifactName)) {
                roots.addAll(IdeaSourceProvider.getAllSourceFolders(sourceProvider));
            }
        }
        FileRootSearchScope fileRootSearchScope = new FileRootSearchScope(this.myModule.getProject(), roots);
        if (fileRootSearchScope == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(11);
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getAndroidTestExcludeScope() {
        if (this.myAndroidTestExcludeScope == null) {
            FileRootSearchScope exclude = this.getUnitTestSourceScope().exclude(this.getAndroidTestSourceScope());
            this.myAndroidTestExcludeScope = exclude.merge(this.getAndroidTestDependencyExcludeScope());
        }
        FileRootSearchScope fileRootSearchScope = this.myAndroidTestExcludeScope;
        if (fileRootSearchScope == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(12);
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getUnitTestExcludeScope() {
        if (this.myUnitTestExcludeScope == null) {
            FileRootSearchScope exclude = this.getAndroidTestSourceScope().exclude(this.getUnitTestSourceScope());
            this.myUnitTestExcludeScope = exclude.merge(this.getUnitTestDependencyExcludeScope());
        }
        FileRootSearchScope fileRootSearchScope = this.myUnitTestExcludeScope;
        if (fileRootSearchScope == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(13);
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getSharedTestsExcludeScope() {
        if (this.mySharedTestsExcludeScope == null) {
            this.mySharedTestsExcludeScope = this.getAndroidTestDependencyExcludeScope().merge(this.getUnitTestDependencyExcludeScope());
        }
        FileRootSearchScope fileRootSearchScope = this.mySharedTestsExcludeScope;
        if (fileRootSearchScope == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(14);
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getAndroidTestDependencyExcludeScope() {
        if (this.myAndroidTestDependencyExcludeScope == null) {
            this.myAndroidTestDependencyExcludeScope = this.getExcludedDependenciesScope("_android_test_");
        }
        FileRootSearchScope fileRootSearchScope = this.myAndroidTestDependencyExcludeScope;
        if (fileRootSearchScope == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(15);
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getUnitTestDependencyExcludeScope() {
        if (this.myUnitTestDependencyExcludeScope == null) {
            this.myUnitTestDependencyExcludeScope = this.getExcludedDependenciesScope("_unit_test_");
        }
        FileRootSearchScope fileRootSearchScope = this.myUnitTestDependencyExcludeScope;
        if (fileRootSearchScope == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(16);
        }
        return fileRootSearchScope;
    }

    @NotNull
    private FileRootSearchScope getExcludedDependenciesScope(@NotNull String artifactName) {
        if (artifactName == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(17);
        }
        if (this.getAndroidModel() == null) {
            FileRootSearchScope fileRootSearchScope = new FileRootSearchScope(this.myModule.getProject(), Collections.emptyList());
            if (fileRootSearchScope == null) {
                TestArtifactSearchScopes.$$$reportNull$$$0(18);
            }
            return fileRootSearchScope;
        }
        this.resolveDependencies();
        boolean isAndroidTest = "_android_test_".equals(artifactName);
        DependencySet dependenciesToInclude = isAndroidTest ? this.androidTestDependencies : this.unitTestDependencies;
        DependencySet dependenciesToExclude = isAndroidTest ? this.unitTestDependencies : this.androidTestDependencies;
        ExcludedModules excludedModules = new ExcludedModules(this.myModule);
        excludedModules.add(dependenciesToExclude);
        excludedModules.remove(dependenciesToInclude);
        excludedModules.remove(this.mainDependencies);
        ExcludedRoots excludedRoots = new ExcludedRoots(this.myModule, excludedModules, dependenciesToExclude, dependenciesToInclude, isAndroidTest);
        excludedRoots.removeLibraryPaths(this.mainDependencies);
        FileRootSearchScope fileRootSearchScope = new FileRootSearchScope(this.myModule.getProject(), excludedRoots.get());
        if (fileRootSearchScope == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(19);
        }
        return fileRootSearchScope;
    }

    private void mergeSubmoduleDependencies(@NotNull DependencySet original, @Nullable DependencySet toMergeMain, @Nullable DependencySet toMergeAndroid, @Nullable DependencySet toMergeUnit) {
        if (original == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(20);
        }
        HashSet<ModuleDependency> moduleDependencies = new HashSet<ModuleDependency>(original.onModules());
        for (ModuleDependency moduleDependency : moduleDependencies) {
            TestArtifactSearchScopes moduleScope;
            Module module = moduleDependency.getModule(this.myModule.getProject());
            if (module == null || (moduleScope = TestArtifactSearchScopes.get(module)) == null) continue;
            moduleScope.resolveDependencies();
            if (toMergeMain != null) {
                toMergeMain.addAll(moduleScope.mainDependencies);
            }
            if (toMergeAndroid != null) {
                toMergeAndroid.addAll(moduleScope.androidTestDependencies);
            }
            if (toMergeUnit == null) continue;
            toMergeUnit.addAll(moduleScope.unitTestDependencies);
        }
    }

    @VisibleForTesting
    void resolveDependencies() {
        AndroidModuleModel androidModel = this.getAndroidModel();
        if (androidModel == null || this.alreadyResolved) {
            return;
        }
        this.mainDependencies = this.extractMainDependencies(androidModel);
        this.androidTestDependencies = this.extractAndroidTestDependencies(androidModel);
        this.unitTestDependencies = this.extractUnitTestDependencies(androidModel);
        this.mergeSubmoduleDependencies(this.mainDependencies, this.mainDependencies, null, null);
        this.mergeSubmoduleDependencies(this.androidTestDependencies, this.androidTestDependencies, this.androidTestDependencies, null);
        this.mergeSubmoduleDependencies(this.unitTestDependencies, this.unitTestDependencies, null, this.unitTestDependencies);
        this.alreadyResolved = true;
    }

    @NotNull
    private DependencySet extractUnitTestDependencies(@NotNull AndroidModuleModel androidModel) {
        if (androidModel == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(21);
        }
        JavaArtifact artifact = androidModel.getUnitTestArtifactInSelectedVariant();
        if (this.unitTestDependencies == null) {
            this.unitTestDependencies = TestArtifactSearchScopes.extractTestDependencies((BaseArtifact)artifact, androidModel.getModelVersion());
        }
        DependencySet dependencySet = this.unitTestDependencies;
        if (dependencySet == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(22);
        }
        return dependencySet;
    }

    @NotNull
    private DependencySet extractAndroidTestDependencies(@NotNull AndroidModuleModel androidModel) {
        if (androidModel == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(23);
        }
        AndroidArtifact artifact = androidModel.getAndroidTestArtifactInSelectedVariant();
        if (this.androidTestDependencies == null) {
            this.androidTestDependencies = TestArtifactSearchScopes.extractTestDependencies((BaseArtifact)artifact, androidModel.getModelVersion());
        }
        DependencySet dependencySet = this.androidTestDependencies;
        if (dependencySet == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(24);
        }
        return dependencySet;
    }

    @NotNull
    private static DependencySet extractTestDependencies(@Nullable BaseArtifact artifact, @Nullable GradleVersion modelVersion) {
        DependencySet dependencySet = TestArtifactSearchScopes.extractDependencies(DependencyScope.TEST, artifact, modelVersion);
        if (dependencySet == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(25);
        }
        return dependencySet;
    }

    @NotNull
    private DependencySet extractMainDependencies(AndroidModuleModel androidModel) {
        if (this.mainDependencies == null) {
            this.mainDependencies = TestArtifactSearchScopes.extractDependencies(DependencyScope.COMPILE, (BaseArtifact)androidModel.getMainArtifact(), androidModel.getModelVersion());
        }
        DependencySet dependencySet = this.mainDependencies;
        if (dependencySet == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(26);
        }
        return dependencySet;
    }

    @NotNull
    private static DependencySet extractDependencies(@NotNull DependencyScope scope, @Nullable BaseArtifact artifact, @Nullable GradleVersion modelVersion) {
        if (scope == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(27);
        }
        DependencySet dependencySet = artifact != null ? DependenciesExtractor.getInstance().extractFrom(artifact, scope, modelVersion) : DependencySet.EMPTY;
        if (dependencySet == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(28);
        }
        return dependencySet;
    }

    @Nullable
    private AndroidModuleModel getAndroidModel() {
        return this.myModule.isDisposed() ? null : AndroidModuleModel.get(this.myModule);
    }

    public void dispose() {
        this.myModule.putUserData(SEARCH_SCOPES_KEY, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidTestSourceScope";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnitTestSourceScope";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceScope";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidTestExcludeScope";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnitTestExcludeScope";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedTestsExcludeScope";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidTestDependencyExcludeScope";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnitTestDependencyExcludeScope";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedDependenciesScope";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "extractUnitTestDependencies";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "extractAndroidTestDependencies";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTestDependencies";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "extractMainDependencies";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "extractDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initializeScope";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAndroidTestSource";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isUnitTestSource";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSourceScope";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getExcludedDependenciesScope";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "mergeSubmoduleDependencies";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "extractUnitTestDependencies";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "extractAndroidTestDependencies";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "extractDependencies";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

