/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.menu;

import com.android.tools.idea.uibuilder.model.NlComponent;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ActionBar {
    private final List<NlComponent> myItems;
    private final List<NlComponent> myOverflowItems;
    private final Rectangle myItemBounds;
    private final Rectangle myOverflowItemBounds;

    ActionBar(@NotNull NlComponent group) {
        if (group == null) {
            ActionBar.$$$reportNull$$$0(0);
        }
        this.myItems = new ArrayList<NlComponent>();
        this.myOverflowItems = new ArrayList<NlComponent>();
        this.addToItemsOrOverflowItems(group);
        this.myItems.sort((item1, item2) -> Integer.compare(item1.x, item2.x));
        this.myOverflowItems.sort((item1, item2) -> Integer.compare(item1.y, item2.y));
        this.myItemBounds = ActionBar.getBounds(this.myItems);
        this.myOverflowItemBounds = ActionBar.getBounds(this.myOverflowItems);
    }

    private void addToItemsOrOverflowItems(@NotNull NlComponent group) {
        if (group == null) {
            ActionBar.$$$reportNull$$$0(1);
        }
        group.getChildren().stream().filter(item -> item.w != -1 && item.h != -1).forEach(item -> {
            if (item.viewInfo == null) {
                this.addToItemsOrOverflowItems((NlComponent)item);
                return;
            }
            switch (item.viewInfo.getViewType()) {
                case ACTION_BAR_MENU: {
                    this.myItems.add((NlComponent)item);
                    break;
                }
                case ACTION_BAR_OVERFLOW_MENU: {
                    this.myOverflowItems.add((NlComponent)item);
                    break;
                }
            }
        });
    }

    @Nullable
    private static Rectangle getBounds(@NotNull List<NlComponent> items) {
        if (items == null) {
            ActionBar.$$$reportNull$$$0(2);
        }
        if (items.isEmpty()) {
            return null;
        }
        NlComponent firstItem = items.get(0);
        Rectangle bounds = new Rectangle(firstItem.x, firstItem.y, firstItem.w, firstItem.h);
        items.subList(1, items.size()).forEach(item -> bounds.add(new Rectangle(item.x, item.y, item.w, item.h)));
        return bounds;
    }

    @NotNull
    List<NlComponent> getItems() {
        List<NlComponent> list = this.myItems;
        if (list == null) {
            ActionBar.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    List<NlComponent> getOverflowItems() {
        List<NlComponent> list = this.myOverflowItems;
        if (list == null) {
            ActionBar.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    Rectangle getItemBounds() {
        return this.myItemBounds;
    }

    @Nullable
    Rectangle getOverflowItemBounds() {
        return this.myOverflowItemBounds;
    }

    boolean contains(int x, int y) {
        return this.myItemBounds.contains(x, y) || this.myOverflowItemBounds.contains(x, y);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/menu/ActionBar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/menu/ActionBar";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverflowItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addToItemsOrOverflowItems";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBounds";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

