/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.lint;

import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.lint.checks.RtlDetector;
import com.android.tools.lint.detector.api.Issue;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.psi.PsiElement;
import icons.AndroidIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LintAnnotationsModel {
    private ListMultimap<NlComponent, IssueData> myIssues;
    private List<IssueData> myIssueList;

    @NotNull
    public Collection<NlComponent> getComponentsWithIssues() {
        Collection<NlComponent> collection = this.myIssues == null ? Collections.emptyList() : this.myIssues.keySet();
        if (collection == null) {
            LintAnnotationsModel.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @Nullable
    public Icon getIssueIcon(@NotNull NlComponent component) {
        if (component == null) {
            LintAnnotationsModel.$$$reportNull$$$0(1);
        }
        if (this.myIssues == null) {
            return null;
        }
        List issueData = this.myIssues.get((Object)component);
        if (issueData == null || issueData.isEmpty()) {
            return null;
        }
        IssueData max = LintAnnotationsModel.findHighestSeverityIssue(issueData);
        return HighlightDisplayLevel.ERROR.equals(max.level) ? AndroidIcons.ErrorBadge : AndroidIcons.WarningBadge;
    }

    public String getIssueMessage(@NotNull NlComponent component) {
        if (component == null) {
            LintAnnotationsModel.$$$reportNull$$$0(2);
        }
        if (this.myIssues == null) {
            return null;
        }
        List issueData = this.myIssues.get((Object)component);
        if (issueData == null || issueData.isEmpty()) {
            return null;
        }
        IssueData max = LintAnnotationsModel.findHighestSeverityIssue(issueData);
        return max.message + "<br><br>\n" + max.inspection.getStaticDescription();
    }

    private static IssueData findHighestSeverityIssue(List<IssueData> issueData) {
        return Collections.max(issueData, (o1, o2) -> o1.level.getSeverity().compareTo(o2.level.getSeverity()));
    }

    public void addIssue(@NotNull NlComponent component, @NotNull Issue issue, @NotNull String message, @NotNull AndroidLintInspectionBase inspection, @NotNull HighlightDisplayLevel level, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (component == null) {
            LintAnnotationsModel.$$$reportNull$$$0(3);
        }
        if (issue == null) {
            LintAnnotationsModel.$$$reportNull$$$0(4);
        }
        if (message == null) {
            LintAnnotationsModel.$$$reportNull$$$0(5);
        }
        if (inspection == null) {
            LintAnnotationsModel.$$$reportNull$$$0(6);
        }
        if (level == null) {
            LintAnnotationsModel.$$$reportNull$$$0(7);
        }
        if (startElement == null) {
            LintAnnotationsModel.$$$reportNull$$$0(8);
        }
        if (endElement == null) {
            LintAnnotationsModel.$$$reportNull$$$0(9);
        }
        if (issue == RtlDetector.COMPAT) {
            return;
        }
        if (this.myIssues == null) {
            this.myIssues = ArrayListMultimap.create();
            this.myIssueList = Lists.newArrayList();
        }
        IssueData data = new IssueData(component, inspection, issue, message, level, startElement, endElement);
        this.myIssues.put((Object)component, (Object)data);
        this.myIssueList.add(data);
    }

    public int getIssueCount() {
        return this.myIssueList == null ? 0 : this.myIssueList.size();
    }

    @NotNull
    public List<IssueData> getIssues() {
        List<IssueData> list = this.myIssueList != null ? this.myIssueList : Collections.emptyList();
        if (list == null) {
            LintAnnotationsModel.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/lint/LintAnnotationsModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentsWithIssues";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/lint/LintAnnotationsModel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssues";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getIssueIcon";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIssueMessage";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addIssue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class IssueData {
        @NotNull
        public final AndroidLintInspectionBase inspection;
        @NotNull
        public final HighlightDisplayLevel level;
        @NotNull
        public final String message;
        @NotNull
        public final Issue issue;
        @NotNull
        public final PsiElement endElement;
        @NotNull
        public final PsiElement startElement;
        @NotNull
        public final NlComponent component;

        private IssueData(@NotNull NlComponent component, @NotNull AndroidLintInspectionBase inspection, @NotNull Issue issue, @NotNull String message, @NotNull HighlightDisplayLevel level, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (component == null) {
                IssueData.$$$reportNull$$$0(0);
            }
            if (inspection == null) {
                IssueData.$$$reportNull$$$0(1);
            }
            if (issue == null) {
                IssueData.$$$reportNull$$$0(2);
            }
            if (message == null) {
                IssueData.$$$reportNull$$$0(3);
            }
            if (level == null) {
                IssueData.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                IssueData.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                IssueData.$$$reportNull$$$0(6);
            }
            this.component = component;
            this.inspection = inspection;
            this.issue = issue;
            this.message = message;
            this.level = level;
            this.startElement = startElement;
            this.endElement = endElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "inspection";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "issue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "level";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[0] = "endElement";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/uibuilder/lint/LintAnnotationsModel$IssueData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

