/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor;

import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.idea.actions.MockupEditAction;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.editor.MockupViewPanel;
import com.android.tools.idea.uibuilder.mockup.editor.tools.CropTool;
import com.android.tools.idea.uibuilder.mockup.editor.tools.ExtractWidgetTool;
import com.android.tools.idea.uibuilder.mockup.editor.tools.SelectionEditors;
import com.android.tools.idea.uibuilder.model.ModelListener;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.DesignSurfaceListener;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockupEditor
extends JPanel
implements ToolContent<DesignSurface> {
    private static final String TITLE = "Mockup Editor";
    private static final String NO_MOCKUP_TEXT = "<html>No mockup available for this View.<br/>Click to add mockup</html>";
    private static final Dimension MINIMUM_SIZE = new Dimension(100, 100);
    private static final String CARD_MOCKUP_VIEW_PANEL = "mockupViewPanel";
    private static final String CARD_NO_MOCKUP = "noMockup";
    private final MyModelListener myModelListener;
    private final SelectionEditors mySelectionEditors;
    private final List<MockupEditorListener> myEditorListeners = new ArrayList<MockupEditorListener>();
    private final Set<Tool> myActiveTools = new HashSet<Tool>();
    private final ExtractWidgetTool myExtractWidgetTool;
    private final Mockup.MockupModelListener myMockupListener;
    private final DesignSurfaceListener myDesignSurfaceListener;
    private final JPanel myCenterPanel;
    private final CardLayout myCenterCardLayout;
    @Nullable
    private DesignSurface mySurface;
    @Nullable
    private NlModel myModel;
    @Nullable
    private Mockup myMockup;
    private final MockupViewPanel myMockupViewPanel;
    private final MyTopBar myTopBar;
    private final JPanel myBottomPanel;

    public MockupEditor() {
        super(new BorderLayout());
        JLabel addMockupIcon = MockupEditor.createNoMockupIcon(this.createAddMockupMouseAdapter());
        this.myMockupListener = (mockup, changedFlags) -> this.notifyListeners(mockup);
        this.myBottomPanel = new JPanel(new FlowLayout(2));
        this.myModelListener = new MyModelListener(this);
        this.myMockupViewPanel = new MockupViewPanel(this);
        this.myExtractWidgetTool = new ExtractWidgetTool(this);
        this.mySelectionEditors = new SelectionEditors(this.myMockupViewPanel);
        this.myTopBar = new MyTopBar(new CropTool(this), this.mySelectionEditors);
        this.myCenterCardLayout = new CardLayout();
        this.myCenterPanel = new JPanel(this.myCenterCardLayout);
        this.myCenterPanel.add((Component)this.myMockupViewPanel, CARD_MOCKUP_VIEW_PANEL);
        this.myCenterPanel.add((Component)addMockupIcon, CARD_NO_MOCKUP);
        this.add((Component)this.myTopBar, "North");
        this.add((Component)this.myCenterPanel, "Center");
        this.add((Component)this.myBottomPanel, "South");
        this.myDesignSurfaceListener = new MyDesignSurfaceListener(this);
        this.myExtractWidgetTool.enable(this);
        this.setMinimumSize(MINIMUM_SIZE);
        this.initSelection();
    }

    private void initSelection() {
        if (this.myModel != null) {
            List<NlComponent> selection = this.myModel.getSelectionModel().getSelection();
            if (selection.isEmpty()) {
                selection = this.myModel.getComponents();
            }
            this.selectionUpdated(this.myModel, selection);
        }
    }

    private static JLabel createNoMockupIcon(MouseListener listener) {
        JBLabel addMockupIcon = new JBLabel(NO_MOCKUP_TEXT, AndroidIcons.Mockup.NoMockup, 0);
        addMockupIcon.setHorizontalTextPosition(0);
        addMockupIcon.setVerticalTextPosition(3);
        addMockupIcon.setIconTextGap(15);
        addMockupIcon.addMouseListener(listener);
        return addMockupIcon;
    }

    private void selectionUpdated(@Nullable NlModel model, @NotNull List<NlComponent> selection) {
        if (selection == null) {
            MockupEditor.$$$reportNull$$$0(0);
        }
        NlComponent selectedComponent = null;
        if (!selection.isEmpty()) {
            selectedComponent = selection.get(0);
        } else if (model != null && !(selection = model.getComponents()).isEmpty()) {
            selectedComponent = selection.get(0);
        }
        if (this.myMockup == null || selectedComponent != this.myMockup.getComponent()) {
            this.showMockupInEditor(selectedComponent != null ? Mockup.create(selectedComponent, false) : null);
        } else if (!Mockup.hasMockupAttribute(this.myMockup.getComponent())) {
            this.showNoMockup(true);
        } else {
            this.showNoMockup(false);
        }
    }

    private void showMockupInEditor(@Nullable Mockup mockup) {
        this.showNoMockup(mockup == null);
        if (mockup != this.myMockup) {
            this.setMockup(mockup);
        }
        this.resetTools();
        this.notifyListeners(mockup);
    }

    private void setMockup(@Nullable Mockup mockup) {
        if (this.myMockup != null) {
            this.myMockup.removeMockupListener(this.myMockupListener);
        }
        this.myMockup = mockup;
        if (this.myMockup != null) {
            this.myMockup.addMockupListener(this.myMockupListener);
        }
    }

    private void showNoMockup(boolean show) {
        this.myCenterCardLayout.show(this.myCenterPanel, show ? CARD_NO_MOCKUP : CARD_MOCKUP_VIEW_PANEL);
    }

    private void notifyListeners(Mockup mockup) {
        this.myEditorListeners.forEach(listener -> listener.editorUpdated(mockup));
    }

    public void addListener(@NotNull MockupEditorListener listener) {
        if (listener == null) {
            MockupEditor.$$$reportNull$$$0(1);
        }
        if (!this.myEditorListeners.contains(listener)) {
            this.myEditorListeners.add(listener);
        }
    }

    public void removeListener(@NotNull MockupEditorListener listener) {
        if (listener == null) {
            MockupEditor.$$$reportNull$$$0(2);
        }
        this.myEditorListeners.remove(listener);
    }

    @NotNull
    private MouseAdapter createAddMockupMouseAdapter() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MockupEditor.this.myModel != null && MockupEditor.this.mySurface != null) {
                    List<NlComponent> selection = MockupEditor.this.myModel.getSelectionModel().getSelection();
                    if (selection.isEmpty()) {
                        MockupEditor.this.myModel.getSelectionModel().setSelection(MockupEditor.this.myModel.getComponents());
                    }
                    if (!selection.isEmpty()) {
                        new MockupEditAction(MockupEditor.this.mySurface).actionPerformed(null);
                    }
                }
            }
        };
        if (mouseAdapter == null) {
            MockupEditor.$$$reportNull$$$0(3);
        }
        return mouseAdapter;
    }

    @NotNull
    public MockupViewPanel getMockupViewPanel() {
        MockupViewPanel mockupViewPanel = this.myMockupViewPanel;
        if (mockupViewPanel == null) {
            MockupEditor.$$$reportNull$$$0(4);
        }
        return mockupViewPanel;
    }

    private void resetTools() {
        for (Tool activeTool : this.myActiveTools) {
            activeTool.disable(this);
        }
        this.myActiveTools.clear();
        if (this.myMockup != null) {
            this.myExtractWidgetTool.enable(this);
        }
        this.myMockupViewPanel.getSelectionLayer().clearSelection();
        this.mySelectionEditors.setVisible(false);
    }

    public void disableTool(@NotNull Tool tool) {
        if (tool == null) {
            MockupEditor.$$$reportNull$$$0(5);
        }
        tool.disable(this);
        this.myActiveTools.remove(tool);
        if (this.myActiveTools.isEmpty()) {
            this.myActiveTools.add(this.myExtractWidgetTool);
            this.myExtractWidgetTool.enable(this);
        }
        this.myBottomPanel.removeAll();
        this.validate();
    }

    public void enableTool(@NotNull Tool tool) {
        if (tool == null) {
            MockupEditor.$$$reportNull$$$0(6);
        }
        this.myActiveTools.remove(this.myExtractWidgetTool);
        this.myExtractWidgetTool.disable(this);
        tool.enable(this);
        this.myActiveTools.add(tool);
    }

    @Nullable
    public Mockup getMockup() {
        return this.myMockup;
    }

    private void setModel(@Nullable NlModel model) {
        if (model == this.myModel) {
            return;
        }
        if (this.myModel != null) {
            this.myModel.removeListener(this.myModelListener);
        }
        this.myModel = model;
        if (this.myModel != null) {
            this.myModel.addListener(this.myModelListener);
        }
        List<NlComponent> selection = this.myModel != null ? this.myModel.getSelectionModel().getSelection() : Collections.emptyList();
        this.selectionUpdated(this.myModel, selection);
    }

    public void showError(String message) {
        if (this.myTopBar != null) {
            this.myTopBar.showError(message);
        }
    }

    public void setSelectionText(Rectangle selection) {
        this.mySelectionEditors.setSelection(selection);
    }

    public void addBottomControls(JComponent component) {
        this.myBottomPanel.add(component);
        this.validate();
    }

    public void dispose() {
    }

    public void setToolContext(@Nullable DesignSurface newDesignSurface) {
        ScreenView screenView;
        if (this.mySurface != null) {
            this.mySurface.removeListener(this.myDesignSurfaceListener);
            this.mySurface = null;
            this.myExtractWidgetTool.setDesignSurface(null);
        }
        ScreenView screenView2 = screenView = newDesignSurface != null ? newDesignSurface.getCurrentScreenView() : null;
        if (screenView != null) {
            this.mySurface = newDesignSurface;
            this.mySurface.addListener(this.myDesignSurfaceListener);
            this.setModel(screenView.getModel());
            this.myExtractWidgetTool.setDesignSurface(this.mySurface);
        }
    }

    @NotNull
    public JComponent getComponent() {
        MockupEditor mockupEditor = this;
        if (mockupEditor == null) {
            MockupEditor.$$$reportNull$$$0(7);
        }
        return mockupEditor;
    }

    @NotNull
    public JComponent getFocusedComponent() {
        MockupEditor mockupEditor = this;
        if (mockupEditor == null) {
            MockupEditor.$$$reportNull$$$0(8);
        }
        return mockupEditor;
    }

    @NotNull
    public List<AnAction> getGearActions() {
        List<AnAction> list = Collections.emptyList();
        if (list == null) {
            MockupEditor.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<AnAction> getAdditionalActions() {
        List<AnAction> list = Collections.emptyList();
        if (list == null) {
            MockupEditor.$$$reportNull$$$0(10);
        }
        return list;
    }

    public void registerCloseAutoHideWindow(@NotNull Runnable runnable) {
        if (runnable == null) {
            MockupEditor.$$$reportNull$$$0(11);
        }
    }

    public boolean supportsFiltering() {
        return false;
    }

    public void setFilter(@NotNull String filter) {
        if (filter == null) {
            MockupEditor.$$$reportNull$$$0(12);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/mockup/editor/MockupEditor";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/MockupEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddMockupMouseAdapter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMockupViewPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusedComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getGearActions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "selectionUpdated";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "disableTool";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "enableTool";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerCloseAutoHideWindow";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyModelListener
    implements ModelListener {
        private final MockupEditor myMockupEditor;

        public MyModelListener(MockupEditor mockupEditor) {
            this.myMockupEditor = mockupEditor;
        }

        @Override
        public void modelChanged(@NotNull NlModel model) {
            if (model == null) {
                MyModelListener.$$$reportNull$$$0(0);
            }
            this.processModelChange(model);
        }

        @Override
        public void modelRendered(@NotNull NlModel model) {
            if (model == null) {
                MyModelListener.$$$reportNull$$$0(1);
            }
            this.processModelChange(model);
        }

        @Override
        public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
            if (model == null) {
                MyModelListener.$$$reportNull$$$0(2);
            }
        }

        private void processModelChange(@NotNull NlModel model) {
            if (model == null) {
                MyModelListener.$$$reportNull$$$0(3);
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (model == null) {
                    MyModelListener.$$$reportNull$$$0(4);
                }
                this.myMockupEditor.selectionUpdated(model, model.getSelectionModel().getSelection());
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "model";
            objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/MockupEditor$MyModelListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelRendered";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelChangedOnLayout";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processModelChange";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$processModelChange$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface MockupEditorListener {
        public void editorUpdated(@Nullable Mockup var1);
    }

    private static class MyTopBar
    extends JPanel {
        public static final int ERROR_MESSAGE_DISPLAY_DURATION = 2000;
        private JLabel myErrorLabel;
        private Timer myErrorTimer;

        MyTopBar(@NotNull CropTool cropTool, @NotNull SelectionEditors selectionEditors) {
            if (cropTool == null) {
                MyTopBar.$$$reportNull$$$0(0);
            }
            if (selectionEditors == null) {
                MyTopBar.$$$reportNull$$$0(1);
            }
            super(new BorderLayout());
            this.add((Component)MyTopBar.createTitleBar(cropTool), "North");
            this.add((Component)this.createActionBar(selectionEditors), "South");
            this.myErrorTimer = new Timer(2000, e -> this.showError(""));
            this.myErrorTimer.setRepeats(false);
            this.setPreferredSize(new Dimension(100, 70));
            this.setMinimumSize(this.getPreferredSize());
        }

        @NotNull
        private JPanel createActionBar(SelectionEditors selectionEditors) {
            JPanel actionBar = new JPanel(new FlowLayout(2));
            actionBar.add(selectionEditors);
            this.myErrorLabel = new JLabel();
            this.myErrorLabel.setForeground((Color)JBColor.RED);
            actionBar.add((Component)this.myErrorLabel, "West");
            actionBar.setBorder((Border)JBUI.Borders.empty((int)0, (int)10, (int)0, (int)5));
            JPanel jPanel = actionBar;
            if (jPanel == null) {
                MyTopBar.$$$reportNull$$$0(2);
            }
            return jPanel;
        }

        @NotNull
        private static JPanel createTitleBar(CropTool cropTool) {
            JPanel titleBar = new JPanel(new BorderLayout());
            titleBar.add((Component)new JBLabel(MockupEditor.TITLE), "West");
            titleBar.add((Component)cropTool, "East");
            titleBar.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)0, (int)10));
            JPanel jPanel = titleBar;
            if (jPanel == null) {
                MyTopBar.$$$reportNull$$$0(3);
            }
            return jPanel;
        }

        private void showError(String message) {
            UIUtil.invokeLaterIfNeeded(() -> this.myErrorLabel.setText(message));
            if (!message.isEmpty()) {
                this.myErrorTimer.restart();
            } else {
                this.myErrorTimer.stop();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cropTool";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectionEditors";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/mockup/editor/MockupEditor$MyTopBar";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/MockupEditor$MyTopBar";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActionBar";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTitleBar";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyDesignSurfaceListener
    implements DesignSurfaceListener {
        MockupEditor myEditor;

        public MyDesignSurfaceListener(@NotNull MockupEditor editor) {
            if (editor == null) {
                MyDesignSurfaceListener.$$$reportNull$$$0(0);
            }
            this.myEditor = editor;
        }

        @Override
        public void componentSelectionChanged(@NotNull DesignSurface surface, @NotNull List<NlComponent> newSelection) {
            if (surface == null) {
                MyDesignSurfaceListener.$$$reportNull$$$0(1);
            }
            if (newSelection == null) {
                MyDesignSurfaceListener.$$$reportNull$$$0(2);
            }
            this.myEditor.selectionUpdated(this.myEditor.myModel, newSelection);
        }

        @Override
        public void screenChanged(@NotNull DesignSurface surface, @Nullable ScreenView screenView) {
            if (surface == null) {
                MyDesignSurfaceListener.$$$reportNull$$$0(3);
            }
        }

        @Override
        public void modelChanged(@NotNull DesignSurface surface, @Nullable NlModel model) {
            if (surface == null) {
                MyDesignSurfaceListener.$$$reportNull$$$0(4);
            }
            this.myEditor.setModel(model);
        }

        @Override
        public boolean activatePreferredEditor(@NotNull DesignSurface surface, @NotNull NlComponent component) {
            if (surface == null) {
                MyDesignSurfaceListener.$$$reportNull$$$0(5);
            }
            if (component == null) {
                MyDesignSurfaceListener.$$$reportNull$$$0(6);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "surface";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newSelection";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/MockupEditor$MyDesignSurfaceListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "componentSelectionChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "screenChanged";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelChanged";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "activatePreferredEditor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Tool {
        public void enable(@NotNull MockupEditor var1);

        public void disable(@NotNull MockupEditor var1);
    }
}

