/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.decorator;

import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintUtilities;
import com.android.tools.idea.uibuilder.scene.SceneComponent;
import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.decorator.SceneDecorator;
import com.android.tools.idea.uibuilder.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.scene.draw.DrawTextRegion;
import com.android.tools.sherpa.drawing.ColorSet;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import org.jetbrains.annotations.NotNull;

public class RadioButtonDecorator
extends SceneDecorator {
    /*
     * WARNING - void declaration
     */
    @Override
    public void addContent(@NotNull DisplayList list, long time, @NotNull SceneContext sceneContext, @NotNull SceneComponent sceneComponent) {
        void component;
        if (list == null) {
            RadioButtonDecorator.$$$reportNull$$$0(0);
        }
        if (sceneContext == null) {
            RadioButtonDecorator.$$$reportNull$$$0(1);
        }
        if (sceneComponent == null) {
            RadioButtonDecorator.$$$reportNull$$$0(2);
        }
        super.addContent(list, time, sceneContext, (SceneComponent)component);
        Rectangle rect = new Rectangle();
        component.fillDrawRect(time, rect);
        int l = sceneContext.getSwingX(rect.x);
        int t = sceneContext.getSwingY(rect.y);
        int w = sceneContext.getSwingDimension(rect.width);
        int h = sceneContext.getSwingDimension(rect.height);
        String text = ConstraintUtilities.getResolvedText(component.getNlComponent());
        int baseLineOffset = sceneContext.getSwingDimension(component.getBaseline());
        float scale = (float)sceneContext.getScale();
        list.add(new DrawRadioButton(l, t, w, h, baseLineOffset, scale, text));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "list";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sceneContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "component";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/uibuilder/scene/decorator/RadioButtonDecorator";
        objectArray[2] = "addContent";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DrawRadioButton
    extends DrawTextRegion {
        private float mScale;
        int[] xp = new int[3];
        int[] yp = new int[3];

        @Override
        public int getLevel() {
            return 20;
        }

        DrawRadioButton(int x, int y, int width, int height, int baselineOffset, float scale, String text) {
            super(x, y, width, height, baselineOffset, text, true, false, 5, 4, 32);
            this.mScale = scale;
            this.mFont = this.mFont.deriveFont(32.0f * this.mScale);
        }

        public DrawRadioButton(String s) {
            String[] sp = s.split(",");
            int c = 0;
            this.x = Integer.parseInt(sp[c++]);
            this.y = Integer.parseInt(sp[c++]);
            this.width = Integer.parseInt(sp[c++]);
            this.height = Integer.parseInt(sp[c++]);
            this.myBaseLineOffset = Integer.parseInt(sp[c++]);
            this.mScale = Float.parseFloat(sp[c++]);
            this.mFont = this.mFont.deriveFont((float)this.mFont.getSize() * this.mScale);
            this.mText = s.substring(s.indexOf(34) + 1, s.lastIndexOf(34));
        }

        @Override
        public String serialize() {
            return this.getClass().getSimpleName() + "," + this.x + "," + this.y + "," + this.width + "," + this.height + "," + this.myBaseLineOffset + "," + this.mScale + ",\"" + this.mText + "\"";
        }

        @Override
        public void paint(Graphics2D g, SceneContext sceneContext) {
            int margin = this.height / 5;
            this.mHorizontalPadding = this.height;
            super.paint(g, sceneContext);
            ColorSet colorSet = sceneContext.getColorSet();
            if (colorSet.drawBackground()) {
                Stroke stroke = g.getStroke();
                g.setStroke(new BasicStroke(2.0f));
                g.setColor(colorSet.getFakeUI());
                int side = this.height - margin * 2;
                g.drawRoundRect(this.x + margin, this.y + margin, side, side, side, side);
                g.setStroke(stroke);
            }
        }
    }
}

