/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.wizard.FirstRunWizard;
import com.android.tools.idea.welcome.wizard.WelcomeScreenWindowListener;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Atomics;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirstRunWizardHost
extends JPanel
implements WelcomeScreen,
DynamicWizardHost {
    private static final Insets BUTTON_MARGINS = new Insets(2, 16, 2, 16);
    @NotNull
    private final FirstRunWizardMode myMode;
    private Action myCancelAction;
    private Action myPreviousAction;
    private Action myNextAction;
    private FinishAction myFinishAction;
    private FirstRunWizard myWizard;
    private JFrame myFrame;
    private Dimension myFrameSize;
    private String myFrameTitle;
    private String myTitle;
    private Dimension myPreferredWindowSize;
    private Map<Action, JButton> myActionToButtonMap;
    private AtomicReference<ProgressIndicator> myCurrentProgressIndicator;
    private boolean myIsActive;

    public FirstRunWizardHost(@NotNull FirstRunWizardMode mode) {
        if (mode == null) {
            FirstRunWizardHost.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myCancelAction = new CancelAction();
        this.myPreviousAction = new PreviousAction();
        this.myNextAction = new NextAction();
        this.myFinishAction = new FinishAction();
        this.myPreferredWindowSize = JBUI.size((int)800, (int)600);
        this.myActionToButtonMap = Maps.newHashMap();
        this.myCurrentProgressIndicator = Atomics.newReference();
        this.myMode = mode;
        this.add((Component)this.createSouthPanel(), "South");
    }

    private static void setMargin(JButton button) {
        if (!SystemInfo.isMac && BUTTON_MARGINS != null) {
            button.setMargin(BUTTON_MARGINS);
        }
    }

    public JComponent getWelcomePanel() {
        if (this.myWizard == null) {
            this.setupWizard();
        }
        assert (this.myWizard != null);
        return this;
    }

    private void setupWizard() {
        FirstRunWizard wizard = new FirstRunWizard(this, this.myMode);
        ((DynamicWizard)wizard).init();
        this.add(wizard.getContentPane(), "Center");
    }

    public void setupFrame(JFrame frame) {
        this.myFrame = frame;
        this.myFrameSize = frame.getSize();
        this.myFrameTitle = frame.getTitle();
        if (this.myTitle != null) {
            frame.setTitle(this.myTitle);
        }
        frame.setSize(this.myPreferredWindowSize);
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (size.width - this.myPreferredWindowSize.width) / 2;
        int y = (size.height - this.myPreferredWindowSize.height) / 2;
        frame.setLocation(x, y);
        JButton defaultButton = this.myActionToButtonMap.get(this.myFinishAction);
        if (!defaultButton.isEnabled()) {
            defaultButton = this.myActionToButtonMap.get(this.myNextAction);
        }
        this.setDefaultButton(defaultButton);
        this.myIsActive = true;
        WelcomeScreenWindowListener.install(frame, this);
    }

    public void dispose() {
    }

    @Override
    @NotNull
    public Disposable getDisposable() {
        FirstRunWizardHost firstRunWizardHost = this;
        if (firstRunWizardHost == null) {
            FirstRunWizardHost.$$$reportNull$$$0(1);
        }
        return firstRunWizardHost;
    }

    @Override
    public void init(@NotNull DynamicWizard wizard) {
        if (wizard == null) {
            FirstRunWizardHost.$$$reportNull$$$0(2);
        }
        this.myWizard = (FirstRunWizard)wizard;
    }

    @Override
    public boolean showAndGet() {
        return false;
    }

    @Override
    public void close(@NotNull DynamicWizardHost.CloseAction action) {
        if (action == null) {
            FirstRunWizardHost.$$$reportNull$$$0(3);
        }
        this.myIsActive = false;
        this.myFrame.setVisible(false);
        this.myFrame.dispose();
        if (action == DynamicWizardHost.CloseAction.FINISH || action == DynamicWizardHost.CloseAction.CANCEL) {
            WelcomeFrame.showNow();
        } else if (action == DynamicWizardHost.CloseAction.EXIT) {
            ApplicationManager.getApplication().exit();
        }
    }

    @Override
    public void shakeWindow() {
    }

    @Override
    public void updateButtons(boolean canGoPrev, boolean canGoNext, boolean canCancel, boolean canFinish) {
        this.setButtonEnabled(this.myCancelAction, canCancel);
        this.setButtonEnabled(this.myPreviousAction, canGoPrev);
        this.setButtonEnabled(this.myNextAction, canGoNext);
        this.setButtonEnabled(this.myFinishAction, canFinish);
        if (this.myFrame != null) {
            this.setDefaultButton(this.myActionToButtonMap.get(canFinish ? this.myFinishAction : this.myNextAction));
        }
    }

    private void setButtonEnabled(Action action, boolean enabled) {
        JButton button = this.myActionToButtonMap.get(action);
        if (button != null) {
            button.setEnabled(enabled);
        }
    }

    @Override
    public void setTitle(String title) {
        this.myTitle = title;
        if (this.myFrame != null) {
            this.myFrame.setTitle(title);
        }
    }

    @Override
    public void setIcon(@Nullable Icon icon) {
    }

    @Override
    public void runSensitiveOperation(@NotNull ProgressIndicator progressIndicator, boolean cancellable, @NotNull Runnable operation) {
        if (progressIndicator == null) {
            FirstRunWizardHost.$$$reportNull$$$0(4);
        }
        if (operation == null) {
            FirstRunWizardHost.$$$reportNull$$$0(5);
        }
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        if (!this.myCurrentProgressIndicator.compareAndSet(null, progressIndicator)) {
            throw new IllegalStateException("Submitting an operation while another is in progress.");
        }
        JRootPane rootPane = this.myFrame.getRootPane();
        JButton defaultButton = rootPane.getDefaultButton();
        rootPane.setDefaultButton(null);
        this.updateButtons(false, false, true, false);
        LongRunningOperationWrapper task = new LongRunningOperationWrapper(operation, cancellable, defaultButton);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task, progressIndicator);
    }

    @NotNull
    private JComponent createSouthPanel() {
        JBInsets insets;
        Action[] actions = this.createActions();
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        JPanel panel = new JPanel(new BorderLayout());
        JPanel lrButtonsPanel = new JPanel(new GridBagLayout());
        JBInsets jBInsets = insets = SystemInfo.isMacOSLeopard ? JBUI.emptyInsets() : JBUI.insetsTop((int)8);
        if (actions.length > 0) {
            int gridX = 0;
            lrButtonsPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(gridX++, 0, 1, 1, 1.0, 0.0, 10, 2, (Insets)insets, 0, 0));
            if (actions.length > 0) {
                JPanel buttonsPanel = this.createButtons(actions, buttons);
                lrButtonsPanel.add((Component)buttonsPanel, new GridBagConstraints(gridX, 0, 1, 1, 0.0, 0.0, 10, 0, (Insets)insets, 0, 0));
            }
        }
        panel.add((Component)lrButtonsPanel, "Center");
        panel.setBorder(IdeBorderFactory.createEmptyBorder((Insets)WizardConstants.STUDIO_WIZARD_INSETS));
        JPanel jPanel = panel;
        if (jPanel == null) {
            FirstRunWizardHost.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    private Action[] createActions() {
        if (SystemInfo.isMac) {
            return new Action[]{this.myCancelAction, this.myPreviousAction, this.myNextAction, this.myFinishAction};
        }
        return new Action[]{this.myPreviousAction, this.myNextAction, this.myCancelAction, this.myFinishAction};
    }

    @NotNull
    private JPanel createButtons(@NotNull Action[] actions, @NotNull List<JButton> buttons) {
        if (actions == null) {
            FirstRunWizardHost.$$$reportNull$$$0(7);
        }
        if (buttons == null) {
            FirstRunWizardHost.$$$reportNull$$$0(8);
        }
        if (!UISettings.getShadowInstance().getAllowMergeButtons()) {
            ArrayList<Action> actionList = new ArrayList<Action>();
            for (Action action : actions) {
                actionList.add(action);
                if (!(action instanceof OptionAction)) continue;
                Action[] options = ((OptionAction)action).getOptions();
                actionList.addAll(Arrays.asList(options));
            }
            if (actionList.size() != actions.length) {
                actions = actionList.toArray(actionList.toArray(new Action[actionList.size()]));
            }
        }
        JPanel buttonsPanel = new JPanel(new GridLayout(1, actions.length, SystemInfo.isMacOSLeopard ? 0 : 5, 0));
        for (Action action : actions) {
            JButton button = this.createJButtonForAction(action);
            Object value = action.getValue("MnemonicKey");
            if (value instanceof Integer) {
                int mnemonic = (Integer)value;
                button.setMnemonic(mnemonic);
            }
            buttons.add(button);
            buttonsPanel.add(button);
        }
        JPanel jPanel = buttonsPanel;
        if (jPanel == null) {
            FirstRunWizardHost.$$$reportNull$$$0(9);
        }
        return jPanel;
    }

    protected JButton createJButtonForAction(Action action) {
        JButton button = new JButton(action);
        String text = button.getText();
        if (SystemInfo.isMac) {
            button.putClientProperty("JButton.buttonType", "text");
        }
        if (text != null) {
            int mnemonic = 0;
            StringBuilder plainText = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                int ch = text.charAt(i);
                if (ch == 95 || ch == 38) {
                    if (i >= text.length()) break;
                    ch = text.charAt(i);
                    if (ch != 95 && ch != 38) {
                        int vk = ch;
                        if (vk >= 97 && vk <= 122) {
                            vk -= 32;
                        }
                        mnemonic = vk;
                    }
                }
                plainText.append((char)ch);
            }
            button.setText(plainText.toString());
            button.setMnemonic(mnemonic);
            FirstRunWizardHost.setMargin(button);
        }
        this.myActionToButtonMap.put(action, button);
        return button;
    }

    @Override
    public void setPreferredWindowSize(Dimension preferredWindowSize) {
        this.myPreferredWindowSize = preferredWindowSize;
        if (this.myFrame != null) {
            this.myFrame.setSize(preferredWindowSize);
        }
    }

    private void setDefaultButton(@Nullable JButton button) {
        JRootPane rootPane = this.getRootPane();
        if (rootPane != null) {
            rootPane.setDefaultButton(button);
        }
    }

    public boolean isActive() {
        return this.myIsActive;
    }

    public void cancel() {
        ProgressIndicator indicator = this.myCurrentProgressIndicator.get();
        if (indicator == null) {
            this.myWizard.doCancelAction();
        } else {
            indicator.cancel();
            JButton button = this.myActionToButtonMap.get(this.myCancelAction);
            if (button != null) {
                button.setEnabled(false);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/welcome/wizard/FirstRunWizardHost";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buttons";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/welcome/wizard/FirstRunWizardHost";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createSouthPanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createButtons";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "close";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runSensitiveOperation";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createButtons";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LongRunningOperationWrapper
    extends Task.Backgroundable {
        private final Runnable myOperation;
        private final JButton myDefaultButton;

        public LongRunningOperationWrapper(Runnable operation, boolean cancellable, JButton defaultButton) {
            super(null, FirstRunWizardHost.this.myWizard.getWizardActionDescription(), cancellable);
            this.myOperation = operation;
            this.myDefaultButton = defaultButton;
        }

        public void onSuccess() {
            FirstRunWizardHost.this.myCurrentProgressIndicator.set(null);
            FirstRunWizardHost.this.updateButtons(false, false, false, true);
            FirstRunWizardHost.this.myFrame.getRootPane().setDefaultButton(this.myDefaultButton);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                LongRunningOperationWrapper.$$$reportNull$$$0(0);
            }
            this.myOperation.run();
        }

        public void onCancel() {
            this.onSuccess();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/welcome/wizard/FirstRunWizardHost$LongRunningOperationWrapper", "run"));
        }
    }

    protected class FinishAction
    extends AbstractAction {
        protected FinishAction() {
            this.putValue("Name", IdeBundle.message((String)"button.finish", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FirstRunWizardHost.this.myWizard.doFinishAction();
        }
    }

    protected class PreviousAction
    extends AbstractAction {
        protected PreviousAction() {
            this.putValue("Name", IdeBundle.message((String)"button.wizard.previous", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FirstRunWizardHost.this.myWizard.doPreviousAction();
        }
    }

    protected class NextAction
    extends AbstractAction {
        protected NextAction() {
            this.putValue("Name", IdeBundle.message((String)"button.wizard.next", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FirstRunWizardHost.this.myWizard.doNextAction();
        }
    }

    protected class CancelAction
    extends AbstractAction {
        protected CancelAction() {
            this.putValue("Name", IdeBundle.message((String)"button.cancel", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FirstRunWizardHost.this.cancel();
        }
    }
}

