/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import io.grpc.EquivalentAddressGroup;
import io.grpc.Status;
import io.grpc.TransportManager;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class RoundRobinServerList<T> {
    private final TransportManager<T> tm;
    private final List<EquivalentAddressGroup> list;
    private final Iterator<EquivalentAddressGroup> cyclingIter;
    private final T requestDroppingTransport;

    private RoundRobinServerList(TransportManager<T> tm, List<EquivalentAddressGroup> list) {
        this.tm = tm;
        this.list = list;
        this.cyclingIter = Iterators.cycle(list);
        this.requestDroppingTransport = tm.createFailingTransport(Status.UNAVAILABLE.withDescription("Throttled by LB"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getTransportForNextServer() {
        EquivalentAddressGroup currentServer;
        Iterator<EquivalentAddressGroup> iterator = this.cyclingIter;
        synchronized (iterator) {
            currentServer = this.cyclingIter.next();
        }
        if (currentServer == null) {
            return this.requestDroppingTransport;
        }
        return this.tm.getTransport(currentServer);
    }

    @VisibleForTesting
    public List<EquivalentAddressGroup> getList() {
        return this.list;
    }

    public int size() {
        return this.list.size();
    }

    @NotThreadSafe
    public static class Builder<T> {
        private final ImmutableList.Builder<EquivalentAddressGroup> listBuilder = ImmutableList.builder();
        private final TransportManager<T> tm;

        public Builder(TransportManager<T> tm) {
            this.tm = tm;
        }

        public void add(@Nullable SocketAddress address) {
            this.listBuilder.add((Object)new EquivalentAddressGroup(address));
        }

        public void addList(List<SocketAddress> addresses) {
            this.listBuilder.add((Object)new EquivalentAddressGroup(addresses));
        }

        public RoundRobinServerList<T> build() {
            return new RoundRobinServerList(this.tm, (List)this.listBuilder.build());
        }
    }
}

