/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.util.SmartList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.actions.CommitToIcsActionKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fJ\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/settingsRepository/actions/ProjectChangeCollectConsumer;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "projectChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "consume", "", "change", "getResult", "", "hasResult", "", "settings-repository"})
final class ProjectChangeCollectConsumer {
    private List<Change> projectChanges;
    private final Project project;

    public final void consume(@NotNull Change change) {
        Intrinsics.checkParameterIsNotNull((Object)change, (String)"change");
        if (CommitToIcsActionKt.access$isProjectConfigFile(change.getVirtualFile(), this.project)) {
            if (this.projectChanges == null) {
                this.projectChanges = (List)new SmartList();
            }
            List<Change> list = this.projectChanges;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            list.add(change);
        }
    }

    @NotNull
    public final List<Change> getResult() {
        List<Change> list;
        if (this.projectChanges == null) {
            list = CollectionsKt.emptyList();
        } else {
            list = this.projectChanges;
            if (list == null) {
                Intrinsics.throwNpe();
            }
        }
        return list;
    }

    public final boolean hasResult() {
        return this.projectChanges != null;
    }

    public ProjectChangeCollectConsumer(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }
}

