/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.util.SmartList;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.UnmergedPathsException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.ignore.IgnoreNode;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.OperationResult;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.Transport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.AuthenticationException;
import org.jetbrains.settingsRepository.BaseRepositoryManager;
import org.jetbrains.settingsRepository.IcsCredentialsStore;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.RepositoryManager;
import org.jetbrains.settingsRepository.SyncType;
import org.jetbrains.settingsRepository.UpdateResult;
import org.jetbrains.settingsRepository.git.AddLoadedFile;
import org.jetbrains.settingsRepository.git.CommitKt;
import org.jetbrains.settingsRepository.git.DeleteDirectory;
import org.jetbrains.settingsRepository.git.DirCacheEditorKt;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.GitRepositoryClient;
import org.jetbrains.settingsRepository.git.GitRepositoryManagerKt;
import org.jetbrains.settingsRepository.git.IdeaCommitMessageFormatter;
import org.jetbrains.settingsRepository.git.JGitCredentialsProvider;
import org.jetbrains.settingsRepository.git.JGitProgressMonitorKt;
import org.jetbrains.settingsRepository.git.Pull;
import org.jetbrains.settingsRepository.git.PullKt;
import org.jetbrains.settingsRepository.git.Reset;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020#H\u0016J$\u0010$\u001a\u00020#2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020#H\u0016J\u001a\u0010*\u001a\u00020#2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020#H\u0016J\u0018\u0010.\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020#H\u0014J\b\u00100\u001a\u00020\u001aH\u0016J\u0012\u00101\u001a\u0002022\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\b\u00103\u001a\u00020!H\u0016J\n\u00104\u001a\u0004\u0018\u00010\u0016H\u0002J\n\u00105\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u00106\u001a\u00020#H\u0016J\u0010\u00107\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u00108\u001a\u00020#H\u0016J\u0014\u00109\u001a\u0004\u0018\u00010:2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u0012\u0010;\u001a\u00020\u001a2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J$\u0010<\u001a\u00020#2\u0014\u0010=\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001d0>2\u0006\u0010?\u001a\u00020\u001dJ \u0010@\u001a\u00020:2\u0006\u0010%\u001a\u00020&2\u000e\u0010A\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010BH\u0016J\u0010\u0010C\u001a\u00020:2\u0006\u0010%\u001a\u00020&H\u0016J\u001c\u0010D\u001a\u00020\u001a2\b\u0010E\u001a\u0004\u0018\u00010\u001d2\b\u0010F\u001a\u0004\u0018\u00010\u001dH\u0016R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\u00108VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\f\u00a8\u0006G"}, d2={"Lorg/jetbrains/settingsRepository/git/GitRepositoryManager;", "Lorg/jetbrains/settingsRepository/BaseRepositoryManager;", "Lorg/jetbrains/settingsRepository/git/GitRepositoryClient;", "credentialsStore", "Lkotlin/Lazy;", "Lorg/jetbrains/settingsRepository/IcsCredentialsStore;", "dir", "Ljava/nio/file/Path;", "(Lkotlin/Lazy;Ljava/nio/file/Path;)V", "_repository", "Lorg/eclipse/jgit/lib/Repository;", "get_repository", "()Lorg/eclipse/jgit/lib/Repository;", "set_repository", "(Lorg/eclipse/jgit/lib/Repository;)V", "credentialsProvider", "Lorg/eclipse/jgit/transport/CredentialsProvider;", "getCredentialsProvider", "()Lorg/eclipse/jgit/transport/CredentialsProvider;", "credentialsProvider$delegate", "Lkotlin/Lazy;", "ignoreRules", "Lorg/eclipse/jgit/ignore/IgnoreNode;", "repository", "getRepository", "addToIndex", "", "file", "path", "", "content", "", "size", "", "canCommit", "", "commit", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "syncType", "Lorg/jetbrains/settingsRepository/SyncType;", "fixStateIfCannotCommit", "commitIfCan", "state", "Lorg/eclipse/jgit/lib/RepositoryState;", "createRepositoryIfNeed", "deleteFromIndex", "isFile", "deleteRepository", "fetch", "Lorg/jetbrains/settingsRepository/RepositoryManager$Updater;", "getAheadCommitsCount", "getIgnoreRules", "getUpstream", "hasUpstream", "isPathIgnored", "isRepositoryExists", "pull", "Lorg/jetbrains/settingsRepository/UpdateResult;", "push", "renameDirectory", "pairs", "", "commitMessage", "resetToMy", "localRepositoryInitializer", "Lkotlin/Function0;", "resetToTheirs", "setUpstream", "url", "branch", "settings-repository"})
public final class GitRepositoryManager
extends BaseRepositoryManager
implements GitRepositoryClient {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @Nullable
    private Repository _repository;
    @NotNull
    private final Lazy credentialsProvider$delegate;
    private IgnoreNode ignoreRules;
    private final Lazy<IcsCredentialsStore> credentialsStore;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(GitRepositoryManager.class), "credentialsProvider", "getCredentialsProvider()Lorg/eclipse/jgit/transport/CredentialsProvider;"))};
    }

    @Override
    @NotNull
    public Repository getRepository() {
        Repository r = this._repository;
        if (r == null) {
            this._repository = r = GitExKt.buildRepository$default(this.getDir(), false, null, false, 14, null);
            Application application = ApplicationManager.getApplication();
            if (application == null || !application.isUnitTestMode()) {
                ShutDownTracker.getInstance().registerShutdownTask(new Runnable(this){
                    final /* synthetic */ GitRepositoryManager this$0;

                    public final void run() {
                        block0: {
                            Repository repository2 = this.this$0.get_repository();
                            if (repository2 == null) break block0;
                            repository2.close();
                        }
                    }
                    {
                        this.this$0 = gitRepositoryManager;
                    }
                });
            }
        }
        return r;
    }

    @Nullable
    public final Repository get_repository() {
        return this._repository;
    }

    public final void set_repository(@Nullable Repository repository2) {
        this._repository = repository2;
    }

    @Override
    @NotNull
    public CredentialsProvider getCredentialsProvider() {
        Lazy lazy = this.credentialsProvider$delegate;
        GitRepositoryManager gitRepositoryManager = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (CredentialsProvider)lazy.getValue();
    }

    @Override
    public boolean createRepositoryIfNeed() {
        this.ignoreRules = null;
        if (this.isRepositoryExists()) {
            return false;
        }
        this.getRepository().create();
        GitExKt.disableAutoCrLf(this.getRepository());
        return true;
    }

    @Override
    public void deleteRepository() {
        this.ignoreRules = null;
        super.deleteRepository();
        Repository r = this._repository;
        if (r != null) {
            this._repository = null;
            r.close();
        }
    }

    @Override
    @Nullable
    public String getUpstream() {
        return GitExKt.getUpstream(this.getRepository());
    }

    @Override
    public void setUpstream(@Nullable String url, @Nullable String branch) {
        Repository repository2 = this.getRepository();
        String string = branch;
        if (string == null) {
            string = "master";
        }
        GitExKt.setUpstream(repository2, url, string);
    }

    @Override
    public boolean isRepositoryExists() {
        Repository repo = this._repository;
        if (repo == null) {
            return PathKt.exists((Path)this.getDir()) && ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setWorkTree(this.getDir().toFile())).setUseSystemConfig(false)).setup()).getObjectDirectory().exists();
        }
        return repo.getObjectDatabase().exists();
    }

    @Override
    public boolean hasUpstream() {
        return this.getUpstream() != null;
    }

    @Override
    protected void addToIndex(@NotNull Path file, @NotNull String path, @NotNull byte[] content, int size) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        DirCacheEditorKt.edit(this.getRepository(), new AddLoadedFile(path, content, size, PathKt.lastModified((Path)file).toMillis()));
    }

    @Override
    protected void deleteFromIndex(@NotNull String path, boolean isFile) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        DirCacheEditorKt.deletePath(this.getRepository(), path, isFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean commit(@Nullable ProgressIndicator indicator, @Nullable SyncType syncType, boolean fixStateIfCannotCommit) {
        int n;
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = 0;
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n4 = n3 - 1;
        if (n2 <= n4) {
            do {
                n = ++n2;
                readLock.unlock();
            } while (n2 != n4);
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            try {
                RepositoryState repositoryState = !fixStateIfCannotCommit || Intrinsics.areEqual((Object)((Object)syncType), (Object)((Object)SyncType.OVERWRITE_LOCAL)) ? this.getRepository().getRepositoryState() : PullKt.fixAndGetState(this.getRepository());
                Intrinsics.checkExpressionValueIsNotNull((Object)repositoryState, (String)"if (!fixStateIfCannotCom\u2026pository.fixAndGetState()");
                boolean bl = this.commitIfCan(indicator, repositoryState);
                return bl;
            }
            catch (UnmergedPathsException e2222) {
                boolean bl;
                block20: {
                    block18: {
                        boolean bl2;
                        block19: {
                            if (!Intrinsics.areEqual((Object)((Object)syncType), (Object)((Object)SyncType.OVERWRITE_LOCAL))) break block18;
                            IcsManagerKt.getLOG().warn("Unmerged detected, ignored because sync type is OVERWRITE_LOCAL", (Throwable)e2222);
                            bl2 = false;
                            n = 0;
                            int e2222 = n3 - 1;
                            if (n > e2222) break block19;
                            do {
                                int $i$a$1$write = ++n;
                                readLock.lock();
                            } while (n != e2222);
                        }
                        writeLock.unlock();
                        return bl2;
                    }
                    ProgressIndicator progressIndicator = indicator;
                    if (progressIndicator != null) {
                        progressIndicator.checkCanceled();
                    }
                    IcsManagerKt.getLOG().warn("Unmerged detected, will be attempted to resolve", (Throwable)e2222);
                    PullKt.resolveUnmergedConflicts(this.getRepository());
                    ProgressIndicator progressIndicator2 = indicator;
                    if (progressIndicator2 != null) {
                        progressIndicator2.checkCanceled();
                    }
                    bl = this.commitIfCan(indicator, PullKt.fixAndGetState(this.getRepository()));
                    n = 0;
                    int e432 = n3 - 1;
                    if (n > e432) break block20;
                    do {
                        int $i$a$1$write = ++n;
                        readLock.lock();
                    } while (n != e432);
                }
                writeLock.unlock();
                return bl;
            }
            catch (NoHeadException e) {
                boolean bl;
                block21: {
                    IcsManagerKt.getLOG().warn("Cannot commit - no HEAD", (Throwable)e);
                    bl = false;
                    n = 0;
                    int n5 = n3 - 1;
                    if (n > n5) break block21;
                    do {
                        int n6 = ++n;
                        readLock.lock();
                    } while (n != n5);
                }
                writeLock.unlock();
                return bl;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            n = 0;
            int n7 = n3 - 1;
            if (n <= n7) {
                do {
                    int $i$a$1$write = ++n;
                    readLock.lock();
                } while (n != n7);
            }
            writeLock.unlock();
        }
    }

    private final boolean commitIfCan(ProgressIndicator indicator, RepositoryState state) {
        if (state.canCommit()) {
            return CommitKt.commit$default(this.getRepository(), indicator, null, 4, null);
        }
        IcsManagerKt.getLOG().warn("Cannot commit, repository in state " + state.getDescription());
        return false;
    }

    @Override
    public int getAheadCommitsCount() {
        return GitExKt.getAheadCommitsCount(this.getRepository());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void push(@Nullable ProgressIndicator indicator) {
        Ref head;
        IcsManagerKt.getLOG().debug("Push");
        SmartList refSpecs = new SmartList((Collection)new RemoteConfig((Config)this.getRepository().getConfig(), "origin").getPushRefSpecs());
        if (refSpecs.isEmpty() && (head = this.getRepository().findRef("HEAD")) != null && head.isSymbolic()) {
            refSpecs.add((Object)new RefSpec(head.getLeaf().getName()));
        }
        ProgressMonitor monitor = JGitProgressMonitorKt.asProgressMonitor(indicator);
        block6: for (Transport transport : Transport.openAll((Repository)this.getRepository(), (String)"origin", (Transport.Operation)Transport.Operation.PUSH)) {
            int n = 0;
            int n2 = 2;
            while (n < n2) {
                void attempt;
                block12: {
                    transport.setCredentialsProvider(this.getCredentialsProvider());
                    try {
                        PushResult result = transport.push(monitor, transport.findRemoteRefUpdatesFor((Collection)refSpecs));
                        if (!IcsManagerKt.getLOG().isDebugEnabled()) continue block6;
                        PushResult pushResult = result;
                        Intrinsics.checkExpressionValueIsNotNull((Object)pushResult, (String)"result");
                        GitRepositoryManagerKt.printMessages((OperationResult)pushResult);
                        for (RemoteRefUpdate refUpdate : result.getRemoteUpdates()) {
                            IcsManagerKt.getLOG().debug(refUpdate.toString());
                        }
                        continue block6;
                    }
                    catch (TransportException e) {
                        if (Intrinsics.areEqual((Object)e.getStatus(), (Object)TransportException.Status.NOT_PERMITTED)) {
                            if (attempt == false) {
                                this.getCredentialsProvider().reset(transport.getURI());
                                break block12;
                            }
                            throw (Throwable)new AuthenticationException(e);
                        }
                        if (Intrinsics.areEqual((Object)e.getStatus(), (Object)TransportException.Status.BAD_GATEWAY)) break block12;
                        GitExKt.wrapIfNeedAndReThrow(e);
                    }
                    finally {
                        transport.close();
                        continue block6;
                    }
                }
                ++attempt;
            }
        }
    }

    @Override
    @NotNull
    public RepositoryManager.Updater fetch(@Nullable ProgressIndicator indicator) {
        GitRepositoryClient gitRepositoryClient = this;
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        Pull pullTask = new Pull(gitRepositoryClient, progressIndicator, null, 4, null);
        Ref refToMerge = Pull.fetch$default(pullTask, null, null, 3, null);
        return new RepositoryManager.Updater(this, pullTask, refToMerge){
            private boolean definitelySkipPush;
            final /* synthetic */ GitRepositoryManager this$0;
            final /* synthetic */ Pull $pullTask;
            final /* synthetic */ Ref $refToMerge;

            public boolean getDefinitelySkipPush() {
                return this.definitelySkipPush;
            }

            public void setDefinitelySkipPush(boolean bl) {
                this.definitelySkipPush = bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public UpdateResult merge() {
                int committed;
                int n;
                ReentrantReadWriteLock reentrantReadWriteLock = GitRepositoryManager.access$getLock$p(this.this$0);
                ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                int n2 = 0;
                int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                int n4 = n3 - 1;
                if (n2 <= n4) {
                    do {
                        n = ++n2;
                        readLock.unlock();
                    } while (n2 != n4);
                }
                ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                writeLock.lock();
                try {
                    committed = RepositoryManager.DefaultImpls.commit$default(this.this$0, this.$pullTask.getIndicator(), null, false, 6, null);
                    if (this.$refToMerge == null) {
                        this.setDefinitelySkipPush(committed == 0 && this.this$0.getAheadCommitsCount() == 0);
                        UpdateResult updateResult = null;
                        return updateResult;
                    }
                    UpdateResult updateResult = Pull.pull$default(this.$pullTask, null, null, this.$refToMerge, 3, null);
                    return updateResult;
                }
                finally {
                    n = 0;
                    committed = n3 - 1;
                    if (n <= committed) {
                        do {
                            int $i$a$1$write = ++n;
                            readLock.lock();
                        } while (n != committed);
                    }
                    writeLock.unlock();
                }
            }
            {
                this.this$0 = $outer;
                this.$pullTask = $captured_local_variable$1;
                this.$refToMerge = $captured_local_variable$2;
            }
        };
    }

    @Override
    @Nullable
    public UpdateResult pull(@Nullable ProgressIndicator indicator) {
        return Pull.pull$default(new Pull(this, indicator, null, 4, null), null, null, null, 7, null);
    }

    @Override
    @NotNull
    public UpdateResult resetToTheirs(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        return Reset.reset$default(new Reset(this, indicator), true, null, 2, null);
    }

    @Override
    @NotNull
    public UpdateResult resetToMy(@NotNull ProgressIndicator indicator, @Nullable Function0<Unit> localRepositoryInitializer) {
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        return new Reset(this, indicator).reset(false, localRepositoryInitializer);
    }

    @Override
    public boolean canCommit() {
        return this.getRepository().getRepositoryState().canCommit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean renameDirectory(@NotNull Map<String, String> pairs, @NotNull String commitMessage) {
        Intrinsics.checkParameterIsNotNull(pairs, (String)"pairs");
        Intrinsics.checkParameterIsNotNull((Object)commitMessage, (String)"commitMessage");
        AddCommand addCommand = null;
        SmartList toDelete = new SmartList();
        Map<String, String> map = pairs;
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> object2;
            Map.Entry<String, String> entry = object2 = iterator.next();
            String oldPath = entry.getKey();
            entry = object2;
            String newPath = entry.getValue();
            Path old = this.getDir().resolve(oldPath);
            if (!PathKt.exists((Path)old)) continue;
            IcsManagerKt.getLOG().info("Rename " + oldPath + " to " + newPath);
            Path $receiver$iv = old;
            try {
                Closeable closeable;
                Closeable noSuchFileException = Files.newDirectoryStream($receiver$iv);
                boolean bl = false;
                try {
                    DirectoryStream it = (DirectoryStream)noSuchFileException;
                    Path path = newPath == null ? this.getDir() : this.getDir().resolve(newPath);
                    for (Path file : it) {
                        Logger $receiver$iv2 = IcsManagerKt.getLOG();
                        try {
                            if (PathKt.isHidden((Path)file)) {
                                PathKt.delete((Path)file);
                                continue;
                            }
                            try {
                                Path path2 = path.resolve(file.getFileName());
                                Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"new.resolve(file.fileName)");
                                PathKt.move((Path)file, (Path)path2);
                            }
                            catch (FileAlreadyExistsException ignored) {
                                continue;
                            }
                            if (addCommand == null) {
                                addCommand = new AddCommand(this.getRepository());
                            }
                            AddCommand addCommand2 = addCommand;
                            if (addCommand2 == null) {
                                Intrinsics.throwNpe();
                            }
                            addCommand2.addFilepattern(newPath == null ? ((Object)file.getFileName()).toString() : "" + newPath + '/' + file.getFileName());
                        }
                        catch (ProcessCanceledException e$iv) {
                        }
                        catch (Throwable e$iv) {
                            $receiver$iv2.error(e$iv);
                        }
                    }
                    Boolean exception = toDelete.add((Object)new DeleteDirectory(oldPath));
                    closeable = noSuchFileException;
                }
                catch (Exception throwable) {
                    try {
                        bl = true;
                        try {
                            Closeable closeable2 = noSuchFileException;
                            if (closeable2 != null) {
                                closeable2.close();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw (Throwable)throwable;
                    }
                    catch (Throwable throwable2) {
                        if (!bl) {
                            Closeable closeable3 = noSuchFileException;
                            if (closeable3 != null) {
                                closeable3.close();
                            }
                        }
                        throw throwable2;
                    }
                }
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (NoSuchFileException noSuchFileException) {
            }
            $receiver$iv = IcsManagerKt.getLOG();
            try {
                PathKt.delete((Path)old);
            }
            catch (ProcessCanceledException e$iv) {
            }
            catch (Throwable e$iv) {
                $receiver$iv.error(e$iv);
            }
        }
        if (toDelete.isEmpty() && addCommand == null) {
            return false;
        }
        DirCacheEditorKt.edit(this.getRepository(), (List)toDelete);
        AddCommand addCommand3 = addCommand;
        if (addCommand3 != null) {
            addCommand3.call();
        }
        IdeaCommitMessageFormatter ideaCommitMessageFormatter = new IdeaCommitMessageFormatter();
        Repository repository2 = this.getRepository();
        IdeaCommitMessageFormatter $receiver = ideaCommitMessageFormatter;
        StringBuilder stringBuilder = $receiver.appendCommitOwnerInfo(new StringBuilder(), true);
        GitExKt.commit$default(repository2, stringBuilder.append(commitMessage).toString(), null, null, null, 14, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IgnoreNode getIgnoreRules() {
        IgnoreNode node;
        block8: {
            Path file;
            node = this.ignoreRules;
            if (node != null || !PathKt.exists((Path)(file = this.getDir().resolve(".gitignore")))) break block8;
            node = new IgnoreNode();
            AutoCloseable $receiver$iv = PathKt.inputStream((Path)file);
            boolean closed$iv = false;
            try {
                InputStream it = (InputStream)$receiver$iv;
                node.parse(it);
                it = Unit.INSTANCE;
            }
            catch (Exception e$iv) {
                try {
                    closed$iv = true;
                    try {
                        $receiver$iv.close();
                    }
                    catch (Exception closeException$iv) {
                        Exception exception = e$iv;
                        if (exception == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                        }
                        ((Throwable)exception).addSuppressed(closeException$iv);
                    }
                    throw (Throwable)e$iv;
                }
                catch (Throwable throwable) {
                    if (!closed$iv) {
                        $receiver$iv.close();
                    }
                    throw throwable;
                }
            }
            $receiver$iv.close();
            this.ignoreRules = node;
        }
        return node;
    }

    @Override
    protected boolean isPathIgnored(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        IgnoreNode ignoreNode = this.getIgnoreRules();
        return Intrinsics.areEqual(ignoreNode != null ? ignoreNode.isIgnored('/' + path, false) : null, (Object)IgnoreNode.MatchResult.IGNORED);
    }

    public GitRepositoryManager(@NotNull Lazy<IcsCredentialsStore> credentialsStore2, @NotNull Path dir) {
        Intrinsics.checkParameterIsNotNull(credentialsStore2, (String)"credentialsStore");
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        super(dir);
        this.credentialsStore = credentialsStore2;
        this.credentialsProvider$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JGitCredentialsProvider>(this){
            final /* synthetic */ GitRepositoryManager this$0;

            @NotNull
            public final JGitCredentialsProvider invoke() {
                return new JGitCredentialsProvider((Lazy<IcsCredentialsStore>)GitRepositoryManager.access$getCredentialsStore$p(this.this$0), this.this$0.getRepository());
            }
            {
                this.this$0 = gitRepositoryManager;
                super(0);
            }
        }));
    }

    @NotNull
    public static final /* synthetic */ ReentrantReadWriteLock access$getLock$p(GitRepositoryManager $this) {
        return $this.getLock();
    }

    @NotNull
    public static final /* synthetic */ Lazy access$getCredentialsStore$p(GitRepositoryManager $this) {
        return $this.credentialsStore;
    }
}

