/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.action;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PasteMvnDependencyPreProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        return null;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        if ("build.gradle".equals(file.getName()) && PasteMvnDependencyPreProcessor.isMvnDependency(text)) {
            String string = PasteMvnDependencyPreProcessor.toGradleDependency(text);
            if (string == null) {
                PasteMvnDependencyPreProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static String toGradleDependency(String mavenDependency) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            try {
                Document document = builder.parse(new InputSource(new StringReader(mavenDependency)));
                String gradleDependency = PasteMvnDependencyPreProcessor.extractGradleDependency(document);
                return gradleDependency != null ? gradleDependency : mavenDependency;
            }
            catch (IOException | SAXException exception) {
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return mavenDependency;
    }

    @Nullable
    private static String extractGradleDependency(Document document) {
        String groupId = PasteMvnDependencyPreProcessor.getGroupId(document);
        String artifactId = PasteMvnDependencyPreProcessor.getArtifactId(document);
        String version = PasteMvnDependencyPreProcessor.getVersion(document);
        String scope = PasteMvnDependencyPreProcessor.getScope(document);
        String classifier = PasteMvnDependencyPreProcessor.getClassifier(document);
        if (groupId.isEmpty() || artifactId.isEmpty() || version.isEmpty()) {
            return null;
        }
        String gradleClassifier = classifier.isEmpty() ? "" : ":" + classifier;
        return scope + "'" + groupId + ":" + artifactId + ":" + version + gradleClassifier + "'";
    }

    private static String getScope(@NotNull Document document) {
        String scope;
        if (document == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(2);
        }
        switch (scope = PasteMvnDependencyPreProcessor.firstOrEmpty(document.getElementsByTagName("scope"))) {
            case "test": {
                scope = "testCompile ";
                break;
            }
            case "compile": 
            case "runtime": {
                scope = scope + " ";
                break;
            }
            default: {
                scope = "compile ";
            }
        }
        return scope;
    }

    private static String getVersion(@NotNull Document document) {
        if (document == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(3);
        }
        return PasteMvnDependencyPreProcessor.firstOrEmpty(document.getElementsByTagName("version"));
    }

    private static String getArtifactId(@NotNull Document document) {
        if (document == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(4);
        }
        return PasteMvnDependencyPreProcessor.firstOrEmpty(document.getElementsByTagName("artifactId"));
    }

    private static String getGroupId(@NotNull Document document) {
        if (document == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(5);
        }
        return PasteMvnDependencyPreProcessor.firstOrEmpty(document.getElementsByTagName("groupId"));
    }

    private static String getClassifier(@NotNull Document document) {
        if (document == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(6);
        }
        return PasteMvnDependencyPreProcessor.firstOrEmpty(document.getElementsByTagName("classifier"));
    }

    private static String firstOrEmpty(@NotNull NodeList list) {
        Node first;
        if (list == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(7);
        }
        return (first = list.item(0)) != null ? first.getTextContent() : "";
    }

    private static boolean isMvnDependency(String text) {
        String trimmed = text.trim();
        return trimmed.startsWith("<dependency>") && trimmed.endsWith("</dependency>");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/action/PasteMvnDependencyPreProcessor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/action/PasteMvnDependencyPreProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactId";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getGroupId";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getClassifier";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "firstOrEmpty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

