/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VfsUtilCore;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.settings.GradleSystemRunningSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleOrderEnumeratorHandler
extends OrderEnumerationHandler {
    private static final Logger LOG = Logger.getInstance(GradleOrderEnumeratorHandler.class);
    private final boolean myResolveModulePerSourceSet;
    private final boolean myShouldProcessDependenciesRecursively;

    public GradleOrderEnumeratorHandler(@NotNull Module module) {
        if (module == null) {
            GradleOrderEnumeratorHandler.$$$reportNull$$$0(0);
        }
        String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
        if (rootProjectPath != null) {
            GradleProjectSettings settings = (GradleProjectSettings)GradleSettings.getInstance(module.getProject()).getLinkedProjectSettings(rootProjectPath);
            this.myResolveModulePerSourceSet = settings != null && settings.isResolveModulePerSourceSet();
            String gradleVersion = GradleLocalSettings.getInstance(module.getProject()).getGradleVersion(rootProjectPath);
            this.myShouldProcessDependenciesRecursively = gradleVersion != null && GradleVersion.version((String)gradleVersion).compareTo(GradleVersion.version((String)"2.5")) < 0;
        } else {
            this.myShouldProcessDependenciesRecursively = false;
            this.myResolveModulePerSourceSet = false;
        }
    }

    public boolean shouldAddRuntimeDependenciesToTestCompilationClasspath() {
        return this.myResolveModulePerSourceSet;
    }

    public boolean shouldIncludeTestsFromDependentModulesToTestClasspath() {
        return !this.myResolveModulePerSourceSet;
    }

    public boolean shouldProcessDependenciesRecursively() {
        return this.myShouldProcessDependenciesRecursively;
    }

    public boolean addCustomModuleRoots(@NotNull OrderRootType type, @NotNull ModuleRootModel rootModel, @NotNull Collection<String> result, boolean includeProduction, boolean includeTests) {
        if (type == null) {
            GradleOrderEnumeratorHandler.$$$reportNull$$$0(1);
        }
        if (rootModel == null) {
            GradleOrderEnumeratorHandler.$$$reportNull$$$0(2);
        }
        if (result == null) {
            GradleOrderEnumeratorHandler.$$$reportNull$$$0(3);
        }
        if (!type.equals((Object)OrderRootType.CLASSES)) {
            return false;
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)rootModel.getModule())) {
            return false;
        }
        String gradleProjectPath = ExternalSystemModulePropertyManager.getInstance((Module)rootModel.getModule()).getRootProjectPath();
        if (gradleProjectPath == null) {
            LOG.error("Root project path of the Gradle project not found for " + rootModel.getModule());
            return false;
        }
        ExternalProjectDataCache externalProjectDataCache = ExternalProjectDataCache.getInstance(rootModel.getModule().getProject());
        assert (externalProjectDataCache != null);
        ExternalProject externalRootProject = externalProjectDataCache.getRootExternalProject(GradleConstants.SYSTEM_ID, new File(gradleProjectPath));
        if (externalRootProject == null) {
            LOG.debug("Root external project was not yep imported for the project path: " + gradleProjectPath);
            return false;
        }
        Map<String, ExternalSourceSet> externalSourceSets = externalProjectDataCache.findExternalProject(externalRootProject, rootModel.getModule());
        if (externalSourceSets.isEmpty()) {
            return false;
        }
        boolean isGradleAwareMake = GradleSystemRunningSettings.getInstance().isUseGradleAwareMake();
        for (ExternalSourceSet sourceSet : externalSourceSets.values()) {
            if (includeTests) {
                if (isGradleAwareMake) {
                    GradleOrderEnumeratorHandler.addOutputModuleRoots((ExternalSourceDirectorySet)sourceSet.getSources().get(ExternalSystemSourceType.TEST), result, true);
                }
                GradleOrderEnumeratorHandler.addOutputModuleRoots((ExternalSourceDirectorySet)sourceSet.getSources().get(ExternalSystemSourceType.TEST_RESOURCE), result, isGradleAwareMake);
            }
            if (!includeProduction) continue;
            if (isGradleAwareMake) {
                GradleOrderEnumeratorHandler.addOutputModuleRoots((ExternalSourceDirectorySet)sourceSet.getSources().get(ExternalSystemSourceType.SOURCE), result, true);
            }
            GradleOrderEnumeratorHandler.addOutputModuleRoots((ExternalSourceDirectorySet)sourceSet.getSources().get(ExternalSystemSourceType.RESOURCE), result, isGradleAwareMake);
        }
        return true;
    }

    private static void addOutputModuleRoots(@Nullable ExternalSourceDirectorySet directorySet, @NotNull Collection<String> result, boolean isGradleAwareMake) {
        if (result == null) {
            GradleOrderEnumeratorHandler.$$$reportNull$$$0(4);
        }
        if (directorySet == null) {
            return;
        }
        if (isGradleAwareMake) {
            for (File outputDir : directorySet.getGradleOutputDirs()) {
                result.add(VfsUtilCore.pathToUrl((String)outputDir.getAbsolutePath()));
            }
        } else if (!directorySet.isCompilerOutputPathInherited()) {
            result.add(VfsUtilCore.pathToUrl((String)directorySet.getOutputDir().getAbsolutePath()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/execution/GradleOrderEnumeratorHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addCustomModuleRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addOutputModuleRoots";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FactoryImpl
    extends OrderEnumerationHandler.Factory {
        private static final ExtensionPointName<FactoryImpl> EP_NAME = ExtensionPointName.create((String)"org.jetbrains.plugins.gradle.orderEnumerationHandlerFactory");

        public boolean isApplicable(@NotNull Module module) {
            if (module == null) {
                FactoryImpl.$$$reportNull$$$0(0);
            }
            return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module);
        }

        public GradleOrderEnumeratorHandler createHandler(@NotNull Module module) {
            if (module == null) {
                FactoryImpl.$$$reportNull$$$0(1);
            }
            for (FactoryImpl factory : (FactoryImpl[])EP_NAME.getExtensions()) {
                if (!factory.isApplicable(module)) continue;
                return factory.createHandler(module);
            }
            return new GradleOrderEnumeratorHandler(module);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "module";
            objectArray2[1] = "org/jetbrains/plugins/gradle/execution/GradleOrderEnumeratorHandler$FactoryImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isApplicable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createHandler";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

