/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.google.common.io.InputSupplier;
import com.google.gson.GsonBuilder;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.externalSystem.JavaProjectData;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.externalSystem.model.ConfigurationDataImpl;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.IExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import groovy.lang.GroovyObject;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleModuleVersion;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.tooling.model.idea.IdeaCompilerOutput;
import org.gradle.tooling.model.idea.IdeaContentRoot;
import org.gradle.tooling.model.idea.IdeaDependency;
import org.gradle.tooling.model.idea.IdeaDependencyScope;
import org.gradle.tooling.model.idea.IdeaJavaLanguageSettings;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.tooling.model.idea.IdeaSingleEntryLibraryDependency;
import org.gradle.tooling.model.idea.IdeaSourceDirectory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.DefaultGradleExtensions;
import org.jetbrains.plugins.gradle.model.ExtIdeaContentRoot;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.ExternalTask;
import org.jetbrains.plugins.gradle.model.GradleExtensions;
import org.jetbrains.plugins.gradle.model.IntelliJProjectSettings;
import org.jetbrains.plugins.gradle.model.IntelliJSettings;
import org.jetbrains.plugins.gradle.model.ModuleExtendedModel;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.BaseProjectImportErrorHandler;
import org.jetbrains.plugins.gradle.service.project.DefaultProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataService;
import org.jetbrains.plugins.gradle.service.project.data.GradleExtensionsDataService;
import org.jetbrains.plugins.gradle.settings.GradleExecutionWorkspace;
import org.jetbrains.plugins.gradle.tooling.builder.ModelBuildScriptClasspathBuilderImpl;
import org.jetbrains.plugins.gradle.tooling.internal.init.Init;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.slf4j.Logger;
import org.slf4j.impl.Log4jLoggerFactory;

@Order(value=0x7FFFFFFF)
public class BaseGradleProjectResolverExtension
implements GradleProjectResolverExtension {
    private static final com.intellij.openapi.diagnostic.Logger LOG = com.intellij.openapi.diagnostic.Logger.getInstance(BaseGradleProjectResolverExtension.class);
    @NotNull
    @NonNls
    private static final String UNRESOLVED_DEPENDENCY_PREFIX = "unresolved dependency - ";
    @NotNull
    private ProjectResolverContext resolverCtx;
    @NotNull
    private final BaseProjectImportErrorHandler myErrorHandler = new BaseProjectImportErrorHandler();

    @Override
    public void setProjectResolverContext(@NotNull ProjectResolverContext projectResolverContext) {
        if (projectResolverContext == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(0);
        }
        this.resolverCtx = projectResolverContext;
    }

    @Override
    public void setNext(@NotNull GradleProjectResolverExtension next) {
        if (next == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(1);
        }
    }

    @Override
    @Nullable
    public GradleProjectResolverExtension getNext() {
        return null;
    }

    @Override
    @NotNull
    public ProjectData createProject() {
        String projectDirPath = this.resolverCtx.getProjectPath();
        ExternalProject externalProject = this.resolverCtx.getExtraProject(ExternalProject.class);
        String projectName = externalProject != null ? externalProject.getName() : this.resolverCtx.getModels().getIdeaProject().getName();
        ProjectData projectData = new ProjectData(GradleConstants.SYSTEM_ID, projectName, projectDirPath, projectDirPath);
        if (projectData == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(2);
        }
        return projectData;
    }

    @Override
    @NotNull
    public JavaProjectData createJavaProjectData() {
        String projectDirPath = this.resolverCtx.getProjectPath();
        IdeaProject ideaProject = this.resolverCtx.getModels().getIdeaProject();
        JavaProjectData javaProjectData = new JavaProjectData(GradleConstants.SYSTEM_ID, projectDirPath + "/build/classes");
        javaProjectData.setJdkVersion(ideaProject.getJdkName());
        LanguageLevel resolvedLanguageLevel = null;
        String languageLevel = ideaProject.getLanguageLevel().getLevel();
        for (LanguageLevel level : LanguageLevel.values()) {
            if (!level.name().equals(languageLevel)) continue;
            resolvedLanguageLevel = level;
            break;
        }
        if (resolvedLanguageLevel != null) {
            javaProjectData.setLanguageLevel(resolvedLanguageLevel);
        } else {
            javaProjectData.setLanguageLevel(languageLevel);
        }
        JavaProjectData javaProjectData2 = javaProjectData;
        if (javaProjectData2 == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(3);
        }
        return javaProjectData2;
    }

    @Override
    public void populateProjectExtraModels(@NotNull IdeaProject gradleProject, @NotNull DataNode<ProjectData> ideProject) {
        IntelliJSettings intellijSettings;
        ExternalProject externalProject;
        if (gradleProject == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(4);
        }
        if (ideProject == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(5);
        }
        if ((externalProject = this.resolverCtx.getExtraProject(ExternalProject.class)) != null) {
            ideProject.createChild(ExternalProjectDataService.KEY, (Object)externalProject);
            ((ProjectData)ideProject.getData()).setDescription(externalProject.getDescription());
        }
        if ((intellijSettings = (IntelliJSettings)this.resolverCtx.getExtraProject(IntelliJProjectSettings.class)) != null) {
            ideProject.createChild(ProjectKeys.CONFIGURATION, (Object)new ConfigurationDataImpl(GradleConstants.SYSTEM_ID, intellijSettings.getSettings()));
        }
    }

    @Override
    @NotNull
    public DataNode<ModuleData> createModule(@NotNull IdeaModule gradleModule, @NotNull DataNode<ProjectData> projectDataNode) {
        if (gradleModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(6);
        }
        if (projectDataNode == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(7);
        }
        DataNode<ModuleData> mainModuleNode = GradleProjectResolverUtil.createMainModule(this.resolverCtx, gradleModule, projectDataNode);
        ModuleData mainModuleData = (ModuleData)mainModuleNode.getData();
        String mainModuleConfigPath = mainModuleData.getLinkedExternalProjectPath();
        String mainModuleFileDirectoryPath = mainModuleData.getModuleFileDirectoryPath();
        String jdkName = BaseGradleProjectResolverExtension.getJdkName(gradleModule);
        ExternalProject externalProject = this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        if (this.resolverCtx.isResolveModulePerSourceSet() && externalProject != null) {
            String[] moduleGroup = null;
            if (!this.resolverCtx.isUseQualifiedModuleNames()) {
                String[] stringArray;
                boolean isRootModule;
                String gradlePath = gradleModule.getGradleProject().getPath();
                boolean bl = isRootModule = StringUtil.isEmpty((String)gradlePath) || ":".equals(gradlePath);
                if (isRootModule) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = mainModuleData.getInternalName();
                } else {
                    stringArray = (String[])ArrayUtil.remove((Object[])gradlePath.split(":"), (int)0);
                }
                moduleGroup = stringArray;
                mainModuleData.setIdeModuleGroup(isRootModule ? null : moduleGroup);
            }
            for (ExternalSourceSet sourceSet : externalProject.getSourceSets().values()) {
                String moduleId = GradleProjectResolverUtil.getModuleId(this.resolverCtx, gradleModule, sourceSet);
                String moduleExternalName = gradleModule.getName() + ":" + sourceSet.getName();
                String moduleInternalName = GradleProjectResolverUtil.getInternalModuleName(gradleModule, externalProject, sourceSet.getName(), this.resolverCtx);
                GradleSourceSetData sourceSetData = new GradleSourceSetData(moduleId, moduleExternalName, moduleInternalName, mainModuleFileDirectoryPath, mainModuleConfigPath);
                sourceSetData.setGroup(externalProject.getGroup());
                if ("main".equals(sourceSet.getName())) {
                    sourceSetData.setPublication((ProjectCoordinate)new ProjectId(externalProject.getGroup(), externalProject.getName(), externalProject.getVersion()));
                }
                sourceSetData.setVersion(externalProject.getVersion());
                sourceSetData.setIdeModuleGroup(moduleGroup);
                sourceSetData.setSourceCompatibility(sourceSet.getSourceCompatibility());
                sourceSetData.setTargetCompatibility(sourceSet.getTargetCompatibility());
                sourceSetData.setSdkName(jdkName);
                THashSet artifacts = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.FILE_HASHING_STRATEGY);
                if ("main".equals(sourceSet.getName())) {
                    Set defaultArtifacts = (Set)externalProject.getArtifactsByConfiguration().get("default");
                    if (defaultArtifacts != null) {
                        artifacts.addAll(defaultArtifacts);
                    }
                    if (externalProject.getArtifactsByConfiguration().get("archives") != null) {
                        HashSet archivesArtifacts = ContainerUtil.newHashSet((Iterable)((Iterable)externalProject.getArtifactsByConfiguration().get("archives")));
                        Set testsArtifacts = (Set)externalProject.getArtifactsByConfiguration().get("tests");
                        if (testsArtifacts != null) {
                            archivesArtifacts.removeAll(testsArtifacts);
                        }
                        artifacts.addAll(archivesArtifacts);
                    }
                } else if ("test".equals(sourceSet.getName())) {
                    sourceSetData.setProductionModuleId(GradleProjectResolverUtil.getInternalModuleName(gradleModule, externalProject, "main", this.resolverCtx));
                    Set testsArtifacts = (Set)externalProject.getArtifactsByConfiguration().get("tests");
                    if (testsArtifacts != null) {
                        artifacts.addAll(testsArtifacts);
                    }
                }
                artifacts.addAll(sourceSet.getArtifacts());
                sourceSetData.setArtifacts(ContainerUtil.newArrayList((Iterable)artifacts));
                DataNode sourceSetDataNode = mainModuleNode.createChild(GradleSourceSetData.KEY, (Object)sourceSetData);
                Map sourceSetMap = (Map)projectDataNode.getUserData(GradleProjectResolver.RESOLVED_SOURCE_SETS);
                assert (sourceSetMap != null);
                sourceSetMap.put(moduleId, Pair.create((Object)sourceSetDataNode, (Object)sourceSet));
            }
        } else {
            try {
                IdeaJavaLanguageSettings languageSettings = gradleModule.getJavaLanguageSettings();
                if (languageSettings != null) {
                    if (languageSettings.getLanguageLevel() != null) {
                        mainModuleData.setSourceCompatibility(languageSettings.getLanguageLevel().toString());
                    }
                    if (languageSettings.getTargetBytecodeVersion() != null) {
                        mainModuleData.setTargetCompatibility(languageSettings.getTargetBytecodeVersion().toString());
                    }
                }
                mainModuleData.setSdkName(jdkName);
            }
            catch (UnsupportedMethodException languageSettings) {
                // empty catch block
            }
        }
        ProjectData projectData = (ProjectData)projectDataNode.getData();
        if (StringUtil.equals((CharSequence)mainModuleData.getLinkedExternalProjectPath(), (CharSequence)projectData.getLinkedExternalProjectPath())) {
            projectData.setGroup(mainModuleData.getGroup());
            projectData.setVersion(mainModuleData.getVersion());
        }
        DataNode<ModuleData> dataNode = mainModuleNode;
        if (dataNode == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(8);
        }
        return dataNode;
    }

    @Nullable
    private static String getJdkName(@NotNull IdeaModule gradleModule) {
        if (gradleModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(9);
        }
        try {
            return gradleModule.getJdkName();
        }
        catch (UnsupportedMethodException e) {
            return null;
        }
    }

    @Override
    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        IntelliJSettings intellijSettings;
        BuildScriptClasspathModel buildScriptClasspathModel;
        if (gradleModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(10);
        }
        if (ideModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(11);
        }
        List classpathEntries = (buildScriptClasspathModel = this.resolverCtx.getExtraProject(gradleModule, BuildScriptClasspathModel.class)) != null ? ContainerUtil.map((Collection)buildScriptClasspathModel.getClasspath(), model -> new BuildScriptClasspathData.ClasspathEntry(model.getClasses(), model.getSources(), model.getJavadoc())) : ContainerUtil.emptyList();
        BuildScriptClasspathData buildScriptClasspathData = new BuildScriptClasspathData(GradleConstants.SYSTEM_ID, classpathEntries);
        buildScriptClasspathData.setGradleHomeDir(buildScriptClasspathModel != null ? buildScriptClasspathModel.getGradleHomeDir() : null);
        ideModule.createChild(BuildScriptClasspathData.KEY, (Object)buildScriptClasspathData);
        GradleExtensions gradleExtensions = this.resolverCtx.getExtraProject(gradleModule, GradleExtensions.class);
        if (gradleExtensions != null) {
            DefaultGradleExtensions extensions = new DefaultGradleExtensions(gradleExtensions);
            ExternalProject externalProject = this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
            if (externalProject != null) {
                extensions.getTasks().addAll(externalProject.getTasks().values());
            }
            ideModule.createChild(GradleExtensionsDataService.KEY, (Object)extensions);
        }
        if ((intellijSettings = this.resolverCtx.getExtraProject(gradleModule, IntelliJSettings.class)) != null) {
            ideModule.createChild(ProjectKeys.CONFIGURATION, (Object)new ConfigurationDataImpl(GradleConstants.SYSTEM_ID, intellijSettings.getSettings()));
        }
    }

    @Override
    public void populateModuleContentRoots(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        DomainObjectSet contentRoots;
        ExternalProject externalProject;
        if (gradleModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(12);
        }
        if (ideModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(13);
        }
        if ((externalProject = this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class)) != null) {
            BaseGradleProjectResolverExtension.processSourceSets(this.resolverCtx, gradleModule, externalProject, ideModule, new SourceSetsProcessor(){

                @Override
                public void process(@NotNull DataNode<? extends ModuleData> dataNode, @NotNull ExternalSourceSet sourceSet) {
                    if (dataNode == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (sourceSet == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    for (Map.Entry directorySetEntry : sourceSet.getSources().entrySet()) {
                        ExternalSystemSourceType sourceType = ExternalSystemSourceType.from((IExternalSystemSourceType)((IExternalSystemSourceType)directorySetEntry.getKey()));
                        ExternalSourceDirectorySet sourceDirectorySet = (ExternalSourceDirectorySet)directorySetEntry.getValue();
                        for (File file : sourceDirectorySet.getSrcDirs()) {
                            ContentRootData ideContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, file.getAbsolutePath());
                            ideContentRoot.storePath(sourceType, file.getAbsolutePath());
                            dataNode.createChild(ProjectKeys.CONTENT_ROOT, (Object)ideContentRoot);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "dataNode";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "sourceSet";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension$1";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        if ((contentRoots = gradleModule.getContentRoots()) == null) {
            return;
        }
        for (IdeaContentRoot gradleContentRoot : contentRoots) {
            Set excluded;
            File rootDirectory;
            if (gradleContentRoot == null || (rootDirectory = gradleContentRoot.getRootDirectory()) == null) continue;
            ContentRootData ideContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, rootDirectory.getAbsolutePath());
            if (externalProject == null) {
                BaseGradleProjectResolverExtension.populateContentRoot(ideContentRoot, ExternalSystemSourceType.SOURCE, (Iterable<? extends IdeaSourceDirectory>)gradleContentRoot.getSourceDirectories());
                BaseGradleProjectResolverExtension.populateContentRoot(ideContentRoot, ExternalSystemSourceType.TEST, (Iterable<? extends IdeaSourceDirectory>)gradleContentRoot.getTestDirectories());
                if (gradleContentRoot instanceof ExtIdeaContentRoot) {
                    ExtIdeaContentRoot extIdeaContentRoot = (ExtIdeaContentRoot)gradleContentRoot;
                    BaseGradleProjectResolverExtension.populateContentRoot(ideContentRoot, ExternalSystemSourceType.RESOURCE, (Iterable<? extends IdeaSourceDirectory>)extIdeaContentRoot.getResourceDirectories());
                    BaseGradleProjectResolverExtension.populateContentRoot(ideContentRoot, ExternalSystemSourceType.TEST_RESOURCE, (Iterable<? extends IdeaSourceDirectory>)extIdeaContentRoot.getTestResourceDirectories());
                }
            }
            if ((excluded = gradleContentRoot.getExcludeDirectories()) != null) {
                for (File file : excluded) {
                    ideContentRoot.storePath(ExternalSystemSourceType.EXCLUDED, file.getAbsolutePath());
                }
            }
            ideModule.createChild(ProjectKeys.CONTENT_ROOT, (Object)ideContentRoot);
        }
    }

    private static void processSourceSets(@NotNull ProjectResolverContext resolverCtx, @NotNull IdeaModule gradleModule, @NotNull ExternalProject externalProject, @NotNull DataNode<ModuleData> ideModule, @NotNull SourceSetsProcessor processor) {
        if (resolverCtx == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(14);
        }
        if (gradleModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(15);
        }
        if (externalProject == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(16);
        }
        if (ideModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(17);
        }
        if (processor == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(18);
        }
        HashMap sourceSetsMap = ContainerUtil.newHashMap();
        for (DataNode dataNode : ExternalSystemApiUtil.findAll(ideModule, GradleSourceSetData.KEY)) {
            sourceSetsMap.put(((GradleSourceSetData)((Object)dataNode.getData())).getId(), dataNode);
        }
        for (ExternalSourceSet sourceSet : externalProject.getSourceSets().values()) {
            DataNode moduleDataNode;
            if (sourceSet == null || sourceSet.getSources().isEmpty()) continue;
            String moduleId = GradleProjectResolverUtil.getModuleId(resolverCtx, gradleModule, sourceSet);
            DataNode dataNode = moduleDataNode = sourceSetsMap.isEmpty() ? ideModule : (DataNode)sourceSetsMap.get(moduleId);
            if (moduleDataNode == null) continue;
            processor.process((DataNode<? extends ModuleData>)moduleDataNode, sourceSet);
        }
    }

    @Override
    public void populateModuleCompileOutputSettings(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        boolean inheritOutputDirs;
        if (gradleModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(19);
        }
        if (ideModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(20);
        }
        ModuleData moduleData = (ModuleData)ideModule.getData();
        File ideaOutDir = new File(moduleData.getLinkedExternalProjectPath(), "out");
        ExternalProject externalProject = this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        if (this.resolverCtx.isResolveModulePerSourceSet() && externalProject != null) {
            DataNode projectDataNode = ideModule.getDataNode(ProjectKeys.PROJECT);
            assert (projectDataNode != null);
            final Map moduleOutputsMap = (Map)projectDataNode.getUserData(GradleProjectResolver.MODULES_OUTPUTS);
            assert (moduleOutputsMap != null);
            final HashSet outputDirs = ContainerUtil.newHashSet();
            BaseGradleProjectResolverExtension.processSourceSets(this.resolverCtx, gradleModule, externalProject, ideModule, new SourceSetsProcessor(){

                @Override
                public void process(@NotNull DataNode<? extends ModuleData> dataNode, @NotNull ExternalSourceSet sourceSet) {
                    MultiMap gradleOutputMap;
                    if (dataNode == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (sourceSet == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if ((gradleOutputMap = (MultiMap)dataNode.getUserData(GradleProjectResolver.GRADLE_OUTPUTS)) == null) {
                        gradleOutputMap = MultiMap.create();
                        dataNode.putUserData(GradleProjectResolver.GRADLE_OUTPUTS, (Object)gradleOutputMap);
                    }
                    for (Map.Entry directorySetEntry : sourceSet.getSources().entrySet()) {
                        ExternalSystemSourceType sourceType = ExternalSystemSourceType.from((IExternalSystemSourceType)((IExternalSystemSourceType)directorySetEntry.getKey()));
                        ExternalSourceDirectorySet sourceDirectorySet = (ExternalSourceDirectorySet)directorySetEntry.getValue();
                        ModuleData moduleData = (ModuleData)dataNode.getData();
                        File outputDir = sourceDirectorySet.getOutputDir();
                        outputDirs.add(outputDir.getPath());
                        moduleData.setCompileOutputPath(sourceType, outputDir.getAbsolutePath());
                        moduleData.setInheritProjectCompileOutputPath(sourceDirectorySet.isCompilerOutputPathInherited());
                        for (File gradleOutputDir : sourceDirectorySet.getGradleOutputDirs()) {
                            String gradleOutputPath = ExternalSystemApiUtil.toCanonicalPath((String)gradleOutputDir.getAbsolutePath());
                            gradleOutputMap.putValue((Object)sourceType, (Object)gradleOutputPath);
                            if (gradleOutputDir.getPath().equals(outputDir.getPath())) continue;
                            moduleOutputsMap.put(gradleOutputPath, Pair.create((Object)moduleData.getId(), (Object)sourceType));
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "dataNode";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "sourceSet";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension$2";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            if (outputDirs.stream().anyMatch(path -> FileUtil.isAncestor((File)ideaOutDir, (File)new File((String)path), (boolean)false))) {
                this.excludeOutDir(ideModule, ideaOutDir);
            }
            return;
        }
        IdeaCompilerOutput moduleCompilerOutput = gradleModule.getCompilerOutput();
        HashMap compileOutputPaths = ContainerUtil.newHashMap();
        boolean bl = inheritOutputDirs = moduleCompilerOutput != null && moduleCompilerOutput.getInheritOutputDirs();
        if (moduleCompilerOutput != null) {
            File outputDir = moduleCompilerOutput.getOutputDir();
            File classesOutputDir = (File)ObjectUtils.chooseNotNull((Object)outputDir, (Object)new File(ideaOutDir, "production/classes"));
            compileOutputPaths.put(ExternalSystemSourceType.SOURCE, classesOutputDir);
            File resourcesOutputDir = (File)ObjectUtils.chooseNotNull((Object)outputDir, (Object)new File(ideaOutDir, "production/resources"));
            compileOutputPaths.put(ExternalSystemSourceType.RESOURCE, resourcesOutputDir);
            File testOutputDir = moduleCompilerOutput.getTestOutputDir();
            File testClassesOutputDir = (File)ObjectUtils.chooseNotNull((Object)testOutputDir, (Object)new File(ideaOutDir, "test/classes"));
            compileOutputPaths.put(ExternalSystemSourceType.TEST, testClassesOutputDir);
            File testResourcesOutputDir = (File)ObjectUtils.chooseNotNull((Object)testOutputDir, (Object)new File(ideaOutDir, "test/resources"));
            compileOutputPaths.put(ExternalSystemSourceType.TEST_RESOURCE, testResourcesOutputDir);
            if (!(inheritOutputDirs || outputDir != null && testOutputDir != null)) {
                this.excludeOutDir(ideModule, ideaOutDir);
            }
        }
        for (Map.Entry sourceTypeFileEntry : compileOutputPaths.entrySet()) {
            File outputPath = (File)sourceTypeFileEntry.getValue();
            if (outputPath == null) continue;
            moduleData.setCompileOutputPath((ExternalSystemSourceType)sourceTypeFileEntry.getKey(), outputPath.getAbsolutePath());
        }
        moduleData.setInheritProjectCompileOutputPath(inheritOutputDirs);
    }

    private void excludeOutDir(@NotNull DataNode<ModuleData> ideModule, File ideaOutDir) {
        DataNode contentRootDataDataNode;
        if (ideModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(21);
        }
        ContentRootData excludedContentRootData = (contentRootDataDataNode = ExternalSystemApiUtil.find(ideModule, (Key)ProjectKeys.CONTENT_ROOT)) == null || !FileUtil.isAncestor((File)new File(((ContentRootData)contentRootDataDataNode.getData()).getRootPath()), (File)ideaOutDir, (boolean)false) ? new ContentRootData(GradleConstants.SYSTEM_ID, ideaOutDir.getAbsolutePath()) : (ContentRootData)contentRootDataDataNode.getData();
        excludedContentRootData.storePath(ExternalSystemSourceType.EXCLUDED, ideaOutDir.getAbsolutePath());
        ideModule.createChild(ProjectKeys.CONTENT_ROOT, (Object)excludedContentRootData);
    }

    @Nullable
    private static File selectCompileOutputDir(@Nullable File outputDir, @NotNull String projectPath, String path) {
        if (projectPath == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(22);
        }
        return outputDir != null ? outputDir : new File(projectPath, path);
    }

    @Override
    public void populateModuleDependencies(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, final @NotNull DataNode<ProjectData> ideProject) {
        ExternalSystemTaskId taskId;
        Project project;
        List dependencies;
        ExternalProject externalProject;
        if (gradleModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(23);
        }
        if (ideModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(24);
        }
        if (ideProject == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(25);
        }
        if ((externalProject = this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class)) != null) {
            final Map sourceSetMap = (Map)ideProject.getUserData(GradleProjectResolver.RESOLVED_SOURCE_SETS);
            final Map artifactsMap = (Map)ideProject.getUserData(GradleProjectResolver.CONFIGURATION_ARTIFACTS);
            assert (artifactsMap != null);
            if (this.resolverCtx.isResolveModulePerSourceSet()) {
                assert (sourceSetMap != null);
                BaseGradleProjectResolverExtension.processSourceSets(this.resolverCtx, gradleModule, externalProject, ideModule, new SourceSetsProcessor(){

                    @Override
                    public void process(@NotNull DataNode<? extends ModuleData> dataNode, @NotNull ExternalSourceSet sourceSet) {
                        if (dataNode == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        if (sourceSet == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        GradleProjectResolverUtil.buildDependencies(BaseGradleProjectResolverExtension.this.resolverCtx, sourceSetMap, artifactsMap, dataNode, sourceSet.getDependencies(), (DataNode<ProjectData>)ideProject);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "dataNode";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "sourceSet";
                                break;
                            }
                        }
                        objectArray[1] = "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension$3";
                        objectArray[2] = "process";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                return;
            }
        }
        if ((dependencies = gradleModule.getDependencies().getAll()) == null) {
            return;
        }
        ArrayList orphanModules = ContainerUtil.newArrayList();
        for (int i = 0; i < dependencies.size(); ++i) {
            ModuleDependencyData d;
            IdeaDependency dependency = (IdeaDependency)dependencies.get(i);
            if (dependency == null) continue;
            DependencyScope scope = BaseGradleProjectResolverExtension.parseScope(dependency.getScope());
            if (dependency instanceof IdeaModuleDependency) {
                d = BaseGradleProjectResolverExtension.buildDependency(this.resolverCtx, ideModule, (IdeaModuleDependency)dependency, ideProject);
                d.setExported(dependency.getExported());
                if (scope != null) {
                    d.setScope(scope);
                }
                d.setOrder(i);
                ideModule.createChild(ProjectKeys.MODULE_DEPENDENCY, (Object)d);
                ModuleData targetModule = (ModuleData)d.getTarget();
                if (!targetModule.getId().isEmpty() || !targetModule.getLinkedExternalProjectPath().isEmpty()) continue;
                orphanModules.add(targetModule.getExternalName());
                continue;
            }
            if (!(dependency instanceof IdeaSingleEntryLibraryDependency)) continue;
            d = this.buildDependency(gradleModule, ideModule, (IdeaSingleEntryLibraryDependency)dependency, ideProject);
            d.setExported(dependency.getExported());
            if (scope != null) {
                d.setScope(scope);
            }
            d.setOrder(i);
            ideModule.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)d);
        }
        if (!orphanModules.isEmpty() && (project = (taskId = this.resolverCtx.getExternalSystemTaskId()).findProject()) != null) {
            String msg = "Can't find the following module" + (orphanModules.size() > 1 ? "s" : "") + ": " + StringUtil.join((Collection)orphanModules, (String)", ") + "\nIt can be caused by composite build configuration inside your *.gradle scripts with Gradle version older than 3.3.\nTry Gradle 3.3 or better or enable 'Create separate module per source set' option";
            NotificationData notification = new NotificationData("Gradle project structure problems", msg, NotificationCategory.WARNING, NotificationSource.PROJECT_SYNC);
            ExternalSystemNotificationManager.getInstance((Project)project).showNotification(taskId.getProjectSystemId(), notification);
        }
    }

    @Override
    @NotNull
    public Collection<TaskData> populateModuleTasks(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull DataNode<ProjectData> ideProject) throws IllegalArgumentException, IllegalStateException {
        boolean isFlatProject;
        if (gradleModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(26);
        }
        if (ideModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(27);
        }
        if (ideProject == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(28);
        }
        ArrayList tasks = ContainerUtil.newArrayList();
        String moduleConfigPath = ((ModuleData)ideModule.getData()).getLinkedExternalProjectPath();
        ExternalProject externalProject = this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        String rootProjectPath = ((ProjectData)ideProject.getData()).getLinkedExternalProjectPath();
        try {
            GradleBuild build = this.resolverCtx.getExtraProject(gradleModule, GradleBuild.class);
            if (build != null) {
                rootProjectPath = ExternalSystemApiUtil.toCanonicalPath((String)build.getRootProject().getProjectDirectory().getCanonicalPath());
            }
        }
        catch (IOException e) {
            LOG.warn("construction of the canonical path for the module fails", (Throwable)e);
        }
        boolean bl = isFlatProject = !FileUtil.isAncestor((String)rootProjectPath, (String)moduleConfigPath, (boolean)false);
        if (externalProject != null) {
            for (ExternalTask task : externalProject.getTasks().values()) {
                String taskName = isFlatProject ? task.getQName() : task.getName();
                String taskGroup = task.getGroup();
                if (taskName.trim().isEmpty() || GradleProjectResolverUtil.isIdeaTask(taskName, taskGroup)) continue;
                String taskPath = isFlatProject ? rootProjectPath : moduleConfigPath;
                TaskData taskData = new TaskData(GradleConstants.SYSTEM_ID, taskName, taskPath, task.getDescription());
                taskData.setGroup(taskGroup);
                taskData.setType(task.getType());
                ideModule.createChild(ProjectKeys.TASK, (Object)taskData);
                taskData.setInherited(StringUtil.equals((CharSequence)task.getName(), (CharSequence)task.getQName()));
                tasks.add(taskData);
            }
            ArrayList arrayList = tasks;
            if (arrayList == null) {
                BaseGradleProjectResolverExtension.$$$reportNull$$$0(29);
            }
            return arrayList;
        }
        for (GradleTask task : gradleModule.getGradleProject().getTasks()) {
            String taskName = task.getName();
            String taskGroup = BaseGradleProjectResolverExtension.getTaskGroup(task);
            if (taskName == null || taskName.trim().isEmpty() || GradleProjectResolverUtil.isIdeaTask(taskName, taskGroup)) continue;
            TaskData taskData = new TaskData(GradleConstants.SYSTEM_ID, taskName, moduleConfigPath, task.getDescription());
            taskData.setGroup(taskGroup);
            ideModule.createChild(ProjectKeys.TASK, (Object)taskData);
            tasks.add(taskData);
        }
        ArrayList arrayList = tasks;
        if (arrayList == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    @Nullable
    private static String getTaskGroup(GradleTask task) {
        String taskGroup;
        try {
            taskGroup = task.getGroup();
        }
        catch (UnsupportedMethodException e) {
            taskGroup = null;
        }
        return taskGroup;
    }

    @Override
    @NotNull
    public Set<Class> getExtraProjectModelClasses() {
        Set result = ContainerUtil.set((Object[])new Class[]{GradleBuild.class, ModuleExtendedModel.class});
        result.add(BuildScriptClasspathModel.class);
        result.add(GradleExtensions.class);
        result.add(ExternalProject.class);
        result.add(IntelliJProjectSettings.class);
        result.add(IntelliJSettings.class);
        Set set = result;
        if (set == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(31);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<Class> getToolingExtensionsClasses() {
        Set set = ContainerUtil.set((Object[])new Class[]{ExternalSystemSourceType.class, ProjectImportAction.class, ModelBuildScriptClasspathBuilderImpl.class, InputSupplier.class, GsonBuilder.class, ShortTypeHandling.class});
        if (set == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(32);
        }
        return set;
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getExtraJvmArgs() {
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            List hosts;
            ArrayList extraJvmArgs = ContainerUtil.newArrayList();
            HttpConfigurable httpConfigurable = HttpConfigurable.getInstance();
            if (!StringUtil.isEmpty((String)httpConfigurable.PROXY_EXCEPTIONS) && !(hosts = StringUtil.split((String)httpConfigurable.PROXY_EXCEPTIONS, (String)",")).isEmpty()) {
                String nonProxyHosts = StringUtil.join((Collection)hosts, (Function)StringUtil.TRIMMER, (String)"|");
                extraJvmArgs.add(Pair.pair((Object)"http.nonProxyHosts", (Object)nonProxyHosts));
                extraJvmArgs.add(Pair.pair((Object)"https.nonProxyHosts", (Object)nonProxyHosts));
            }
            if (httpConfigurable.USE_HTTP_PROXY && StringUtil.isNotEmpty((String)httpConfigurable.getProxyLogin())) {
                extraJvmArgs.add(Pair.pair((Object)"http.proxyUser", (Object)httpConfigurable.getProxyLogin()));
                extraJvmArgs.add(Pair.pair((Object)"https.proxyUser", (Object)httpConfigurable.getProxyLogin()));
                String plainProxyPassword = httpConfigurable.getPlainProxyPassword();
                extraJvmArgs.add(Pair.pair((Object)"http.proxyPassword", (Object)plainProxyPassword));
                extraJvmArgs.add(Pair.pair((Object)"https.proxyPassword", (Object)plainProxyPassword));
            }
            extraJvmArgs.addAll(httpConfigurable.getJvmProperties(false, null));
            ArrayList arrayList = extraJvmArgs;
            if (arrayList == null) {
                BaseGradleProjectResolverExtension.$$$reportNull$$$0(33);
            }
            return arrayList;
        }
        List<Pair<String, String>> list = Collections.emptyList();
        if (list == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(34);
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getExtraCommandLineArgs() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(35);
        }
        return list;
    }

    @Override
    @NotNull
    public ExternalSystemException getUserFriendlyError(@NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        if (error == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(36);
        }
        if (projectPath == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(37);
        }
        ExternalSystemException externalSystemException = this.myErrorHandler.getUserFriendlyError(error, projectPath, buildFilePath);
        if (externalSystemException == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(38);
        }
        return externalSystemException;
    }

    @Override
    public void preImportCheck() {
    }

    @Override
    public void enhanceTaskProcessing(@NotNull List<String> taskNames, @Nullable String jvmAgentSetup, @NotNull Consumer<String> initScriptConsumer) {
        if (taskNames == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(39);
        }
        if (initScriptConsumer == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(40);
        }
        if (!StringUtil.isEmpty((String)jvmAgentSetup)) {
            String names = "[\"" + StringUtil.join(taskNames, (String)"\", \"") + "\"]";
            String[] lines = new String[]{"gradle.taskGraph.beforeTask { Task task ->", "    if (task instanceof JavaForkOptions && (" + names + ".contains(task.name) || " + names + ".contains(task.path))) {", "        def jvmArgs = task.jvmArgs.findAll{!it?.startsWith('-agentlib:jdwp') && !it?.startsWith('-Xrunjdwp')}", "        jvmArgs << '" + jvmAgentSetup.trim().replace("\\", "\\\\") + '\'', "        task.jvmArgs = jvmArgs", "    }}"};
            String script = StringUtil.join((String[])lines, (String)SystemProperties.getLineSeparator());
            initScriptConsumer.consume((Object)script);
        }
    }

    public void enhanceRemoteProcessing(@NotNull SimpleJavaParameters parameters) throws ExecutionException {
        if (parameters == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(41);
        }
        PathsList classPath = parameters.getClassPath();
        ExternalSystemApiUtil.addBundle((PathsList)classPath, (String)"i18n.GradleBundle", GradleBundle.class);
        String toolingApiPath = PathManager.getJarPathForClass(ProjectConnection.class);
        if (toolingApiPath == null) {
            LOG.warn(GradleBundle.message("gradle.generic.text.error.jar.not.found", new Object[0]));
            throw new ExecutionException("Can't find gradle libraries");
        }
        File gradleJarsDir = new File(toolingApiPath).getParentFile();
        File[] gradleJars = gradleJarsDir.listFiles(FileFilters.filesWithExtension((String)"jar"));
        if (gradleJars == null) {
            LOG.warn(GradleBundle.message("gradle.generic.text.error.jar.not.found", new Object[0]));
            throw new ExecutionException("Can't find gradle libraries at " + gradleJarsDir.getAbsolutePath());
        }
        for (File jar : gradleJars) {
            classPath.add(jar.getAbsolutePath());
        }
        ArrayList additionalEntries = ContainerUtilRt.newArrayList();
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(GroovyObject.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(GsonBuilder.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(ExternalProject.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(JavaProjectData.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(LanguageLevel.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(StdModuleTypes.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(JavaModuleType.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(ModuleType.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(EmptyModuleType.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(ProjectImportAction.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(Init.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(Logger.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(Log4jLoggerFactory.class));
        for (String entry : additionalEntries) {
            classPath.add(entry);
        }
    }

    public void enhanceLocalProcessing(@NotNull List<URL> urls) {
        if (urls == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(42);
        }
    }

    private static void populateContentRoot(@NotNull ContentRootData contentRoot, @NotNull ExternalSystemSourceType type, @Nullable Iterable<? extends IdeaSourceDirectory> dirs) throws IllegalArgumentException {
        if (contentRoot == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(43);
        }
        if (type == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(44);
        }
        if (dirs == null) {
            return;
        }
        for (IdeaSourceDirectory ideaSourceDirectory : dirs) {
            ExternalSystemSourceType dirSourceType = type;
            try {
                if (ideaSourceDirectory.isGenerated() && !dirSourceType.isGenerated()) {
                    ExternalSystemSourceType generatedType = ExternalSystemSourceType.from((boolean)dirSourceType.isTest(), (boolean)ideaSourceDirectory.isGenerated(), (boolean)dirSourceType.isResource(), (boolean)dirSourceType.isExcluded());
                    dirSourceType = generatedType != null ? generatedType : dirSourceType;
                }
            }
            catch (UnsupportedMethodException e) {
                LOG.warn(e.getMessage());
                BaseGradleProjectResolverExtension.printToolingProxyDiagnosticInfo(ideaSourceDirectory);
            }
            catch (Throwable e) {
                LOG.debug(e);
                BaseGradleProjectResolverExtension.printToolingProxyDiagnosticInfo(ideaSourceDirectory);
            }
            contentRoot.storePath(dirSourceType, ideaSourceDirectory.getDirectory().getAbsolutePath());
        }
    }

    private static void printToolingProxyDiagnosticInfo(@Nullable Object obj) {
        if (!LOG.isDebugEnabled() || obj == null) {
            return;
        }
        LOG.debug(String.format("obj: %s", obj));
        Class<?> aClass = obj.getClass();
        LOG.debug(String.format("obj class: %s", aClass));
        LOG.debug(String.format("classloader: %s", aClass.getClassLoader()));
        for (Method m : aClass.getDeclaredMethods()) {
            LOG.debug(String.format("obj m: %s", m));
        }
        if (obj instanceof Proxy) {
            try {
                Field hField = ReflectionUtil.findField(obj.getClass(), null, (String)"h");
                hField.setAccessible(true);
                Object h = hField.get(obj);
                Field delegateField = ReflectionUtil.findField(h.getClass(), null, (String)"delegate");
                delegateField.setAccessible(true);
                Object delegate = delegateField.get(h);
                LOG.debug(String.format("delegate: %s", delegate));
                LOG.debug(String.format("delegate class: %s", delegate.getClass()));
                LOG.debug(String.format("delegate classloader: %s", delegate.getClass().getClassLoader()));
                for (Method m : delegate.getClass().getDeclaredMethods()) {
                    LOG.debug(String.format("delegate m: %s", m));
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    @Nullable
    private static DependencyScope parseScope(@Nullable IdeaDependencyScope scope) {
        if (scope == null) {
            return null;
        }
        String scopeAsString = scope.getScope();
        if (scopeAsString == null) {
            return null;
        }
        for (DependencyScope dependencyScope : DependencyScope.values()) {
            if (!scopeAsString.equalsIgnoreCase(dependencyScope.toString())) continue;
            return dependencyScope;
        }
        return null;
    }

    @NotNull
    private static ModuleDependencyData buildDependency(@NotNull ProjectResolverContext resolverContext, @NotNull DataNode<ModuleData> ownerModule, @NotNull IdeaModuleDependency dependency, @NotNull DataNode<ProjectData> ideProject) throws IllegalStateException {
        IdeaModule module;
        if (resolverContext == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(45);
        }
        if (ownerModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(46);
        }
        if (dependency == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(47);
        }
        if (ideProject == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(48);
        }
        if ((module = dependency.getDependencyModule()) == null) {
            if (resolverContext.getSettings() != null) {
                String moduleName = dependency.getTargetModuleName();
                GradleExecutionWorkspace executionWorkspace = resolverContext.getSettings().getExecutionWorkspace();
                ModuleData moduleData = executionWorkspace.findModuleDataByName(moduleName);
                if (moduleData != null) {
                    ModuleDependencyData moduleDependencyData = new ModuleDependencyData((ModuleData)ownerModule.getData(), moduleData);
                    if (moduleDependencyData == null) {
                        BaseGradleProjectResolverExtension.$$$reportNull$$$0(49);
                    }
                    return moduleDependencyData;
                }
                for (IdeaProject project : resolverContext.getModels().getIncludedBuilds()) {
                    moduleData = executionWorkspace.findModuleDataByName(project.getName() + ':' + moduleName);
                    if (moduleData == null) continue;
                    ModuleDependencyData moduleDependencyData = new ModuleDependencyData((ModuleData)ownerModule.getData(), moduleData);
                    if (moduleDependencyData == null) {
                        BaseGradleProjectResolverExtension.$$$reportNull$$$0(50);
                    }
                    return moduleDependencyData;
                }
                ModuleDependencyData moduleDependencyData = new ModuleDependencyData((ModuleData)ownerModule.getData(), new ModuleData("", GradleConstants.SYSTEM_ID, StdModuleTypes.JAVA.getId(), moduleName, "", ""));
                if (moduleDependencyData == null) {
                    BaseGradleProjectResolverExtension.$$$reportNull$$$0(51);
                }
                return moduleDependencyData;
            }
            throw new IllegalStateException(String.format("Can't parse gradle module dependency '%s'. Reason: referenced module is null", dependency));
        }
        String moduleName = module.getName();
        if (moduleName == null) {
            throw new IllegalStateException(String.format("Can't parse gradle module dependency '%s'. Reason: referenced module name is undefined (module: '%s') ", dependency, module));
        }
        HashSet registeredModuleNames = ContainerUtilRt.newHashSet();
        Collection modulesDataNode = ExternalSystemApiUtil.getChildren(ideProject, (Key)ProjectKeys.MODULE);
        for (DataNode moduleDataNode : modulesDataNode) {
            String name = ((ModuleData)moduleDataNode.getData()).getExternalName();
            registeredModuleNames.add(name);
            if (!name.equals(moduleName)) continue;
            ModuleDependencyData moduleDependencyData = new ModuleDependencyData((ModuleData)ownerModule.getData(), (ModuleData)moduleDataNode.getData());
            if (moduleDependencyData == null) {
                BaseGradleProjectResolverExtension.$$$reportNull$$$0(52);
            }
            return moduleDependencyData;
        }
        throw new IllegalStateException(String.format("Can't parse gradle module dependency '%s'. Reason: no module with such name (%s) is found. Registered modules: %s", dependency, moduleName, registeredModuleNames));
    }

    @NotNull
    private LibraryDependencyData buildDependency(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ownerModule, @NotNull IdeaSingleEntryLibraryDependency dependency, @NotNull DataNode<ProjectData> ideProject) throws IllegalStateException {
        String libraryName;
        LibraryLevel level;
        File binaryPath;
        if (gradleModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(53);
        }
        if (ownerModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(54);
        }
        if (dependency == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(55);
        }
        if (ideProject == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(56);
        }
        if ((binaryPath = dependency.getFile()) == null) {
            throw new IllegalStateException(String.format("Can't parse external library dependency '%s'. Reason: it doesn't specify path to the binaries", dependency));
        }
        GradleModuleVersion moduleVersion = dependency.getGradleModuleVersion();
        boolean unresolved = binaryPath.getPath().startsWith(UNRESOLVED_DEPENDENCY_PREFIX);
        if (moduleVersion == null) {
            if (binaryPath.isFile()) {
                boolean isModuleLocalLibrary = false;
                try {
                    isModuleLocalLibrary = FileUtil.isAncestor((File)gradleModule.getGradleProject().getProjectDirectory(), (File)binaryPath, (boolean)false);
                }
                catch (UnsupportedMethodException unsupportedMethodException) {
                    // empty catch block
                }
                level = isModuleLocalLibrary ? LibraryLevel.MODULE : LibraryLevel.PROJECT;
                libraryName = this.chooseName(binaryPath, level, ideProject);
            } else {
                level = LibraryLevel.MODULE;
                libraryName = "";
            }
            if (unresolved) {
                int dependencyNameIndex;
                libraryName = binaryPath.getPath().substring(UNRESOLVED_DEPENDENCY_PREFIX.length());
                int i = libraryName.indexOf(32);
                if (i >= 0) {
                    i = CharArrayUtil.shiftForward((CharSequence)libraryName, (int)(i + 1), (String)" ");
                }
                if (i >= 0 && i < libraryName.length() && (i = libraryName.indexOf(32, dependencyNameIndex = i)) > 0) {
                    libraryName = String.format("%s-%s", libraryName.substring(dependencyNameIndex, i), libraryName.substring(i + 1));
                }
            }
        } else {
            level = LibraryLevel.PROJECT;
            libraryName = String.format("%s:%s:%s", moduleVersion.getGroup(), moduleVersion.getName(), moduleVersion.getVersion());
            if (binaryPath.isFile()) {
                String libraryFileName = FileUtil.getNameWithoutExtension((File)binaryPath);
                String mavenLibraryFileName = String.format("%s-%s", moduleVersion.getName(), moduleVersion.getVersion());
                if (!mavenLibraryFileName.equals(libraryFileName)) {
                    Pattern pattern = Pattern.compile(moduleVersion.getName() + "-" + moduleVersion.getVersion() + "-(.*)");
                    Matcher matcher = pattern.matcher(libraryFileName);
                    if (matcher.matches()) {
                        String classifier = matcher.group(1);
                        libraryName = libraryName + ":" + classifier;
                    } else {
                        String artifactId = StringUtil.trimEnd((String)StringUtil.trimEnd((String)libraryFileName, (String)moduleVersion.getVersion()), (String)"-");
                        libraryName = String.format("%s:%s:%s", moduleVersion.getGroup(), artifactId, moduleVersion.getVersion());
                    }
                }
            }
        }
        if (StringUtil.isNotEmpty((String)libraryName) && !FileUtilRt.extensionEquals((String)binaryPath.getPath(), (String)"jar")) {
            libraryName = libraryName + ":" + FileUtilRt.getExtension((String)binaryPath.getPath());
        }
        LibraryData library = new LibraryData(GradleConstants.SYSTEM_ID, libraryName, unresolved);
        if (moduleVersion != null) {
            library.setGroup(moduleVersion.getGroup());
            library.setArtifactId(moduleVersion.getName());
            library.setVersion(moduleVersion.getVersion());
        }
        if (!unresolved) {
            library.addPath(LibraryPathType.BINARY, binaryPath.getAbsolutePath());
        }
        File sourcePath = dependency.getSource();
        if (!unresolved && sourcePath != null) {
            library.addPath(LibraryPathType.SOURCE, sourcePath.getAbsolutePath());
        }
        if (!unresolved && sourcePath == null) {
            GradleProjectResolverUtil.attachGradleSdkSources(gradleModule, binaryPath, library, this.resolverCtx);
            if (this.resolverCtx instanceof DefaultProjectResolverContext) {
                GradleProjectResolverUtil.attachSourcesAndJavadocFromGradleCacheIfNeeded(((DefaultProjectResolverContext)this.resolverCtx).getGradleUserHome(), library);
            }
        }
        File javadocPath = dependency.getJavadoc();
        if (!unresolved && javadocPath != null) {
            library.addPath(LibraryPathType.DOC, javadocPath.getAbsolutePath());
        }
        if (level == LibraryLevel.PROJECT) {
            GradleProjectResolverUtil.linkProjectLibrary(ideProject, library);
        }
        LibraryDependencyData libraryDependencyData = new LibraryDependencyData((ModuleData)ownerModule.getData(), library, level);
        if (libraryDependencyData == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(57);
        }
        return libraryDependencyData;
    }

    private String chooseName(File path, LibraryLevel level, DataNode<ProjectData> ideProject) {
        String candidateName;
        DataNode libraryData;
        String fileName = FileUtil.getNameWithoutExtension((File)path);
        if (level == LibraryLevel.MODULE) {
            return fileName;
        }
        int count = 0;
        while ((libraryData = ExternalSystemApiUtil.find(ideProject, (Key)ProjectKeys.LIBRARY, arg_0 -> BaseGradleProjectResolverExtension.lambda$chooseName$2(candidateName = fileName + (count == 0 ? "" : "_" + count), arg_0))) != null) {
            if (((LibraryData)libraryData.getData()).getPaths(LibraryPathType.BINARY).contains(FileUtil.toSystemIndependentName((String)path.getAbsolutePath()))) {
                return candidateName;
            }
            ++count;
        }
        return candidateName;
    }

    private static /* synthetic */ boolean lambda$chooseName$2(String candidateName, DataNode node) {
        return ((LibraryData)node.getData()).getExternalName().equals(candidateName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectResolverContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProject";
                break;
            }
            case 5: 
            case 25: 
            case 28: 
            case 48: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProject";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 19: 
            case 23: 
            case 26: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleModule";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDataNode";
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModule";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverCtx";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProject";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 22: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskNames";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initScriptConsumer";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverContext";
                break;
            }
            case 46: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerModule";
                break;
            }
            case 47: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaProjectData";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "populateModuleTasks";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraProjectModelClasses";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolingExtensionsClasses";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraJvmArgs";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraCommandLineArgs";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserFriendlyError";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setProjectResolverContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setNext";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 57: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "populateProjectExtraModels";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getJdkName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleExtraModels";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleContentRoots";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processSourceSets";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleCompileOutputSettings";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "excludeOutDir";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "selectCompileOutputDir";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleDependencies";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleTasks";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getUserFriendlyError";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "enhanceTaskProcessing";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "enhanceRemoteProcessing";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "enhanceLocalProcessing";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "populateContentRoot";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "buildDependency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface SourceSetsProcessor {
        public void process(@NotNull DataNode<? extends ModuleData> var1, @NotNull ExternalSourceSet var2);
    }
}

