/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.resolve.GradleResolverUtil;
import org.jetbrains.plugins.gradle.service.resolve.UtilKt;
import org.jetbrains.plugins.gradle.settings.GradleExtensionsSettings;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyClosurePattern;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyPatternsKt;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"processExtension", "", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "place", "Lcom/intellij/psi/PsiElement;", "extension", "Lorg/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleExtension;", "gradle"})
public final class GradleExtensionsContributorKt {
    public static final boolean processExtension(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place, @NotNull GradleExtensionsSettings.GradleExtension extension) {
        Object $receiver;
        String name;
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        boolean shouldProcessMethods = ResolveUtil.shouldProcessMethods((ElementClassHint)classHint);
        GroovyPsiManager groovyPsiManager = GroovyPsiManager.getInstance((Project)place.getProject());
        GlobalSearchScope resolveScope = place.getResolveScope();
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)place.getProject()).findClass("org.gradle.api.Project", resolveScope);
        if (psiClass == null) {
            return true;
        }
        PsiClass projectClass = psiClass;
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        String string = name = nameHint != null ? nameHint.getName(state) : null;
        if (Intrinsics.areEqual((Object)name, (Object)extension.name)) {
            GrLightMethodBuilder grLightMethodBuilder;
            PsiClassType psiClassType = groovyPsiManager.createTypeByFQClassName(extension.rootTypeFqn, resolveScope);
            if (psiClassType == null) {
                return true;
            }
            PsiClassType returnClass = psiClassType;
            String methodName = shouldProcessMethods ? extension.name : "get" + StringsKt.capitalize((String)extension.name);
            $receiver = grLightMethodBuilder = new GrLightMethodBuilder(place.getManager(), methodName);
            $receiver.setContainingClass(projectClass);
            $receiver.setReturnType((PsiType)returnClass);
            GrLightMethodBuilder methodBuilder = grLightMethodBuilder;
            if (shouldProcessMethods) {
                methodBuilder.addParameter("configuration", "groovy.lang.Closure", true);
            }
            place.putUserData(UtilKt.RESOLVED_CODE, (Object)true);
            if (!processor.execute((PsiElement)methodBuilder, state)) {
                return false;
            }
        }
        GroovyClosurePattern groovyClosurePattern = GroovyPatternsKt.groovyClosure();
        String[] stringArray = new String[1];
        String string2 = extension.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"extension.name");
        stringArray[0] = string2;
        GroovyClosurePattern extensionClosure = groovyClosurePattern.inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.Project", (String[])stringArray));
        String placeText = place.getText();
        PsiJavaElementPattern.Capture psiElement = PsiJavaPatterns.psiElement();
        if (((PsiJavaElementPattern.Capture)psiElement.inside((ElementPattern)extensionClosure)).accepts((Object)place)) {
            GrLightMethodBuilder methodBuilder;
            Object it;
            CharSequence charSequence;
            if (shouldProcessMethods && !GradleResolverUtil.processDeclarations(processor, state, place, extension.rootTypeFqn)) {
                return false;
            }
            String string3 = extension.namedObjectTypeFqn;
            if (string3 == null || (string3 = !StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)(it = ($receiver = string3)))) ? it : null) == null) {
                return true;
            }
            String objectTypeFqn = string3;
            if (place.getParent() instanceof GrMethodCallExpression && (methodBuilder = GradleResolverUtil.createMethodWithClosure(placeText, objectTypeFqn, null, place)) != null) {
                place.putUserData(UtilKt.RESOLVED_CODE, (Object)true);
                if (!processor.execute((PsiElement)methodBuilder, state)) {
                    return false;
                }
            }
            if (place.getParent() instanceof GrReferenceExpression || ((PsiJavaElementPattern.Capture)psiElement.withTreeParent((ElementPattern)extensionClosure)).accepts((Object)place)) {
                GrLightVariable variable2 = new GrLightVariable(place.getManager(), placeText, objectTypeFqn, place);
                place.putUserData(UtilKt.RESOLVED_CODE, (Object)true);
                if (!processor.execute((PsiElement)variable2, state)) {
                    return false;
                }
            }
        }
        return true;
    }
}

