/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Text;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.config.GradleSettingsListenerAdapter;
import org.jetbrains.plugins.gradle.model.ExternalTask;
import org.jetbrains.plugins.gradle.model.GradleExtensions;
import org.jetbrains.plugins.gradle.model.GradleProperty;
import org.jetbrains.plugins.gradle.service.project.data.GradleExtensionsDataService;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@State(name="GradleExtensions", storages={@Storage(value="$WORKSPACE_FILE$", deprecated=true)})
public class GradleExtensionsSettings
implements PersistentStateComponent<Settings> {
    private static final Logger LOG = Logger.getInstance(GradleExtensionsSettings.class);
    private final Settings myState = new Settings();

    public GradleExtensionsSettings(Project project) {
        ExternalSystemApiUtil.subscribe((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (ExternalSystemSettingsListener)new GradleSettingsListenerAdapter(){

            public void onProjectsUnlinked(@NotNull Set<String> linkedProjectPaths) {
                if (linkedProjectPaths == null) {
                    1.$$$reportNull$$$0(0);
                }
                GradleExtensionsSettings.this.myState.remove(linkedProjectPaths);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkedProjectPaths", "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$1", "onProjectsUnlinked"));
            }
        });
    }

    @Nullable
    public Settings getState() {
        return new Settings();
    }

    public void loadState(Settings state) {
    }

    @NotNull
    public static Settings getInstance(@NotNull Project project) {
        if (project == null) {
            GradleExtensionsSettings.$$$reportNull$$$0(0);
        }
        Settings settings = ((GradleExtensionsSettings)ServiceManager.getService((Project)project, GradleExtensionsSettings.class)).myState;
        if (settings == null) {
            GradleExtensionsSettings.$$$reportNull$$$0(1);
        }
        return settings;
    }

    public static void load(Project project) {
        Collection projectsData = ProjectDataManager.getInstance().getExternalProjectsData(project, GradleConstants.SYSTEM_ID);
        for (ExternalProjectInfo projectInfo : projectsData) {
            DataNode projectDataNode = projectInfo.getExternalProjectStructure();
            if (projectDataNode == null) continue;
            SmartList nodes = new SmartList();
            for (DataNode moduleNode : ExternalSystemApiUtil.findAll((DataNode)projectDataNode, (Key)ProjectKeys.MODULE)) {
                ContainerUtil.addIfNotNull((Collection)nodes, (Object)ExternalSystemApiUtil.find((DataNode)moduleNode, GradleExtensionsDataService.KEY));
            }
            GradleExtensionsSettings.getInstance(project).add(projectInfo.getExternalProjectPath(), (Collection<DataNode<GradleExtensions>>)nodes);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="conf")
    public static class GradleConfiguration {
        @Attribute(value="name")
        public String name;
        @Attribute(value="visible")
        public boolean visible = true;
        @Attribute(value="scriptClasspath")
        public boolean scriptClasspath;
        @Text
        public String description;
    }

    @Tag(value="task")
    public static class GradleTask
    implements TypeAware {
        @Attribute(value="name")
        public String name;
        @Attribute(value="type")
        public String typeFqn = "org.gradle.api.DefaultTask";
        @Text
        @Nullable
        public String description;

        @Override
        public String getTypeFqn() {
            return this.typeFqn;
        }
    }

    @Tag(value="prop")
    public static class GradleProp
    implements TypeAware {
        @Attribute(value="name")
        public String name;
        @Attribute(value="type")
        public String typeFqn = "java.lang.String";
        @Text
        @Nullable
        public String value;

        @Override
        public String getTypeFqn() {
            return this.typeFqn;
        }
    }

    @Tag(value="ext")
    public static class GradleExtension
    implements TypeAware {
        @Attribute(value="name")
        public String name;
        @Attribute(value="type")
        public String rootTypeFqn = "Object";
        @Attribute(value="objectType")
        public String namedObjectTypeFqn;

        @Override
        public String getTypeFqn() {
            return this.rootTypeFqn;
        }
    }

    public static interface TypeAware {
        public String getTypeFqn();
    }

    @Tag(value="extensions")
    public static class GradleExtensionsData {
        @Transient
        private GradleProject myGradleProject;
        @Attribute(value="parent")
        public String parent;
        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false)
        public List<GradleExtension> extensions = new SmartList();
        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false)
        public List<GradleProp> properties = new SmartList();
        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false)
        public List<GradleTask> tasks = new SmartList();
        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false)
        public List<GradleConfiguration> configurations = new SmartList();

        @Transient
        @Nullable
        public GradleExtensionsData getParent() {
            if (this.myGradleProject == null) {
                return null;
            }
            return this.myGradleProject.extensions.get(this.parent);
        }

        @Nullable
        public GradleProp findProperty(@Nullable String name) {
            return GradleExtensionsData.findProperty(this, name);
        }

        @NotNull
        public Collection<GradleProp> findAllProperties() {
            Collection<GradleProp> collection = GradleExtensionsData.findAllProperties(this, ContainerUtil.newHashMap());
            if (collection == null) {
                GradleExtensionsData.$$$reportNull$$$0(0);
            }
            return collection;
        }

        @NotNull
        private static Collection<GradleProp> findAllProperties(@NotNull GradleExtensionsData extensionsData, @NotNull Map<String, GradleProp> result) {
            if (extensionsData == null) {
                GradleExtensionsData.$$$reportNull$$$0(1);
            }
            if (result == null) {
                GradleExtensionsData.$$$reportNull$$$0(2);
            }
            for (GradleProp property : extensionsData.properties) {
                if (result.containsKey(property.name)) continue;
                result.put(property.name, property);
            }
            if (extensionsData.getParent() != null) {
                GradleExtensionsData.findAllProperties(extensionsData.getParent(), result);
            }
            Collection<GradleProp> collection = result.values();
            if (collection == null) {
                GradleExtensionsData.$$$reportNull$$$0(3);
            }
            return collection;
        }

        @Nullable
        private static GradleProp findProperty(@NotNull GradleExtensionsData extensionsData, String propName) {
            GradleExtensionsData parentData;
            if (extensionsData == null) {
                GradleExtensionsData.$$$reportNull$$$0(4);
            }
            for (GradleProp property : extensionsData.properties) {
                if (!property.name.equals(propName)) continue;
                return property;
            }
            if (extensionsData.parent != null && extensionsData.myGradleProject != null && (parentData = extensionsData.myGradleProject.extensions.get(extensionsData.parent)) != null) {
                return GradleExtensionsData.findProperty(parentData, propName);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleExtensionsData";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extensionsData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findAllProperties";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleExtensionsData";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findAllProperties";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findProperty";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @Tag(value="sub-project")
    static class GradleProject {
        @Property(surroundWithTag=false)
        @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false, entryTagName="project", keyAttributeName="path")
        @NotNull
        public Map<String, GradleExtensionsData> extensions = new HashMap<String, GradleExtensionsData>();

        GradleProject() {
        }
    }

    public static class Settings {
        @Property(surroundWithTag=false)
        @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false, entryTagName="project", keyAttributeName="path")
        @NotNull
        public Map<String, GradleProject> projects = new HashMap<String, GradleProject>();

        public void add(@NotNull String rootPath, @NotNull Collection<DataNode<GradleExtensions>> extensionsData) {
            if (rootPath == null) {
                Settings.$$$reportNull$$$0(0);
            }
            if (extensionsData == null) {
                Settings.$$$reportNull$$$0(1);
            }
            HashMap extensionMap = ContainerUtil.newHashMap();
            for (DataNode<GradleExtensions> node : extensionsData) {
                DataNode parent = node.getParent();
                if (parent == null || !(parent.getData() instanceof ModuleData)) continue;
                String projectPath = ((ModuleData)parent.getData()).getLinkedExternalProjectPath();
                extensionMap.put(projectPath, node.getData());
            }
            this.add(rootPath, extensionMap);
        }

        public void add(@NotNull String rootPath, @NotNull Map<String, GradleExtensions> extensions) {
            if (rootPath == null) {
                Settings.$$$reportNull$$$0(2);
            }
            if (extensions == null) {
                Settings.$$$reportNull$$$0(3);
            }
            GradleProject gradleProject = new GradleProject();
            for (Map.Entry<String, GradleExtensions> entry : extensions.entrySet()) {
                GradleExtensionsData extensionsData = new GradleExtensionsData();
                GradleExtensions gradleExtensions = entry.getValue();
                try {
                    File parentProjectDir = gradleExtensions.getParentProjectDir();
                    if (parentProjectDir != null) {
                        extensionsData.parent = ExternalSystemApiUtil.toCanonicalPath((String)parentProjectDir.getCanonicalPath());
                    }
                }
                catch (IOException e) {
                    LOG.warn("construction of the canonical path for the gradle project fails", (Throwable)e);
                }
                for (org.jetbrains.plugins.gradle.model.GradleExtension extension : gradleExtensions.getExtensions()) {
                    GradleExtension gradleExtension = new GradleExtension();
                    gradleExtension.name = extension.getName();
                    gradleExtension.rootTypeFqn = extension.getTypeFqn();
                    gradleExtension.namedObjectTypeFqn = extension.getNamedObjectTypeFqn();
                    extensionsData.extensions.add(gradleExtension);
                }
                for (GradleProperty property : gradleExtensions.getGradleProperties()) {
                    GradleProp gradleProp = new GradleProp();
                    gradleProp.name = property.getName();
                    gradleProp.typeFqn = property.getTypeFqn();
                    extensionsData.properties.add(gradleProp);
                }
                for (ExternalTask task : gradleExtensions.getTasks()) {
                    GradleTask gradleTask = new GradleTask();
                    gradleTask.name = task.getName();
                    String type = task.getType();
                    if (type != null) {
                        gradleTask.typeFqn = type;
                    }
                    StringBuilder description = new StringBuilder();
                    if (task.getDescription() != null) {
                        description.append(task.getDescription());
                        if (task.getGroup() != null) {
                            description.append("<p>");
                        }
                    }
                    if (task.getGroup() != null) {
                        description.append("<i>Task group: ").append(task.getGroup()).append("<i>");
                    }
                    gradleTask.description = description.toString();
                    extensionsData.tasks.add(gradleTask);
                }
                for (org.jetbrains.plugins.gradle.model.GradleConfiguration configuration : gradleExtensions.getConfigurations()) {
                    GradleConfiguration gradleConfiguration = new GradleConfiguration();
                    gradleConfiguration.name = configuration.getName();
                    gradleConfiguration.description = configuration.getDescription();
                    gradleConfiguration.visible = configuration.isVisible();
                    gradleConfiguration.scriptClasspath = configuration.isScriptClasspathConfiguration();
                    extensionsData.configurations.add(gradleConfiguration);
                }
                gradleProject.extensions.put(entry.getKey(), extensionsData);
                extensionsData.myGradleProject = gradleProject;
            }
            HashMap<String, GradleProject> projects = new HashMap<String, GradleProject>(this.projects);
            projects.put(rootPath, gradleProject);
            this.projects = projects;
        }

        public void remove(Set<String> rootPaths) {
            HashMap<String, GradleProject> projects = new HashMap<String, GradleProject>(this.projects);
            for (String path : rootPaths) {
                projects.remove(path);
            }
            this.projects = projects;
        }

        @Nullable
        public GradleExtensionsData getExtensionsFor(@Nullable Module module) {
            if (module == null) {
                return null;
            }
            return this.getExtensionsFor(ExternalSystemApiUtil.getExternalRootProjectPath((Module)module), ExternalSystemApiUtil.getExternalProjectPath((Module)module));
        }

        @Nullable
        public GradleExtensionsData getExtensionsFor(@Nullable String rootProjectPath, @Nullable String projectPath) {
            if (rootProjectPath == null || projectPath == null) {
                return null;
            }
            GradleProject gradleProject = this.projects.get(rootProjectPath);
            if (gradleProject == null) {
                return null;
            }
            return gradleProject.extensions.get(projectPath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rootPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "extensionsData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "extensions";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$Settings";
            objectArray[2] = "add";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

