/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.core.AbstractComponentMatcher;
import org.fest.util.Preconditions;

public abstract class GenericTypeMatcher<T extends Component>
extends AbstractComponentMatcher {
    private final Class<T> supportedType;

    public GenericTypeMatcher(@Nonnull Class<T> supportedType) {
        if (supportedType == null) {
            GenericTypeMatcher.$$$reportNull$$$0(0);
        }
        this(supportedType, false);
    }

    public GenericTypeMatcher(@Nonnull Class<T> supportedType, boolean requireShowing) {
        if (supportedType == null) {
            GenericTypeMatcher.$$$reportNull$$$0(1);
        }
        super(requireShowing);
        this.supportedType = (Class)Preconditions.checkNotNull(supportedType);
    }

    @Override
    @RunsInCurrentThread
    public final boolean matches(@Nullable Component c) {
        if (c == null) {
            return false;
        }
        if (!this.supportedType.isInstance(c)) {
            return false;
        }
        try {
            return this.requireShowingMatches(c) && this.isMatching((Component)this.supportedType.cast(c));
        }
        catch (ClassCastException ignored) {
            return false;
        }
    }

    @Nonnull
    public final Class<T> supportedType() {
        Class<T> clazz = this.supportedType;
        if (clazz == null) {
            GenericTypeMatcher.$$$reportNull$$$0(2);
        }
        return clazz;
    }

    @RunsInCurrentThread
    protected abstract boolean isMatching(@Nonnull T var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/core/GenericTypeMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/core/GenericTypeMatcher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "supportedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

