/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.data;

import javax.annotation.Nonnull;
import javax.swing.JTable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JTableCellReader;
import org.fest.swing.data.TableCell;
import org.fest.swing.data.TableCellFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.ActionFailedException;
import org.fest.util.Arrays;
import org.fest.util.Objects;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

public class TableCellInRowByValue
implements TableCellFinder {
    private final String[] values;
    private final int column;

    @Nonnull
    public static TableCellBuilder rowWithValue(String ... values) {
        if (values == null) {
            TableCellInRowByValue.$$$reportNull$$$0(0);
        }
        TableCellBuilder tableCellBuilder = new TableCellBuilder(values);
        if (tableCellBuilder == null) {
            TableCellInRowByValue.$$$reportNull$$$0(1);
        }
        return tableCellBuilder;
    }

    protected TableCellInRowByValue(@Nonnull String[] values, int column) {
        if (values == null) {
            TableCellInRowByValue.$$$reportNull$$$0(2);
        }
        this.values = values;
        this.column = column;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public TableCell findCell(@Nonnull JTable table, @Nonnull JTableCellReader cellReader) {
        int row;
        if (table == null) {
            TableCellInRowByValue.$$$reportNull$$$0(3);
        }
        if (cellReader == null) {
            TableCellInRowByValue.$$$reportNull$$$0(4);
        }
        if ((row = TableCellInRowByValue.findRowIndex(table, cellReader, this.values)) == -1) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to find a row with values:<", Arrays.format((Object)this.values), ">"}));
        }
        TableCell tableCell = new TableCell(row, this.column);
        if (tableCell == null) {
            TableCellInRowByValue.$$$reportNull$$$0(5);
        }
        return tableCell;
    }

    @RunsInEDT
    private static int findRowIndex(final @Nonnull JTable table, final @Nonnull JTableCellReader cellReader, final @Nonnull String[] values) {
        if (table == null) {
            TableCellInRowByValue.$$$reportNull$$$0(6);
        }
        if (cellReader == null) {
            TableCellInRowByValue.$$$reportNull$$$0(7);
        }
        if (values == null) {
            TableCellInRowByValue.$$$reportNull$$$0(8);
        }
        Integer result = GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() {
                TableCellInRowByValue.validateEqualSize(table, values);
                int rowCount = table.getRowCount();
                for (int row = 0; row < rowCount; ++row) {
                    if (!TableCellInRowByValue.matchingRow(table, cellReader, values, row)) continue;
                    return row;
                }
                return -1;
            }
        });
        return (Integer)Preconditions.checkNotNull((Object)result);
    }

    @RunsInCurrentThread
    private static void validateEqualSize(@Nonnull JTable table, @Nonnull String[] values) {
        int columnCount;
        if (table == null) {
            TableCellInRowByValue.$$$reportNull$$$0(9);
        }
        if (values == null) {
            TableCellInRowByValue.$$$reportNull$$$0(10);
        }
        if (values.length != (columnCount = table.getColumnCount())) {
            throw new IllegalStateException(Strings.concat((Object[])new Object[]{"The array of values should have size:<", columnCount, ">"}));
        }
    }

    @RunsInCurrentThread
    private static boolean matchingRow(@Nonnull JTable table, @Nonnull JTableCellReader cellReader, @Nonnull String[] values, int row) {
        if (table == null) {
            TableCellInRowByValue.$$$reportNull$$$0(11);
        }
        if (cellReader == null) {
            TableCellInRowByValue.$$$reportNull$$$0(12);
        }
        if (values == null) {
            TableCellInRowByValue.$$$reportNull$$$0(13);
        }
        int columnCount = table.getColumnCount();
        for (int col = 0; col < columnCount; ++col) {
            if (Objects.areEqual((Object)cellReader.valueAt(table, row, col), (Object)values[col])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("%s[values=%s, column=%d]", this.getClass().getName(), Arrays.format((Object)this.values), this.column);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/data/TableCellInRowByValue";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/data/TableCellInRowByValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "rowWithValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findCell";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "rowWithValue";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findCell";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findRowIndex";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "validateEqualSize";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "matchingRow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TableCellBuilder {
        private final String[] values;

        TableCellBuilder(@Nonnull String[] values) {
            if (values == null) {
                TableCellBuilder.$$$reportNull$$$0(0);
            }
            this.values = (String[])Preconditions.checkNotNull((Object)values);
        }

        @Nonnull
        public TableCellInRowByValue column(int column) {
            TableCellInRowByValue tableCellInRowByValue = new TableCellInRowByValue(this.values, column);
            if (tableCellInRowByValue == null) {
                TableCellBuilder.$$$reportNull$$$0(1);
            }
            return tableCellInRowByValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@Nonnull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/fest/swing/data/TableCellInRowByValue$TableCellBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/fest/swing/data/TableCellInRowByValue$TableCellBuilder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "column";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

