/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.cell.JComboBoxCellReader;
import org.fest.swing.driver.BasicCellRendererReader;
import org.fest.swing.driver.CellRendererReader;
import org.fest.swing.driver.ModelValueToString;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.util.Preconditions;

public class BasicJComboBoxCellReader
implements JComboBoxCellReader {
    private static final JList REFERENCE_JLIST = BasicJComboBoxCellReader.newJList();
    private final CellRendererReader rendererReader;

    @Nonnull
    private static JList newJList() {
        JList result = GuiActionRunner.execute(new GuiQuery<JList>(){

            @Override
            @Nullable
            protected JList executeInEDT() {
                return new JList();
            }
        });
        JList jList = (JList)Preconditions.checkNotNull((Object)result);
        if (jList == null) {
            BasicJComboBoxCellReader.$$$reportNull$$$0(0);
        }
        return jList;
    }

    public BasicJComboBoxCellReader() {
        this(new BasicCellRendererReader());
    }

    public BasicJComboBoxCellReader(@Nonnull CellRendererReader rendererReader) {
        if (rendererReader == null) {
            BasicJComboBoxCellReader.$$$reportNull$$$0(1);
        }
        this.rendererReader = (CellRendererReader)Preconditions.checkNotNull((Object)rendererReader);
    }

    @Override
    @Nullable
    @RunsInCurrentThread
    public String valueAt(@Nonnull JComboBox comboBox, int index) {
        Component c;
        String value;
        if (comboBox == null) {
            BasicJComboBoxCellReader.$$$reportNull$$$0(2);
        }
        String string = value = (c = this.cellRendererComponent(comboBox, index)) != null ? this.rendererReader.valueFrom(c) : null;
        if (value != null) {
            return value;
        }
        return ModelValueToString.asText(comboBox.getItemAt(index));
    }

    @Nullable
    @RunsInCurrentThread
    private Component cellRendererComponent(@Nonnull JComboBox comboBox, int index) {
        if (comboBox == null) {
            BasicJComboBoxCellReader.$$$reportNull$$$0(3);
        }
        Object item = comboBox.getItemAt(index);
        ListCellRenderer renderer = comboBox.getRenderer();
        return renderer.getListCellRendererComponent(REFERENCE_JLIST, item, index, true, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/BasicJComboBoxCellReader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rendererReader";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "newJList";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/BasicJComboBoxCellReader";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "valueAt";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cellRendererComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

