/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JInternalFrame;
import org.fest.reflect.core.Reflection;
import org.fest.reflect.exception.ReflectionError;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentDriver;
import org.fest.swing.driver.ComponentMovableQuery;
import org.fest.swing.driver.ComponentMoveTask;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.ComponentSetSizeTask;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.format.Formatting;
import org.fest.swing.util.Pair;
import org.fest.swing.util.Triple;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;
import org.fest.util.VisibleForTesting;

@InternalApi
public abstract class ContainerDriver
extends ComponentDriver {
    public ContainerDriver(@Nonnull Robot robot) {
        if (robot == null) {
            ContainerDriver.$$$reportNull$$$0(0);
        }
        super(robot);
    }

    @RunsInEDT
    protected final void doResizeWidth(@Nonnull Container c, int width) {
        if (c == null) {
            ContainerDriver.$$$reportNull$$$0(1);
        }
        Pair<Dimension, Insets> resizeInfo = this.resizeInfo(c);
        Dimension size = (Dimension)resizeInfo.first;
        this.resizeBy(c, resizeInfo, width - size.width, 0);
    }

    @RunsInEDT
    protected final void doResizeHeight(@Nonnull Container c, int height) {
        if (c == null) {
            ContainerDriver.$$$reportNull$$$0(2);
        }
        Pair<Dimension, Insets> resizeInfo = this.resizeInfo(c);
        Dimension size = (Dimension)resizeInfo.first;
        this.resizeBy(c, resizeInfo, 0, height - size.height);
    }

    @RunsInEDT
    protected final void resize(@Nonnull Container c, int width, int height) {
        if (c == null) {
            ContainerDriver.$$$reportNull$$$0(3);
        }
        Pair<Dimension, Insets> resizeInfo = this.resizeInfo(c);
        Dimension size = (Dimension)resizeInfo.first;
        this.resizeBy(c, resizeInfo, width - size.width, height - size.height);
    }

    @Nonnull
    @RunsInEDT
    private Pair<Dimension, Insets> resizeInfo(final @Nonnull Container c) {
        if (c == null) {
            ContainerDriver.$$$reportNull$$$0(4);
        }
        Pair<Dimension, Insets> result = GuiActionRunner.execute(new GuiQuery<Pair<Dimension, Insets>>(){

            @Override
            @Nullable
            protected Pair<Dimension, Insets> executeInEDT() {
                ContainerDriver.this.checkCanResize(c);
                return Pair.of(c.getSize(), c.getInsets());
            }
        });
        Pair pair = (Pair)Preconditions.checkNotNull(result);
        if (pair == null) {
            ContainerDriver.$$$reportNull$$$0(5);
        }
        return pair;
    }

    @VisibleForTesting
    @RunsInCurrentThread
    void checkCanResize(@Nonnull Container c) {
        if (c == null) {
            ContainerDriver.$$$reportNull$$$0(6);
        }
        if (!this.isResizable(c)) {
            String msg = String.format("Expecting component %s to be resizable by the user", Formatting.format(c));
            throw new IllegalStateException(msg);
        }
        if (c instanceof JInternalFrame) {
            ComponentPreconditions.checkShowing(c);
            return;
        }
        ComponentPreconditions.checkEnabledAndShowing(c);
    }

    @RunsInCurrentThread
    protected boolean isResizable(@Nonnull Container c) {
        if (c == null) {
            ContainerDriver.$$$reportNull$$$0(7);
        }
        try {
            Boolean resizable = (Boolean)Reflection.method((String)"isResizable").withReturnType(Boolean.TYPE).in((Object)c).invoke(new Object[0]);
            return (Boolean)Preconditions.checkNotNull((Object)resizable);
        }
        catch (ReflectionError e) {
            return false;
        }
    }

    @RunsInEDT
    private void resizeBy(@Nonnull Container c, @Nonnull Pair<Dimension, Insets> resizeInfo, int x, int y) {
        if (c == null) {
            ContainerDriver.$$$reportNull$$$0(8);
        }
        if (resizeInfo == null) {
            ContainerDriver.$$$reportNull$$$0(9);
        }
        this.simulateResizeStarted(c, resizeInfo, x, y);
        Dimension size = (Dimension)resizeInfo.first;
        ComponentSetSizeTask.setComponentSize(c, size.width + x, size.height + y);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private void simulateResizeStarted(@Nonnull Container c, @Nonnull Pair<Dimension, Insets> resizeInfo, int x, int y) {
        if (c == null) {
            ContainerDriver.$$$reportNull$$$0(10);
        }
        if (resizeInfo == null) {
            ContainerDriver.$$$reportNull$$$0(11);
        }
        Point p = ContainerDriver.resizeLocation(resizeInfo);
        this.moveMouseIgnoringAnyError(c, p);
        this.moveMouseIgnoringAnyError(c, p.x + x, p.y + y);
    }

    @Nonnull
    private static Point resizeLocation(@Nonnull Pair<Dimension, Insets> resizeInfo) {
        if (resizeInfo == null) {
            ContainerDriver.$$$reportNull$$$0(12);
        }
        Point point = ContainerDriver.resizeLocation((Dimension)Preconditions.checkNotNull(resizeInfo.first), (Insets)Preconditions.checkNotNull(resizeInfo.second));
        if (point == null) {
            ContainerDriver.$$$reportNull$$$0(13);
        }
        return point;
    }

    @Nonnull
    private static Point resizeLocation(@Nonnull Dimension size, @Nonnull Insets insets) {
        if (size == null) {
            ContainerDriver.$$$reportNull$$$0(14);
        }
        if (insets == null) {
            ContainerDriver.$$$reportNull$$$0(15);
        }
        Point point = ContainerDriver.resizeLocation(size.width, size.height, insets.right, insets.bottom);
        if (point == null) {
            ContainerDriver.$$$reportNull$$$0(16);
        }
        return point;
    }

    @Nonnull
    private static Point resizeLocation(int width, int height, int right, int bottom) {
        Point point = new Point(width - right / 2, height - bottom / 2);
        if (point == null) {
            ContainerDriver.$$$reportNull$$$0(17);
        }
        return point;
    }

    @RunsInEDT
    public void move(@Nonnull Container c, int x, int y) {
        if (c == null) {
            ContainerDriver.$$$reportNull$$$0(18);
        }
        Triple<Dimension, Insets, Point> moveInfo = this.moveInfo(c);
        Point locationOnScreen = (Point)moveInfo.third;
        this.moveBy(c, moveInfo, x - locationOnScreen.x, y - locationOnScreen.y);
    }

    @Nonnull
    @RunsInEDT
    private Triple<Dimension, Insets, Point> moveInfo(final @Nonnull Container c) {
        if (c == null) {
            ContainerDriver.$$$reportNull$$$0(19);
        }
        Triple<Dimension, Insets, Point> result = GuiActionRunner.execute(new GuiQuery<Triple<Dimension, Insets, Point>>(){

            @Override
            @Nullable
            protected Triple<Dimension, Insets, Point> executeInEDT() {
                ContainerDriver.this.checkCanMove(c);
                Point locationOnScreen = null;
                try {
                    locationOnScreen = c.getLocationOnScreen();
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    // empty catch block
                }
                if (locationOnScreen == null) {
                    String msg = String.format("Expecting component %s to be showing on the screen", Formatting.format(c));
                    throw new IllegalStateException(msg);
                }
                return Triple.of(c.getSize(), c.getInsets(), locationOnScreen);
            }
        });
        Triple triple = (Triple)Preconditions.checkNotNull(result);
        if (triple == null) {
            ContainerDriver.$$$reportNull$$$0(20);
        }
        return triple;
    }

    @RunsInCurrentThread
    private void checkCanMove(@Nonnull Container c) {
        if (c == null) {
            ContainerDriver.$$$reportNull$$$0(21);
        }
        ComponentPreconditions.checkEnabledAndShowing(c);
        if (!ComponentMovableQuery.isUserMovable(c)) {
            String msg = String.format("Expecting component %s to be movable by the user", Formatting.format(c));
            throw new IllegalStateException(msg);
        }
    }

    @RunsInEDT
    private void moveBy(@Nonnull Container c, @Nonnull Triple<Dimension, Insets, Point> moveInfo, int x, int y) {
        if (c == null) {
            ContainerDriver.$$$reportNull$$$0(22);
        }
        if (moveInfo == null) {
            ContainerDriver.$$$reportNull$$$0(23);
        }
        this.simulateMoveStarted(c, moveInfo, x, y);
        Point locationOnScreen = (Point)moveInfo.third;
        Point location = new Point(locationOnScreen.x + x, locationOnScreen.y + y);
        ComponentMoveTask.moveComponent(c, location);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private void simulateMoveStarted(@Nonnull Container c, @Nonnull Triple<Dimension, Insets, Point> moveInfo, int x, int y) {
        if (c == null) {
            ContainerDriver.$$$reportNull$$$0(24);
        }
        if (moveInfo == null) {
            ContainerDriver.$$$reportNull$$$0(25);
        }
        Point p = this.moveLocation((Dimension)Preconditions.checkNotNull((Object)moveInfo.first), (Insets)Preconditions.checkNotNull((Object)moveInfo.second));
        this.moveMouseIgnoringAnyError(c, p);
        this.moveMouseIgnoringAnyError(c, p.x + x, p.y + y);
    }

    @Nonnull
    private Point moveLocation(@Nonnull Dimension size, @Nonnull Insets insets) {
        if (size == null) {
            ContainerDriver.$$$reportNull$$$0(26);
        }
        if (insets == null) {
            ContainerDriver.$$$reportNull$$$0(27);
        }
        Point point = new Point(size.width / 2, insets.top / 2);
        if (point == null) {
            ContainerDriver.$$$reportNull$$$0(28);
        }
        return point;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 28: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 5: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/ContainerDriver";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resizeInfo";
                break;
            }
            case 14: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 15: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moveInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/ContainerDriver";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resizeInfo";
                break;
            }
            case 13: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "resizeLocation";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "moveInfo";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "moveLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doResizeWidth";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doResizeHeight";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resizeInfo";
                break;
            }
            case 5: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 28: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkCanResize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isResizable";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resizeBy";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "simulateResizeStarted";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resizeLocation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "moveInfo";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkCanMove";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "moveBy";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "simulateMoveStarted";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "moveLocation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

