/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.fest.reflect.core.Reflection;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JToolBarIsFloatingQuery;
import org.fest.swing.driver.JToolBarLocation;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.format.Formatting;
import org.fest.swing.util.GenericRange;
import org.fest.swing.util.Pair;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class JToolBarDriver
extends JComponentDriver {
    private final JToolBarLocation location;

    public JToolBarDriver(@Nonnull Robot robot) {
        if (robot == null) {
            JToolBarDriver.$$$reportNull$$$0(0);
        }
        super(robot);
        this.location = new JToolBarLocation();
    }

    @RunsInEDT
    public boolean isFloating(final @Nonnull JToolBar toolBar) {
        if (toolBar == null) {
            JToolBarDriver.$$$reportNull$$$0(1);
        }
        Boolean result = GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() {
                return JToolBarIsFloatingQuery.isJToolBarFloating(toolBar);
            }
        });
        return (Boolean)Preconditions.checkNotNull((Object)result);
    }

    public void makeFloat(@Nonnull JToolBar toolBar) {
        if (toolBar == null) {
            JToolBarDriver.$$$reportNull$$$0(2);
        }
        Pair<Point, Pair<Window, Point>> floatInfo = JToolBarDriver.floatInfo(toolBar, this.location());
        Point p = (Point)((Pair)floatInfo.second).second;
        this.doFloat(toolBar, p.x, p.y, floatInfo);
    }

    @RunsInEDT
    public void floatTo(@Nonnull JToolBar toolBar, int x, int y) {
        if (toolBar == null) {
            JToolBarDriver.$$$reportNull$$$0(3);
        }
        this.doFloat(toolBar, x, y, JToolBarDriver.floatInfo(toolBar, this.location()));
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Point, Pair<Window, Point>> floatInfo(final @Nonnull JToolBar toolBar, final @Nonnull JToolBarLocation location) {
        if (toolBar == null) {
            JToolBarDriver.$$$reportNull$$$0(4);
        }
        if (location == null) {
            JToolBarDriver.$$$reportNull$$$0(5);
        }
        Pair<Point, Pair<Window, Point>> result = GuiActionRunner.execute(new GuiQuery<Pair<Point, Pair<Window, Point>>>(){

            @Override
            protected Pair<Point, Pair<Window, Point>> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(toolBar);
                JToolBarDriver.checkFloatable(toolBar);
                Pair windowAndLocation = JToolBarDriver.ancestorAndLocation(toolBar);
                return Pair.of(location.pointToGrab(toolBar), windowAndLocation);
            }
        });
        Pair pair = (Pair)Preconditions.checkNotNull(result);
        if (pair == null) {
            JToolBarDriver.$$$reportNull$$$0(6);
        }
        return pair;
    }

    @RunsInCurrentThread
    private static void checkFloatable(@Nonnull JToolBar toolBar) {
        if (toolBar == null) {
            JToolBarDriver.$$$reportNull$$$0(7);
        }
        if (!toolBar.isFloatable()) {
            String msg = String.format("JToolbar <%s> is not floatable", Formatting.format(toolBar));
            throw new IllegalStateException(msg);
        }
    }

    @Nonnull
    @RunsInCurrentThread
    private static Pair<Window, Point> ancestorAndLocation(@Nonnull JToolBar toolBar) {
        if (toolBar == null) {
            JToolBarDriver.$$$reportNull$$$0(8);
        }
        Window window = SwingUtilities.getWindowAncestor(toolBar);
        Pair<Window, Point> pair = Pair.of(window, window.getLocation());
        if (pair == null) {
            JToolBarDriver.$$$reportNull$$$0(9);
        }
        return pair;
    }

    @RunsInEDT
    private void doFloat(@Nonnull JToolBar toolBar, int x, int y, Pair<Point, Pair<Window, Point>> floatInfo) {
        if (toolBar == null) {
            JToolBarDriver.$$$reportNull$$$0(10);
        }
        this.drag(toolBar, (Point)Preconditions.checkNotNull(floatInfo.first));
        Pair locationAndAncestor = (Pair)floatInfo.second;
        Point ancestorLocation = (Point)locationAndAncestor.second;
        this.drop((Component)Preconditions.checkNotNull(locationAndAncestor.first), new Point(x - ancestorLocation.x, y - ancestorLocation.y));
        JToolBarDriver.checkFloated(toolBar);
    }

    @RunsInEDT
    private static void checkFloated(final @Nonnull JToolBar toolBar) {
        if (toolBar == null) {
            JToolBarDriver.$$$reportNull$$$0(11);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                if (!JToolBarIsFloatingQuery.isJToolBarFloating(toolBar)) {
                    throw ActionFailedException.actionFailure(String.format("Unable to float JToolbar <%s>", Formatting.format(toolBar)));
                }
            }
        });
    }

    @RunsInEDT
    public void unfloat(@Nonnull JToolBar toolBar, @Nonnull String constraint) {
        if (toolBar == null) {
            JToolBarDriver.$$$reportNull$$$0(12);
        }
        if (constraint == null) {
            JToolBarDriver.$$$reportNull$$$0(13);
        }
        Pair<GenericRange<Point>, Container> unfloatInfo = JToolBarDriver.unfloatInfo(toolBar, constraint, this.location());
        GenericRange fromAndTo = (GenericRange)unfloatInfo.first;
        this.drag(toolBar, (Point)fromAndTo.from());
        this.drop((Component)Preconditions.checkNotNull(unfloatInfo.second), (Point)fromAndTo.to());
        JToolBarDriver.validateIsNotFloating(toolBar, constraint);
    }

    @Nonnull
    @RunsInEDT
    private static Pair<GenericRange<Point>, Container> unfloatInfo(final @Nonnull JToolBar toolBar, final @Nonnull String constraint, final @Nonnull JToolBarLocation location) {
        if (toolBar == null) {
            JToolBarDriver.$$$reportNull$$$0(14);
        }
        if (constraint == null) {
            JToolBarDriver.$$$reportNull$$$0(15);
        }
        if (location == null) {
            JToolBarDriver.$$$reportNull$$$0(16);
        }
        Pair<GenericRange<Point>, Container> result = GuiActionRunner.execute(new GuiQuery<Pair<GenericRange<Point>, Container>>(){

            @Override
            protected Pair<GenericRange<Point>, Container> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(toolBar);
                Container dock = JToolBarDriver.dockFor(toolBar);
                Point from = location.pointToGrab(toolBar);
                Point to = location.dockLocation(toolBar, dock, constraint);
                return Pair.of(new GenericRange<Point>(from, to), dock);
            }
        });
        Pair pair = (Pair)Preconditions.checkNotNull(result);
        if (pair == null) {
            JToolBarDriver.$$$reportNull$$$0(17);
        }
        return pair;
    }

    @RunsInEDT
    private static void validateIsNotFloating(final @Nonnull JToolBar toolBar, final @Nonnull String constraint) {
        if (toolBar == null) {
            JToolBarDriver.$$$reportNull$$$0(18);
        }
        if (constraint == null) {
            JToolBarDriver.$$$reportNull$$$0(19);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                if (JToolBarIsFloatingQuery.isJToolBarFloating(toolBar)) {
                    String msg = String.format("Failed to dock <%s> using constraint '%s'", Formatting.format(toolBar), constraint);
                    throw ActionFailedException.actionFailure(msg);
                }
            }
        });
    }

    @Nonnull
    @RunsInCurrentThread
    private static Container dockFor(@Nonnull JToolBar toolBar) {
        Container container;
        if (toolBar == null) {
            JToolBarDriver.$$$reportNull$$$0(20);
        }
        try {
            container = (Container)Preconditions.checkNotNull((Object)Reflection.field((String)"dockingSource").ofType(Container.class).in((Object)toolBar.getUI()).get());
        }
        catch (RuntimeException e) {
            throw ActionFailedException.actionFailure("Unabled to determine dock for JToolBar");
        }
        if (container == null) {
            JToolBarDriver.$$$reportNull$$$0(21);
        }
        return container;
    }

    @RunsInEDT
    public void unfloat(@Nonnull JToolBar toolBar) {
        Window w;
        if (toolBar == null) {
            JToolBarDriver.$$$reportNull$$$0(22);
        }
        if ((w = JToolBarDriver.windowAncestorOf(toolBar)) != null) {
            this.robot.close(w);
        }
    }

    @Nullable
    @RunsInEDT
    private static Window windowAncestorOf(final @Nonnull JToolBar toolBar) {
        if (toolBar == null) {
            JToolBarDriver.$$$reportNull$$$0(23);
        }
        return GuiActionRunner.execute(new GuiQuery<Window>(){

            @Override
            protected Window executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(toolBar);
                return SwingUtilities.getWindowAncestor(toolBar);
            }
        });
    }

    @Nonnull
    private JToolBarLocation location() {
        JToolBarLocation jToolBarLocation = this.location;
        if (jToolBarLocation == null) {
            JToolBarDriver.$$$reportNull$$$0(24);
        }
        return jToolBarLocation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 17: 
            case 21: 
            case 24: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 17: 
            case 21: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolBar";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 6: 
            case 9: 
            case 17: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JToolBarDriver";
                break;
            }
            case 13: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JToolBarDriver";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "floatInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "ancestorAndLocation";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "unfloatInfo";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "dockFor";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isFloating";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "makeFloat";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "floatTo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "floatInfo";
                break;
            }
            case 6: 
            case 9: 
            case 17: 
            case 21: 
            case 24: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkFloatable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "ancestorAndLocation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doFloat";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkFloated";
                break;
            }
            case 12: 
            case 13: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "unfloat";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "unfloatInfo";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "validateIsNotFloating";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "dockFor";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "windowAncestorOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 17: 
            case 21: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

