/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.cell.JTreeCellReader;
import org.fest.swing.driver.BasicJTreeCellReader;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.util.Lists;
import org.fest.util.Strings;

class JTreePathFinder {
    private static final String SEPARATOR = "/";
    private JTreeCellReader cellReader;
    private String separator;

    JTreePathFinder() {
        this.replaceCellReader(new BasicJTreeCellReader());
        this.replaceSeparator(SEPARATOR);
    }

    @Nonnull
    @RunsInCurrentThread
    TreePath findMatchingPath(@Nonnull JTree tree, @Nonnull String path) {
        if (tree == null) {
            JTreePathFinder.$$$reportNull$$$0(0);
        }
        if (path == null) {
            JTreePathFinder.$$$reportNull$$$0(1);
        }
        String[] pathStrings = this.splitPath(path);
        TreeModel model = tree.getModel();
        ArrayList newPathValues = Lists.newArrayList();
        Object node = model.getRoot();
        int pathElementCount = pathStrings.length;
        for (int stringIndex = 0; stringIndex < pathElementCount; ++stringIndex) {
            String pathString = pathStrings[stringIndex];
            Object match = null;
            if (stringIndex == 0 && tree.isRootVisible()) {
                if (!pathString.equals(this.value(tree, node))) {
                    throw this.pathNotFound(path);
                }
                newPathValues.add(node);
                continue;
            }
            int childCount = model.getChildCount(node);
            for (int childIndex = 0; childIndex < childCount; ++childIndex) {
                Object child = model.getChild(node, childIndex);
                if (!pathString.equals(this.value(tree, child))) continue;
                if (match != null) {
                    throw this.multipleMatchingNodes(pathString, this.value(tree, node));
                }
                match = child;
            }
            if (match == null) {
                throw this.pathNotFound(path);
            }
            newPathValues.add(match);
            node = match;
        }
        TreePath treePath = new TreePath(newPathValues.toArray());
        if (treePath == null) {
            JTreePathFinder.$$$reportNull$$$0(2);
        }
        return treePath;
    }

    @Nonnull
    private LocationUnavailableException pathNotFound(@Nonnull String path) {
        if (path == null) {
            JTreePathFinder.$$$reportNull$$$0(3);
        }
        throw new LocationUnavailableException(String.format("Unable to find path %s", Strings.quote((String)path)));
    }

    @Nonnull
    private String[] splitPath(@Nonnull String path) {
        if (path == null) {
            JTreePathFinder.$$$reportNull$$$0(4);
        }
        ArrayList result = Lists.newArrayList();
        int separatorSize = this.separator.length();
        int index = 0;
        int pathSize = path.length();
        while (index < pathSize) {
            int separatorPosition = path.indexOf(this.separator, index);
            if (separatorPosition == -1) {
                separatorPosition = pathSize;
            }
            result.add(path.substring(index, separatorPosition));
            index = separatorPosition + separatorSize;
        }
        String[] stringArray = result.toArray(new String[result.size()]);
        if (stringArray == null) {
            JTreePathFinder.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    @Nonnull
    private LocationUnavailableException multipleMatchingNodes(@Nonnull String matchingText, @Nullable Object parentText) {
        if (matchingText == null) {
            JTreePathFinder.$$$reportNull$$$0(6);
        }
        String msg = String.format("There is more than one node with value '%s' under %s", matchingText, Strings.quote((Object)parentText));
        throw new LocationUnavailableException(msg);
    }

    @Nullable
    private String value(@Nonnull JTree tree, @Nullable Object modelValue) {
        if (tree == null) {
            JTreePathFinder.$$$reportNull$$$0(7);
        }
        return this.cellReader.valueAt(tree, modelValue);
    }

    @Nonnull
    String separator() {
        String string = this.separator;
        if (string == null) {
            JTreePathFinder.$$$reportNull$$$0(8);
        }
        return string;
    }

    void replaceSeparator(@Nonnull String newSeparator) {
        if (newSeparator == null) {
            JTreePathFinder.$$$reportNull$$$0(9);
        }
        this.separator = newSeparator;
    }

    void replaceCellReader(@Nonnull JTreeCellReader newCellReader) {
        if (newCellReader == null) {
            JTreePathFinder.$$$reportNull$$$0(10);
        }
        this.cellReader = newCellReader;
    }

    @Nonnull
    JTreeCellReader cellReader() {
        JTreeCellReader jTreeCellReader = this.cellReader;
        if (jTreeCellReader == null) {
            JTreePathFinder.$$$reportNull$$$0(11);
        }
        return jTreeCellReader;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JTreePathFinder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchingText";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSeparator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newCellReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JTreePathFinder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findMatchingPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "splitPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "separator";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "cellReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingPath";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "pathNotFound";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "splitPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "multipleMatchingNodes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "value";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replaceSeparator";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replaceCellReader";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

