/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.format;

import java.awt.Component;
import javax.annotation.Nonnull;
import javax.swing.JTabbedPane;
import org.fest.swing.format.ComponentFormatterTemplate;
import org.fest.util.Arrays;
import org.fest.util.Strings;

public class JTabbedPaneFormatter
extends ComponentFormatterTemplate {
    private static final String NO_SELECTION = "<No selection>";

    @Override
    @Nonnull
    protected String doFormat(@Nonnull Component c) {
        if (c == null) {
            JTabbedPaneFormatter.$$$reportNull$$$0(0);
        }
        JTabbedPane tabbedPane = (JTabbedPane)c;
        String format = "%s[name=%s, selectedTabIndex=%d, selectedTabTitle=%s, tabCount=%d, tabTitles=%s, enabled=%b, visible=%s, showing=%s";
        String string = String.format(format, tabbedPane.getClass().getName(), Strings.quote((String)tabbedPane.getName()), tabbedPane.getSelectedIndex(), this.selectedTab(tabbedPane), tabbedPane.getTabCount(), Arrays.format((Object)this.tabTitles(tabbedPane)), tabbedPane.isEnabled(), tabbedPane.isVisible(), tabbedPane.isShowing());
        if (string == null) {
            JTabbedPaneFormatter.$$$reportNull$$$0(1);
        }
        return string;
    }

    private String selectedTab(JTabbedPane tabbedPane) {
        if (tabbedPane.getTabCount() == 0) {
            return NO_SELECTION;
        }
        int index = tabbedPane.getSelectedIndex();
        if (index == -1) {
            return NO_SELECTION;
        }
        return Strings.quote((String)tabbedPane.getTitleAt(index));
    }

    private String[] tabTitles(JTabbedPane tabbedPane) {
        int count = tabbedPane.getTabCount();
        if (count == 0) {
            return new String[0];
        }
        String[] titles = new String[count];
        for (int i = 0; i < count; ++i) {
            titles[i] = tabbedPane.getTitleAt(i);
        }
        return titles;
    }

    @Override
    @Nonnull
    public Class<? extends Component> targetType() {
        if (JTabbedPane.class == null) {
            JTabbedPaneFormatter.$$$reportNull$$$0(2);
        }
        return JTabbedPane.class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/format/JTabbedPaneFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/format/JTabbedPaneFormatter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "doFormat";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "targetType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doFormat";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

