/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.input;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import javax.annotation.Nonnull;
import org.fest.swing.input.DisposedWindowMonitor;
import org.fest.swing.listener.WeakEventListener;
import org.fest.util.VisibleForTesting;

public class EventNormalizer
implements AWTEventListener {
    private final DisposedWindowMonitor disposedWindowMonitor;
    private WeakEventListener weakEventListener;
    private AWTEventListener listener;

    public EventNormalizer() {
        this(new DisposedWindowMonitor());
    }

    @VisibleForTesting
    EventNormalizer(@Nonnull DisposedWindowMonitor disposedWindowMonitor) {
        if (disposedWindowMonitor == null) {
            EventNormalizer.$$$reportNull$$$0(0);
        }
        this.disposedWindowMonitor = disposedWindowMonitor;
    }

    public void startListening(@Nonnull Toolkit toolkit, @Nonnull AWTEventListener delegate, long mask) {
        if (toolkit == null) {
            EventNormalizer.$$$reportNull$$$0(1);
        }
        if (delegate == null) {
            EventNormalizer.$$$reportNull$$$0(2);
        }
        this.listener = delegate;
        this.weakEventListener = WeakEventListener.attachAsWeakEventListener(toolkit, this, mask);
    }

    public void stopListening() {
        this.disposeWeakEventListener();
        this.listener = null;
    }

    private void disposeWeakEventListener() {
        if (this.weakEventListener == null) {
            return;
        }
        this.weakEventListener.dispose();
        this.weakEventListener = null;
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        boolean discard = this.disposedWindowMonitor.isDuplicateDispose(event);
        if (!discard && this.listener != null) {
            this.delegate(event);
        }
    }

    private void delegate(@Nonnull AWTEvent e) {
        if (e == null) {
            EventNormalizer.$$$reportNull$$$0(3);
        }
        this.listener.eventDispatched(e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposedWindowMonitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolkit";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/input/EventNormalizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "startListening";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "delegate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

