/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.keystroke;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import org.fest.assertions.Assertions;
import org.fest.reflect.core.Reflection;
import org.fest.reflect.exception.ReflectionError;
import org.fest.swing.exception.ParsingException;
import org.fest.swing.keystroke.KeyStrokeMapping;
import org.fest.swing.keystroke.KeyStrokeMappingProvider;
import org.fest.swing.keystroke.ParsedKeyStrokeMappingProvider;
import org.fest.util.Closeables;
import org.fest.util.Lists;
import org.fest.util.Maps;
import org.fest.util.Preconditions;
import org.fest.util.Strings;
import org.fest.util.VisibleForTesting;

public class KeyStrokeMappingsParser {
    private static final Map<String, Character> SPECIAL_MAPPINGS = Maps.newHashMap();

    @Nonnull
    public KeyStrokeMappingProvider parse(@Nonnull String fileName) {
        KeyStrokeMappingProvider keyStrokeMappingProvider;
        if (fileName == null) {
            KeyStrokeMappingsParser.$$$reportNull$$$0(0);
        }
        Preconditions.checkNotNullOrEmpty((String)fileName);
        try {
            keyStrokeMappingProvider = this.parse(this.fileAsStream(fileName));
        }
        catch (IOException e) {
            throw new ParsingException(Strings.concat((Object[])new Object[]{"An I/O error ocurred while parsing file ", fileName}), e);
        }
        if (keyStrokeMappingProvider == null) {
            KeyStrokeMappingsParser.$$$reportNull$$$0(1);
        }
        return keyStrokeMappingProvider;
    }

    @Nonnull
    private InputStream fileAsStream(String file) {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
        if (stream == null) {
            throw new ParsingException(String.format("Unable to open file %s", file));
        }
        InputStream inputStream = stream;
        if (inputStream == null) {
            KeyStrokeMappingsParser.$$$reportNull$$$0(2);
        }
        return inputStream;
    }

    @Nonnull
    public KeyStrokeMappingProvider parse(@Nonnull File file) {
        KeyStrokeMappingProvider keyStrokeMappingProvider;
        if (file == null) {
            KeyStrokeMappingsParser.$$$reportNull$$$0(3);
        }
        Assertions.assertThat((File)file).isFile();
        try {
            keyStrokeMappingProvider = this.parse(this.fileAsStream(file));
        }
        catch (IOException e) {
            throw new ParsingException(Strings.concat((Object[])new Object[]{"An I/O error ocurred while parsing file ", file}), e);
        }
        if (keyStrokeMappingProvider == null) {
            KeyStrokeMappingsParser.$$$reportNull$$$0(4);
        }
        return keyStrokeMappingProvider;
    }

    @Nonnull
    private InputStream fileAsStream(@Nonnull File file) {
        FileInputStream fileInputStream;
        block3: {
            if (file == null) {
                KeyStrokeMappingsParser.$$$reportNull$$$0(5);
            }
            try {
                fileInputStream = new FileInputStream(file);
                if (fileInputStream != null) break block3;
            }
            catch (FileNotFoundException e) {
                String msg = String.format("The file %s was not found", file.getPath());
                throw new ParsingException(msg, e);
            }
            KeyStrokeMappingsParser.$$$reportNull$$$0(6);
        }
        return fileInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private KeyStrokeMappingProvider parse(@Nonnull InputStream input) throws IOException {
        ParsedKeyStrokeMappingProvider parsedKeyStrokeMappingProvider;
        if (input == null) {
            KeyStrokeMappingsParser.$$$reportNull$$$0(7);
        }
        ArrayList mappings = Lists.newArrayList();
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        try {
            String line = reader.readLine();
            while (line != null) {
                mappings.add(this.mappingFrom(line));
                line = reader.readLine();
            }
            parsedKeyStrokeMappingProvider = new ParsedKeyStrokeMappingProvider(mappings);
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly((Closeable[])new Closeable[]{reader});
            throw throwable;
        }
        Closeables.closeQuietly((Closeable[])new Closeable[]{reader});
        ParsedKeyStrokeMappingProvider parsedKeyStrokeMappingProvider2 = parsedKeyStrokeMappingProvider;
        if (parsedKeyStrokeMappingProvider2 == null) {
            KeyStrokeMappingsParser.$$$reportNull$$$0(8);
        }
        return parsedKeyStrokeMappingProvider2;
    }

    @Nonnull
    @VisibleForTesting
    KeyStrokeMapping mappingFrom(@Nonnull String line) {
        String[] parts;
        if (line == null) {
            KeyStrokeMappingsParser.$$$reportNull$$$0(9);
        }
        if ((parts = line.trim().split(",")).length != 3) {
            String msg = String.format("Line '%s' does not conform with pattern '{char}, {keycode}, {modifiers}'", line);
            throw new ParsingException(msg);
        }
        char character = KeyStrokeMappingsParser.characterFrom(parts[0].trim());
        int keyCode = KeyStrokeMappingsParser.keyCodeFrom(parts[1].trim());
        int modifiers = KeyStrokeMappingsParser.modifiersFrom(parts[2].trim());
        KeyStrokeMapping keyStrokeMapping = KeyStrokeMapping.mapping(character, keyCode, modifiers);
        if (keyStrokeMapping == null) {
            KeyStrokeMappingsParser.$$$reportNull$$$0(10);
        }
        return keyStrokeMapping;
    }

    private static char characterFrom(@Nonnull String s) {
        if (s == null) {
            KeyStrokeMappingsParser.$$$reportNull$$$0(11);
        }
        if (SPECIAL_MAPPINGS.containsKey(s)) {
            return SPECIAL_MAPPINGS.get(s).charValue();
        }
        if (s.length() == 1) {
            return s.charAt(0);
        }
        throw new ParsingException(String.format("The text '%s' should have a single character", s));
    }

    private static int keyCodeFrom(@Nonnull String s) {
        if (s == null) {
            KeyStrokeMappingsParser.$$$reportNull$$$0(12);
        }
        try {
            Integer keyCode = (Integer)Reflection.field((String)("VK_" + s)).ofType(Integer.TYPE).in(KeyEvent.class).get();
            return (Integer)Preconditions.checkNotNull((Object)keyCode);
        }
        catch (ReflectionError e) {
            throw new ParsingException(Strings.concat((Object[])new Object[]{"Unable to retrieve key code from text ", Strings.quote((String)s)}), e.getCause());
        }
    }

    private static int modifiersFrom(@Nonnull String s) {
        if (s == null) {
            KeyStrokeMappingsParser.$$$reportNull$$$0(13);
        }
        if ("NO_MASK".equals(s)) {
            return 0;
        }
        try {
            Integer modifiers = (Integer)Reflection.field((String)s).ofType(Integer.TYPE).in(InputEvent.class).get();
            return (Integer)Preconditions.checkNotNull((Object)modifiers);
        }
        catch (ReflectionError e) {
            throw new ParsingException(Strings.concat((Object[])new Object[]{"Unable to retrieve modifiers from text ", Strings.quote((String)s)}), e.getCause());
        }
    }

    static {
        SPECIAL_MAPPINGS.put("COMMA", Character.valueOf(','));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/keystroke/KeyStrokeMappingsParser";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/keystroke/KeyStrokeMappingsParser";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fileAsStream";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "mappingFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fileAsStream";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mappingFrom";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "characterFrom";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "keyCodeFrom";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "modifiersFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

