/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.launcher;

import javax.annotation.Nonnull;
import org.fest.reflect.core.Reflection;
import org.fest.swing.exception.UnexpectedException;
import org.fest.swing.util.Arrays;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

public class ApplicationLauncher {
    private final Class<?> applicationType;
    private String[] args;

    @Nonnull
    public static ApplicationLauncher application(@Nonnull String applicationTypeName) {
        ApplicationLauncher applicationLauncher;
        if (applicationTypeName == null) {
            ApplicationLauncher.$$$reportNull$$$0(0);
        }
        try {
            Class<?> applicationType = Thread.currentThread().getContextClassLoader().loadClass(applicationTypeName);
            applicationLauncher = ApplicationLauncher.application(applicationType);
        }
        catch (ClassNotFoundException e) {
            throw new UnexpectedException(Strings.concat((Object[])new Object[]{"Unable to load class ", Strings.quote((String)applicationTypeName)}), e);
        }
        if (applicationLauncher == null) {
            ApplicationLauncher.$$$reportNull$$$0(1);
        }
        return applicationLauncher;
    }

    @Nonnull
    public static ApplicationLauncher application(@Nonnull Class<?> applicationType) {
        if (applicationType == null) {
            ApplicationLauncher.$$$reportNull$$$0(2);
        }
        ApplicationLauncher applicationLauncher = new ApplicationLauncher(applicationType);
        if (applicationLauncher == null) {
            ApplicationLauncher.$$$reportNull$$$0(3);
        }
        return applicationLauncher;
    }

    private ApplicationLauncher(@Nonnull Class<?> applicationType) {
        if (applicationType == null) {
            ApplicationLauncher.$$$reportNull$$$0(4);
        }
        this.args = new String[0];
        this.applicationType = applicationType;
    }

    @Nonnull
    public ApplicationLauncher withArgs(String ... newArgs) {
        if (newArgs == null) {
            ApplicationLauncher.$$$reportNull$$$0(5);
        }
        this.args = (String[])Arrays.copyOf((Object[])Preconditions.checkNotNull((Object)newArgs));
        ApplicationLauncher applicationLauncher = this;
        if (applicationLauncher == null) {
            ApplicationLauncher.$$$reportNull$$$0(6);
        }
        return applicationLauncher;
    }

    public void start() {
        Reflection.method((String)"main").withParameterTypes(new Class[]{String[].class}).in(this.applicationType).invoke(new Object[]{this.args});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationTypeName";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/launcher/ApplicationLauncher";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/launcher/ApplicationLauncher";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "application";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "application";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withArgs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

