/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import git4idea.GitVcs;
import git4idea.i18n.GitBundle;
import java.awt.Component;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitShowCommitInLogAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(GitShowCommitInLogAction.class);

    public GitShowCommitInLogAction() {
        super(GitBundle.getString("vcs.history.action.gitlog"));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            GitShowCommitInLogAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)event.getRequiredData(CommonDataKeys.PROJECT);
        VcsRevisionNumber revision = this.getRevisionNumber(event);
        if (revision == null) {
            return;
        }
        VcsLogContentUtil.openMainLogAndExecute((Project)project, logUi -> GitShowCommitInLogAction.jumpToRevisionUnderProgress(project, logUi, revision));
    }

    @Nullable
    protected VcsRevisionNumber getRevisionNumber(@NotNull AnActionEvent event) {
        VcsFileRevision fileRevision;
        VcsRevisionNumber revision;
        if (event == null) {
            GitShowCommitInLogAction.$$$reportNull$$$0(1);
        }
        if ((revision = (VcsRevisionNumber)event.getData(VcsDataKeys.VCS_REVISION_NUMBER)) == null && (fileRevision = (VcsFileRevision)event.getData(VcsDataKeys.VCS_FILE_REVISION)) != null) {
            revision = fileRevision.getRevisionNumber();
        }
        return revision;
    }

    @Nullable
    protected VcsKey getVcsKey(@NotNull AnActionEvent event) {
        if (event == null) {
            GitShowCommitInLogAction.$$$reportNull$$$0(2);
        }
        return (VcsKey)event.getData(VcsDataKeys.VCS);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GitShowCommitInLogAction.$$$reportNull$$$0(3);
        }
        super.update(e);
        Project project = e.getProject();
        e.getPresentation().setEnabled(project != null && VcsProjectLog.getInstance((Project)project) != null && this.getRevisionNumber(e) != null && Comparing.equal((Object)this.getVcsKey(e), (Object)GitVcs.getKey()));
    }

    private static void jumpToRevisionUnderProgress(final @NotNull Project project, final @NotNull VcsLogUiImpl logUi, @NotNull VcsRevisionNumber revision) {
        Future future;
        if (project == null) {
            GitShowCommitInLogAction.$$$reportNull$$$0(4);
        }
        if (logUi == null) {
            GitShowCommitInLogAction.$$$reportNull$$$0(5);
        }
        if (revision == null) {
            GitShowCommitInLogAction.$$$reportNull$$$0(6);
        }
        if (!(future = logUi.getVcsLog().jumpToReference(revision.asString())).isDone()) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Searching for revision " + revision.asString(), false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        future.get();
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (project == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            if (logUi == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            GitShowCommitInLogAction.ensureHasFocus(project, logUi);
                        });
                    }
                    catch (InterruptedException | CancellationException exception) {
                    }
                    catch (ExecutionException e) {
                        LOG.error((Throwable)e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "logUi";
                            break;
                        }
                    }
                    objectArray2[1] = "git4idea/log/GitShowCommitInLogAction$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "run";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$run$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        } else {
            GitShowCommitInLogAction.ensureHasFocus(project, logUi);
        }
    }

    private static void ensureHasFocus(@Nullable Project project, @NotNull VcsLogUiImpl logUi) {
        if (logUi == null) {
            GitShowCommitInLogAction.$$$reportNull$$$0(7);
        }
        if (!logUi.getTable().hasFocus()) {
            IdeFocusManager.getInstance((Project)project).requestFocus((Component)logUi.getTable(), true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logUi";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
        }
        objectArray2[1] = "git4idea/log/GitShowCommitInLogAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getRevisionNumber";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getVcsKey";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "jumpToRevisionUnderProgress";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureHasFocus";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

