/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.config.GitConfigUtil;
import git4idea.rebase.GitRebaseEntry;
import git4idea.util.StringScanner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class GitInteractiveRebaseFile {
    @NonNls
    private static final String CYGDRIVE_PREFIX = "/cygdrive/";
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final String myFile;

    GitInteractiveRebaseFile(@NotNull Project project, @NotNull VirtualFile root, @NotNull String rebaseFilePath) {
        if (project == null) {
            GitInteractiveRebaseFile.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitInteractiveRebaseFile.$$$reportNull$$$0(1);
        }
        if (rebaseFilePath == null) {
            GitInteractiveRebaseFile.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myRoot = root;
        this.myFile = GitInteractiveRebaseFile.adjustFilePath(rebaseFilePath);
    }

    @NotNull
    public List<GitRebaseEntry> load() throws IOException, NoopException {
        String encoding = GitConfigUtil.getLogEncoding(this.myProject, this.myRoot);
        ArrayList entries = ContainerUtil.newArrayList();
        StringScanner s = new StringScanner(FileUtil.loadFile((File)new File(this.myFile), (String)encoding));
        boolean noop = false;
        while (s.hasMoreData()) {
            if (s.isEol() || s.startsWith("\u0001")) {
                s.nextLine();
                continue;
            }
            if (s.startsWith("noop")) {
                noop = true;
                s.nextLine();
                continue;
            }
            String action = s.spaceToken();
            String hash = s.spaceToken();
            String comment = s.line();
            entries.add(new GitRebaseEntry(action, hash, comment));
        }
        if (noop && entries.isEmpty()) {
            throw new NoopException();
        }
        ArrayList arrayList = entries;
        if (arrayList == null) {
            GitInteractiveRebaseFile.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public void cancel() throws IOException {
        try (PrintWriter out = new PrintWriter(new FileWriter(this.myFile));){
            out.println("# rebase is cancelled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(@NotNull List<GitRebaseEntry> entries) throws IOException {
        if (entries == null) {
            GitInteractiveRebaseFile.$$$reportNull$$$0(4);
        }
        String encoding = GitConfigUtil.getLogEncoding(this.myProject, this.myRoot);
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.myFile), encoding));){
            for (GitRebaseEntry e : entries) {
                if (e.getAction() == GitRebaseEntry.Action.skip) continue;
                out.println(e.getAction().toString() + " " + e.getCommit() + " " + e.getSubject());
            }
        }
    }

    @NotNull
    private static String adjustFilePath(@NotNull String file) {
        if (file == null) {
            GitInteractiveRebaseFile.$$$reportNull$$$0(5);
        }
        if (SystemInfo.isWindows && file.startsWith(CYGDRIVE_PREFIX)) {
            int prefixSize = CYGDRIVE_PREFIX.length();
            String string = file.substring(prefixSize, prefixSize + 1) + ":" + file.substring(prefixSize + 1);
            if (string == null) {
                GitInteractiveRebaseFile.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = file;
        if (string == null) {
            GitInteractiveRebaseFile.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rebaseFilePath";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/rebase/GitInteractiveRebaseFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/rebase/GitInteractiveRebaseFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "adjustFilePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class NoopException
    extends Exception {
        NoopException() {
        }
    }
}

