/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.compiler.ModuleSourceSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Couple;
import com.intellij.util.Chunk;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;

public final class ModuleCompilerUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.ModuleCompilerUtil");

    private ModuleCompilerUtil() {
    }

    @NotNull
    public static Module[] getDependencies(Module module) {
        Module[] moduleArray = ModuleRootManager.getInstance(module).getDependencies();
        if (moduleArray == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(0);
        }
        return moduleArray;
    }

    @NotNull
    private static Graph<Module> createModuleGraph(final @NotNull Module[] modules) {
        if (modules == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(1);
        }
        Graph graph = GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<Module>(){

            public Collection<Module> getNodes() {
                return Arrays.asList(modules);
            }

            public Iterator<Module> getIn(Module module) {
                return Arrays.asList(ModuleCompilerUtil.getDependencies(module)).iterator();
            }
        }));
        if (graph == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(2);
        }
        return graph;
    }

    @NotNull
    public static List<Chunk<Module>> getSortedModuleChunks(@NotNull Project project, @NotNull List<Module> modules) {
        if (project == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(3);
        }
        if (modules == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(4);
        }
        Module[] allModules = ModuleManager.getInstance(project).getModules();
        List<Chunk<Module>> chunks = ModuleCompilerUtil.getSortedChunks(ModuleCompilerUtil.createModuleGraph(allModules));
        HashSet<Module> modulesSet = new HashSet<Module>(modules);
        chunks.removeIf(chunk -> !ContainerUtil.intersects((Collection)chunk.getNodes(), (Collection)modulesSet));
        List<Chunk<Module>> list = chunks;
        if (list == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private static <Node> List<Chunk<Node>> getSortedChunks(@NotNull Graph<Node> graph) {
        if (graph == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(6);
        }
        Graph<Chunk<Node>> chunkGraph = ModuleCompilerUtil.toChunkGraph(graph);
        ArrayList<Chunk<Node>> chunks = new ArrayList<Chunk<Node>>(chunkGraph.getNodes().size());
        for (Chunk chunk : chunkGraph.getNodes()) {
            chunks.add(chunk);
        }
        DFSTBuilder builder = new DFSTBuilder(chunkGraph);
        if (!builder.isAcyclic()) {
            LOG.error("Acyclic graph expected");
            if (null == null) {
                ModuleCompilerUtil.$$$reportNull$$$0(7);
            }
            return null;
        }
        Collections.sort(chunks, builder.comparator());
        ArrayList<Chunk<Node>> arrayList = chunks;
        if (arrayList == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    public static <Node> Graph<Chunk<Node>> toChunkGraph(@NotNull Graph<Node> graph) {
        if (graph == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(9);
        }
        Graph<Chunk<Node>> graph2 = GraphAlgorithms.getInstance().computeSCCGraph(graph);
        if (graph2 == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(10);
        }
        return graph2;
    }

    public static void sortModules(Project project, List<Module> modules) {
        ApplicationManager.getApplication().runReadAction(() -> {
            Comparator<Module> comparator = ModuleManager.getInstance(project).moduleDependencyComparator();
            Collections.sort(modules, comparator);
        });
    }

    @NotNull
    private static <T extends ModuleRootModel> Graph<T> createGraphGenerator(final @NotNull Map<Module, T> models) {
        if (models == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(11);
        }
        Graph graph = GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<T>(){

            public Collection<T> getNodes() {
                return models.values();
            }

            public Iterator<T> getIn(ModuleRootModel model) {
                ArrayList dependencies = new ArrayList();
                model.orderEntries().compileOnly().forEachModule((Processor<Module>)((Processor)module -> {
                    ModuleRootModel depModel;
                    if (models == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if ((depModel = (ModuleRootModel)models.get(module)) != null) {
                        dependencies.add(depModel);
                    }
                    return true;
                }));
                return dependencies.iterator();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/compiler/ModuleCompilerUtil$2", "lambda$getIn$0"));
            }
        }));
        if (graph == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(12);
        }
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Couple<Module> addingDependencyFormsCircularity(@NotNull Module currentModule, @NotNull Module toDependOn) {
        if (currentModule == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(13);
        }
        if (toDependOn == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(14);
        }
        assert (currentModule != toDependOn);
        LinkedHashMap<Module, ModifiableRootModel> models = new LinkedHashMap<Module, ModifiableRootModel>();
        Project project = currentModule.getProject();
        for (Module module : ModuleManager.getInstance(project).getModules()) {
            ModifiableRootModel modifiableRootModel = ModuleRootManager.getInstance(module).getModifiableModel();
            models.put(module, modifiableRootModel);
        }
        ModifiableRootModel currentModel = (ModifiableRootModel)models.get(currentModule);
        ModifiableRootModel toDependOnModel = (ModifiableRootModel)models.get(toDependOn);
        Collection nodesBefore = ModuleCompilerUtil.buildChunks(models);
        for (Chunk chunk : nodesBefore) {
            if (!chunk.containsNode((Object)toDependOnModel) || !chunk.containsNode((Object)currentModel)) continue;
            return null;
        }
        try {
            currentModel.addModuleOrderEntry(toDependOn);
            Collection nodesAfter = ModuleCompilerUtil.buildChunks(models);
            for (Chunk chunk : nodesAfter) {
                if (!chunk.containsNode((Object)toDependOnModel) || !chunk.containsNode((Object)currentModel)) continue;
                List nodes = ContainerUtil.collect(chunk.getNodes().iterator());
                nodes.sort(Comparator.comparing(m -> m.getModule().getName()));
                Couple couple = Couple.of((Object)((ModifiableRootModel)nodes.get(0)).getModule(), (Object)((ModifiableRootModel)nodes.get(1)).getModule());
                return couple;
            }
        }
        finally {
            for (ModifiableRootModel model : models.values()) {
                model.dispose();
            }
        }
        return null;
    }

    @NotNull
    private static <T extends ModuleRootModel> Collection<Chunk<T>> buildChunks(@NotNull Map<Module, T> models) {
        if (models == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(15);
        }
        Collection collection = ModuleCompilerUtil.toChunkGraph(ModuleCompilerUtil.createGraphGenerator(models)).getNodes();
        if (collection == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(16);
        }
        return collection;
    }

    @NotNull
    public static List<Chunk<ModuleSourceSet>> getCyclicDependencies(@NotNull Project project, @NotNull List<Module> modules) {
        if (project == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(17);
        }
        if (modules == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(18);
        }
        List<Chunk<ModuleSourceSet>> chunks = ModuleCompilerUtil.computeSourceSetCycles(new DefaultModulesProvider(project));
        HashSet<Module> modulesSet = new HashSet<Module>(modules);
        List list = ContainerUtil.filter(chunks, chunk -> {
            for (ModuleSourceSet sourceSet : chunk.getNodes()) {
                if (!modulesSet.contains(sourceSet.getModule())) continue;
                return true;
            }
            return false;
        });
        if (list == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    private static Graph<ModuleSourceSet> createModuleSourceDependenciesGraph(final @NotNull RootModelProvider provider) {
        if (provider == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(20);
        }
        Graph graph = GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<ModuleSourceSet>(){

            public Collection<ModuleSourceSet> getNodes() {
                Module[] modules = provider.getModules();
                ArrayList<ModuleSourceSet> result = new ArrayList<ModuleSourceSet>(modules.length * 2);
                for (Module module : modules) {
                    result.add(new ModuleSourceSet(module, ModuleSourceSet.Type.PRODUCTION));
                    result.add(new ModuleSourceSet(module, ModuleSourceSet.Type.TEST));
                }
                return result;
            }

            public Iterator<ModuleSourceSet> getIn(ModuleSourceSet n) {
                ModuleRootModel model = provider.getRootModel(n.getModule());
                OrderEnumerator enumerator = model.orderEntries().compileOnly();
                if (n.getType() == ModuleSourceSet.Type.PRODUCTION) {
                    enumerator = enumerator.productionOnly();
                }
                ArrayList<ModuleSourceSet> deps = new ArrayList<ModuleSourceSet>();
                enumerator.forEachModule((Processor<Module>)((Processor)module -> {
                    deps.add(new ModuleSourceSet((Module)module, n.getType()));
                    return true;
                }));
                if (n.getType() == ModuleSourceSet.Type.TEST) {
                    deps.add(new ModuleSourceSet(n.getModule(), ModuleSourceSet.Type.PRODUCTION));
                }
                return deps.iterator();
            }
        }));
        if (graph == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(21);
        }
        return graph;
    }

    @NotNull
    public static List<Chunk<ModuleSourceSet>> computeSourceSetCycles(@NotNull ModulesProvider provider) {
        if (provider == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(22);
        }
        Graph<ModuleSourceSet> graph = ModuleCompilerUtil.createModuleSourceDependenciesGraph(provider);
        Collection<Chunk<ModuleSourceSet>> chunks = GraphAlgorithms.getInstance().computeStronglyConnectedComponents(graph);
        List<Chunk<ModuleSourceSet>> list = ModuleCompilerUtil.removeSingleElementChunks(ModuleCompilerUtil.removeDummyNodes(ModuleCompilerUtil.filterDuplicates(ModuleCompilerUtil.removeSingleElementChunks(chunks)), provider));
        if (list == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(23);
        }
        return list;
    }

    private static List<Chunk<ModuleSourceSet>> removeDummyNodes(List<Chunk<ModuleSourceSet>> chunks, ModulesProvider modulesProvider) {
        ArrayList<Chunk<ModuleSourceSet>> result = new ArrayList<Chunk<ModuleSourceSet>>(chunks.size());
        for (Chunk<ModuleSourceSet> chunk : chunks) {
            LinkedHashSet<ModuleSourceSet> nodes = new LinkedHashSet<ModuleSourceSet>();
            for (ModuleSourceSet sourceSet : chunk.getNodes()) {
                if (ModuleCompilerUtil.isDummy(sourceSet, modulesProvider)) continue;
                nodes.add(sourceSet);
            }
            result.add((Chunk<ModuleSourceSet>)new Chunk(nodes));
        }
        return result;
    }

    private static boolean isDummy(ModuleSourceSet set, ModulesProvider modulesProvider) {
        JavaSourceRootType type = set.getType() == ModuleSourceSet.Type.PRODUCTION ? JavaSourceRootType.SOURCE : JavaSourceRootType.TEST_SOURCE;
        ModuleRootModel rootModel = modulesProvider.getRootModel(set.getModule());
        for (ContentEntry entry : rootModel.getContentEntries()) {
            if (entry.getSourceFolders(type).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static List<Chunk<ModuleSourceSet>> removeSingleElementChunks(Collection<Chunk<ModuleSourceSet>> chunks) {
        return ContainerUtil.filter(chunks, chunk -> chunk.getNodes().size() > 1);
    }

    @NotNull
    private static List<Chunk<ModuleSourceSet>> filterDuplicates(@NotNull Collection<Chunk<ModuleSourceSet>> sourceSetCycles) {
        if (sourceSetCycles == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(24);
        }
        ArrayList<Set<Module>> productionCycles = new ArrayList<Set<Module>>();
        for (Chunk<ModuleSourceSet> cycle : sourceSetCycles) {
            ModuleSourceSet.Type type = ModuleCompilerUtil.getCommonType(cycle);
            if (type != ModuleSourceSet.Type.PRODUCTION) continue;
            productionCycles.add(ModuleSourceSet.getModules(cycle.getNodes()));
        }
        List list = ContainerUtil.filter(sourceSetCycles, chunk -> {
            if (ModuleCompilerUtil.getCommonType((Chunk<ModuleSourceSet>)chunk) != ModuleSourceSet.Type.TEST) {
                return true;
            }
            for (Set productionCycle : productionCycles) {
                if (!productionCycle.containsAll(ModuleSourceSet.getModules(chunk.getNodes()))) continue;
                return false;
            }
            return true;
        });
        if (list == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(25);
        }
        return list;
    }

    @Nullable
    private static ModuleSourceSet.Type getCommonType(@NotNull Chunk<ModuleSourceSet> cycle) {
        if (cycle == null) {
            ModuleCompilerUtil.$$$reportNull$$$0(26);
        }
        ModuleSourceSet.Type type = null;
        for (ModuleSourceSet set : cycle.getNodes()) {
            if (type == null) {
                type = set.getType();
                continue;
            }
            if (type == set.getType()) continue;
            return null;
        }
        return type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/ModuleCompilerUtil";
                break;
            }
            case 1: 
            case 4: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 3: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentModule";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDependOn";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSetCycles";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cycle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/ModuleCompilerUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleGraph";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedModuleChunks";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedChunks";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toChunkGraph";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createGraphGenerator";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChunks";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCyclicDependencies";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleSourceDependenciesGraph";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSourceSetCycles";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDuplicates";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createModuleGraph";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSortedModuleChunks";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSortedChunks";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toChunkGraph";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createGraphGenerator";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addingDependencyFormsCircularity";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "buildChunks";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCyclicDependencies";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createModuleSourceDependenciesGraph";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "computeSourceSetCycles";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "filterDuplicates";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getCommonType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

