/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;

public class ExperimentalFeature {
    @Attribute(value="id")
    public String id;
    @Attribute(value="percentOfUsers")
    public int percentOfUsers = 0;
    @Attribute(value="internalFeature")
    public boolean internalFeature = false;
    @Tag(value="description")
    public String description;
    @Attribute(value="requireRestart")
    public boolean requireRestart = false;

    public boolean isEnabled() {
        int salt;
        Application app = ApplicationManager.getApplication();
        if (app == null) {
            return false;
        }
        if (!app.isEAP()) {
            return false;
        }
        if (this.internalFeature && !app.isInternal()) {
            return false;
        }
        if (this.percentOfUsers <= 0) {
            return false;
        }
        if (this.percentOfUsers >= 100) {
            return true;
        }
        if (app.isUnitTestMode()) {
            return false;
        }
        int hash = PermanentInstallationID.get().hashCode();
        return Math.floorMod(hash + (salt = this.id.hashCode()), 100) <= this.percentOfUsers;
    }
}

