/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.ex;

import com.intellij.ide.util.JavaAnonymousClassesHelper;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.OrderedSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerPathsEx
extends CompilerPaths {
    @NotNull
    public static String[] getOutputPaths(@NotNull Module[] modules) {
        if (modules == null) {
            CompilerPathsEx.$$$reportNull$$$0(0);
        }
        OrderedSet outputPaths = new OrderedSet();
        for (Module module : modules) {
            String outputPathForTestsUrl;
            CompilerModuleExtension compilerModuleExtension;
            CompilerModuleExtension compilerModuleExtension2 = compilerModuleExtension = !module.isDisposed() ? CompilerModuleExtension.getInstance(module) : null;
            if (compilerModuleExtension == null) continue;
            String outputPathUrl = compilerModuleExtension.getCompilerOutputUrl();
            if (outputPathUrl != null) {
                outputPaths.add(VirtualFileManager.extractPath(outputPathUrl).replace('/', File.separatorChar));
            }
            if ((outputPathForTestsUrl = compilerModuleExtension.getCompilerOutputUrlForTests()) != null) {
                outputPaths.add(VirtualFileManager.extractPath(outputPathForTestsUrl).replace('/', File.separatorChar));
            }
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
            for (OrderEnumerationHandler.Factory handlerFactory : (OrderEnumerationHandler.Factory[])OrderEnumerationHandler.EP_NAME.getExtensions()) {
                if (!handlerFactory.isApplicable(module)) continue;
                OrderEnumerationHandler handler = handlerFactory.createHandler(module);
                SmartList outputUrls = new SmartList();
                handler.addCustomModuleRoots(OrderRootType.CLASSES, moduleRootManager, (Collection<String>)outputUrls, true, true);
                for (String outputUrl : outputUrls) {
                    outputPaths.add(VirtualFileManager.extractPath(outputUrl).replace('/', File.separatorChar));
                }
            }
        }
        String[] stringArray = ArrayUtil.toStringArray((Collection)outputPaths);
        if (stringArray == null) {
            CompilerPathsEx.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @Nullable
    public static ClassFileDescriptor findClassFileInOutput(@NotNull PsiClass aClass) {
        String jvmClassName;
        if (aClass == null) {
            CompilerPathsEx.$$$reportNull$$$0(2);
        }
        if ((jvmClassName = CompilerPathsEx.getJVMClassName(aClass)) != null) {
            ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance(aClass.getProject());
            PsiElement originalClass = aClass.getOriginalElement();
            if (originalClass instanceof PsiCompiledElement) {
                VirtualFile file = originalClass.getContainingFile().getVirtualFile();
                if (file != null) {
                    String classFileName = StringUtil.getShortName((String)jvmClassName) + ".class";
                    if (index.isInLibraryClasses(file)) {
                        VirtualFile classFile = file.getParent().findChild(classFileName);
                        if (classFile != null) {
                            return new VirtualClassFileDescriptor(classFile);
                        }
                    } else {
                        File classFile = new File(file.getParent().getPath(), classFileName);
                        if (classFile.isFile()) {
                            return new IOClassFileDescriptor(classFile);
                        }
                    }
                }
            } else {
                CompilerModuleExtension extension;
                Module module;
                VirtualFile file = aClass.getContainingFile().getVirtualFile();
                if (file != null && (module = index.getModuleForFile(file)) != null && (extension = CompilerModuleExtension.getInstance(module)) != null) {
                    VirtualFile classRoot;
                    boolean inTests = index.isInTestSourceContent(file);
                    VirtualFile virtualFile2 = classRoot = inTests ? extension.getCompilerOutputPathForTests() : extension.getCompilerOutputPath();
                    if (classRoot != null) {
                        String relativePath = jvmClassName.replace('.', '/') + ".class";
                        File classFile = new File(classRoot.getPath(), relativePath);
                        if (classFile.exists()) {
                            return new IOClassFileDescriptor(classFile);
                        }
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    private static String getJVMClassName(PsiClass aClass) {
        if (!(aClass instanceof PsiAnonymousClass)) {
            return ClassUtil.getJVMClassName(aClass);
        }
        PsiClass containingClass = PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class);
        if (containingClass != null) {
            return CompilerPathsEx.getJVMClassName(containingClass) + JavaAnonymousClassesHelper.getName((PsiAnonymousClass)aClass);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/compiler/ex/CompilerPathsEx";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/compiler/ex/CompilerPathsEx";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOutputPaths";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findClassFileInOutput";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IOClassFileDescriptor
    implements ClassFileDescriptor {
        private final File myClassFile;

        private IOClassFileDescriptor(File classFile) {
            this.myClassFile = classFile;
        }

        @Override
        public byte[] loadFileBytes() throws IOException {
            return FileUtil.loadFileBytes((File)this.myClassFile);
        }

        @Override
        public String getPath() {
            return this.myClassFile.getPath();
        }
    }

    private static class VirtualClassFileDescriptor
    implements ClassFileDescriptor {
        private final VirtualFile myClassFile;

        private VirtualClassFileDescriptor(VirtualFile file) {
            this.myClassFile = file;
        }

        @Override
        public byte[] loadFileBytes() throws IOException {
            return this.myClassFile.contentsToByteArray(false);
        }

        @Override
        public String getPath() {
            return this.myClassFile.getPath();
        }
    }

    public static interface ClassFileDescriptor {
        public byte[] loadFileBytes() throws IOException;

        public String getPath();
    }
}

