/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.find.FindManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.AutoScrollToSourceOptionProvider;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.OccurenceNavigatorSupport;
import com.intellij.ide.TextCopyProvider;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.ide.actions.exclusion.ExclusionHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageContextPanel;
import com.intellij.usages.UsageDataUtil;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.ExporterToTextFile;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.NullUsage;
import com.intellij.usages.impl.PreviewUsageAction;
import com.intellij.usages.impl.RuleAction;
import com.intellij.usages.impl.SortMembersAlphabeticallyAction;
import com.intellij.usages.impl.UsageModelTracker;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageNodeTreeBuilder;
import com.intellij.usages.impl.UsageTargetNode;
import com.intellij.usages.impl.UsageViewTreeCellRenderer;
import com.intellij.usages.impl.UsageViewTreeModelBuilder;
import com.intellij.usages.rules.MergeableUsage;
import com.intellij.usages.rules.UsageFilteringRule;
import com.intellij.usages.rules.UsageFilteringRuleProvider;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageGroupingRuleProvider;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.usages.rules.UsageInFiles;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.enumeration.EmptyEnumeration;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageViewImpl
implements UsageView {
    @NonNls
    public static final String SHOW_RECENT_FIND_USAGES_ACTION_ID = "UsageView.ShowRecentFindUsages";
    private final UsageNodeTreeBuilder myBuilder;
    private MyPanel myRootPanel;
    private JTree myTree;
    private final ScheduledFuture<?> myFireEventsFuture;
    private Content myContent;
    private final UsageViewPresentation myPresentation;
    private final UsageTarget[] myTargets;
    private final Factory<UsageSearcher> myUsageSearcherFactory;
    private final Project myProject;
    private volatile boolean mySearchInProgress;
    private final ExporterToTextFile myTextFileExporter;
    private final Alarm myUpdateAlarm;
    private final ExclusionHandler<DefaultMutableTreeNode> myExclusionHandler;
    private final Map<Usage, UsageNode> myUsageNodes;
    public static final UsageNode NULL_NODE = new UsageNode(null, NullUsage.INSTANCE);
    private final ButtonPanel myButtonPanel;
    private final JComponent myAdditionalComponent;
    private volatile boolean isDisposed;
    private volatile boolean myChangesDetected;
    public static final Comparator<Usage> USAGE_COMPARATOR = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == NULL_NODE) {
            return -1;
        }
        if (o2 == NULL_NODE) {
            return 1;
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            int selfcompared = ((Comparable)((Object)o1)).compareTo(o2);
            if (selfcompared != 0) {
                return selfcompared;
            }
            if (o1 instanceof UsageInFile && o2 instanceof UsageInFile) {
                UsageInFile u1 = (UsageInFile)o1;
                UsageInFile u2 = (UsageInFile)o2;
                VirtualFile f1 = u1.getFile();
                VirtualFile f2 = u2.getFile();
                if (f1 != null && f1.isValid() && f2 != null && f2.isValid()) {
                    return f1.getPresentableUrl().compareTo(f2.getPresentableUrl());
                }
            }
            return 0;
        }
        return o1.toString().compareTo(o2.toString());
    };
    @NonNls
    private static final String HELP_ID = "ideaInterface.find";
    private UsageContextPanel myCurrentUsageContextPanel;
    private List<UsageContextPanel.Provider> myUsageContextPanelProviders;
    private UsageContextPanel.Provider myCurrentUsageContextProvider;
    private JPanel myCentralPanel;
    private final GroupNode myRoot;
    private final UsageViewTreeModelBuilder myModel;
    private final Object lock;
    private Splitter myPreviewSplitter;
    private volatile ProgressIndicator associatedProgress;
    private boolean expandingAll;
    private final UsageViewTreeCellRenderer myUsageViewTreeCellRenderer;
    private Usage myOriginUsage;
    private final MultiMap<Node, Node> changedNodesToFire;
    private final Consumer<Node> edtNodeChangedQueue;
    private final Set<Node> nodesInsertedUnder;
    private final Consumer<Node> edtNodeInsertedUnderQueue;
    private boolean rulesChanged;

    public UsageViewImpl(@NotNull Project project, @NotNull UsageViewPresentation presentation, @NotNull UsageTarget[] targets, Factory<UsageSearcher> usageSearcherFactory) {
        if (project == null) {
            UsageViewImpl.$$$reportNull$$$0(0);
        }
        if (presentation == null) {
            UsageViewImpl.$$$reportNull$$$0(1);
        }
        if (targets == null) {
            UsageViewImpl.$$$reportNull$$$0(2);
        }
        this.mySearchInProgress = true;
        this.myTextFileExporter = new ExporterToTextFile(this);
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myUsageNodes = new ConcurrentHashMap<Usage, UsageNode>();
        this.myButtonPanel = new ButtonPanel();
        this.myAdditionalComponent = new JPanel(new BorderLayout());
        this.lock = new Object();
        this.changedNodesToFire = new LinkedMultiMap();
        this.edtNodeChangedQueue = node -> {
            if (!this.getPresentation().isDetachedMode()) {
                MultiMap<Node, Node> multiMap = this.changedNodesToFire;
                synchronized (multiMap) {
                    this.changedNodesToFire.putValue((Object)((Node)node.getParent()), node);
                }
            }
        };
        this.nodesInsertedUnder = new LinkedHashSet<Node>();
        this.edtNodeInsertedUnderQueue = parent -> {
            if (parent == null) {
                UsageViewImpl.$$$reportNull$$$0(65);
            }
            if (!this.getPresentation().isDetachedMode()) {
                Set<Node> set = this.nodesInsertedUnder;
                synchronized (set) {
                    this.nodesInsertedUnder.add((Node)parent);
                }
            }
        };
        this.myFireEventsFuture = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(this::fireEvents, 50L, 50L, TimeUnit.MILLISECONDS);
        Disposer.register((Disposable)this, () -> this.myFireEventsFuture.cancel(false));
        this.myPresentation = presentation;
        this.myTargets = targets;
        this.myUsageSearcherFactory = usageSearcherFactory;
        this.myProject = project;
        this.myModel = new UsageViewTreeModelBuilder(this.myPresentation, targets);
        this.myRoot = (GroupNode)this.myModel.getRoot();
        UsageModelTracker myModelTracker = new UsageModelTracker(project);
        Disposer.register((Disposable)this, (Disposable)myModelTracker);
        this.myBuilder = new UsageNodeTreeBuilder(this.myTargets, UsageViewImpl.getActiveGroupingRules(project), UsageViewImpl.getActiveFilteringRules(project), this.myRoot, this.myProject);
        MessageBusConnection messageBusConnection = this.myProject.getMessageBus().connect((Disposable)this);
        messageBusConnection.subscribe(UsageFilteringRuleProvider.RULES_CHANGED, this::rulesChanged);
        this.myUsageViewTreeCellRenderer = new UsageViewTreeCellRenderer(this);
        if (!this.myPresentation.isDetachedMode()) {
            UIUtil.invokeLaterIfNeeded(() -> {
                Object object = this.lock;
                synchronized (object) {
                    if (this.isDisposed) {
                        return;
                    }
                    this.myTree = new Tree(this.myModel){
                        {
                            ToolTipManager.sharedInstance().registerComponent(this);
                            this.setHorizontalAutoScrollingEnabled(false);
                        }

                        @Override
                        public boolean isRootVisible() {
                            return false;
                        }

                        @Override
                        public String getToolTipText(MouseEvent e) {
                            TreePath path2 = this.getPathForLocation(e.getX(), e.getY());
                            if (path2 != null && this.getCellRenderer() instanceof UsageViewTreeCellRenderer) {
                                return UsageViewTreeCellRenderer.getTooltipFromPresentation(path2.getLastPathComponent());
                            }
                            return null;
                        }

                        @Override
                        public boolean isPathEditable(TreePath path2) {
                            return path2.getLastPathComponent() instanceof UsageViewTreeModelBuilder.TargetsRootNode;
                        }

                        @Override
                        public Enumeration<TreePath> getExpandedDescendants(TreePath parent) {
                            return UsageViewImpl.this.expandingAll ? EmptyEnumeration.getInstance() : super.getExpandedDescendants(parent);
                        }
                    };
                    this.myTree.setName("UsageViewTree");
                    this.myRootPanel = new MyPanel(this.myTree);
                    Disposer.register((Disposable)this, (Disposable)this.myRootPanel);
                    this.myTree.setModel(this.myModel);
                    this.myRootPanel.setLayout(new BorderLayout());
                    SimpleToolWindowPanel toolWindowPanel = new SimpleToolWindowPanel(false, true);
                    this.myRootPanel.add((Component)toolWindowPanel, "Center");
                    JPanel toolbarPanel = new JPanel(new BorderLayout());
                    toolbarPanel.add((Component)this.createActionsToolbar(), "West");
                    toolbarPanel.add((Component)this.createFiltersToolbar(), "Center");
                    toolWindowPanel.setToolbar(toolbarPanel);
                    this.myCentralPanel = new JPanel(new BorderLayout());
                    this.setupCentralPanel();
                    this.initTree();
                    toolWindowPanel.setContent(this.myCentralPanel);
                    this.myTree.setCellRenderer(this.myUsageViewTreeCellRenderer);
                    SwingUtilities.invokeLater(() -> {
                        if (this.isDisposed || this.myProject.isDisposed()) {
                            return;
                        }
                        this.collapseAll();
                    });
                    myModelTracker.addListener(isPropertyChange -> {
                        if (!isPropertyChange) {
                            this.myChangesDetected = true;
                        }
                        this.updateLater();
                    }, this);
                    if (this.myPresentation.isShowCancelButton()) {
                        this.addButtonToLowerPane(this::close, UsageViewBundle.message("usage.view.cancel.button", new Object[0]));
                    }
                    this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                        @Override
                        public void valueChanged(TreeSelectionEvent e) {
                            SwingUtilities.invokeLater(() -> {
                                if (UsageViewImpl.this.isDisposed || UsageViewImpl.this.myProject.isDisposed()) {
                                    return;
                                }
                                UsageViewImpl.this.updateOnSelectionChanged();
                            });
                        }
                    });
                    this.myTree.addFocusListener(new FocusAdapter(){

                        @Override
                        public void focusGained(FocusEvent e) {
                            if (UsageViewImpl.this.rulesChanged) {
                                UsageViewImpl.this.rulesChanged = false;
                                UsageViewImpl.this.rulesChanged();
                            }
                        }
                    });
                }
            });
        }
        this.myExclusionHandler = new ExclusionHandler<DefaultMutableTreeNode>(){

            @Override
            public boolean isNodeExclusionAvailable(@NotNull DefaultMutableTreeNode node) {
                if (node == null) {
                    4.$$$reportNull$$$0(0);
                }
                return node instanceof UsageNode;
            }

            @Override
            public boolean isNodeExcluded(@NotNull DefaultMutableTreeNode node) {
                if (node == null) {
                    4.$$$reportNull$$$0(1);
                }
                return ((UsageNode)node).isDataExcluded();
            }

            @Override
            public void excludeNode(@NotNull DefaultMutableTreeNode node) {
                if (node == null) {
                    4.$$$reportNull$$$0(2);
                }
                HashSet<Node> nodes = new HashSet<Node>();
                UsageViewImpl.collectAllChildNodes(node, nodes);
                this.collectParentNodes(node, nodes, true);
                this.setExcludeNodes(nodes, true);
            }

            private void collectParentNodes(DefaultMutableTreeNode node, Set<Node> nodes, boolean almostAllChildrenExcluded) {
                TreeNode parent = node.getParent();
                if (parent == UsageViewImpl.this.myRoot || !(parent instanceof GroupNode)) {
                    return;
                }
                GroupNode parentNode = (GroupNode)parent;
                List otherNodes = parentNode.getChildren().stream().filter(n -> n.isExcluded() != almostAllChildrenExcluded).collect(Collectors.toList());
                if (otherNodes.size() == 1 && otherNodes.get(0) == node) {
                    nodes.add(parentNode);
                    this.collectParentNodes(parentNode, nodes, almostAllChildrenExcluded);
                }
            }

            private void setExcludeNodes(@NotNull Set<Node> nodes, boolean excluded) {
                if (nodes == null) {
                    4.$$$reportNull$$$0(3);
                }
                for (Node node : nodes) {
                    node.setExcluded(excluded, (Consumer<Node>)UsageViewImpl.this.edtNodeChangedQueue);
                }
                UsageViewImpl.this.updateImmediatelyNodesUpToRoot(nodes);
            }

            @Override
            public void includeNode(@NotNull DefaultMutableTreeNode node) {
                if (node == null) {
                    4.$$$reportNull$$$0(4);
                }
                HashSet<Node> nodes = new HashSet<Node>();
                UsageViewImpl.collectAllChildNodes(node, nodes);
                this.collectParentNodes(node, nodes, false);
                this.setExcludeNodes(nodes, false);
            }

            @Override
            public boolean isActionEnabled(boolean isExcludeAction) {
                return UsageViewImpl.this.getPresentation().isExcludeAvailable();
            }

            @Override
            public void onDone(boolean isExcludeAction) {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "nodes";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/usages/impl/UsageViewImpl$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isNodeExclusionAvailable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isNodeExcluded";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "excludeNode";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setExcludeNodes";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "includeNode";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvents() {
        ArrayList changed;
        ArrayList<Node> insertedUnder;
        ApplicationManager.getApplication().assertIsDispatchThread();
        Set<Node> set = this.nodesInsertedUnder;
        synchronized (set) {
            insertedUnder = new ArrayList<Node>(this.nodesInsertedUnder);
            this.nodesInsertedUnder.clear();
        }
        TIntArrayList indicesToFire = new TIntArrayList();
        ArrayList<Node> nodesToFire = new ArrayList<Node>();
        for (Node parentNode : insertedUnder) {
            List<Node> swingChildren = ((GroupNode)parentNode).getSwingChildren();
            Node node = parentNode;
            synchronized (node) {
                List<Node> modelChildren = ((GroupNode)parentNode).getChildren();
                assert (modelChildren.size() >= swingChildren.size());
                int k = 0;
                for (int i = 0; i < modelChildren.size(); ++i) {
                    Node parent;
                    Node swingNode;
                    Node modelNode = modelChildren.get(i);
                    Node node2 = swingNode = k >= swingChildren.size() ? null : swingChildren.get(k);
                    if (swingNode == modelNode) {
                        ++k;
                        continue;
                    }
                    parentNode.insertNewNode(modelNode, i);
                    indicesToFire.add(i);
                    nodesToFire.add(modelNode);
                    if (k == i) {
                        ++k;
                    }
                    if (!(modelNode instanceof UsageNode) || !((parent = (Node)modelNode.getParent()) instanceof GroupNode)) continue;
                    ((GroupNode)parent).incrementUsageCount();
                }
            }
            this.myModel.fireTreeNodesInserted(parentNode, this.myModel.getPathToRoot(parentNode), indicesToFire.toNativeArray(), nodesToFire.toArray(new Node[0]));
            nodesToFire.clear();
            indicesToFire.clear();
        }
        MultiMap<Node, Node> multiMap = this.changedNodesToFire;
        synchronized (multiMap) {
            changed = new ArrayList(this.changedNodesToFire.entrySet());
            this.changedNodesToFire.clear();
        }
        for (Map.Entry entry : changed) {
            Node parentNode = (Node)entry.getKey();
            THashSet childrenToUpdate = new THashSet((Collection)entry.getValue());
            for (int i = 0; i < parentNode.getChildCount(); ++i) {
                Node childNode = (Node)parentNode.getChildAt(i);
                if (!childrenToUpdate.contains(childNode)) continue;
                nodesToFire.add(childNode);
                indicesToFire.add(i);
            }
            this.myModel.fireTreeNodesChanged(parentNode, this.myModel.getPathToRoot(parentNode), indicesToFire.toNativeArray(), nodesToFire.toArray(new Node[0]));
            nodesToFire.clear();
            indicesToFire.clear();
        }
    }

    boolean searchHasBeenCancelled() {
        ProgressIndicator progress = this.associatedProgress;
        return progress != null && progress.isCanceled();
    }

    void cancelCurrentSearch() {
        ProgressIndicator progress = this.associatedProgress;
        if (progress != null) {
            ProgressWrapper.unwrap((ProgressIndicator)progress).cancel();
        }
    }

    private void clearRendererCache() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.expandingAll) {
            return;
        }
        TreeUI ui = this.myTree.getUI();
        if (ui instanceof BasicTreeUI) {
            AbstractLayoutCache treeState = (AbstractLayoutCache)ReflectionUtil.getField(BasicTreeUI.class, (Object)ui, AbstractLayoutCache.class, (String)"treeState");
            Rectangle visibleRect = this.myTree.getVisibleRect();
            int rowForLocation = this.myTree.getClosestRowForLocation(0, visibleRect.y);
            int visibleRowCount = this.getVisibleRowCount();
            for (int i = rowForLocation + visibleRowCount + 1; i >= rowForLocation; --i) {
                TreePath eachPath = this.myTree.getPathForRow(i);
                if (eachPath == null) continue;
                treeState.invalidatePathBounds(eachPath);
                Object node = eachPath.getLastPathComponent();
                if (!(node instanceof UsageNode)) continue;
                ((UsageNode)node).update(this, this.edtNodeChangedQueue);
            }
            this.myTree.repaint(visibleRect);
        } else {
            this.myTree.setCellRenderer(this.myUsageViewTreeCellRenderer);
        }
    }

    private int getVisibleRowCount() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return TreeUtil.getVisibleRowCountForFixedRowHeight(this.myTree);
    }

    private void setupCentralPanel() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myCentralPanel.removeAll();
        this.disposeUsageContextPanels();
        JScrollPane treePane = ScrollPaneFactory.createScrollPane(this.myTree);
        treePane.getViewport().addChangeListener(__ -> this.clearRendererCache());
        this.myPreviewSplitter = new Splitter(false, 0.5f, 0.1f, 0.9f);
        this.myPreviewSplitter.setFirstComponent((JComponent)treePane);
        this.myCentralPanel.add((Component)this.myPreviewSplitter, "Center");
        if (UsageViewSettings.getInstance().IS_PREVIEW_USAGES) {
            this.myPreviewSplitter.setProportion(UsageViewSettings.getInstance().PREVIEW_USAGES_SPLITTER_PROPORTIONS);
            treePane.putClientProperty(UIUtil.KEEP_BORDER_SIDES, 4);
            JBTabbedPane tabbedPane = new JBTabbedPane(3){

                @Override
                @NotNull
                protected Insets getInsetsForTabComponent() {
                    Insets insets = new Insets(0, 0, 0, 0);
                    if (insets == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return insets;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewImpl$5", "getInsetsForTabComponent"));
                }
            };
            Object[] extensions = (UsageContextPanel.Provider[])Extensions.getExtensions(UsageContextPanel.Provider.EP_NAME, (AreaInstance)this.myProject);
            this.myUsageContextPanelProviders = ContainerUtil.filter((Object[])extensions, provider -> provider.isAvailableFor(this));
            for (UsageContextPanel.Provider provider2 : this.myUsageContextPanelProviders) {
                JComponent component;
                if (this.myCurrentUsageContextProvider == null || this.myCurrentUsageContextProvider == provider2) {
                    this.myCurrentUsageContextProvider = provider2;
                    this.myCurrentUsageContextPanel = provider2.create(this);
                    component = this.myCurrentUsageContextPanel.createComponent();
                } else {
                    component = new JLabel();
                }
                tabbedPane.addTab(provider2.getTabTitle(), component);
            }
            int index = this.myUsageContextPanelProviders.indexOf(this.myCurrentUsageContextProvider);
            tabbedPane.setSelectedIndex(index);
            tabbedPane.addChangeListener(e -> {
                int currentIndex = tabbedPane.getSelectedIndex();
                UsageContextPanel.Provider selectedProvider = this.myUsageContextPanelProviders.get(currentIndex);
                if (selectedProvider != this.myCurrentUsageContextProvider) {
                    this.tabSelected(selectedProvider);
                }
            });
            tabbedPane.setBorder(IdeBorderFactory.createBorder(1));
            JBPanelWithEmptyText panel = new JBPanelWithEmptyText(new BorderLayout());
            panel.add(tabbedPane, "Center");
            this.myPreviewSplitter.setSecondComponent((JComponent)((Object)panel));
        } else {
            this.myPreviewSplitter.setProportion(1.0f);
        }
        this.myCentralPanel.add((Component)this.myAdditionalComponent, "South");
        this.myAdditionalComponent.add((Component)this.myButtonPanel, "South");
        this.myRootPanel.revalidate();
        this.myRootPanel.repaint();
    }

    private void tabSelected(@NotNull UsageContextPanel.Provider provider) {
        if (provider == null) {
            UsageViewImpl.$$$reportNull$$$0(3);
        }
        this.myCurrentUsageContextProvider = provider;
        this.setupCentralPanel();
        this.updateOnSelectionChanged();
    }

    private void disposeUsageContextPanels() {
        if (this.myCurrentUsageContextPanel != null) {
            this.saveSplitterProportions();
            Disposer.dispose((Disposable)this.myCurrentUsageContextPanel);
            this.myCurrentUsageContextPanel = null;
        }
    }

    @NotNull
    private static UsageFilteringRule[] getActiveFilteringRules(Project project) {
        UsageFilteringRuleProvider[] providers = (UsageFilteringRuleProvider[])Extensions.getExtensions(UsageFilteringRuleProvider.EP_NAME);
        ArrayList list = new ArrayList(providers.length);
        for (UsageFilteringRuleProvider provider : providers) {
            ContainerUtil.addAll(list, (Object[])provider.getActiveRules(project));
        }
        UsageFilteringRule[] usageFilteringRuleArray = list.toArray(new UsageFilteringRule[list.size()]);
        if (usageFilteringRuleArray == null) {
            UsageViewImpl.$$$reportNull$$$0(4);
        }
        return usageFilteringRuleArray;
    }

    @NotNull
    private static UsageGroupingRule[] getActiveGroupingRules(@NotNull Project project) {
        if (project == null) {
            UsageViewImpl.$$$reportNull$$$0(5);
        }
        UsageGroupingRuleProvider[] providers = (UsageGroupingRuleProvider[])Extensions.getExtensions(UsageGroupingRuleProvider.EP_NAME);
        ArrayList list = new ArrayList(providers.length);
        for (UsageGroupingRuleProvider provider : providers) {
            ContainerUtil.addAll(list, (Object[])provider.getActiveRules(project));
        }
        Collections.sort(list, Comparator.comparingInt(UsageGroupingRule::getRank));
        UsageGroupingRule[] usageGroupingRuleArray = list.toArray(new UsageGroupingRule[list.size()]);
        if (usageGroupingRuleArray == null) {
            UsageViewImpl.$$$reportNull$$$0(6);
        }
        return usageGroupingRuleArray;
    }

    private void initTree() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myTree.setShowsRootHandles(true);
        SmartExpander.installOn((JTree)this.myTree);
        TreeUtil.installActions(this.myTree);
        EditSourceOnDoubleClickHandler.install(this.myTree);
        this.myTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    Navigatable navigatable;
                    TreePath leadSelectionPath = UsageViewImpl.this.myTree.getLeadSelectionPath();
                    if (leadSelectionPath == null) {
                        return;
                    }
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)leadSelectionPath.getLastPathComponent();
                    if (node instanceof UsageNode) {
                        Usage usage = ((UsageNode)node).getUsage();
                        usage.navigate(false);
                        usage.highlightInEditor();
                    } else if (node.isLeaf() && (navigatable = UsageViewImpl.getNavigatableForNode(node)) != null && navigatable.canNavigate()) {
                        navigatable.navigate(false);
                    }
                }
            }
        });
        TreeUtil.selectFirstNode(this.myTree);
        PopupHandler.installPopupHandler(this.myTree, "UsageView.Popup", "UsageViewPopup");
        this.myTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                UsageViewImpl.this.clearRendererCache();
                TreePath path2 = event.getPath();
                Object component = path2.getLastPathComponent();
                if (component instanceof Node) {
                    Node node = (Node)component;
                    if (!UsageViewImpl.this.expandingAll && node.needsUpdate()) {
                        UsageViewImpl.this.checkNodeValidity(node, path2);
                    }
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                UsageViewImpl.this.clearRendererCache();
            }
        });
        TreeUIHelper.getInstance().installTreeSpeedSearch(this.myTree, (Convertor<TreePath, String>)((Convertor)o -> {
            Object value = o.getLastPathComponent();
            TreeCellRenderer renderer = this.myTree.getCellRenderer();
            if (renderer instanceof UsageViewTreeCellRenderer) {
                UsageViewTreeCellRenderer coloredRenderer = (UsageViewTreeCellRenderer)renderer;
                return coloredRenderer.getPlainTextForNode(value);
            }
            return value == null ? null : value.toString();
        }), true);
    }

    @NotNull
    private JComponent createActionsToolbar() {
        AnAction[] actions;
        ApplicationManager.getApplication().assertIsDispatchThread();
        DefaultActionGroup group = new DefaultActionGroup(){

            @Override
            public void update(AnActionEvent e) {
                super.update(e);
                UsageViewImpl.this.myButtonPanel.update();
            }

            @Override
            public boolean isDumbAware() {
                return true;
            }
        };
        for (AnAction action : actions = this.createActions()) {
            if (action == null) continue;
            group.add(action);
        }
        JComponent jComponent = this.toUsageViewToolbar(group);
        if (jComponent == null) {
            UsageViewImpl.$$$reportNull$$$0(7);
        }
        return jComponent;
    }

    @NotNull
    private JComponent toUsageViewToolbar(@NotNull DefaultActionGroup group) {
        if (group == null) {
            UsageViewImpl.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("UsageViewToolbar", group, false);
        actionToolbar.setTargetComponent(this.myRootPanel);
        JComponent jComponent = actionToolbar.getComponent();
        if (jComponent == null) {
            UsageViewImpl.$$$reportNull$$$0(9);
        }
        return jComponent;
    }

    protected boolean isPreviewUsageActionEnabled() {
        return true;
    }

    @NotNull
    private JComponent createFiltersToolbar() {
        AnAction[] groupingActions;
        ApplicationManager.getApplication().assertIsDispatchThread();
        DefaultActionGroup group = new DefaultActionGroup();
        for (AnAction groupingAction : groupingActions = this.createGroupingActions()) {
            group.add(groupingAction);
        }
        this.addFilteringActions(group);
        if (this.isPreviewUsageActionEnabled()) {
            group.add(new PreviewUsageAction(this));
        }
        group.add(new SortMembersAlphabeticallyAction(this));
        JComponent jComponent = this.toUsageViewToolbar(group);
        if (jComponent == null) {
            UsageViewImpl.$$$reportNull$$$0(10);
        }
        return jComponent;
    }

    public void addFilteringActions(@NotNull DefaultActionGroup group) {
        UsageFilteringRuleProvider[] providers;
        if (group == null) {
            UsageViewImpl.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.getPresentation().isMergeDupLinesAvailable()) {
            MergeDupLines mergeDupLines = new MergeDupLines();
            MyPanel component = this.myRootPanel;
            if (component != null) {
                mergeDupLines.registerCustomShortcutSet(mergeDupLines.getShortcutSet(), component, this);
            }
            group.add(mergeDupLines);
        }
        for (UsageFilteringRuleProvider provider : providers = (UsageFilteringRuleProvider[])Extensions.getExtensions(UsageFilteringRuleProvider.EP_NAME)) {
            AnAction[] actions;
            for (AnAction action : actions = provider.createFilteringActions(this)) {
                group.add(action);
            }
        }
    }

    @NotNull
    protected AnAction[] createActions() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        TreeExpander treeExpander = new TreeExpander(){

            @Override
            public void expandAll() {
                UsageViewImpl.this.expandAll();
                UsageViewSettings.getInstance().setExpanded(true);
            }

            @Override
            public boolean canExpand() {
                return true;
            }

            @Override
            public void collapseAll() {
                UsageViewImpl.this.collapseAll();
                UsageViewSettings.getInstance().setExpanded(false);
            }

            @Override
            public boolean canCollapse() {
                return true;
            }
        };
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        JComponent component = this.getComponent();
        AnAction expandAllAction = actionsManager.createExpandAllAction(treeExpander, component);
        AnAction collapseAllAction = actionsManager.createCollapseAllAction(treeExpander, component);
        Disposer.register((Disposable)this, () -> {
            expandAllAction.unregisterCustomShortcutSet(component);
            collapseAllAction.unregisterCustomShortcutSet(component);
        });
        AnAction[] anActionArray = new AnAction[]{this.canShowSettings() ? this.showSettings() : null, ActionManager.getInstance().getAction("UsageView.Rerun"), new CloseAction(), ActionManager.getInstance().getAction("PinActiveTab"), this.createRecentFindUsagesAction(), expandAllAction, collapseAllAction, actionsManager.createPrevOccurenceAction(this.myRootPanel), actionsManager.createNextOccurenceAction(this.myRootPanel), actionsManager.installAutoscrollToSourceHandler(this.myProject, this.myTree, new MyAutoScrollToSourceOptionProvider()), actionsManager.createExportToTextFileAction(this.myTextFileExporter), actionsManager.createHelpAction(HELP_ID)};
        if (anActionArray == null) {
            UsageViewImpl.$$$reportNull$$$0(12);
        }
        return anActionArray;
    }

    private boolean canShowSettings() {
        if (this.myTargets.length == 0) {
            return false;
        }
        UsageTarget target = this.myTargets[0];
        return target instanceof ConfigurableUsageTarget;
    }

    @NotNull
    private AnAction showSettings() {
        final ConfigurableUsageTarget configurableUsageTarget = UsageViewImpl.getConfigurableTarget(this.myTargets);
        String description = null;
        try {
            description = configurableUsageTarget == null ? null : "Show settings for " + configurableUsageTarget.getLongDescriptiveName();
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        if (description == null) {
            description = "Show find usages settings dialog";
        }
        AnAction anAction = new AnAction("Settings...", description, AllIcons.General.ProjectSettings){
            {
                KeyboardShortcut shortcut;
                super(arg0, arg1, arg2);
                KeyboardShortcut keyboardShortcut = shortcut = configurableUsageTarget == null ? UsageViewImpl.getShowUsagesWithSettingsShortcut() : configurableUsageTarget.getShortcut();
                if (shortcut != null) {
                    this.registerCustomShortcutSet(new CustomShortcutSet(shortcut), UsageViewImpl.this.getComponent());
                }
            }

            @Override
            public boolean startInTransaction() {
                return true;
            }

            @Override
            public void actionPerformed(AnActionEvent e) {
                FindManager.getInstance(UsageViewImpl.this.getProject()).showSettingsAndFindUsages(UsageViewImpl.this.myTargets);
            }
        };
        if (anAction == null) {
            UsageViewImpl.$$$reportNull$$$0(13);
        }
        return anAction;
    }

    private static ConfigurableUsageTarget getConfigurableTarget(@NotNull UsageTarget[] targets) {
        UsageTarget target;
        if (targets == null) {
            UsageViewImpl.$$$reportNull$$$0(14);
        }
        ConfigurableUsageTarget configurableUsageTarget = null;
        if (targets.length != 0 && (target = targets[0]) instanceof ConfigurableUsageTarget) {
            configurableUsageTarget = (ConfigurableUsageTarget)target;
        }
        return configurableUsageTarget;
    }

    @NotNull
    private AnAction createRecentFindUsagesAction() {
        AnAction action = ActionManager.getInstance().getAction(SHOW_RECENT_FIND_USAGES_ACTION_ID);
        action.registerCustomShortcutSet(action.getShortcutSet(), this.getComponent());
        AnAction anAction = action;
        if (anAction == null) {
            UsageViewImpl.$$$reportNull$$$0(15);
        }
        return anAction;
    }

    @NotNull
    private AnAction[] createGroupingActions() {
        UsageGroupingRuleProvider[] providers = (UsageGroupingRuleProvider[])Extensions.getExtensions(UsageGroupingRuleProvider.EP_NAME);
        ArrayList list = new ArrayList(providers.length);
        for (UsageGroupingRuleProvider provider : providers) {
            ContainerUtil.addAll(list, (Object[])provider.createGroupingActions(this));
        }
        AnAction[] anActionArray = list.toArray(new AnAction[list.size()]);
        if (anActionArray == null) {
            UsageViewImpl.$$$reportNull$$$0(16);
        }
        return anActionArray;
    }

    private boolean shouldTreeReactNowToRuleChanges() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myPresentation.isDetachedMode() || this.myTree.isShowing();
    }

    private void rulesChanged() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.shouldTreeReactNowToRuleChanges()) {
            this.rulesChanged = true;
            return;
        }
        ArrayList<UsageState> states = new ArrayList<UsageState>();
        if (this.myTree != null) {
            this.captureUsagesExpandState(new TreePath(this.myTree.getModel().getRoot()), states);
        }
        ArrayList<Usage> allUsages = new ArrayList<Usage>(this.myUsageNodes.keySet());
        Collections.sort(allUsages, USAGE_COMPARATOR);
        Set<Usage> excludedUsages = this.getExcludedUsages();
        this.reset();
        this.myBuilder.setGroupingRules(UsageViewImpl.getActiveGroupingRules(this.myProject));
        this.myBuilder.setFilteringRules(UsageViewImpl.getActiveFilteringRules(this.myProject));
        ApplicationManager.getApplication().runReadAction(() -> {
            for (Usage usage : allUsages) {
                if (!usage.isValid()) continue;
                if (usage instanceof MergeableUsage) {
                    ((MergeableUsage)((Object)usage)).reset();
                }
                this.appendUsage(usage);
            }
        });
        if (this.myTree != null) {
            this.excludeUsages(excludedUsages.toArray(new Usage[excludedUsages.size()]));
        }
        if (this.myCentralPanel != null) {
            this.setupCentralPanel();
        }
        SwingUtilities.invokeLater(() -> {
            if (this.isDisposed) {
                return;
            }
            if (this.myTree != null) {
                this.restoreUsageExpandState(states);
                this.updateImmediately();
            }
        });
    }

    private void captureUsagesExpandState(@NotNull TreePath pathFrom, @NotNull Collection<UsageState> states) {
        if (pathFrom == null) {
            UsageViewImpl.$$$reportNull$$$0(17);
        }
        if (states == null) {
            UsageViewImpl.$$$reportNull$$$0(18);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myTree.isExpanded(pathFrom)) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)pathFrom.getLastPathComponent();
        int childCount = node.getChildCount();
        for (int idx = 0; idx < childCount; ++idx) {
            TreeNode child = node.getChildAt(idx);
            if (child instanceof UsageNode) {
                Usage usage = ((UsageNode)child).getUsage();
                states.add(new UsageState(usage, this.myTree.getSelectionModel().isPathSelected(pathFrom.pathByAddingChild(child))));
                continue;
            }
            this.captureUsagesExpandState(pathFrom.pathByAddingChild(child), states);
        }
    }

    private void restoreUsageExpandState(@NotNull Collection<UsageState> states) {
        if (states == null) {
            UsageViewImpl.$$$reportNull$$$0(19);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myTree.getModel().getRoot();
        for (int i = root.getChildCount() - 1; i >= 0; --i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)root.getChildAt(i);
            if (!(child instanceof GroupNode)) continue;
            TreePath treePath = new TreePath(child.getPath());
            this.myTree.expandPath(treePath);
        }
        this.myTree.getSelectionModel().clearSelection();
        for (UsageState usageState : states) {
            usageState.restore();
        }
    }

    public void expandAll() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.fireEvents();
        this.expandingAll = true;
        try {
            TreeUtil.expandAll(this.myTree);
        }
        finally {
            this.expandingAll = false;
        }
        this.clearRendererCache();
    }

    private void collapseAll() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.fireEvents();
        TreeUtil.collapseAll(this.myTree, 3);
        TreeUtil.expand(this.myTree, 2);
    }

    void expandRoot() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.fireEvents();
        TreeUtil.expand(this.myTree, 1);
    }

    @NotNull
    DefaultMutableTreeNode getModelRoot() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.myTree.getModel().getRoot();
        if (defaultMutableTreeNode == null) {
            UsageViewImpl.$$$reportNull$$$0(20);
        }
        return defaultMutableTreeNode;
    }

    public void select() {
        if (this.myTree != null) {
            this.myTree.requestFocusInWindow();
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            UsageViewImpl.$$$reportNull$$$0(21);
        }
        return project;
    }

    @Nullable
    public static KeyboardShortcut getShowUsagesWithSettingsShortcut() {
        return ActionManager.getInstance().getKeyboardShortcut("ShowSettingsAndFindUsages");
    }

    static KeyboardShortcut getShowUsagesWithSettingsShortcut(@NotNull UsageTarget[] targets) {
        ConfigurableUsageTarget configurableTarget;
        if (targets == null) {
            UsageViewImpl.$$$reportNull$$$0(22);
        }
        return (configurableTarget = UsageViewImpl.getConfigurableTarget(targets)) == null ? UsageViewImpl.getShowUsagesWithSettingsShortcut() : configurableTarget.getShortcut();
    }

    void associateProgress(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            UsageViewImpl.$$$reportNull$$$0(23);
        }
        this.associatedProgress = indicator;
    }

    public void refreshUsages() {
        if (!this.myPresentation.isOpenInNewTab()) {
            this.reset();
        }
        this.doReRun();
    }

    protected void doReRun() {
        this.myChangesDetected = false;
        UsageViewManager.getInstance(this.getProject()).searchAndShowUsages(this.myTargets, this.myUsageSearcherFactory, true, false, this.myPresentation, null);
    }

    private void reset() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myUsageNodes.clear();
        this.myModel.reset();
        if (!this.myPresentation.isDetachedMode()) {
            SwingUtilities.invokeLater(() -> {
                if (this.isDisposed) {
                    return;
                }
                this.fireEvents();
                TreeUtil.expand(this.myTree, 2);
            });
        }
    }

    void drainQueuedUsageNodes() {
        assert (!ApplicationManager.getApplication().isDispatchThread()) : Thread.currentThread();
        UIUtil.invokeAndWaitIfNeeded(this::fireEvents);
    }

    @Override
    public void appendUsage(@NotNull Usage usage) {
        if (usage == null) {
            UsageViewImpl.$$$reportNull$$$0(24);
        }
        this.doAppendUsage(usage);
    }

    public UsageNode doAppendUsage(@NotNull Usage usage) {
        if (usage == null) {
            UsageViewImpl.$$$reportNull$$$0(25);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!usage.isValid()) {
            return null;
        }
        UsageNode child = this.myBuilder.appendUsage(usage, this.edtNodeInsertedUnderQueue, this.isFilterDuplicateLines());
        this.myUsageNodes.put(usage, child == null ? NULL_NODE : child);
        for (Node node = child; node != this.myRoot && node != null; node = (Node)node.getParent()) {
            node.update(this, this.edtNodeChangedQueue);
        }
        return child;
    }

    @Override
    public void removeUsage(@NotNull Usage usage) {
        if (usage == null) {
            UsageViewImpl.$$$reportNull$$$0(26);
        }
        this.removeUsagesBulk(Collections.singleton(usage));
    }

    @Override
    public void removeUsagesBulk(@NotNull Collection<Usage> usages) {
        if (usages == null) {
            UsageViewImpl.$$$reportNull$$$0(27);
        }
        int selectionRow = this.myTree.getMinSelectionRow();
        Set nodes = this.usagesToNodes(usages.stream()).collect(Collectors.toSet());
        usages.forEach(u -> this.myUsageNodes.remove(u));
        if (!nodes.isEmpty() && !this.myPresentation.isDetachedMode()) {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (this.isDisposed) {
                    return;
                }
                DefaultTreeModel treeModel = (DefaultTreeModel)this.myTree.getModel();
                ((GroupNode)treeModel.getRoot()).removeUsagesBulk(nodes, treeModel);
                int rowToSelect = Math.min(this.myTree.getRowCount() - 1, selectionRow);
                if (rowToSelect >= 0) {
                    this.myTree.setSelectionRow(rowToSelect);
                }
            });
        }
    }

    @Override
    public void includeUsages(@NotNull Usage[] usages) {
        if (usages == null) {
            UsageViewImpl.$$$reportNull$$$0(28);
        }
        this.usagesToNodes(Arrays.stream(usages)).forEach(this.myExclusionHandler::includeNode);
    }

    @Override
    public void excludeUsages(@NotNull Usage[] usages) {
        if (usages == null) {
            UsageViewImpl.$$$reportNull$$$0(29);
        }
        this.usagesToNodes(Arrays.stream(usages)).forEach(this.myExclusionHandler::excludeNode);
    }

    private Stream<UsageNode> usagesToNodes(Stream<Usage> usages) {
        return usages.map(this.myUsageNodes::get).filter(node -> node != NULL_NODE && node != null);
    }

    @Override
    public void selectUsages(@NotNull Usage[] usages) {
        if (usages == null) {
            UsageViewImpl.$$$reportNull$$$0(30);
        }
        TreePath[] paths = (TreePath[])this.usagesToNodes(Arrays.stream(usages)).map(node -> new TreePath(node.getPath())).toArray(TreePath[]::new);
        this.myTree.setSelectionPaths(paths);
        if (paths.length != 0) {
            this.myTree.scrollPathToVisible(paths[0]);
        }
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        JComponent jComponent = this.myRootPanel == null ? new JLabel() : this.myRootPanel;
        if (jComponent == null) {
            UsageViewImpl.$$$reportNull$$$0(31);
        }
        return jComponent;
    }

    @Override
    public int getUsagesCount() {
        return this.myUsageNodes.size();
    }

    void setContent(@NotNull Content content) {
        if (content == null) {
            UsageViewImpl.$$$reportNull$$$0(32);
        }
        this.myContent = content;
        content.setDisposer(this);
    }

    private void updateImmediately() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            return;
        }
        TreeNode root = (TreeNode)this.myTree.getModel().getRoot();
        this.checkNodeValidity(root, new TreePath(root));
        this.updateOnSelectionChanged();
    }

    private void updateImmediatelyNodesUpToRoot(@NotNull Collection<Node> nodes) {
        if (nodes == null) {
            UsageViewImpl.$$$reportNull$$$0(33);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            return;
        }
        TreeNode root = (TreeNode)this.myTree.getModel().getRoot();
        HashSet<Node> updated = new HashSet<Node>();
        while (true) {
            HashSet<Node> parents = new HashSet<Node>();
            for (Node node : nodes) {
                node.update(this, this.edtNodeChangedQueue);
                TreeNode parent = node.getParent();
                if (parent == root || !(parent instanceof Node) || !updated.add((Node)parent)) continue;
                parents.add((Node)parent);
            }
            if (parents.isEmpty()) break;
            nodes = parents;
        }
        this.updateImmediately();
    }

    private void updateOnSelectionChanged() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myCurrentUsageContextPanel != null) {
            try {
                this.myCurrentUsageContextPanel.updateLayout(this.getSelectedUsageInfos());
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
    }

    private void checkNodeValidity(@NotNull TreeNode node, @NotNull TreePath path2) {
        if (node == null) {
            UsageViewImpl.$$$reportNull$$$0(34);
        }
        if (path2 == null) {
            UsageViewImpl.$$$reportNull$$$0(35);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean shouldCheckChildren = true;
        if (this.myTree.isCollapsed(path2)) {
            if (node instanceof Node) {
                ((Node)node).markNeedUpdate();
            }
            shouldCheckChildren = false;
        }
        UsageViewTreeCellRenderer.RowLocation isVisible = this.myUsageViewTreeCellRenderer.isRowVisible(this.myTree.getRowForPath(new TreePath(((DefaultMutableTreeNode)node).getPath())), this.myTree.getVisibleRect());
        if (shouldCheckChildren && isVisible != UsageViewTreeCellRenderer.RowLocation.AFTER_VISIBLE_RECT) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                TreeNode child = node.getChildAt(i);
                this.checkNodeValidity(child, path2.pathByAddingChild(child));
            }
        }
        if (node instanceof Node && node != this.getModelRoot() && isVisible == UsageViewTreeCellRenderer.RowLocation.INSIDE_VISIBLE_RECT) {
            try {
                ((Node)node).update(this, this.edtNodeChangedQueue);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
    }

    private void updateLater() {
        this.myUpdateAlarm.cancelAllRequests();
        this.myUpdateAlarm.addRequest(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myProject);
            documentManager.cancelAndRunWhenAllCommitted((Object)"UpdateUsageView", this::updateImmediately);
        }, 300);
    }

    @Override
    public void close() {
        this.cancelCurrentSearch();
        if (this.myContent != null) {
            com.intellij.usageView.UsageViewManager.getInstance(this.myProject).closeContent(this.myContent);
        }
    }

    private void saveSplitterProportions() {
        UsageViewSettings.getInstance().PREVIEW_USAGES_SPLITTER_PROPORTIONS = this.myPreviewSplitter.getProportion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.disposeUsageContextPanels();
        Object object = this.lock;
        synchronized (object) {
            this.isDisposed = true;
            if (this.myTree != null) {
                ToolTipManager.sharedInstance().unregisterComponent(this.myTree);
            }
            this.myUpdateAlarm.cancelAllRequests();
        }
        this.disposeSmartPointers();
    }

    private void disposeSmartPointers() {
        SmartPointerManager pointerManager = SmartPointerManager.getInstance(this.getProject());
        for (Usage usage : this.myUsageNodes.keySet()) {
            if (!(usage instanceof UsageInfo2UsageAdapter)) continue;
            SmartPsiElementPointer<?> pointer = ((UsageInfo2UsageAdapter)usage).getUsageInfo().getSmartPointer();
            pointerManager.removePointer(pointer);
        }
    }

    @Override
    public boolean isSearchInProgress() {
        return this.mySearchInProgress;
    }

    public void setSearchInProgress(boolean searchInProgress) {
        this.mySearchInProgress = searchInProgress;
        if (!this.myPresentation.isDetachedMode()) {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (this.isDisposed) {
                    return;
                }
                UsageNode firstUsageNode = this.myModel.getFirstUsageNode();
                if (firstUsageNode == null) {
                    return;
                }
                Node node = this.getSelectedNode();
                if (node != null && !Comparing.equal((Object)new TreePath(node.getPath()), (Object)TreeUtil.getFirstNodePath(this.myTree))) {
                    return;
                }
                this.showNode(firstUsageNode);
                if (UsageViewSettings.getInstance().isExpanded() && this.myUsageNodes.size() < 10000) {
                    this.expandAll();
                }
            });
        }
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    private void showNode(@NotNull UsageNode node) {
        if (node == null) {
            UsageViewImpl.$$$reportNull$$$0(36);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.isDisposed && !this.myPresentation.isDetachedMode()) {
            this.fireEvents();
            TreePath usagePath = new TreePath(node.getPath());
            this.myTree.expandPath(usagePath.getParentPath());
            TreeUtil.selectPath(this.myTree, usagePath);
        }
    }

    @Override
    public void addButtonToLowerPane(@NotNull Runnable runnable, @NotNull String text) {
        if (runnable == null) {
            UsageViewImpl.$$$reportNull$$$0(37);
        }
        if (text == null) {
            UsageViewImpl.$$$reportNull$$$0(38);
        }
        int index = this.myButtonPanel.getComponentCount();
        if (!SystemInfo.isMac && index > 0 && this.myPresentation.isShowCancelButton()) {
            --index;
        }
        this.myButtonPanel.addButtonRunnable(index, runnable, text);
    }

    @Override
    public void setAdditionalComponent(@Nullable JComponent comp) {
        BorderLayout layout = (BorderLayout)this.myAdditionalComponent.getLayout();
        Component prev = layout.getLayoutComponent(this.myAdditionalComponent, "Center");
        if (prev == comp) {
            return;
        }
        if (prev != null) {
            this.myAdditionalComponent.remove(prev);
        }
        if (comp != null) {
            this.myAdditionalComponent.add((Component)comp, "Center");
        }
        this.myAdditionalComponent.revalidate();
    }

    @Override
    public void addButtonToLowerPane(@NotNull Runnable runnable, @NotNull String text, char mnemonic) {
        if (runnable == null) {
            UsageViewImpl.$$$reportNull$$$0(39);
        }
        if (text == null) {
            UsageViewImpl.$$$reportNull$$$0(40);
        }
        this.addButtonToLowerPane(runnable, text);
    }

    @Override
    public void addPerformOperationAction(@NotNull Runnable processRunnable, String commandName, String cannotMakeString, @NotNull String shortDescription) {
        if (processRunnable == null) {
            UsageViewImpl.$$$reportNull$$$0(41);
        }
        if (shortDescription == null) {
            UsageViewImpl.$$$reportNull$$$0(42);
        }
        this.addPerformOperationAction(processRunnable, commandName, cannotMakeString, shortDescription, true);
    }

    @Override
    public void addPerformOperationAction(@NotNull Runnable processRunnable, String commandName, String cannotMakeString, @NotNull String shortDescription, boolean checkReadOnlyStatus) {
        if (processRunnable == null) {
            UsageViewImpl.$$$reportNull$$$0(43);
        }
        if (shortDescription == null) {
            UsageViewImpl.$$$reportNull$$$0(44);
        }
        this.addButtonToLowerPane(this.newPerformOperationRunnable(processRunnable, commandName, cannotMakeString, checkReadOnlyStatus), shortDescription);
    }

    @NotNull
    private MyPerformOperationRunnable newPerformOperationRunnable(Runnable processRunnable, String commandName, String cannotMakeString, boolean checkReadOnlyStatus) {
        MyPerformOperationRunnable myPerformOperationRunnable = new MyPerformOperationRunnable(cannotMakeString, processRunnable, commandName, checkReadOnlyStatus);
        if (myPerformOperationRunnable == null) {
            UsageViewImpl.$$$reportNull$$$0(45);
        }
        return myPerformOperationRunnable;
    }

    private boolean allTargetsAreValid() {
        for (UsageTarget target : this.myTargets) {
            if (target.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public UsageViewPresentation getPresentation() {
        UsageViewPresentation usageViewPresentation = this.myPresentation;
        if (usageViewPresentation == null) {
            UsageViewImpl.$$$reportNull$$$0(46);
        }
        return usageViewPresentation;
    }

    public boolean canPerformReRun() {
        try {
            return this.myUsageSearcherFactory != null && this.allTargetsAreValid() && this.myUsageSearcherFactory.create() != null;
        }
        catch (PsiInvalidElementAccessException e) {
            return false;
        }
    }

    private boolean checkReadonlyUsages() {
        Set<VirtualFile> readOnlyUsages = this.getReadOnlyUsagesFiles();
        return readOnlyUsages.isEmpty() || !ReadonlyStatusHandler.getInstance(this.myProject).ensureFilesWritable(VfsUtilCore.toVirtualFileArray(readOnlyUsages)).hasReadonlyFiles();
    }

    @NotNull
    private Set<Usage> getReadOnlyUsages() {
        THashSet result = new THashSet();
        Set<Map.Entry<Usage, UsageNode>> usages = this.myUsageNodes.entrySet();
        for (Map.Entry<Usage, UsageNode> entry : usages) {
            Usage usage = entry.getKey();
            UsageNode node = entry.getValue();
            if (node == null || node == NULL_NODE || node.isExcluded() || !usage.isReadOnly()) continue;
            result.add(usage);
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            UsageViewImpl.$$$reportNull$$$0(47);
        }
        return tHashSet;
    }

    @NotNull
    private Set<VirtualFile> getReadOnlyUsagesFiles() {
        Set<Usage> usages = this.getReadOnlyUsages();
        THashSet result = new THashSet();
        for (Usage usage : usages) {
            UsageInFile usageInFile;
            VirtualFile file;
            if (usage instanceof UsageInFile && (file = (usageInFile = (UsageInFile)usage).getFile()) != null && file.isValid()) {
                result.add(file);
            }
            if (!(usage instanceof UsageInFiles)) continue;
            UsageInFiles usageInFiles = (UsageInFiles)((Object)usage);
            ContainerUtil.addAll((Collection)result, (Object[])usageInFiles.getFiles());
        }
        for (UsageTarget target : this.myTargets) {
            Object[] files = target.getFiles();
            if (files == null) continue;
            ContainerUtil.addAll((Collection)result, (Object[])files);
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            UsageViewImpl.$$$reportNull$$$0(48);
        }
        return tHashSet;
    }

    @Override
    @NotNull
    public Set<Usage> getExcludedUsages() {
        THashSet result = new THashSet();
        for (Map.Entry<Usage, UsageNode> entry : this.myUsageNodes.entrySet()) {
            UsageNode node = entry.getValue();
            Usage usage = entry.getKey();
            if (node == NULL_NODE || node == null || !node.isExcluded()) continue;
            result.add(usage);
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            UsageViewImpl.$$$reportNull$$$0(49);
        }
        return tHashSet;
    }

    @Nullable
    private Node getSelectedNode() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        TreePath leadSelectionPath = this.myTree.getLeadSelectionPath();
        if (leadSelectionPath == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)leadSelectionPath.getLastPathComponent();
        return node instanceof Node ? (Node)node : null;
    }

    @Nullable
    private Node[] getSelectedNodes() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        TreePath[] leadSelectionPath = this.myTree.getSelectionPaths();
        if (leadSelectionPath == null || leadSelectionPath.length == 0) {
            return null;
        }
        ArrayList<Node> result = new ArrayList<Node>();
        for (TreePath comp : leadSelectionPath) {
            Object lastPathComponent = comp.getLastPathComponent();
            if (!(lastPathComponent instanceof Node)) continue;
            Node node = (Node)lastPathComponent;
            result.add(node);
        }
        return result.isEmpty() ? null : result.toArray(new Node[result.size()]);
    }

    @Override
    @NotNull
    public Set<Usage> getSelectedUsages() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        if (selectionPaths == null) {
            Set<Usage> set = Collections.emptySet();
            if (set == null) {
                UsageViewImpl.$$$reportNull$$$0(50);
            }
            return set;
        }
        THashSet usages = new THashSet();
        for (TreePath selectionPath : selectionPaths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
            UsageViewImpl.collectUsages(node, (Set<Usage>)usages);
        }
        THashSet tHashSet = usages;
        if (tHashSet == null) {
            UsageViewImpl.$$$reportNull$$$0(51);
        }
        return tHashSet;
    }

    @Override
    @NotNull
    public Set<Usage> getUsages() {
        Set<Usage> set = this.myUsageNodes.keySet();
        if (set == null) {
            UsageViewImpl.$$$reportNull$$$0(52);
        }
        return set;
    }

    @Override
    @NotNull
    public List<Usage> getSortedUsages() {
        ArrayList<Usage> usages = new ArrayList<Usage>(this.getUsages());
        Collections.sort(usages, USAGE_COMPARATOR);
        ArrayList<Usage> arrayList = usages;
        if (arrayList == null) {
            UsageViewImpl.$$$reportNull$$$0(53);
        }
        return arrayList;
    }

    private static void collectUsages(@NotNull DefaultMutableTreeNode node, @NotNull Set<Usage> usages) {
        if (node == null) {
            UsageViewImpl.$$$reportNull$$$0(54);
        }
        if (usages == null) {
            UsageViewImpl.$$$reportNull$$$0(55);
        }
        if (node instanceof UsageNode) {
            UsageNode usageNode = (UsageNode)node;
            Usage usage = usageNode.getUsage();
            usages.add(usage);
        }
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)enumeration.nextElement();
            UsageViewImpl.collectUsages(child, usages);
        }
    }

    private static void collectAllChildNodes(@NotNull DefaultMutableTreeNode node, @NotNull Set<Node> nodes) {
        if (node == null) {
            UsageViewImpl.$$$reportNull$$$0(56);
        }
        if (nodes == null) {
            UsageViewImpl.$$$reportNull$$$0(57);
        }
        if (node instanceof Node) {
            nodes.add((Node)node);
        }
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)enumeration.nextElement();
            UsageViewImpl.collectAllChildNodes(child, nodes);
        }
    }

    @Nullable
    private UsageTarget[] getSelectedUsageTargets() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        if (selectionPaths == null) {
            return null;
        }
        THashSet targets = new THashSet();
        for (TreePath selectionPath : selectionPaths) {
            UsageTargetNode usageTargetNode;
            UsageTarget target;
            Object lastPathComponent = selectionPath.getLastPathComponent();
            if (!(lastPathComponent instanceof UsageTargetNode) || !(target = (usageTargetNode = (UsageTargetNode)lastPathComponent).getTarget()).isValid()) continue;
            targets.add(target);
        }
        return targets.isEmpty() ? null : targets.toArray(new UsageTarget[targets.size()]);
    }

    @Nullable
    private static Navigatable getNavigatableForNode(@NotNull DefaultMutableTreeNode node) {
        Object userObject;
        if (node == null) {
            UsageViewImpl.$$$reportNull$$$0(58);
        }
        if ((userObject = node.getUserObject()) instanceof Navigatable) {
            Navigatable navigatable = (Navigatable)userObject;
            return navigatable.canNavigate() ? navigatable : null;
        }
        return null;
    }

    private static Navigatable[] getNavigatablesForNodes(Node[] nodes) {
        if (nodes == null) {
            return null;
        }
        ArrayList<Navigatable> result = new ArrayList<Navigatable>();
        for (Node node : nodes) {
            Object userObject = node.getUserObject();
            if (!(userObject instanceof Navigatable)) continue;
            result.add((Navigatable)userObject);
        }
        return result.toArray(new Navigatable[result.size()]);
    }

    boolean areTargetsValid() {
        return this.myModel.areTargetsValid();
    }

    private List<UsageInfo> getSelectedUsageInfos() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return (List)USAGE_INFO_LIST_KEY.getData(DataManager.getInstance().getDataContext(this.myRootPanel));
    }

    public GroupNode getRoot() {
        return this.myRoot;
    }

    String getNodeText(@NotNull TreeNode node) {
        if (node == null) {
            UsageViewImpl.$$$reportNull$$$0(59);
        }
        return this.myUsageViewTreeCellRenderer.getPlainTextForNode(node);
    }

    public boolean isVisible(@NotNull Usage usage) {
        if (usage == null) {
            UsageViewImpl.$$$reportNull$$$0(60);
        }
        return this.myBuilder != null && this.myBuilder.isVisible(usage);
    }

    @NotNull
    public UsageTarget[] getTargets() {
        if (this.myTargets == null) {
            UsageViewImpl.$$$reportNull$$$0(61);
        }
        return this.myTargets;
    }

    public void setOriginUsage(@NotNull Usage usage) {
        if (usage == null) {
            UsageViewImpl.$$$reportNull$$$0(62);
        }
        this.myOriginUsage = usage;
    }

    public boolean isOriginUsage(@NotNull Usage usage) {
        if (usage == null) {
            UsageViewImpl.$$$reportNull$$$0(63);
        }
        return this.myOriginUsage instanceof UsageInfo2UsageAdapter && usage instanceof UsageInfo2UsageAdapter && ((UsageInfo2UsageAdapter)usage).getUsageInfo().equals(((UsageInfo2UsageAdapter)this.myOriginUsage).getUsageInfo());
    }

    private boolean isFilterDuplicateLines() {
        return this.myPresentation.isMergeDupLinesAvailable() && UsageViewSettings.getInstance().isFilterDuplicatedLine();
    }

    public Usage getNextToSelect(@NotNull Usage toDelete) {
        if (toDelete == null) {
            UsageViewImpl.$$$reportNull$$$0(64);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        UsageNode usageNode = this.myUsageNodes.get(toDelete);
        if (usageNode == null) {
            return null;
        }
        DefaultMutableTreeNode node = this.myRootPanel.mySupport.findNode(this.myTree, usageNode, true, null);
        if (node == null) {
            node = this.myRootPanel.mySupport.findNode(this.myTree, usageNode, false, null);
        }
        return node == null ? null : (node.getUserObject() instanceof Usage ? (Usage)node.getUserObject() : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 31: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 61: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 31: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 61: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: 
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 31: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/impl/UsageViewImpl";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathFrom";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "states";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 60: 
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 33: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 34: 
            case 36: 
            case 54: 
            case 56: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processRunnable";
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortDescription";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDelete";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/impl/UsageViewImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveFilteringRules";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveGroupingRules";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionsToolbar";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toUsageViewToolbar";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createFiltersToolbar";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "showSettings";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createRecentFindUsagesAction";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroupingActions";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelRoot";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "newPerformOperationRunnable";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadOnlyUsages";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadOnlyUsagesFiles";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedUsages";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedUsages";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedUsages";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tabSelected";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 31: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 61: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getActiveGroupingRules";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toUsageViewToolbar";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addFilteringActions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurableTarget";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "captureUsagesExpandState";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "restoreUsageExpandState";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getShowUsagesWithSettingsShortcut";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "associateProgress";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "appendUsage";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "doAppendUsage";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "removeUsage";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "removeUsagesBulk";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "includeUsages";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "excludeUsages";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "selectUsages";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "updateImmediatelyNodesUpToRoot";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "checkNodeValidity";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "showNode";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addButtonToLowerPane";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addPerformOperationAction";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "collectUsages";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "collectAllChildNodes";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatableForNode";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getNodeText";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "setOriginUsage";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isOriginUsage";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getNextToSelect";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$6";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 31: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 61: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyPerformOperationRunnable
    implements Runnable {
        private final String myCannotMakeString;
        private final Runnable myProcessRunnable;
        private final String myCommandName;
        private final boolean myCheckReadOnlyStatus;

        private MyPerformOperationRunnable(String cannotMakeString, Runnable processRunnable, String commandName, boolean checkReadOnlyStatus) {
            this.myCannotMakeString = cannotMakeString;
            this.myProcessRunnable = processRunnable;
            this.myCommandName = commandName;
            this.myCheckReadOnlyStatus = checkReadOnlyStatus;
        }

        @Override
        public void run() {
            if (this.myCheckReadOnlyStatus && !UsageViewImpl.this.checkReadonlyUsages()) {
                return;
            }
            PsiDocumentManager.getInstance(UsageViewImpl.this.myProject).commitAllDocuments();
            if (this.myCannotMakeString != null && UsageViewImpl.this.myChangesDetected) {
                String title = UsageViewBundle.message("changes.detected.error.title", new Object[0]);
                if (UsageViewImpl.this.canPerformReRun()) {
                    String[] options = new String[]{UsageViewBundle.message("action.description.rerun", new Object[0]), UsageViewBundle.message("usage.view.cancel.button", new Object[0])};
                    String message = this.myCannotMakeString + "\n\n" + UsageViewBundle.message("dialog.rerun.search", new Object[0]);
                    int answer = Messages.showOkCancelDialog(UsageViewImpl.this.myProject, message, title, options[0], options[1], Messages.getErrorIcon());
                    if (answer == 0) {
                        UsageViewImpl.this.refreshUsages();
                    }
                } else {
                    Messages.showMessageDialog(UsageViewImpl.this.myProject, this.myCannotMakeString, title, Messages.getErrorIcon());
                }
                return;
            }
            UsageViewImpl.this.close();
            CommandProcessor.getInstance().executeCommand(UsageViewImpl.this.myProject, this.myProcessRunnable, this.myCommandName, null);
        }
    }

    private class UsageState {
        private final Usage myUsage;
        private final boolean mySelected;

        private UsageState(Usage usage, boolean isSelected) {
            if (usage == null) {
                UsageState.$$$reportNull$$$0(0);
            }
            this.myUsage = usage;
            this.mySelected = isSelected;
        }

        private void restore() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            UsageNode node = (UsageNode)UsageViewImpl.this.myUsageNodes.get(this.myUsage);
            if (node == NULL_NODE || node == null) {
                return;
            }
            DefaultMutableTreeNode parentGroupingNode = (DefaultMutableTreeNode)node.getParent();
            if (parentGroupingNode != null) {
                TreePath treePath = new TreePath(parentGroupingNode.getPath());
                UsageViewImpl.this.myTree.expandPath(treePath);
                if (this.mySelected) {
                    UsageViewImpl.this.myTree.addSelectionPath(treePath.pathByAddingChild(node));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/usages/impl/UsageViewImpl$UsageState", "<init>"));
        }
    }

    private final class ButtonPanel
    extends JPanel {
        private ButtonPanel() {
            this.setLayout(new FlowLayout(0, 8, 0));
        }

        private void addButtonRunnable(int index, Runnable runnable, String text) {
            if (this.getBorder() == null) {
                this.setBorder(IdeBorderFactory.createBorder(2));
            }
            JButton button = new JButton(UIUtil.replaceMnemonicAmpersand((String)text));
            DialogUtil.registerMnemonic(button);
            UsageViewImpl.this.getProject().getMessageBus().connect((Disposable)UsageViewImpl.this).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                @Override
                public void enteredDumbMode() {
                    ButtonPanel.this.update();
                }

                @Override
                public void exitDumbMode() {
                    ButtonPanel.this.update();
                }
            });
            button.setFocusable(false);
            button.addActionListener(e -> runnable.run());
            this.add((Component)button, index);
            this.invalidate();
            if (this.getParent() != null) {
                this.getParent().validate();
            }
        }

        void update() {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof JButton)) continue;
                JButton button = (JButton)component;
                button.setEnabled(!UsageViewImpl.this.isSearchInProgress() && !DumbService.isDumb(UsageViewImpl.this.myProject));
            }
        }
    }

    private static class MyAutoScrollToSourceOptionProvider
    implements AutoScrollToSourceOptionProvider {
        private MyAutoScrollToSourceOptionProvider() {
        }

        @Override
        public boolean isAutoScrollMode() {
            return UsageViewSettings.getInstance().IS_AUTOSCROLL_TO_SOURCE;
        }

        @Override
        public void setAutoScrollMode(boolean state) {
            UsageViewSettings.getInstance().IS_AUTOSCROLL_TO_SOURCE = state;
        }
    }

    private class MyPanel
    extends JPanel
    implements TypeSafeDataProvider,
    OccurenceNavigator,
    Disposable {
        @Nullable
        private OccurenceNavigatorSupport mySupport;
        private final CopyProvider myCopyProvider;

        private MyPanel(JTree tree) {
            if (tree == null) {
                MyPanel.$$$reportNull$$$0(0);
            }
            this.mySupport = new OccurenceNavigatorSupport(tree){

                @Override
                protected Navigatable createDescriptorForNode(DefaultMutableTreeNode node) {
                    if (node.getChildCount() > 0) {
                        return null;
                    }
                    if (node instanceof Node && ((Node)node).isExcluded()) {
                        return null;
                    }
                    return UsageViewImpl.getNavigatableForNode(node);
                }

                @Override
                public String getNextOccurenceActionName() {
                    return UsageViewBundle.message("action.next.occurrence", new Object[0]);
                }

                @Override
                public String getPreviousOccurenceActionName() {
                    return UsageViewBundle.message("action.previous.occurrence", new Object[0]);
                }
            };
            this.myCopyProvider = new TextCopyProvider(){

                @Override
                @Nullable
                public Collection<String> getTextLinesToCopy() {
                    Node[] selectedNodes = UsageViewImpl.this.getSelectedNodes();
                    if (selectedNodes != null && selectedNodes.length > 0) {
                        ArrayList lines = ContainerUtil.newArrayList();
                        for (Node node : selectedNodes) {
                            lines.add(node.getText(UsageViewImpl.this));
                        }
                        return lines;
                    }
                    return null;
                }
            };
        }

        public void dispose() {
            this.mySupport = null;
        }

        @Override
        public boolean hasNextOccurence() {
            return this.mySupport != null && this.mySupport.hasNextOccurence();
        }

        @Override
        public boolean hasPreviousOccurence() {
            return this.mySupport != null && this.mySupport.hasPreviousOccurence();
        }

        @Override
        public OccurenceNavigator.OccurenceInfo goNextOccurence() {
            return this.mySupport != null ? this.mySupport.goNextOccurence() : null;
        }

        @Override
        public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
            return this.mySupport != null ? this.mySupport.goPreviousOccurence() : null;
        }

        @Override
        public String getNextOccurenceActionName() {
            return this.mySupport != null ? this.mySupport.getNextOccurenceActionName() : "";
        }

        @Override
        public String getPreviousOccurenceActionName() {
            return this.mySupport != null ? this.mySupport.getPreviousOccurenceActionName() : "";
        }

        @Override
        public void calcData(DataKey key, DataSink sink) {
            if (key == CommonDataKeys.PROJECT) {
                sink.put(CommonDataKeys.PROJECT, UsageViewImpl.this.myProject);
            } else if (key == UsageView.USAGE_VIEW_KEY) {
                sink.put(UsageView.USAGE_VIEW_KEY, UsageViewImpl.this);
            } else if (key == ExclusionHandler.EXCLUSION_HANDLER) {
                sink.put(ExclusionHandler.EXCLUSION_HANDLER, UsageViewImpl.this.myExclusionHandler);
            } else if (key == CommonDataKeys.NAVIGATABLE_ARRAY) {
                sink.put(CommonDataKeys.NAVIGATABLE_ARRAY, UsageViewImpl.getNavigatablesForNodes(UsageViewImpl.this.getSelectedNodes()));
            } else if (key == PlatformDataKeys.EXPORTER_TO_TEXT_FILE) {
                sink.put(PlatformDataKeys.EXPORTER_TO_TEXT_FILE, UsageViewImpl.this.myTextFileExporter);
            } else if (key == UsageView.USAGES_KEY) {
                Set<Usage> selectedUsages = UsageViewImpl.this.getSelectedUsages();
                sink.put(UsageView.USAGES_KEY, selectedUsages.toArray(new Usage[selectedUsages.size()]));
            } else if (key == UsageView.USAGE_TARGETS_KEY) {
                sink.put(UsageView.USAGE_TARGETS_KEY, UsageViewImpl.this.getSelectedUsageTargets());
            } else if (key == CommonDataKeys.VIRTUAL_FILE_ARRAY) {
                Set<Usage> usages = ApplicationManager.getApplication().isDispatchThread() ? UsageViewImpl.this.getSelectedUsages() : null;
                Usage[] ua = usages == null ? null : usages.toArray(new Usage[usages.size()]);
                UsageTarget[] usageTargets = ApplicationManager.getApplication().isDispatchThread() ? UsageViewImpl.this.getSelectedUsageTargets() : null;
                VirtualFile[] data = UsageDataUtil.provideVirtualFileArray(ua, usageTargets);
                sink.put(CommonDataKeys.VIRTUAL_FILE_ARRAY, data);
            } else if (key == PlatformDataKeys.HELP_ID) {
                sink.put(PlatformDataKeys.HELP_ID, UsageViewImpl.HELP_ID);
            } else if (key == PlatformDataKeys.COPY_PROVIDER) {
                sink.put(PlatformDataKeys.COPY_PROVIDER, this.myCopyProvider);
            } else {
                Node node;
                Node node2 = node = ApplicationManager.getApplication().isDispatchThread() ? UsageViewImpl.this.getSelectedNode() : null;
                if (node != null) {
                    DataProvider dataProvider;
                    Object data;
                    Object userObject = node.getUserObject();
                    if (userObject instanceof TypeSafeDataProvider) {
                        ((TypeSafeDataProvider)userObject).calcData(key, sink);
                    } else if (userObject instanceof DataProvider && (data = (dataProvider = (DataProvider)userObject).getData(key.getName())) != null) {
                        sink.put(key, data);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/usages/impl/UsageViewImpl$MyPanel", "<init>"));
        }
    }

    private class MergeDupLines
    extends RuleAction {
        private MergeDupLines() {
            super(UsageViewImpl.this, UsageViewBundle.message("action.merge.same.line", new Object[0]), AllIcons.Toolbar.Filterdups);
            this.setShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(70, 128)));
        }

        @Override
        protected boolean getOptionValue() {
            return UsageViewSettings.getInstance().isFilterDuplicatedLine();
        }

        @Override
        protected void setOptionValue(boolean value) {
            UsageViewSettings.getInstance().setFilterDuplicatedLine(value);
        }
    }

    private class CloseAction
    extends CloseTabToolbarAction {
        private CloseAction() {
        }

        @Override
        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setVisible(UsageViewImpl.this.myContent != null);
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            UsageViewImpl.this.close();
        }
    }
}

