/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.scout;

import com.android.tools.sherpa.scout.Direction;
import com.android.tools.sherpa.scout.ScoutWidget;
import com.android.tools.sherpa.scout.Utils;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class ScoutProbabilities {
    private static final boolean DEBUG = false;
    private static final float BASELINE_ERROR = 4.0f;
    private static final int RESULT_PROBABILITY = 0;
    private static final int RESULT_MARGIN = 1;
    private static final boolean SUPPORT_CENTER_TO_NON_ROOT = true;
    private static final boolean SUPPORT_WEAK_TO_CENTER = true;
    private static final int NEGATIVE_GAP_FLAG = -3;
    private static final int CONSTRAINT_FAILED_FLAG = -2;
    private static final float CENTER_ERROR = 2.0f;
    private static final float SLOPE_CENTER_CONNECTION = 20.0f;
    private static final int MAX_DIST_FOR_CENTER_OVERLAP = 40;
    private static final int ROOT_MARGIN_DISCOUNT = 16;
    private static final int MAX_ROOT_OVERHANG = 10;
    private static final boolean SKIP_SPARSE_COLUMNS = true;
    float[][][] mProbability;
    float[][][] mMargin;
    float[][][][] mBinaryBias;
    float[][][][] mBinaryProbability;
    int len;

    public void computeConstraints(ScoutWidget[] list) {
        if (list.length < 2) {
            throw new IllegalArgumentException("list must contain more than 1 widget");
        }
        if (!list[0].isRoot()) {
            throw new IllegalArgumentException("list[0] must be root");
        }
        this.len = list.length;
        this.mProbability = new float[this.len][][];
        this.mMargin = new float[this.len][][];
        float[] result = new float[2];
        for (int i = 1; i < this.len; ++i) {
            Direction[] all = Direction.getAllDirections();
            if (list[i].isGuideline()) continue;
            this.mProbability[i] = new float[all.length][];
            this.mMargin[i] = new float[all.length][];
            for (int dir = 0; dir < all.length; ++dir) {
                Direction direction = Direction.get(dir);
                int connectTypes = direction.connectTypes();
                this.mProbability[i][dir] = new float[this.len * connectTypes];
                this.mMargin[i][dir] = new float[this.len * connectTypes];
                for (int candidate = 0; candidate < this.mMargin[i][dir].length; ++candidate) {
                    int widgetNumber = candidate / connectTypes;
                    int opposite = candidate % connectTypes;
                    Direction connectTo = opposite == 0 ? direction : direction.getOpposite();
                    ScoutProbabilities.estimateProbability(list[i], direction, list[widgetNumber], connectTo, list, result);
                    this.mProbability[i][dir][candidate] = result[0];
                    this.mMargin[i][dir][candidate] = result[1];
                }
            }
        }
        this.mBinaryProbability = new float[this.len][2][this.len * 2][this.len * 2];
        this.mBinaryBias = new float[this.len][2][this.len * 2][this.len * 2];
        Direction[][] directions = new Direction[][]{{Direction.NORTH, Direction.SOUTH}, {Direction.WEST, Direction.EAST}};
        for (int i = 1; i < this.len; ++i) {
            for (int horizontal = 0; horizontal < 2; ++horizontal) {
                Direction[] sides = directions[horizontal];
                for (int candidate1 = 0; candidate1 < this.len * 2; ++candidate1) {
                    for (int candidate2 = 0; candidate2 < this.len * 2; ++candidate2) {
                        int widget1Number = candidate1 / 2;
                        int widget2Number = candidate2 / 2;
                        Direction widget1Side = sides[candidate1 & 1];
                        Direction widget2Side = sides[candidate2 & 1];
                        ScoutProbabilities.estimateBinaryProbability(list[i], horizontal, list[widget1Number], widget1Side, list[widget2Number], widget2Side, list, result);
                        this.mBinaryProbability[i][horizontal][candidate1][candidate2] = result[0];
                        this.mBinaryBias[i][horizontal][candidate1][candidate2] = result[1];
                    }
                }
            }
        }
    }

    public void applyConstraints(ScoutWidget[] list) {
        this.pickColumnWidgets(list);
        this.pickCenterOverlap(list);
        this.pickBaseLineConnections(list);
        this.pickCenteredConnections(list, true);
        this.pickMarginConnections(list, 10);
        this.pickCenteredConnections(list, false);
        this.pickMarginConnections(list, 100);
    }

    private void pickCenterOverlap(ScoutWidget[] list) {
        for (int i = 0; i < list.length; ++i) {
            ScoutWidget scoutWidget = list[i];
            float centerX = scoutWidget.getX() + scoutWidget.getWidth() / 2.0f;
            float centerY = scoutWidget.getY() + scoutWidget.getHeight() / 2.0f;
            for (int j = 0; j < list.length; ++j) {
                if (i == j) continue;
                ScoutWidget widget = list[j];
                if (scoutWidget.isGuideline() || !widget.isGuideline() && ScoutWidget.distance(scoutWidget, widget) > 40.0f) continue;
                if (!widget.isGuideline() || widget.isVerticalGuideline()) {
                    if (Math.abs(widget.getX() - centerX) < 2.0f) {
                        scoutWidget.setEdgeCentered(1, widget, Direction.WEST);
                    }
                    if (Math.abs(widget.getX() + widget.getWidth() - centerX) < 2.0f) {
                        scoutWidget.setEdgeCentered(1, widget, Direction.EAST);
                    }
                }
                if (widget.isGuideline() && !widget.isHorizontalGuideline()) continue;
                if (Math.abs(widget.getY() - centerY) < 2.0f) {
                    scoutWidget.setEdgeCentered(0, widget, Direction.NORTH);
                }
                if (!(Math.abs(widget.getY() + widget.getHeight() - centerY) < 2.0f)) continue;
                scoutWidget.setEdgeCentered(0, widget, Direction.SOUTH);
            }
        }
    }

    private void pickColumnWidgets(ScoutWidget[] list) {
        ScoutWidget[] w = new ScoutWidget[list.length - 1];
        for (int i = 0; i < list.length - 1; ++i) {
            w[i] = list[i + 1];
        }
        Arrays.sort(w, new Comparator<ScoutWidget>(){

            @Override
            public int compare(ScoutWidget w1, ScoutWidget w2) {
                int n = Integer.compare(w1.mConstraintWidget.getX(), w2.mConstraintWidget.getX());
                if (n == 0) {
                    n = Integer.compare(w1.mConstraintWidget.getWidth(), w2.mConstraintWidget.getWidth());
                }
                return n;
            }
        });
        ArrayList groups = new ArrayList();
        ArrayList<ScoutWidget> current = new ArrayList<ScoutWidget>();
        for (int i = 2; i < w.length; ++i) {
            ScoutWidget scoutWidget = w[i];
            if (!ScoutProbabilities.sameCol(w[i], w[i - 1])) continue;
            if (current.isEmpty()) {
                groups.add(current);
                current.add(w[i - 1]);
                current.add(w[i]);
                continue;
            }
            if (ScoutProbabilities.sameCol((ScoutWidget)current.get(0), w[i])) {
                current.add(w[i]);
                continue;
            }
            current = new ArrayList();
            groups.add(current);
            current.add(w[i - 1]);
            current.add(w[i]);
        }
        int[] dualIndex = new int[2];
        for (ArrayList arrayList : groups) {
            int gap;
            int i;
            int j;
            Rectangle union = null;
            int area = 0;
            for (ScoutWidget scoutWidget : arrayList) {
                Rectangle r = scoutWidget.getRectangle();
                area += r.width * r.height;
                if (union == null) {
                    union = r;
                    continue;
                }
                union = union.union(r);
            }
            int unionArea = union.width * union.height;
            if (unionArea > 2 * area) continue;
            ScoutWidget[] widgets = arrayList.toArray(new ScoutWidget[arrayList.size()]);
            Arrays.sort(widgets, ScoutWidget.sSortY);
            boolean reverse = widgets[0].rootDistanceY() > widgets[widgets.length - 1].rootDistanceY();
            float[] max = new float[widgets.length];
            int[] map = new int[widgets.length];
            for (int i2 = 0; i2 < widgets.length; ++i2) {
                for (j = 1; j < list.length; ++j) {
                    if (widgets[i2] != list[j]) continue;
                    map[i2] = j;
                }
            }
            for (int i2 = 0; i2 < widgets.length; ++i2) {
                for (j = 0; j < widgets.length; ++j) {
                    int l = map[j] * 2;
                    for (int k = 2; k < 2 * list.length; ++k) {
                        this.mBinaryProbability[map[i2]][1][l][k] = -1.0f;
                        this.mBinaryProbability[map[i2]][1][k][l] = -1.0f;
                        this.mBinaryProbability[map[i2]][1][l + 1][k] = -1.0f;
                        this.mBinaryProbability[map[i2]][1][k][l + 1] = -1.0f;
                    }
                }
            }
            int bestToConnect = -1;
            float maxVal = -1.0f;
            for (i = 0; i < widgets.length; ++i) {
                max[i] = Utils.max(this.mBinaryProbability[map[i]][1], dualIndex);
                if (!(maxVal < max[i])) continue;
                bestToConnect = i;
                maxVal = max[i];
            }
            if (reverse) {
                for (i = 1; i < widgets.length; ++i) {
                    gap = widgets[i].mConstraintWidget.getY();
                    gap -= widgets[i - 1].mConstraintWidget.getY();
                    widgets[i - 1].setConstraint(Direction.SOUTH.getDirection(), widgets[i], Direction.NORTH.getDirection(), gap -= widgets[i - 1].mConstraintWidget.getHeight());
                }
            } else {
                for (i = 1; i < widgets.length; ++i) {
                    gap = widgets[i].mConstraintWidget.getY();
                    gap -= widgets[i - 1].mConstraintWidget.getY();
                    widgets[i].setConstraint(Direction.NORTH.getDirection(), widgets[i - 1], Direction.SOUTH.getDirection(), gap -= widgets[i - 1].mConstraintWidget.getHeight());
                }
            }
            if (bestToConnect >= 0) {
                Utils.max(this.mBinaryProbability[map[bestToConnect]][1], dualIndex);
                ScoutWidget w1 = list[dualIndex[0] / 2];
                ScoutWidget w2 = list[dualIndex[1] / 2];
                Direction dir1 = (dualIndex[0] & 1) == 0 ? Direction.WEST : Direction.EAST;
                Direction dir2 = (dualIndex[1] & 1) == 0 ? Direction.WEST : Direction.EAST;
                widgets[bestToConnect].setCentered(0, w1, w2, dir1, dir2, 0.0f);
                for (int i3 = bestToConnect + 1; i3 < widgets.length; ++i3) {
                    widgets[i3].setCentered(1, widgets[i3 - 1], widgets[i3 - 1], Direction.WEST, Direction.EAST, 0.0f);
                }
                for (int i3 = 1; i3 <= bestToConnect; ++i3) {
                    widgets[i3 - 1].setCentered(1, widgets[i3], widgets[i3], Direction.WEST, Direction.EAST, 0.0f);
                }
                continue;
            }
            if (reverse) {
                for (i = 1; i < widgets.length; ++i) {
                    widgets[i - 1].setCentered(0, widgets[i], widgets[i], Direction.WEST, Direction.EAST, 0.0f);
                }
                continue;
            }
            for (i = 1; i < widgets.length; ++i) {
                widgets[i].setCentered(0, widgets[i - 1], widgets[i - 1], Direction.WEST, Direction.EAST, 0.0f);
            }
        }
    }

    private static boolean sameCol(ScoutWidget a, ScoutWidget b) {
        return a.mConstraintWidget.getX() == b.mConstraintWidget.getX() && a.mConstraintWidget.getWidth() == b.mConstraintWidget.getWidth();
    }

    private void pickBaseLineConnections(ScoutWidget[] list) {
        int baseline = Direction.BASE.getDirection();
        int north = Direction.NORTH.getDirection();
        int south = Direction.SOUTH.getDirection();
        int east = Direction.EAST.getDirection();
        int west = Direction.WEST.getDirection();
        for (int i = 1; i < this.len; ++i) {
            float[][] widgetProbability = this.mProbability[i];
            if (widgetProbability == null || widgetProbability[baseline] == null) continue;
            float maxValue = 0.0f;
            float maxNorth = widgetProbability[north][Utils.max(widgetProbability[north])];
            float maxSouth = widgetProbability[south][Utils.max(widgetProbability[south])];
            int maxIndex = Utils.max(widgetProbability[baseline]);
            float maxBaseline = widgetProbability[baseline][maxIndex];
            if (maxBaseline < maxNorth || maxBaseline < maxSouth || !list[i].setConstraint(baseline, list[maxIndex], baseline, 0.0f)) continue;
            Utils.zero(this.mBinaryProbability[i][0]);
            Arrays.fill(widgetProbability[baseline], 0.0f);
            widgetProbability[north] = null;
            Arrays.fill(widgetProbability[south], 0.0f);
        }
    }

    private void pickCenteredConnections(ScoutWidget[] list, boolean checkResizeable) {
        Direction[][] side = new Direction[][]{{Direction.NORTH, Direction.SOUTH}, {Direction.WEST, Direction.EAST}};
        int[] dualIndex = new int[2];
        for (int i = 1; i < this.len; ++i) {
            float[][][] widgetBinaryProbability = this.mBinaryProbability[i];
            float[][][] widgetBinaryBias = this.mBinaryBias[i];
            for (int horizontal = 0; horizontal < widgetBinaryProbability.length; ++horizontal) {
                float[][] pmatrix = widgetBinaryProbability[horizontal];
                float[][] bias = widgetBinaryBias[horizontal];
                if (pmatrix == null) continue;
                boolean worked = false;
                while (!worked) {
                    Utils.max(pmatrix, dualIndex);
                    int max1 = dualIndex[0];
                    int max2 = dualIndex[1];
                    int wNo1 = max1 / 2;
                    int wNo2 = max2 / 2;
                    Direction widget1Side = side[horizontal][max1 & 1];
                    Direction widget2Side = side[horizontal][max2 & 1];
                    float centerProbability = pmatrix[max1][max2];
                    worked = true;
                    if (!((double)centerProbability > 0.9) || checkResizeable && !list[i].isCandidateResizable(horizontal)) continue;
                    worked = list[i].setCentered(horizontal * 2, list[wNo1], list[wNo2], widget1Side, widget2Side, bias[max1][max2]);
                    if (worked) {
                        this.mProbability[i][horizontal * 2] = null;
                        this.mProbability[i][horizontal * 2 + 1] = null;
                        continue;
                    }
                    pmatrix[max1][max2] = 0.0f;
                }
            }
        }
    }

    private void pickMarginConnections(ScoutWidget[] list, int maxMarginPercent) {
        int baseline = Direction.BASE.getDirection();
        int north = Direction.NORTH.getDirection();
        int south = Direction.SOUTH.getDirection();
        int east = Direction.EAST.getDirection();
        int width = list[0].mConstraintWidget.getWidth();
        int height = list[0].mConstraintWidget.getWidth();
        int maxWidthMargin = width * maxMarginPercent / 100;
        int maxHeightMargin = height * maxMarginPercent / 100;
        int[] maxMargin = new int[]{maxHeightMargin, maxWidthMargin};
        int west = Direction.WEST.getDirection();
        int[][] dirTypes = new int[][]{{north, south}, {west, east}};
        for (int i = this.len - 1; i > 0; --i) {
            float[][] widgetProbability = this.mProbability[i];
            for (int horizontal = 0; horizontal < 2; ++horizontal) {
                int[] dirs = dirTypes[horizontal];
                boolean found = false;
                while (!found) {
                    int cDir;
                    int m;
                    found = true;
                    int setlen = dirs.length;
                    int dir = dirs[0];
                    if (widgetProbability == null || widgetProbability[dir] == null) continue;
                    int maxIndex = 0;
                    int maxDirection = 0;
                    float maxValue = 0.0f;
                    boolean rowType = false;
                    for (int j = 0; j < setlen; ++j) {
                        int rowMaxIndex = Utils.max(widgetProbability[dirs[j]]);
                        if (!(maxValue < widgetProbability[dirs[j]][rowMaxIndex])) continue;
                        maxDirection = dirs[j];
                        maxIndex = rowMaxIndex;
                        maxValue = widgetProbability[dirs[j]][rowMaxIndex];
                    }
                    if (widgetProbability[maxDirection] == null) {
                        System.out.println(list[i] + " " + maxDirection);
                        continue;
                    }
                    if (maxDirection == baseline) {
                        m = maxIndex;
                        cDir = baseline;
                    } else {
                        m = maxIndex / 2;
                        cDir = maxDirection;
                        if (maxIndex % 2 == 1) {
                            cDir ^= 1;
                        }
                    }
                    if (this.mMargin[i][maxDirection][maxIndex] > (float)maxMargin[horizontal]) continue;
                    String s = list[i] + "(" + Direction.toString(maxDirection) + ") -> " + list[m] + " " + Direction.toString(cDir);
                    if (!list[i].setConstraint(maxDirection, list[m], cDir, this.mMargin[i][maxDirection][maxIndex])) {
                        if (!(widgetProbability[maxDirection][maxIndex] >= 0.0f)) continue;
                        widgetProbability[maxDirection][maxIndex] = -2.0f;
                        found = false;
                        continue;
                    }
                    this.mBinaryProbability[i][horizontal] = null;
                }
            }
        }
    }

    private void pickWeakConstraints(ScoutWidget[] list) {
        int j;
        Direction[] directions = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
        ScoutWidget[][] candidates = new ScoutWidget[directions.length][];
        ScoutWidget[] maxCandidate = new ScoutWidget[directions.length];
        ScoutWidget centeredVertical = null;
        ScoutWidget centeredHorizontal = null;
        float[] maxDist = new float[]{-1.0f, -1.0f, -1.0f, -1.0f};
        for (int i = 1; i < list.length; ++i) {
            ScoutWidget widget = list[i];
            if (widget.isCentered(0) && (centeredVertical == null || centeredVertical.getHeight() > widget.getHeight())) {
                centeredVertical = widget;
            }
            if (!widget.isCentered(1) || centeredHorizontal != null && !(centeredHorizontal.getWidth() > widget.getWidth())) continue;
            centeredHorizontal = widget;
        }
        ScoutWidget[] centeredMax = new ScoutWidget[]{centeredVertical, centeredVertical, centeredHorizontal, centeredHorizontal};
        for (j = 0; j < directions.length; ++j) {
            Direction direction = directions[j];
            ArrayList<ScoutWidget> tmp = new ArrayList<ScoutWidget>();
            for (int i = 1; i < list.length; ++i) {
                float dist;
                ScoutWidget widget = list[i];
                if (widget.isGuideline() || widget.isConnected(directions[j].getOpposite()) || Float.isNaN(dist = widget.connectedDistanceToRoot(list, direction))) continue;
                if (dist > maxDist[j]) {
                    maxDist[j] = dist;
                    maxCandidate[j] = widget;
                }
                tmp.add(widget);
            }
            candidates[j] = tmp.toArray(new ScoutWidget[tmp.size()]);
        }
        for (j = 0; j < directions.length; ++j) {
            if (candidates[j].length <= 0 || candidates[j ^ 1].length != 0) continue;
            int dirInt = directions[j].getOpposite().getDirection();
            int rootDirInt = directions[j].getOpposite().getDirection();
            ScoutWidget connect = list[0];
            int connectSide = rootDirInt;
            if (centeredMax[j] != null) {
                float centerPos = centeredMax[j].getLocation(directions[j]);
                float maxPos = maxCandidate[j].getLocation(directions[j].getOpposite());
                float delta = centerPos - maxPos;
                if (directions[j] == Direction.EAST || directions[j] == Direction.SOUTH) {
                    delta = -delta;
                }
                if (delta > 0.0f) {
                    connectSide = directions[j].getDirection();
                    connect = centeredMax[j];
                }
            }
            maxCandidate[j].setWeakConstraint(dirInt, connect, connectSide);
            candidates[j] = new ScoutWidget[0];
        }
        for (j = 0; j < directions.length; j += 2) {
            if (candidates[j].length <= 0 || candidates[j + 1].length <= 0) continue;
            Direction side = directions[j].getOpposite();
            Direction otherSide = directions[j];
            if (!(maxCandidate[j].getLocation(side) < maxCandidate[j + 1].getLocation(otherSide))) continue;
            maxCandidate[j].setWeakConstraint(side.getDirection(), maxCandidate[j + 1], otherSide.getDirection());
            candidates[j] = new ScoutWidget[0];
            maxCandidate[j] = null;
        }
        for (j = 0; j < directions.length; j += 2) {
            if (candidates[j].length <= 0 || candidates[j + 1].length <= 0) continue;
            Direction side = directions[j].getOpposite();
            Direction otherSide = directions[j];
            boolean clearToRoot1 = maxCandidate[j].getNeighbor(otherSide, list).isRoot();
            boolean clearToRoot2 = maxCandidate[j].getNeighbor(side, list).isRoot();
            if (!clearToRoot1 || !clearToRoot2) continue;
            if (maxDist[j] > maxDist[j + 1]) {
                maxCandidate[j].setWeakConstraint(side.getDirection(), list[0], side.getDirection());
                continue;
            }
            maxCandidate[j + 1].setWeakConstraint(otherSide.getDirection(), list[0], otherSide.getDirection());
        }
    }

    private static void estimateProbability(ScoutWidget from, Direction fromDir, ScoutWidget to, Direction toDir, ScoutWidget[] list, float[] result) {
        result[0] = 0.0f;
        result[1] = 0.0f;
        if (from == to) {
            return;
        }
        if (from.isGuideline()) {
            return;
        }
        if (to.isGuideline()) {
            if ((toDir == Direction.NORTH || toDir == Direction.SOUTH) && to.isVerticalGuideline()) {
                return;
            }
            if ((toDir == Direction.EAST || toDir == Direction.WEST) && to.isHorizontalGuideline()) {
                return;
            }
        }
        if ((toDir == Direction.NORTH || toDir == Direction.SOUTH) & from.hasBaseline() && from.hasConnection(Direction.BASE)) {
            return;
        }
        if (!(fromDir != Direction.BASE || from.hasBaseline() && to.hasBaseline())) {
            return;
        }
        float fromLocation = from.getLocation(fromDir);
        float toLocation = to.getLocation(toDir);
        float positionDiff = fromDir.reverse() ? fromLocation - toLocation : toLocation - fromLocation;
        float distance = 2.0f * ScoutWidget.distance(from, to);
        if (to.isRoot()) {
            distance = Math.abs(distance - 16.0f);
        }
        float probability = 1.0f / (1.0f + distance * distance + positionDiff * positionDiff);
        if (fromDir == Direction.BASE) {
            if (Math.abs(positionDiff) > 4.0f) {
                return;
            }
            probability *= 2.0f;
        }
        if (to.isRoot()) {
            probability *= 2.0f;
        }
        result[0] = positionDiff >= 0.0f ? probability : -3.0f;
        result[1] = positionDiff;
    }

    private static void estimateBinaryProbability(ScoutWidget from, int orientation, ScoutWidget to1, Direction toDir1, ScoutWidget to2, Direction toDir2, ScoutWidget[] list, float[] result) {
        result[0] = 0.0f;
        result[1] = 0.0f;
        if (from == to1 || from == to2) {
            return;
        }
        if (from.isGuideline()) {
            return;
        }
        if (orientation == 0 & from.hasBaseline() && from.hasConnection(Direction.BASE)) {
            return;
        }
        float scale = 0.5f * (orientation == 0 ? from.getParent().getHeight() : from.getParent().getWidth());
        Direction fromLeft = Direction.getDirections(orientation)[0];
        Direction fromRight = Direction.getDirections(orientation)[1];
        float location1 = from.getLocation(fromLeft);
        float location2 = from.getLocation(fromRight);
        float toLoc1 = to1.getLocation(toDir1);
        float toLoc2 = to2.getLocation(toDir2);
        float positionDiff1 = location1 - toLoc1;
        float positionDiff2 = toLoc2 - location2;
        if (positionDiff1 < 0.0f || positionDiff2 < 0.0f) {
            boolean badCandidate = true;
            if (positionDiff2 < 0.0f && to2.isRoot() && positionDiff2 > -10.0f) {
                badCandidate = false;
                positionDiff2 = 0.0f;
            }
            if (positionDiff1 < 0.0f && to1.isRoot() && positionDiff2 > -10.0f) {
                badCandidate = false;
                positionDiff2 = 0.0f;
            }
            if (badCandidate) {
                result[0] = -3.0f;
                return;
            }
        }
        float distance1 = ScoutWidget.distance(from, to1) / scale;
        float distance2 = ScoutWidget.distance(from, to2) / scale;
        float diff = Math.abs(positionDiff1 - positionDiff2);
        float probability = diff < 20.0f ? 1 : 0;
        probability /= 1.0f + distance1 + distance2;
        probability += 1.0f / (1.0f + Math.abs(positionDiff1 - positionDiff2));
        result[0] = probability *= to1.isRoot() && to2.isRoot() ? 2.0f : 1.0f;
        result[1] = Math.min(positionDiff1, positionDiff2);
    }

    public void printTable(ScoutWidget[] list) {
        this.printCenterTable(list);
        this.printBaseTable(list);
    }

    public void printCenterTable(ScoutWidget[] list) {
        System.out.println("----------------- BASE TABLE --------------------");
        int SIZE = 10;
        String padd = new String(new char[10]).replace('\u0000', ' ');
        System.out.print("  ");
        for (int i = 0; i < this.len; ++i) {
            String dbg = "[" + i + "] " + list[i] + "-------------------------";
            dbg = dbg.substring(0, 20);
            System.out.print(dbg + (i == this.len - 1 ? "\n" : ""));
        }
        String str = "[";
        for (int con = 0; con < this.len * 2; ++con) {
            int opposite = con & 1;
            str = str + (con / 2 + (opposite == 0 ? "->" : "<-") + "           ").substring(0, 10);
        }
        System.out.println("  " + str);
        for (int i = 1; i < this.len; ++i) {
            for (int dir = 0; dir < this.mBinaryProbability[i].length; ++dir) {
                String tab = "";
                for (int k = 0; k < this.mBinaryProbability[i][dir].length; ++k) {
                    tab = tab + Utils.toS(this.mBinaryProbability[i][dir][k]) + "\n  ";
                }
                System.out.println(Direction.toString(dir) + " " + tab);
            }
        }
    }

    public void printBaseTable(ScoutWidget[] list) {
        System.out.println("----------------- CENTER TABLE --------------------");
        int SIZE = 10;
        String padd = new String(new char[10]).replace('\u0000', ' ');
        System.out.print(" ");
        for (int i = 0; i < this.len; ++i) {
            String dbg = "[" + i + "] " + list[i] + "-------------------------";
            dbg = i == 0 ? padd + dbg.substring(0, 20) : dbg.substring(0, 20);
            System.out.print(dbg + (i == this.len - 1 ? "\n" : ""));
        }
        String str = "[";
        for (int con = 0; con < this.len * 2; ++con) {
            int opposite = con & 1;
            str = str + (con / 2 + (opposite == 0 ? "->" : "<-") + "           ").substring(0, 10);
        }
        String header = ("Connection " + padd).substring(0, 10);
        System.out.println(header + " " + str);
        for (int i = 1; i < this.len; ++i) {
            if (this.mProbability[i] == null) continue;
            for (int dir = 0; dir < this.mProbability[i].length; ++dir) {
                System.out.println(Utils.leftTrim(padd + i + " " + Direction.toString(dir), 10) + " " + Utils.toS(this.mProbability[i][dir]));
                System.out.println(padd + " " + Utils.toS(this.mMargin[i][dir]));
            }
        }
    }
}

