/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.modules;

import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.SmartList;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.cli.common.modules.DelegatedSaxHandler;
import org.jetbrains.kotlin.cli.common.modules.ModuleBuilder;
import org.jetbrains.kotlin.cli.common.modules.ModuleScriptData;
import org.jetbrains.kotlin.modules.JavaRootPath;
import org.jetbrains.kotlin.modules.Module;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ModuleXmlParser {
    public static final String MODULES = "modules";
    public static final String MODULE = "module";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String TYPE_PRODUCTION = "java-production";
    public static final String TYPE_TEST = "java-test";
    public static final String OUTPUT_DIR = "outputDir";
    public static final String FRIEND_DIR = "friendDir";
    public static final String SOURCES = "sources";
    public static final String JAVA_SOURCE_ROOTS = "javaSourceRoots";
    public static final String JAVA_SOURCE_PACKAGE_PREFIX = "packagePrefix";
    public static final String PATH = "path";
    public static final String CLASSPATH = "classpath";
    public static final String MODULAR_JDK_ROOT = "modularJdkRoot";
    private final MessageCollector messageCollector;
    private final List<Module> modules;
    private DefaultHandler currentState;
    private final DefaultHandler initial;
    private final DefaultHandler insideModules;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static ModuleScriptData parseModuleScript(@NotNull String xmlFile, @NotNull MessageCollector messageCollector) {
        ModuleScriptData moduleScriptData;
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser", "parseModuleScript"));
        }
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser", "parseModuleScript"));
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(xmlFile);
            moduleScriptData = new ModuleXmlParser(messageCollector).parse(new BufferedInputStream(stream));
        }
        catch (FileNotFoundException e) {
            ModuleScriptData moduleScriptData2;
            try {
                MessageCollectorUtil.reportException(messageCollector, e);
                moduleScriptData2 = ModuleScriptData.EMPTY;
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(stream);
                throw throwable;
            }
            StreamUtil.closeStream((Closeable)stream);
            ModuleScriptData moduleScriptData3 = moduleScriptData2;
            if (moduleScriptData3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser", "parseModuleScript"));
            }
            return moduleScriptData3;
        }
        StreamUtil.closeStream((Closeable)stream);
        ModuleScriptData moduleScriptData4 = moduleScriptData;
        if (moduleScriptData4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser", "parseModuleScript"));
        }
        return moduleScriptData4;
    }

    private ModuleXmlParser(@NotNull MessageCollector messageCollector) {
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser", "<init>"));
        }
        this.modules = new SmartList();
        this.initial = new DefaultHandler(){

            @Override
            public void startElement(@NotNull String uri, @NotNull String localName, @NotNull String qName, @NotNull Attributes attributes) throws SAXException {
                if (uri == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$2", "startElement"));
                }
                if (localName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localName", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$2", "startElement"));
                }
                if (qName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$2", "startElement"));
                }
                if (attributes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$2", "startElement"));
                }
                if (!ModuleXmlParser.MODULES.equalsIgnoreCase(qName)) {
                    throw ModuleXmlParser.createError(qName);
                }
                ModuleXmlParser.this.setCurrentState(ModuleXmlParser.this.insideModules);
            }
        };
        this.insideModules = new DefaultHandler(){

            @Override
            public void startElement(@NotNull String uri, @NotNull String localName, @NotNull String qName, @NotNull Attributes attributes) throws SAXException {
                if (uri == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$3", "startElement"));
                }
                if (localName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localName", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$3", "startElement"));
                }
                if (qName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$3", "startElement"));
                }
                if (attributes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$3", "startElement"));
                }
                if (!ModuleXmlParser.MODULE.equalsIgnoreCase(qName)) {
                    throw ModuleXmlParser.createError(qName);
                }
                String moduleType = ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.TYPE, qName);
                assert (ModuleXmlParser.TYPE_PRODUCTION.equals(moduleType) || ModuleXmlParser.TYPE_TEST.equals(moduleType)) : "Unknown module type: " + moduleType;
                ModuleXmlParser.this.setCurrentState(new InsideModule(ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.NAME, qName), ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.OUTPUT_DIR, qName), moduleType));
            }

            @Override
            public void endElement(String uri, @NotNull String localName, @NotNull String qName) throws SAXException {
                if (localName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localName", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$3", "endElement"));
                }
                if (qName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$3", "endElement"));
                }
                if (ModuleXmlParser.MODULE.equalsIgnoreCase(qName) || ModuleXmlParser.MODULES.equalsIgnoreCase(qName)) {
                    ModuleXmlParser.this.setCurrentState(ModuleXmlParser.this.insideModules);
                }
            }
        };
        this.messageCollector = messageCollector;
    }

    private void setCurrentState(@NotNull DefaultHandler currentState) {
        if (currentState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentState", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser", "setCurrentState"));
        }
        this.currentState = currentState;
    }

    private ModuleScriptData parse(@NotNull InputStream xml) {
        if (xml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xml", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser", "parse"));
        }
        try {
            this.setCurrentState(this.initial);
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(xml, (DefaultHandler)new DelegatedSaxHandler(){

                @Override
                @NotNull
                protected DefaultHandler getDelegate() {
                    DefaultHandler defaultHandler = ModuleXmlParser.this.currentState;
                    if (defaultHandler == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$1", "getDelegate"));
                    }
                    return defaultHandler;
                }
            });
            return new ModuleScriptData(this.modules);
        }
        catch (IOException | ParserConfigurationException e) {
            MessageCollectorUtil.reportException(this.messageCollector, e);
        }
        catch (SAXException e) {
            this.messageCollector.report(CompilerMessageSeverity.ERROR, "Build file does not have a valid XML: " + e, null);
        }
        return ModuleScriptData.EMPTY;
    }

    @NotNull
    private static String getAttribute(Attributes attributes, String qName, String tag) throws SAXException {
        String name = attributes.getValue(qName);
        if (name == null) {
            throw new SAXException("No '" + qName + "' attribute for " + tag);
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser", "getAttribute"));
        }
        return string;
    }

    @Nullable
    private static String getNullableAttribute(Attributes attributes, String qName) throws SAXException {
        return attributes.getValue(qName);
    }

    private static SAXException createError(String qName) throws SAXException {
        return new SAXException("Unexpected tag: " + qName);
    }

    private class InsideModule
    extends DefaultHandler {
        private final ModuleBuilder moduleBuilder;

        private InsideModule(String name, @NotNull String outputDir2, String type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleXmlParser.TYPE, "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$InsideModule", "<init>"));
            }
            this.moduleBuilder = new ModuleBuilder(name, outputDir2, type);
            ModuleXmlParser.this.modules.add(this.moduleBuilder);
        }

        @Override
        public void startElement(@NotNull String uri, @NotNull String localName, @NotNull String qName, @NotNull Attributes attributes) throws SAXException {
            if (uri == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$InsideModule", "startElement"));
            }
            if (localName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localName", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$InsideModule", "startElement"));
            }
            if (qName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$InsideModule", "startElement"));
            }
            if (attributes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$InsideModule", "startElement"));
            }
            if (ModuleXmlParser.SOURCES.equalsIgnoreCase(qName)) {
                String path = ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.PATH, qName);
                this.moduleBuilder.addSourceFiles(path);
            } else if (ModuleXmlParser.FRIEND_DIR.equalsIgnoreCase(qName)) {
                String path = ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.PATH, qName);
                this.moduleBuilder.addFriendDir(path);
            } else if (ModuleXmlParser.CLASSPATH.equalsIgnoreCase(qName)) {
                String path = ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.PATH, qName);
                this.moduleBuilder.addClasspathEntry(path);
            } else if (ModuleXmlParser.JAVA_SOURCE_ROOTS.equalsIgnoreCase(qName)) {
                String path = ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.PATH, qName);
                String packagePrefix = ModuleXmlParser.getNullableAttribute(attributes, ModuleXmlParser.JAVA_SOURCE_PACKAGE_PREFIX);
                this.moduleBuilder.addJavaSourceRoot(new JavaRootPath(path, packagePrefix));
            } else if (ModuleXmlParser.MODULAR_JDK_ROOT.equalsIgnoreCase(qName)) {
                String path = ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.PATH, qName);
                this.moduleBuilder.setModularJdkRoot(path);
            } else {
                throw ModuleXmlParser.createError(qName);
            }
        }

        @Override
        public void endElement(String uri, @NotNull String localName, @NotNull String qName) throws SAXException {
            if (localName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localName", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$InsideModule", "endElement"));
            }
            if (qName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$InsideModule", "endElement"));
            }
            if (ModuleXmlParser.MODULE.equalsIgnoreCase(qName)) {
                ModuleXmlParser.this.setCurrentState(ModuleXmlParser.this.insideModules);
            }
        }
    }
}

