/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.incremental.storage.PathStringDescriptor;
import org.jetbrains.kotlin.incremental.storage.StringCollectionExternalizer;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J\u0016\u0010\r\u001a\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00022\u0006\u0010\t\u001a\u00020\u0005H\u0086\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0003H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/incremental/SourceToClassesMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Ljava/io/File;)V", "add", "", "sourceFile", "className", "Lorg/jetbrains/kotlin/name/FqName;", "clearOutputsForSource", "dumpValue", "value", "get", "remove", "path", "build-common"})
final class SourceToClassesMap
extends BasicStringMap<Collection<? extends String>> {
    public final void clearOutputsForSource(@NotNull File sourceFile) {
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        String string = sourceFile.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceFile.canonicalPath");
        this.remove(string);
    }

    public final void add(@NotNull File sourceFile, @NotNull FqName className2) {
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
        LazyStorage lazyStorage = this.getStorage();
        String string = sourceFile.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceFile.canonicalPath");
        String string2 = className2.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"className.asString()");
        lazyStorage.append(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<FqName> get(@NotNull File sourceFile) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        LazyStorage lazyStorage = this.getStorage();
        String string = sourceFile.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceFile.canonicalPath");
        Collection collection = (Collection)lazyStorage.get(string);
        Collection collection2 = collection;
        if (collection2 == null) {
            collection2 = CollectionsKt.emptyList();
        }
        Iterable $receiver$iv = collection2;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            FqName fqName = new FqName((String)it);
            collection3.add(fqName);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    protected String dumpValue(@NotNull Collection<String> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        return IncrementalJvmCacheKt.dumpCollection(value);
    }

    private final void remove(String path) {
        this.getStorage().remove(path);
    }

    public SourceToClassesMap(@NotNull File storageFile) {
        Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
        super(storageFile, (KeyDescriptor<String>)((KeyDescriptor)PathStringDescriptor.INSTANCE), (DataExternalizer)StringCollectionExternalizer.INSTANCE);
    }
}

