/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.KotlinPaths;

public class KotlinPathsFromHomeDir
implements KotlinPaths {
    private final File homePath;

    public KotlinPathsFromHomeDir(@NotNull File homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "<init>"));
        }
        this.homePath = homePath;
    }

    @Override
    @NotNull
    public File getHomePath() {
        File file = this.homePath;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getHomePath"));
        }
        return file;
    }

    @Override
    @NotNull
    public File getLibPath() {
        File file = new File(this.homePath, "lib");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getLibPath"));
        }
        return file;
    }

    @Override
    @NotNull
    public File getStdlibPath() {
        File file = this.getLibraryFile("kotlin-stdlib.jar");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getStdlibPath"));
        }
        return file;
    }

    @Override
    @NotNull
    public File getReflectPath() {
        File file = this.getLibraryFile("kotlin-reflect.jar");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getReflectPath"));
        }
        return file;
    }

    @Override
    @NotNull
    public File getScriptRuntimePath() {
        File file = this.getLibraryFile("kotlin-script-runtime.jar");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getScriptRuntimePath"));
        }
        return file;
    }

    @Override
    @NotNull
    public File getKotlinTestPath() {
        File file = this.getLibraryFile("kotlin-test.jar");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getKotlinTestPath"));
        }
        return file;
    }

    @Override
    @NotNull
    public File getStdlibSourcesPath() {
        File file = this.getLibraryFile("kotlin-stdlib-sources.jar");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getStdlibSourcesPath"));
        }
        return file;
    }

    @Override
    @NotNull
    public File getJsStdLibJarPath() {
        File file = this.getLibraryFile("kotlin-stdlib-js.jar");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getJsStdLibJarPath"));
        }
        return file;
    }

    @Override
    @NotNull
    public File getJsStdLibSrcJarPath() {
        File file = this.getLibraryFile("kotlin-stdlib-js-sources.jar");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getJsStdLibSrcJarPath"));
        }
        return file;
    }

    @Override
    @NotNull
    public File getJsKotlinTestJarPath() {
        File file = this.getLibraryFile("kotlin-test-js.jar");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getJsKotlinTestJarPath"));
        }
        return file;
    }

    @Override
    @NotNull
    public File getAllOpenPluginJarPath() {
        File file = this.getLibraryFile("allopen-compiler-plugin.jar");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getAllOpenPluginJarPath"));
        }
        return file;
    }

    @Override
    @NotNull
    public File getNoArgPluginJarPath() {
        File file = this.getLibraryFile("noarg-compiler-plugin.jar");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getNoArgPluginJarPath"));
        }
        return file;
    }

    @Override
    @NotNull
    public File getSamWithReceiverJarPath() {
        File file = this.getLibraryFile("sam-with-receiver-compiler-plugin.jar");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getSamWithReceiverJarPath"));
        }
        return file;
    }

    @Override
    @NotNull
    public File getCompilerPath() {
        File file = this.getLibraryFile("kotlin-compiler.jar");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getCompilerPath"));
        }
        return file;
    }

    @Override
    @NotNull
    public File getBuildNumberFile() {
        File file = new File(this.homePath, "build.txt");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getBuildNumberFile"));
        }
        return file;
    }

    @NotNull
    private File getLibraryFile(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getLibraryFile"));
        }
        File file = new File(this.getLibPath(), fileName);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getLibraryFile"));
        }
        return file;
    }
}

