/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModifier;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenDependencyCompletionUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomConfiguration;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugins;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenProjectModelModifier
extends JavaProjectModelModifier {
    private final Project myProject;
    private final MavenProjectsManager myProjectsManager;
    private MavenProjectIndicesManager myIndicesManager;

    public MavenProjectModelModifier(Project project, MavenProjectsManager projectsManager, MavenProjectIndicesManager manager) {
        this.myProject = project;
        this.myProjectsManager = projectsManager;
        this.myIndicesManager = manager;
    }

    @Nullable
    public Promise<Void> addModuleDependency(@NotNull Module from, @NotNull Module to, @NotNull DependencyScope scope, boolean exported) {
        MavenProject toProject;
        if (from == null) {
            MavenProjectModelModifier.$$$reportNull$$$0(0);
        }
        if (to == null) {
            MavenProjectModelModifier.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            MavenProjectModelModifier.$$$reportNull$$$0(2);
        }
        if ((toProject = this.myProjectsManager.findProject(to)) == null) {
            return null;
        }
        MavenId mavenId = toProject.getMavenId();
        return this.addDependency(Collections.singletonList(from), mavenId, scope);
    }

    private Promise<Void> addDependency(@NotNull Collection<Module> fromModules, @NotNull MavenId mavenId, @NotNull DependencyScope scope) {
        if (fromModules == null) {
            MavenProjectModelModifier.$$$reportNull$$$0(3);
        }
        if (mavenId == null) {
            MavenProjectModelModifier.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            MavenProjectModelModifier.$$$reportNull$$$0(5);
        }
        return this.addDependency(fromModules, mavenId, null, null, scope);
    }

    private Promise<Void> addDependency(@NotNull Collection<Module> fromModules, @NotNull MavenId mavenId, @Nullable String minVersion, @Nullable String maxVersion, @NotNull DependencyScope scope) {
        if (fromModules == null) {
            MavenProjectModelModifier.$$$reportNull$$$0(6);
        }
        if (mavenId == null) {
            MavenProjectModelModifier.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            MavenProjectModelModifier.$$$reportNull$$$0(8);
        }
        final ArrayList<Trinity> models = new ArrayList<Trinity>(fromModules.size());
        ArrayList<XmlFile> files = new ArrayList<XmlFile>(fromModules.size());
        ArrayList<MavenProject> projectToUpdate = new ArrayList<MavenProject>(fromModules.size());
        String mavenScope = MavenProjectModelModifier.getMavenScope(scope);
        for (Module from : fromModules) {
            if (!this.myProjectsManager.isMavenizedModule(from)) {
                return null;
            }
            MavenProject fromProject = this.myProjectsManager.findProject(from);
            if (fromProject == null) {
                return null;
            }
            MavenDomProjectModel model = MavenDomUtil.getMavenDomProjectModel(this.myProject, fromProject.getFile());
            if (model == null) {
                return null;
            }
            String scopeToSet = null;
            String version = null;
            if (mavenId.getGroupId() != null && mavenId.getArtifactId() != null) {
                MavenDomDependency managedDependency = MavenDependencyCompletionUtil.findManagedDependency(model, this.myProject, mavenId.getGroupId(), mavenId.getArtifactId());
                if (managedDependency != null) {
                    String managedScope = StringUtil.nullize((String)managedDependency.getScope().getStringValue(), (boolean)true);
                    String string = scopeToSet = managedScope == null && "compile".equals(mavenScope) || StringUtil.equals((CharSequence)managedScope, (CharSequence)mavenScope) ? null : mavenScope;
                }
                if (managedDependency == null || StringUtil.isEmpty((String)managedDependency.getVersion().getStringValue())) {
                    version = this.selectVersion(mavenId, minVersion, maxVersion);
                }
            }
            models.add(Trinity.create((Object)model, (Object)new MavenId(mavenId.getGroupId(), mavenId.getArtifactId(), version), scopeToSet));
            files.add(DomUtil.getFile((DomElement)model));
            projectToUpdate.add(fromProject);
        }
        new WriteCommandAction(this.myProject, "Add Maven Dependency", PsiUtilCore.toPsiFileArray(files)){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (Trinity trinity : models) {
                    Document document;
                    MavenDomProjectModel model = (MavenDomProjectModel)trinity.first;
                    MavenDomDependency dependency = MavenDomUtil.createDomDependency(model, null, (MavenId)trinity.second);
                    String mavenScope = (String)trinity.third;
                    if (mavenScope != null) {
                        dependency.getScope().setStringValue(mavenScope);
                    }
                    if ((document = PsiDocumentManager.getInstance((Project)MavenProjectModelModifier.this.myProject).getDocument((PsiFile)DomUtil.getFile((DomElement)model))) == null) continue;
                    FileDocumentManager.getInstance().saveDocument(document);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier$1", "run"));
            }
        }.execute();
        return this.myProjectsManager.forceUpdateProjects(projectToUpdate);
    }

    @Nullable
    public Promise<Void> addExternalLibraryDependency(@NotNull Collection<Module> modules, @NotNull ExternalLibraryDescriptor descriptor, @NotNull DependencyScope scope) {
        if (modules == null) {
            MavenProjectModelModifier.$$$reportNull$$$0(9);
        }
        if (descriptor == null) {
            MavenProjectModelModifier.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            MavenProjectModelModifier.$$$reportNull$$$0(11);
        }
        for (Module module : modules) {
            if (this.myProjectsManager.isMavenizedModule(module)) continue;
            return null;
        }
        MavenId mavenId = new MavenId(descriptor.getLibraryGroupId(), descriptor.getLibraryArtifactId(), null);
        return this.addDependency(modules, mavenId, descriptor.getMinVersion(), descriptor.getMaxVersion(), scope);
    }

    @NotNull
    private String selectVersion(@NotNull MavenId mavenId, @Nullable String minVersion, @Nullable String maxVersion) {
        if (mavenId == null) {
            MavenProjectModelModifier.$$$reportNull$$$0(12);
        }
        Set<String> versions = this.myIndicesManager.getVersions(mavenId.getGroupId(), mavenId.getArtifactId());
        ArrayList<String> suitableVersions = new ArrayList<String>();
        for (String version : versions) {
            if (minVersion != null && VersionComparatorUtil.compare((String)minVersion, (String)version) > 0 || maxVersion != null && VersionComparatorUtil.compare((String)version, (String)maxVersion) > 0) continue;
            suitableVersions.add(version);
        }
        String string = suitableVersions.isEmpty() ? "RELEASE" : (String)Collections.max(suitableVersions, VersionComparatorUtil.COMPARATOR);
        if (string == null) {
            MavenProjectModelModifier.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    public Promise<Void> addLibraryDependency(@NotNull Module from, @NotNull Library library, @NotNull DependencyScope scope, boolean exported) {
        String name;
        if (from == null) {
            MavenProjectModelModifier.$$$reportNull$$$0(14);
        }
        if (library == null) {
            MavenProjectModelModifier.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            MavenProjectModelModifier.$$$reportNull$$$0(16);
        }
        if ((name = library.getName()) != null && name.startsWith("Maven: ")) {
            String mavenCoordinates = StringUtil.trimStart((String)name, (String)"Maven: ");
            return this.addDependency(Collections.singletonList(from), new MavenId(mavenCoordinates), scope);
        }
        return null;
    }

    public Promise<Void> changeLanguageLevel(@NotNull Module module, final @NotNull LanguageLevel level) {
        if (module == null) {
            MavenProjectModelModifier.$$$reportNull$$$0(17);
        }
        if (level == null) {
            MavenProjectModelModifier.$$$reportNull$$$0(18);
        }
        if (!this.myProjectsManager.isMavenizedModule(module)) {
            return null;
        }
        MavenProject mavenProject = this.myProjectsManager.findProject(module);
        if (mavenProject == null) {
            return null;
        }
        final MavenDomProjectModel model = MavenDomUtil.getMavenDomProjectModel(this.myProject, mavenProject.getFile());
        if (model == null) {
            return null;
        }
        new WriteCommandAction(this.myProject, "Add Maven Dependency", new PsiFile[]{DomUtil.getFile((DomElement)model)}){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    2.$$$reportNull$$$0(0);
                }
                MavenDomConfiguration configuration = MavenProjectModelModifier.getCompilerPlugin(model).getConfiguration();
                XmlTag tag = configuration.ensureTagExists();
                MavenProjectModelModifier.setChildTagValue(tag, "source", level.getCompilerComplianceDefaultOption());
                MavenProjectModelModifier.setChildTagValue(tag, "target", level.getCompilerComplianceDefaultOption());
                Document document = PsiDocumentManager.getInstance((Project)MavenProjectModelModifier.this.myProject).getDocument((PsiFile)DomUtil.getFile((DomElement)model));
                if (document != null) {
                    FileDocumentManager.getInstance().saveDocument(document);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier$2", "run"));
            }
        }.execute();
        return this.myProjectsManager.forceUpdateProjects(Collections.singleton(mavenProject));
    }

    private static void setChildTagValue(@NotNull XmlTag tag, @NotNull String subTagName, @NotNull String value) {
        XmlTag subTag;
        if (tag == null) {
            MavenProjectModelModifier.$$$reportNull$$$0(19);
        }
        if (subTagName == null) {
            MavenProjectModelModifier.$$$reportNull$$$0(20);
        }
        if (value == null) {
            MavenProjectModelModifier.$$$reportNull$$$0(21);
        }
        if ((subTag = tag.findFirstSubTag(subTagName)) != null) {
            subTag.getValue().setText(value);
        } else {
            tag.addSubTag(tag.createChildTag(subTagName, tag.getNamespace(), value, false), false);
        }
    }

    @NotNull
    private static MavenDomPlugin getCompilerPlugin(MavenDomProjectModel model) {
        MavenDomPlugins plugins = model.getBuild().getPlugins();
        for (MavenDomPlugin plugin : plugins.getPlugins()) {
            if (!"org.apache.maven.plugins".equals(plugin.getGroupId().getValue()) || !"maven-compiler-plugin".equals(plugin.getArtifactId().getValue())) continue;
            MavenDomPlugin mavenDomPlugin = plugin;
            if (mavenDomPlugin == null) {
                MavenProjectModelModifier.$$$reportNull$$$0(22);
            }
            return mavenDomPlugin;
        }
        MavenDomPlugin plugin = plugins.addPlugin();
        plugin.getGroupId().setValue((Object)"org.apache.maven.plugins");
        plugin.getArtifactId().setValue((Object)"maven-compiler-plugin");
        MavenDomPlugin mavenDomPlugin = plugin;
        if (mavenDomPlugin == null) {
            MavenProjectModelModifier.$$$reportNull$$$0(23);
        }
        return mavenDomPlugin;
    }

    @Nullable
    private static String getMavenScope(@NotNull DependencyScope scope) {
        if (scope == null) {
            MavenProjectModelModifier.$$$reportNull$$$0(24);
        }
        switch (scope) {
            case RUNTIME: {
                return "runtime";
            }
            case COMPILE: {
                return "compile";
            }
            case TEST: {
                return "test";
            }
            case PROVIDED: {
                return "provided";
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromModules";
                break;
            }
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 13: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/importing/MavenProjectModelModifier";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subTagName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/importing/MavenProjectModelModifier";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "selectVersion";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerPlugin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addModuleDependency";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addDependency";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addExternalLibraryDependency";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "selectVersion";
                break;
            }
            case 13: 
            case 22: 
            case 23: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addLibraryDependency";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "changeLanguageLevel";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setChildTagValue";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getMavenScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

