/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.MavenSimpleProjectComponent;

public class MavenImportNotifier
extends MavenSimpleProjectComponent
implements Disposable {
    private static final String MAVEN_IMPORT_NOTIFICATION_GROUP = "Maven Import";
    private MavenProjectsManager myMavenProjectsManager;
    private MergingUpdateQueue myUpdatesQueue;
    private Notification myNotification;

    public MavenImportNotifier(Project p, MavenProjectsManager mavenProjectsManager) {
        super(p);
        if (!this.isNormalProject()) {
            return;
        }
        NotificationsConfiguration.getNotificationsConfiguration().register(MAVEN_IMPORT_NOTIFICATION_GROUP, NotificationDisplayType.STICKY_BALLOON, true);
        this.myMavenProjectsManager = mavenProjectsManager;
        this.myUpdatesQueue = new MergingUpdateQueue("MavenImportNotifier", 500, false, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.myProject);
        this.myMavenProjectsManager.addManagerListener(new MavenProjectsManager.Listener(){

            @Override
            public void activated() {
                MavenImportNotifier.this.init();
            }

            @Override
            public void projectsScheduled() {
                MavenImportNotifier.this.scheduleUpdate(false);
            }

            @Override
            public void importAndResolveScheduled() {
                MavenImportNotifier.this.scheduleUpdate(true);
            }
        });
    }

    private void init() {
        this.myUpdatesQueue.activate();
    }

    public void dispose() {
        if (this.myNotification != null) {
            this.myNotification.expire();
        }
    }

    private void scheduleUpdate(final boolean close) {
        this.myUpdatesQueue.queue(new Update(this.myUpdatesQueue){

            public void run() {
                MavenImportNotifier.this.doUpdateNotifications(close);
            }
        });
    }

    private void doUpdateNotifications(boolean close) {
        if (close) {
            if (this.myNotification == null) {
                return;
            }
            this.myNotification.expire();
            this.myNotification = null;
        } else {
            if (this.myNotification != null && !this.myNotification.isExpired()) {
                return;
            }
            this.myNotification = new Notification(MAVEN_IMPORT_NOTIFICATION_GROUP, ProjectBundle.message("maven.project.changed", new Object[0]), "<a href='reimport'>" + ProjectBundle.message("maven.project.importChanged", new Object[0]) + "</a> &nbsp;&nbsp;<a href='autoImport'>" + ProjectBundle.message("maven.project.enableAutoImport", new Object[0]) + "</a>", NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    if (event.getDescription().equals("reimport")) {
                        MavenImportNotifier.this.myMavenProjectsManager.scheduleImportAndResolve();
                    }
                    if (event.getDescription().equals("autoImport")) {
                        MavenImportNotifier.this.myMavenProjectsManager.getImportingSettings().setImportAutomatically(true);
                    }
                    notification.expire();
                    MavenImportNotifier.this.myNotification = null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/idea/maven/utils/MavenImportNotifier$3";
                    objectArray[2] = "hyperlinkActivated";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            Notifications.Bus.notify((Notification)this.myNotification, (Project)this.myProject);
        }
    }
}

