/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.elements;

import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.builder.LightMemberOriginForDeclaration;
import org.jetbrains.kotlin.asJava.elements.KtLightDeclaration;
import org.jetbrains.kotlin.asJava.elements.KtLightIdentifier;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.asJava.elements.KtLightSimpleModifierList;
import org.jetbrains.kotlin.asJava.elements.LightParameter;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

public class KtLightParameter
extends LightParameter
implements KtLightDeclaration<KtParameter, PsiParameter> {
    private final PsiModifierList modifierList;
    private final PsiParameter delegate;
    private final int index;
    private final KtLightMethod method;
    private KtLightIdentifier lightIdentifier = null;

    private static String getName(PsiParameter delegate2, int index2) {
        String name2 = delegate2.getName();
        return name2 != null ? name2 : "p" + index2;
    }

    public KtLightParameter(PsiParameter delegate2, int index2, KtLightMethod method) {
        super(KtLightParameter.getName(delegate2, index2), delegate2.getType(), method, (Language)KotlinLanguage.INSTANCE);
        this.delegate = delegate2;
        this.index = index2;
        this.method = method;
        this.modifierList = method.getLightMemberOrigin() instanceof LightMemberOriginForDeclaration ? new KtLightSimpleModifierList(this, Collections.emptySet()) : super.getModifierList();
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList = this.modifierList;
        if (psiModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/elements/KtLightParameter", "getModifierList"));
        }
        return psiModifierList;
    }

    @Override
    @NotNull
    public PsiParameter getClsDelegate() {
        PsiParameter psiParameter = this.delegate;
        if (psiParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/elements/KtLightParameter", "getClsDelegate"));
        }
        return psiParameter;
    }

    @Override
    @Nullable
    public KtParameter getKotlinOrigin() {
        int jetIndex;
        KtDeclaration declaration2 = (KtDeclaration)this.method.getKotlinOrigin();
        if (declaration2 == null) {
            return null;
        }
        int n = jetIndex = KtPsiUtilKt.isExtensionDeclaration(declaration2) ? this.index - 1 : this.index;
        if (jetIndex < 0) {
            return null;
        }
        if (declaration2 instanceof KtFunction) {
            List<KtParameter> paramList = ((KtFunction)declaration2).getValueParameters();
            return jetIndex < paramList.size() ? paramList.get(jetIndex) : null;
        }
        if (jetIndex != 0) {
            return null;
        }
        KtPropertyAccessor setter = null;
        if (declaration2 instanceof KtPropertyAccessor) {
            KtPropertyAccessor accessor = (KtPropertyAccessor)declaration2;
            setter = accessor.isSetter() ? accessor : null;
        } else if (declaration2 instanceof KtProperty) {
            setter = ((KtProperty)declaration2).getSetter();
        } else if (declaration2 instanceof KtParameter) {
            return (KtParameter)declaration2;
        }
        return setter != null ? setter.getParameter() : null;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        KtParameter origin = this.getKotlinOrigin();
        KtParameter ktParameter = origin != null ? origin : super.getNavigationElement();
        if (ktParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/elements/KtLightParameter", "getNavigationElement"));
        }
        return ktParameter;
    }

    public boolean isValid() {
        return this.method.isValid();
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/asJava/elements/KtLightParameter", "setName"));
        }
        KtParameter origin = this.getKotlinOrigin();
        if (origin != null) {
            origin.setName(name2);
        }
        return this;
    }

    public PsiFile getContainingFile() {
        return this.method.getContainingFile();
    }

    @NotNull
    public Language getLanguage() {
        KotlinLanguage kotlinLanguage = KotlinLanguage.INSTANCE;
        if (kotlinLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/elements/KtLightParameter", "getLanguage"));
        }
        return kotlinLanguage;
    }

    @NotNull
    public SearchScope getUseScope() {
        KtParameter origin = this.getKotlinOrigin();
        Object object = origin != null ? origin.getUseScope() : new LocalSearchScope((PsiElement)this);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/elements/KtLightParameter", "getUseScope"));
        }
        return object;
    }

    public KtLightMethod getMethod() {
        return this.method;
    }

    public String getText() {
        KtParameter origin = this.getKotlinOrigin();
        return origin != null ? origin.getText() : "";
    }

    public TextRange getTextRange() {
        KtParameter origin = this.getKotlinOrigin();
        return origin != null ? origin.getTextRange() : TextRange.EMPTY_RANGE;
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        if (this.lightIdentifier == null) {
            this.lightIdentifier = new KtLightIdentifier((PsiNameIdentifierOwner)this, this.getKotlinOrigin());
        }
        return this.lightIdentifier;
    }

    public PsiElement getParent() {
        return this.getMethod().getParameterList();
    }

    public boolean isEquivalentTo(PsiElement another) {
        KtParameter kotlinOrigin2 = this.getKotlinOrigin();
        if (another instanceof KtLightParameter && kotlinOrigin2 != null) {
            KtLightParameter anotherParam = (KtLightParameter)another;
            return kotlinOrigin2.equals(anotherParam.getKotlinOrigin()) && this.getClsDelegate().equals(anotherParam.getClsDelegate());
        }
        return super.isEquivalentTo(another);
    }

    public boolean equals(Object obj) {
        return obj instanceof PsiElement && this.isEquivalentTo((PsiElement)obj);
    }

    public int hashCode() {
        KtParameter kotlinOrigin2 = this.getKotlinOrigin();
        if (kotlinOrigin2 != null) {
            return kotlinOrigin2.hashCode();
        }
        return 0;
    }
}

