/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.repl;

import com.google.common.base.Throwables;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplUtilKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001\u001a*\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\b\b\u0000\u0010\n*\u00020\u000b*\b\u0012\u0004\u0012\u0002H\n0\t2\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a\u0012\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t*\u00020\u000fH\u0000\u001a\u0012\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\t*\u00020\u0011H\u0000\u00a8\u0006\u0012"}, d2={"makeScriptBaseName", "", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "renderReplStackTrace", "cause", "", "startFromMethodName", "ensureNotEmpty", "", "T", "", "error", "listAllUrlsAsFiles", "Ljava/io/File;", "Ljava/lang/ClassLoader;", "listLocalUrlsAsFiles", "Ljava/net/URLClassLoader;", "cli-common"})
public final class ReplUtilKt {
    @NotNull
    public static final String makeScriptBaseName(@NotNull ReplCodeLine codeLine) {
        Intrinsics.checkParameterIsNotNull((Object)codeLine, (String)"codeLine");
        return "Line_" + codeLine.getNo() + "" + (codeLine.getGeneration() > 1 ? "_gen_" + codeLine.getGeneration() : "");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String renderReplStackTrace(@NotNull Throwable cause, @NotNull String startFromMethodName) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
        Intrinsics.checkParameterIsNotNull((Object)startFromMethodName, (String)"startFromMethodName");
        ArrayList<StackTraceElement> newTrace = new ArrayList<StackTraceElement>();
        boolean skip2 = true;
        for (StackTraceElement element3 : ArraysKt.reversed((Object[])cause.getStackTrace())) {
            if (Intrinsics.areEqual((Object)("" + element3.getClassName() + '.' + element3.getMethodName()), (Object)startFromMethodName)) {
                skip2 = false;
            }
            if (skip2) continue;
            newTrace.add(element3);
        }
        List resultingTrace = CollectionsKt.dropLast((List)CollectionsKt.reversed((Iterable)newTrace), (int)1);
        Object object = resultingTrace;
        Throwable throwable = cause;
        void v0 = $receiver$iv;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv = v0;
        StackTraceElement[] stackTraceElementArray = thisCollection$iv.toArray(new StackTraceElement[thisCollection$iv.size()]);
        if (stackTraceElementArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
        throwable.setStackTrace(stackTraceElementArray2);
        Object object2 = object = Throwables.getStackTraceAsString((Throwable)cause);
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trimEnd((CharSequence)((CharSequence)object2))).toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> listAllUrlsAsFiles(@NotNull ClassLoader $receiver) {
        void $receiver$iv;
        List initial$iv;
        Sequence parents2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Sequence sequence2 = parents2 = SequencesKt.filterIsInstance((Sequence)SequencesKt.generateSequence((Object)$receiver, (Function1)listAllUrlsAsFiles.parents.1.INSTANCE), URLClassLoader.class);
        List accumulator$iv = initial$iv = CollectionsKt.emptyList();
        for (Object element$iv : $receiver$iv) {
            void loader;
            URLClassLoader uRLClassLoader = (URLClassLoader)element$iv;
            List accum = accumulator$iv;
            accumulator$iv = CollectionsKt.plus((Collection)ReplUtilKt.listLocalUrlsAsFiles((URLClassLoader)loader), (Iterable)accum);
        }
        return CollectionsKt.distinct((Iterable)accumulator$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> listLocalUrlsAsFiles(@NotNull URLClassLoader $receiver) {
        void var3_3;
        String element$iv$iv$iv;
        Object $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object $receiver$iv = $receiver.getURLs();
        Object[] objectArray = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (int i = 0; i < ((void)$receiver$iv$iv$iv).length; ++i) {
            String string;
            element$iv$iv$iv = $receiver$iv$iv$iv[i];
            String element$iv$iv = element$iv$iv$iv;
            URL it = (URL)((Object)element$iv$iv);
            if (StringsKt.removePrefix((String)it.toString(), (CharSequence)"file:") == null) continue;
            String it$iv$iv = string;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void p1;
            Object item$iv$iv = iterator2.next();
            element$iv$iv$iv = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            File file2 = new File((String)p1);
            collection.add(file2);
        }
        return (List)var3_3;
    }

    @NotNull
    public static final <T> List<T> ensureNotEmpty(@NotNull List<? extends T> $receiver, @NotNull String error) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        if ($receiver.isEmpty()) {
            throw (Throwable)new IllegalStateException(error);
        }
        return $receiver;
    }
}

