/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinPluginUpdater;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.PluginUpdateStatus;
import org.jetbrains.kotlin.idea.actions.ConfigurePluginUpdatesDialog;
import org.jetbrains.kotlin.idea.actions.ConfigurePluginUpdatesForm;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0014J\b\u0010\u0010\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\bH\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/actions/ConfigurePluginUpdatesDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "form", "Lorg/jetbrains/kotlin/idea/actions/ConfigurePluginUpdatesForm;", "initialSelectedChannel", "", "update", "Lorg/jetbrains/kotlin/idea/PluginUpdateStatus$Update;", "createCenterPanel", "Ljavax/swing/JComponent;", "doCancelAction", "", "doOKAction", "resetUpdateStatus", "saveSelectedChannel", "channel", "saveSettings", "EAPChannels", "idea"})
public final class ConfigurePluginUpdatesDialog
extends DialogWrapper {
    private final ConfigurePluginUpdatesForm form;
    private final int initialSelectedChannel;
    private PluginUpdateStatus.Update update;

    private final void resetUpdateStatus() {
        this.form.updateStatusLabel.setText(" ");
        this.form.installButton.setVisible(false);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel jPanel = this.form.mainPanel;
        Intrinsics.checkExpressionValueIsNotNull((Object)jPanel, (String)"form.mainPanel");
        return jPanel;
    }

    private final void saveSettings() {
        this.saveSelectedChannel(this.form.channelCombo.getSelectedIndex());
    }

    private final void saveSelectedChannel(int channel) {
        List hosts = UpdateSettings.getInstance().getStoredPluginHosts();
        hosts.removeIf(saveSelectedChannel.1.INSTANCE);
        int n = channel;
        if (n == EAPChannels.EAP_1_1.getUiIndex()) {
            hosts.add(EAPChannels.EAP_1_1.getUrl());
        } else if (n == EAPChannels.EAP_1_2.getUiIndex()) {
            hosts.add(EAPChannels.EAP_1_2.getUrl());
        }
    }

    protected void doOKAction() {
        this.saveSettings();
        super.doOKAction();
    }

    public void doCancelAction() {
        this.saveSelectedChannel(this.initialSelectedChannel);
        super.doCancelAction();
    }

    public ConfigurePluginUpdatesDialog(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(project, false);
        this.form = new ConfigurePluginUpdatesForm();
        this.setTitle("Configure Kotlin Plugin Updates");
        this.form.updateCheckProgressIcon.suspend();
        this.form.updateCheckProgressIcon.setPaintPassiveIcon(false);
        this.form.checkForUpdatesNowButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                this.saveSettings();
                ((ConfigurePluginUpdatesDialog)this).form.updateCheckProgressIcon.resume();
                this.resetUpdateStatus();
                KotlinPluginUpdater.Companion.getInstance().runUpdateCheck((Function1<? super PluginUpdateStatus, Boolean>)((Function1)new Function1<PluginUpdateStatus, Boolean>(){

                    public final boolean invoke(@NotNull PluginUpdateStatus pluginUpdateStatus) {
                        Intrinsics.checkParameterIsNotNull((Object)pluginUpdateStatus, (String)"pluginUpdateStatus");
                        ((ConfigurePluginUpdatesDialog)this).form.updateCheckProgressIcon.suspend();
                        PluginUpdateStatus pluginUpdateStatus2 = pluginUpdateStatus;
                        if (Intrinsics.areEqual((Object)pluginUpdateStatus2, (Object)PluginUpdateStatus.LatestVersionInstalled.INSTANCE)) {
                            ((ConfigurePluginUpdatesDialog)this).form.updateStatusLabel.setText("You have the latest version of the plugin (" + KotlinPluginUtil.getPluginVersion() + ") installed.");
                        } else if (pluginUpdateStatus2 instanceof PluginUpdateStatus.Update) {
                            update = (PluginUpdateStatus.Update)pluginUpdateStatus;
                            ((ConfigurePluginUpdatesDialog)this).form.installButton.setVisible(true);
                            ((ConfigurePluginUpdatesDialog)this).form.updateStatusLabel.setText("A new version " + ((PluginUpdateStatus.Update)pluginUpdateStatus).getPluginDescriptor().getVersion() + " is available");
                        } else if (pluginUpdateStatus2 instanceof PluginUpdateStatus.CheckFailed) {
                            ((ConfigurePluginUpdatesDialog)this).form.updateStatusLabel.setText("Update check failed: " + ((PluginUpdateStatus.CheckFailed)pluginUpdateStatus).getMessage());
                        }
                        return false;
                    }
                }));
            }
        });
        this.form.installButton.setVisible(false);
        this.form.installButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                block0: {
                    PluginUpdateStatus.Update update;
                    PluginUpdateStatus.Update update2 = update;
                    if (update2 == null) break block0;
                    PluginUpdateStatus.Update it2 = update = update2;
                    this.close(0);
                    KotlinPluginUpdater.installPluginUpdate$default(KotlinPluginUpdater.Companion.getInstance(), it2, null, 2, null);
                }
            }
        });
        this.form.channelCombo.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                this.resetUpdateStatus();
            }
        });
        4 indexIfAvailable$ = 4.INSTANCE;
        Integer n = indexIfAvailable$.invoke(EAPChannels.EAP_1_2);
        if (n == null) {
            n = indexIfAvailable$.invoke(EAPChannels.EAP_1_1);
        }
        this.initialSelectedChannel = n != null ? n : 0;
        this.form.channelCombo.setSelectedIndex(this.initialSelectedChannel);
        this.init();
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/actions/ConfigurePluginUpdatesDialog$EAPChannels;", "", "url", "", "uiIndex", "", "(Ljava/lang/String;ILjava/lang/String;I)V", "hasChannel", "", "getHasChannel", "()Z", "getUiIndex", "()I", "getUrl", "()Ljava/lang/String;", "EAP_1_1", "EAP_1_2", "idea"})
    public static final class EAPChannels
    extends Enum<EAPChannels> {
        public static final /* enum */ EAPChannels EAP_1_1;
        public static final /* enum */ EAPChannels EAP_1_2;
        private static final /* synthetic */ EAPChannels[] $VALUES;
        @NotNull
        private final String url;
        private final int uiIndex;

        static {
            EAPChannels[] eAPChannelsArray = new EAPChannels[2];
            EAPChannels[] eAPChannelsArray2 = eAPChannelsArray;
            eAPChannelsArray[0] = EAP_1_1 = new EAPChannels("https://plugins.jetbrains.com/plugins/eap-1.1/6954", 1);
            eAPChannelsArray[1] = EAP_1_2 = new EAPChannels("https://plugins.jetbrains.com/plugins/eap-1.2/6954", 2);
            $VALUES = eAPChannelsArray;
        }

        public final boolean getHasChannel() {
            return UpdateSettings.getInstance().getPluginHosts().contains(this.url);
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        public final int getUiIndex() {
            return this.uiIndex;
        }

        protected EAPChannels(String url, int uiIndex) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            this.url = url;
            this.uiIndex = uiIndex;
        }

        public static EAPChannels[] values() {
            return (EAPChannels[])$VALUES.clone();
        }

        public static EAPChannels valueOf(String string) {
            return Enum.valueOf(EAPChannels.class, string);
        }
    }
}

