/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.KotlinPackageContentModificationListener;
import org.jetbrains.kotlin.idea.caches.PerModulePackageCacheService;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/caches/KotlinPackageContentModificationListener;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "idea-analysis"})
public final class KotlinPackageContentModificationListener {
    private final Project project;

    public KotlinPackageContentModificationListener(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        MessageBusConnection connection = this.project.getMessageBus().connect();
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void before(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkParameterIsNotNull(events, (String)"events");
                this.onEvents(events, (Function1<? super VFileEvent, Boolean>)((Function1)before.1.INSTANCE));
            }

            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkParameterIsNotNull(events, (String)"events");
                this.onEvents(events, (Function1<? super VFileEvent, Boolean>)((Function1)after.1.INSTANCE));
            }

            public final void onEvents(@NotNull List<? extends VFileEvent> events, @NotNull Function1<? super VFileEvent, Boolean> eventPredicate) {
                Intrinsics.checkParameterIsNotNull(events, (String)"events");
                Intrinsics.checkParameterIsNotNull(eventPredicate, (String)"eventPredicate");
                Project $receiver$iv = project;
                Object object = ServiceManager.getService((Project)$receiver$iv, PerModulePackageCacheService.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(this, T::class.java)");
                PerModulePackageCacheService service = (PerModulePackageCacheService)object;
                if (events.size() >= PerModulePackageCacheService.Companion.getFULL_DROP_THRESHOLD()) {
                    service.onTooComplexChange$idea_analysis();
                } else {
                    $receiver$iv = SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)events), eventPredicate), (Function1)onEvents.1.INSTANCE), (Function1)onEvents.2.INSTANCE);
                    for (Object element$iv : $receiver$iv) {
                        VirtualFile file2;
                        VirtualFile virtualFile2 = file2 = (VirtualFile)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
                        service.notifyPackageChange$idea_analysis(virtualFile2);
                    }
                }
            }
        });
    }
}

