/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.types.KotlinType;

public class CodeInsightUtils {
    @Nullable
    public static PsiElement findElement(@NotNull PsiFile file2, int startOffset, int endOffset, @NotNull ElementKind elementKind) {
        KtExpression statement2;
        List<KtExpression> statements;
        Class elementClass;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElement"));
        }
        if (elementKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementKind", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElement"));
        }
        switch (elementKind) {
            case EXPRESSION: {
                elementClass = KtExpression.class;
                break;
            }
            case TYPE_ELEMENT: {
                elementClass = KtTypeElement.class;
                break;
            }
            case TYPE_CONSTRUCTOR: {
                elementClass = KtSimpleNameExpression.class;
                break;
            }
            default: {
                throw new IllegalArgumentException(elementKind.name());
            }
        }
        KtExpression element3 = CodeInsightUtils.findElementOfClassAtRange(file2, startOffset, endOffset, elementClass);
        if (elementKind == ElementKind.TYPE_ELEMENT) {
            return element3;
        }
        if (elementKind == ElementKind.TYPE_CONSTRUCTOR) {
            return element3 != null && KtPsiUtilKt.isTypeConstructorReference((PsiElement)element3) ? element3 : null;
        }
        if (element3 instanceof KtScriptInitializer) {
            element3 = ((KtScriptInitializer)element3).getBody();
        }
        if (element3 == null) {
            return null;
        }
        if (element3 instanceof KtOperationReferenceExpression && ((KtOperationReferenceExpression)element3).getReferencedNameElementType() != KtTokens.IDENTIFIER && element3.getParent() instanceof KtBinaryExpression) {
            return null;
        }
        if (KtPsiUtil.isLabelIdentifierExpression((PsiElement)element3)) {
            element3 = PsiTreeUtil.getParentOfType((PsiElement)element3, KtExpression.class);
        }
        if (element3 instanceof KtBlockExpression && (statements = ((KtBlockExpression)element3).getStatements()).size() == 1 && (statement2 = statements.get(0)).getText().equals(element3.getText())) {
            return statement2;
        }
        KtExpression expression2 = element3;
        BindingContext context = ResolutionUtils.analyze(expression2);
        Qualifier qualifier = context.get(BindingContext.QUALIFIER, expression2);
        if (qualifier != null) {
            if (!(qualifier instanceof ClassQualifier)) {
                return null;
            }
            if (((ClassQualifier)qualifier).getDescriptor().getKind() != ClassKind.OBJECT) {
                return null;
            }
        }
        return expression2;
    }

    @NotNull
    public static PsiElement[] findElements(@NotNull PsiFile file2, int startOffset, int endOffset, @NotNull ElementKind kind2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElements"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElements"));
        }
        PsiElement element12 = CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceBefore(file2, startOffset);
        PsiElement element22 = CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceAfter(file2, endOffset);
        if (element12 == null || element22 == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        startOffset = element12.getTextRange().getStartOffset();
        if (startOffset >= (endOffset = element22.getTextRange().getEndOffset())) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement parent2 = PsiTreeUtil.findCommonParent((PsiElement)element12, (PsiElement)element22);
        if (parent2 == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        while (!(parent2 instanceof KtBlockExpression)) {
            if (parent2 == null || parent2 instanceof KtFile) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElements"));
                }
                return PsiElement.EMPTY_ARRAY;
            }
            parent2 = parent2.getParent();
        }
        if (startOffset != (element12 = CodeInsightUtils.getTopmostParentInside(element12, parent2)).getTextRange().getStartOffset()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (endOffset != (element22 = CodeInsightUtils.getTopmostParentInside(element22, parent2)).getTextRange().getEndOffset()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        PsiElement stopElement = element22.getNextSibling();
        for (PsiElement currentElement = element12; currentElement != stopElement; currentElement = currentElement.getNextSibling()) {
            if (currentElement instanceof PsiWhiteSpace) continue;
            array.add(currentElement);
        }
        for (PsiElement element3 : array) {
            boolean correctType = kind2 == ElementKind.EXPRESSION && element3 instanceof KtExpression || kind2 == ElementKind.TYPE_ELEMENT && element3 instanceof KtTypeElement || kind2 == ElementKind.TYPE_CONSTRUCTOR && KtPsiUtilKt.isTypeConstructorReference(element3);
            if (correctType || element3.getNode().getElementType() == KtTokens.SEMICOLON || element3 instanceof PsiWhiteSpace || element3 instanceof PsiComment) continue;
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElements"));
        }
        return psiElementArray;
    }

    @Nullable
    public static <T extends PsiElement> T findElementOfClassAtRange(@NotNull PsiFile file2, int startOffset, int endOffset, Class<T> aClass2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElementOfClassAtRange"));
        }
        PsiElement element12 = CodeInsightUtils.getParentLabelOrElement(CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceBefore(file2, startOffset));
        PsiElement element22 = CodeInsightUtils.getParentLabelOrElement(CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceAfter(file2, endOffset));
        if (element12 == null || element22 == null) {
            return null;
        }
        startOffset = element12.getTextRange().getStartOffset();
        PsiElement newElement = PsiTreeUtil.findElementOfClassAtRange((PsiFile)file2, (int)startOffset, (int)(endOffset = element22.getTextRange().getEndOffset()), aClass2);
        if (newElement == null || newElement.getTextRange().getStartOffset() != startOffset || newElement.getTextRange().getEndOffset() != endOffset) {
            return null;
        }
        return (T)newElement;
    }

    private static PsiElement getParentLabelOrElement(@Nullable PsiElement element3) {
        if (element3 != null && element3.getParent() instanceof KtLabelReferenceExpression) {
            return element3.getParent();
        }
        return element3;
    }

    @NotNull
    public static List<PsiElement> findElementsOfClassInRange(@NotNull PsiFile file2, int startOffset, int endOffset, Class<? extends PsiElement> ... classes2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElementsOfClassInRange"));
        }
        PsiElement element12 = CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceBefore(file2, startOffset);
        PsiElement element22 = CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceAfter(file2, endOffset);
        if (element12 == null || element22 == null) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElementsOfClassInRange"));
            }
            return list2;
        }
        startOffset = element12.getTextRange().getStartOffset();
        endOffset = element22.getTextRange().getEndOffset();
        PsiElement parent2 = PsiTreeUtil.findCommonParent((PsiElement)element12, (PsiElement)element22);
        if (parent2 == null) {
            List<PsiElement> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElementsOfClassInRange"));
            }
            return list3;
        }
        if (startOffset != (element12 = CodeInsightUtils.getTopmostParentInside(element12, parent2)).getTextRange().getStartOffset()) {
            List<PsiElement> list4 = Collections.emptyList();
            if (list4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElementsOfClassInRange"));
            }
            return list4;
        }
        if (endOffset != (element22 = CodeInsightUtils.getTopmostParentInside(element22, parent2)).getTextRange().getEndOffset()) {
            List<PsiElement> list5 = Collections.emptyList();
            if (list5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElementsOfClassInRange"));
            }
            return list5;
        }
        PsiElement stopElement = element22.getNextSibling();
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (PsiElement currentElement = element12; currentElement != stopElement && currentElement != null; currentElement = currentElement.getNextSibling()) {
            for (Class<? extends PsiElement> aClass2 : classes2) {
                if (aClass2.isInstance(currentElement)) {
                    result2.add(currentElement);
                }
                result2.addAll(PsiTreeUtil.findChildrenOfType((PsiElement)currentElement, aClass2));
            }
        }
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElementsOfClassInRange"));
        }
        return arrayList;
    }

    @NotNull
    private static PsiElement getTopmostParentInside(@NotNull PsiElement element3, @NotNull PsiElement parent2) {
        if (element3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getTopmostParentInside"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getTopmostParentInside"));
        }
        if (!parent2.equals(element3)) {
            while (!parent2.equals(element3.getParent())) {
                element3 = element3.getParent();
            }
        }
        PsiElement psiElement2 = element3;
        if (psiElement2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getTopmostParentInside"));
        }
        return psiElement2;
    }

    @Nullable
    public static PsiElement getElementAtOffsetIgnoreWhitespaceBefore(@NotNull PsiFile file2, int offset2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getElementAtOffsetIgnoreWhitespaceBefore"));
        }
        PsiElement element3 = file2.findElementAt(offset2);
        if (element3 instanceof PsiWhiteSpace) {
            return file2.findElementAt(element3.getTextRange().getEndOffset());
        }
        return element3;
    }

    @Nullable
    public static PsiElement getElementAtOffsetIgnoreWhitespaceAfter(@NotNull PsiFile file2, int offset2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getElementAtOffsetIgnoreWhitespaceAfter"));
        }
        PsiElement element3 = file2.findElementAt(offset2 - 1);
        if (element3 instanceof PsiWhiteSpace) {
            return file2.findElementAt(element3.getTextRange().getStartOffset() - 1);
        }
        return element3;
    }

    @Nullable
    public static String defaultInitializer(KotlinType type2) {
        if (type2.isMarkedNullable()) {
            return "null";
        }
        if (KotlinBuiltIns.isInt(type2) || KotlinBuiltIns.isLong(type2) || KotlinBuiltIns.isShort(type2) || KotlinBuiltIns.isByte(type2)) {
            return "0";
        }
        if (KotlinBuiltIns.isFloat(type2)) {
            return "0.0f";
        }
        if (KotlinBuiltIns.isDouble(type2)) {
            return "0.0";
        }
        if (KotlinBuiltIns.isChar(type2)) {
            return "'\\u0000'";
        }
        if (KotlinBuiltIns.isBoolean(type2)) {
            return "false";
        }
        if (KotlinBuiltIns.isUnit(type2)) {
            return "Unit";
        }
        if (KotlinBuiltIns.isString(type2)) {
            return "\"\"";
        }
        return null;
    }

    public static void showErrorHint(@NotNull Project project, @NotNull Editor editor, @NotNull String message2, @NotNull String title, @Nullable String helpId) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "showErrorHint"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "showErrorHint"));
        }
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "showErrorHint"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "showErrorHint"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(message2);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)title, (String)helpId);
    }

    private CodeInsightUtils() {
    }

    @Nullable
    public static Integer getStartLineOffset(@NotNull PsiFile file2, int line) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getStartLineOffset"));
        }
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document == null) {
            return null;
        }
        if (line >= document.getLineCount()) {
            return null;
        }
        int lineStartOffset = document.getLineStartOffset(line);
        return CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)lineStartOffset, (String)" \t");
    }

    @Nullable
    public static Integer getEndLineOffset(@NotNull PsiFile file2, int line) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getEndLineOffset"));
        }
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document == null) {
            return null;
        }
        if (line >= document.getLineCount()) {
            return null;
        }
        int lineStartOffset = document.getLineEndOffset(line);
        return CharArrayUtil.shiftBackward((CharSequence)document.getCharsSequence(), (int)lineStartOffset, (String)" \t");
    }

    @NotNull
    public static PsiElement getTopmostElementAtOffset(@NotNull PsiElement element3, int offset2) {
        PsiElement parent2;
        if (element3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getTopmostElementAtOffset"));
        }
        while ((parent2 = element3.getParent()) != null && parent2.getTextOffset() >= offset2 && !(parent2 instanceof KtBlockExpression)) {
            element3 = parent2;
        }
        PsiElement psiElement2 = element3;
        if (psiElement2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getTopmostElementAtOffset"));
        }
        return psiElement2;
    }

    @NotNull
    public static PsiElement getTopParentWithEndOffset(@NotNull PsiElement element3, @NotNull Class<?> stopAt) {
        PsiElement parent2;
        if (element3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getTopParentWithEndOffset"));
        }
        if (stopAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stopAt", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getTopParentWithEndOffset"));
        }
        int endOffset = element3.getTextOffset() + element3.getTextLength();
        while ((parent2 = element3.getParent()) != null && parent2.getTextOffset() + parent2.getTextLength() == endOffset && !stopAt.isInstance(element3 = parent2)) {
        }
        PsiElement psiElement2 = element3;
        if (psiElement2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getTopParentWithEndOffset"));
        }
        return psiElement2;
    }

    @Nullable
    public static <T> T getTopmostElementAtOffset(@NotNull PsiElement element3, int offset2, @NotNull Class<T> klass2) {
        PsiElement parent2;
        if (element3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getTopmostElementAtOffset"));
        }
        if (klass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getTopmostElementAtOffset"));
        }
        PsiElement lastElementOfType = null;
        if (klass2.isInstance(element3)) {
            lastElementOfType = element3;
        }
        while ((parent2 = element3.getParent()) != null && parent2.getTextOffset() >= offset2 && !(parent2 instanceof KtBlockExpression)) {
            if (klass2.isInstance(parent2)) {
                lastElementOfType = parent2;
            }
            element3 = parent2;
        }
        return (T)lastElementOfType;
    }

    public static enum ElementKind {
        EXPRESSION,
        TYPE_ELEMENT,
        TYPE_CONSTRUCTOR;

    }
}

