/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.ui;

import com.intellij.ProjectTopics;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinNotificationManagerKt;
import org.jetbrains.kotlin.idea.configuration.ui.KotlinConfigurationCheckerComponent;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.versions.OutdatedKotlinRuntimeCheckerKt;
import org.jetbrains.kotlin.idea.versions.VersionedLibrary;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\fR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0012\u0010\b\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/KotlinConfigurationCheckerComponent;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "isSyncing", "", "()Z", "notificationPostponed", "syncDepth", "Ljava/util/concurrent/atomic/AtomicInteger;", "projectOpened", "", "syncDone", "syncStarted", "Companion", "idea"})
public final class KotlinConfigurationCheckerComponent
extends AbstractProjectComponent {
    private final AtomicInteger syncDepth;
    private volatile boolean notificationPostponed;
    @NotNull
    private static final String CONFIGURE_NOTIFICATION_GROUP_ID = "Configure Kotlin in Project";
    public static final Companion Companion = new Companion(null);

    public void projectOpened() {
        super.projectOpened();
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity(new Runnable(this){
            final /* synthetic */ KotlinConfigurationCheckerComponent this$0;

            public final void run() {
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this){
                    final /* synthetic */ projectOpened.1 this$0;

                    public final void run() {
                        DumbService.getInstance((Project)KotlinConfigurationCheckerComponent.access$getMyProject$p(this.this$0.this$0)).waitForSmartMode();
                        Project project = KotlinConfigurationCheckerComponent.access$getMyProject$p(this.this$0.this$0);
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myProject");
                        for (Module module : ConfigureKotlinInProjectUtilsKt.getModulesWithKotlinFiles(project)) {
                            PlatformKt.getAndCacheLanguageLevelByDependencies(module);
                        }
                        Project project2 = KotlinConfigurationCheckerComponent.access$getMyProject$p(this.this$0.this$0);
                        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"myProject");
                        List<VersionedLibrary> libraries = OutdatedKotlinRuntimeCheckerKt.findOutdatedKotlinLibraries(project2);
                        if (!libraries.isEmpty()) {
                            ApplicationManager.getApplication().invokeLater(new Runnable(this, libraries){
                                final /* synthetic */ projectOpened.1 this$0;
                                final /* synthetic */ List $libraries;

                                public final void run() {
                                    Project project = KotlinConfigurationCheckerComponent.access$getMyProject$p(this.this$0.this$0.this$0);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myProject");
                                    OutdatedKotlinRuntimeCheckerKt.notifyOutdatedKotlinRuntime(project, this.$libraries);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$libraries = list2;
                                }
                            });
                        }
                        if (!this.this$0.this$0.isSyncing()) {
                            List<Module> excludeModules = OutdatedKotlinRuntimeCheckerKt.collectModulesWithOutdatedRuntime(libraries);
                            Project project3 = KotlinConfigurationCheckerComponent.access$getMyProject$p(this.this$0.this$0);
                            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"myProject");
                            ConfigureKotlinInProjectUtilsKt.showConfigureKotlinNotificationIfNeeded(project3, excludeModules);
                        } else {
                            KotlinConfigurationCheckerComponent.access$setNotificationPostponed$p(this.this$0.this$0, true);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = kotlinConfigurationCheckerComponent;
            }
        });
    }

    public final boolean isSyncing() {
        return this.syncDepth.get() > 0;
    }

    public final void syncStarted() {
        this.syncDepth.incrementAndGet();
    }

    public final void syncDone() {
        this.syncDepth.decrementAndGet();
    }

    public KotlinConfigurationCheckerComponent(final @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(project);
        this.syncDepth = new AtomicInteger();
        NotificationsConfiguration.getNotificationsConfiguration().register(Companion.getCONFIGURE_NOTIFICATION_GROUP_ID(), NotificationDisplayType.STICKY_BALLOON, true);
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@Nullable ModuleRootEvent event) {
                if (notificationPostponed && !this.isSyncing()) {
                    ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this){
                        final /* synthetic */ 1 this$0;

                        public final void run() {
                            DumbService.getInstance((Project)KotlinConfigurationCheckerComponent.access$getMyProject$p(this.this$0.this)).waitForSmartMode();
                            if (!this.this$0.this.isSyncing()) {
                                KotlinConfigurationCheckerComponent.access$setNotificationPostponed$p(this.this$0.this, false);
                                Project project = KotlinConfigurationCheckerComponent.access$getMyProject$p(this.this$0.this);
                                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myProject");
                                Project project2 = KotlinConfigurationCheckerComponent.access$getMyProject$p(this.this$0.this);
                                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"myProject");
                                ConfigureKotlinInProjectUtilsKt.showConfigureKotlinNotificationIfNeeded(project, OutdatedKotlinRuntimeCheckerKt.collectModulesWithOutdatedRuntime(OutdatedKotlinRuntimeCheckerKt.findOutdatedKotlinLibraries(project2)));
                            }
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                ConfigureKotlinNotificationManagerKt.checkHideNonConfiguredNotifications(project);
            }
        });
    }

    static {
        CONFIGURE_NOTIFICATION_GROUP_ID = CONFIGURE_NOTIFICATION_GROUP_ID;
    }

    public static final /* synthetic */ Project access$getMyProject$p(KotlinConfigurationCheckerComponent $this) {
        return $this.myProject;
    }

    public static final /* synthetic */ void access$setNotificationPostponed$p(KotlinConfigurationCheckerComponent $this, boolean bl) {
        $this.notificationPostponed = bl;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/KotlinConfigurationCheckerComponent$Companion;", "", "()V", "CONFIGURE_NOTIFICATION_GROUP_ID", "", "getCONFIGURE_NOTIFICATION_GROUP_ID", "()Ljava/lang/String;", "getInstance", "Lorg/jetbrains/kotlin/idea/configuration/ui/KotlinConfigurationCheckerComponent;", "project", "Lcom/intellij/openapi/project/Project;", "idea"})
    public static final class Companion {
        @NotNull
        public final String getCONFIGURE_NOTIFICATION_GROUP_ID() {
            return CONFIGURE_NOTIFICATION_GROUP_ID;
        }

        @NotNull
        public final KotlinConfigurationCheckerComponent getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = project.getComponent(KotlinConfigurationCheckerComponent.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.getComponent(Kot\u2026kerComponent::class.java)");
            return (KotlinConfigurationCheckerComponent)((Object)object);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

