/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.editor.KotlinSmartEnterHandler;
import org.jetbrains.kotlin.idea.editor.fixers.FixersUtilKt;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/editor/fixers/KotlinClassBodyFixer;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$Fixer;", "Lorg/jetbrains/kotlin/idea/editor/KotlinSmartEnterHandler;", "()V", "apply", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "processor", "psiElement", "Lcom/intellij/psi/PsiElement;", "idea"})
public final class KotlinClassBodyFixer
extends SmartEnterProcessorWithFixers.Fixer<KotlinSmartEnterHandler> {
    public void apply(@NotNull Editor editor, @NotNull KotlinSmartEnterHandler processor2, @NotNull PsiElement psiElement2) {
        KtClassBody body2;
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)psiElement2, (String)"psiElement");
        if (!(psiElement2 instanceof KtClassOrObject)) {
            return;
        }
        KtClassBody ktClassBody = body2 = ((KtClassOrObject)psiElement2).getBody();
        CharSequence charSequence = ktClassBody != null ? ktClassBody.getText() : null;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            return;
        }
        int endOffset = FixersUtilKt.getEnd(FixersUtilKt.getRange(psiElement2));
        if (body2 != null) {
            PsiElement psiElement3 = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments$default((PsiElement)body2, false, 1, null);
            if (psiElement3 != null) {
                PsiElement psiElement4;
                PsiElement it = psiElement4 = psiElement3;
                endOffset = PsiUtilsKt.getEndOffset(it);
            }
        }
        editor.getCaretModel().moveToOffset(endOffset - 1);
        editor.getDocument().insertString(endOffset, (CharSequence)"{\n}");
    }
}

