/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.ProgressUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.core.CollectingNameValidator;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.core.NewDeclarationNameValidator;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.intentions.AbstractProcessableUsageInfo;
import org.jetbrains.kotlin.idea.intentions.ConvertFunctionTypeReceiverToParameterIntention;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.refactoring.CallableRefactoring;
import org.jetbrains.kotlin.idea.refactoring.CallableRefactoringKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.references.KtSimpleReference;
import org.jetbrains.kotlin.idea.search.usagesSearch.UtilsKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtFunctionNotStubbed;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtFunctionTypeReceiver;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.resolvedCallUtil.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005\u000f\u0010\u0011\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u0002H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "startInWriteAction", "", "getConversionData", "Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$ConversionData;", "ConversionData", "Converter", "FunctionDefinitionInfo", "LambdaInfo", "ParameterCallInfo", "idea"})
public final class ConvertFunctionTypeReceiverToParameterIntention
extends SelfTargetingRangeIntention<KtTypeReference> {
    private final ConversionData getConversionData(@NotNull KtTypeReference $receiver) {
        PsiElement psiElement2 = $receiver.getParent();
        if (!(psiElement2 instanceof KtFunctionTypeReceiver)) {
            psiElement2 = null;
        }
        KtFunctionTypeReceiver ktFunctionTypeReceiver = (KtFunctionTypeReceiver)psiElement2;
        if (ktFunctionTypeReceiver == null) {
            return null;
        }
        KtFunctionTypeReceiver functionTypeReceiver = ktFunctionTypeReceiver;
        PsiElement psiElement3 = functionTypeReceiver.getParent();
        if (!(psiElement3 instanceof KtFunctionType)) {
            psiElement3 = null;
        }
        KtFunctionType ktFunctionType = (KtFunctionType)psiElement3;
        if (ktFunctionType == null) {
            return null;
        }
        KtFunctionType functionType2 = ktFunctionType;
        KotlinType kotlinType = BindingContextUtilsKt.getAbbreviatedTypeOrType(functionType2, ResolutionUtils.analyze(functionType2, BodyResolveMode.PARTIAL));
        if (kotlinType == null || (kotlinType = FunctionTypesKt.getReceiverTypeFromFunctionType(kotlinType)) == null) {
            return null;
        }
        KotlinType lambdaReceiverType = kotlinType;
        PsiElement psiElement4 = functionType2.getParent();
        if (!(psiElement4 instanceof KtTypeReference)) {
            psiElement4 = null;
        }
        KtTypeReference ktTypeReference = (KtTypeReference)psiElement4;
        Object object = ktTypeReference != null ? ktTypeReference.getParent() : null;
        if (!(object instanceof KtParameter)) {
            object = null;
        }
        KtParameter ktParameter = (KtParameter)object;
        if (ktParameter == null) {
            return null;
        }
        KtParameter containingParameter = ktParameter;
        KtDeclarationWithBody ktDeclarationWithBody = containingParameter.getOwnerFunction();
        if (!(ktDeclarationWithBody instanceof KtFunction)) {
            ktDeclarationWithBody = null;
        }
        KtFunction ktFunction = (KtFunction)ktDeclarationWithBody;
        if (ktFunction == null) {
            return null;
        }
        KtFunction ownerFunction = ktFunction;
        int functionParameterIndex = ownerFunction.getValueParameters().indexOf(containingParameter);
        return new ConversionData(functionParameterIndex, lambdaReceiverType, ownerFunction);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtTypeReference element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        ConversionData conversionData = this.getConversionData(element3);
        if (conversionData == null) {
            return null;
        }
        ConversionData data = conversionData;
        KtTypeReference ktTypeReference = data.getFunction().getValueParameters().get(data.getFunctionParameterIndex()).getTypeReference();
        if (ktTypeReference == null) {
            Intrinsics.throwNpe();
        }
        KtTypeElement ktTypeElement = ktTypeReference.getTypeElement();
        if (ktTypeElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunctionType");
        }
        KtFunctionType elementBefore = (KtFunctionType)ktTypeElement;
        PsiElement psiElement2 = PsiModificationUtilsKt.copied((PsiElement)elementBefore);
        KtFunctionType $receiver = (KtFunctionType)psiElement2;
        KtParameterList ktParameterList = $receiver.getParameterList();
        if (ktParameterList == null) {
            Intrinsics.throwNpe();
        }
        KtParameter ktParameter = KtPsiFactoryKt.KtPsiFactory$default(element3, false, 2, null).createFunctionTypeParameter(element3);
        KtParameterList ktParameterList2 = $receiver.getParameterList();
        if (ktParameterList2 == null) {
            Intrinsics.throwNpe();
        }
        ktParameterList.addParameterBefore(ktParameter, (KtParameter)CollectionsKt.firstOrNull(ktParameterList2.getParameters()));
        TypeRefHelpersKt.setReceiverTypeReference($receiver, null);
        KtFunctionType elementAfter = (KtFunctionType)psiElement2;
        this.setText("Convert '" + elementBefore.getText() + "' to '" + elementAfter.getText() + '\'');
        return element3.getTextRange();
    }

    @Override
    public void applyTo(@NotNull KtTypeReference element3, @Nullable Editor editor) {
        block0: {
            ConversionData conversionData;
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            ConversionData conversionData2 = this.getConversionData(element3);
            if (conversionData2 == null) break block0;
            ConversionData it = conversionData = conversionData2;
            new Converter(it).run();
        }
    }

    public ConvertFunctionTypeReceiverToParameterIntention() {
        super(KtTypeReference.class, "Convert function type receiver to parameter", null, 4, null);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$ConversionData;", "", "functionParameterIndex", "", "lambdaReceiverType", "Lorg/jetbrains/kotlin/types/KotlinType;", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "(ILorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/psi/KtFunction;)V", "getFunction", "()Lorg/jetbrains/kotlin/psi/KtFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getFunctionDescriptor", "()Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "functionDescriptor$delegate", "Lkotlin/Lazy;", "getFunctionParameterIndex", "()I", "getLambdaReceiverType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "idea"})
    public static final class ConversionData {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        @NotNull
        private final Lazy functionDescriptor$delegate;
        private final int functionParameterIndex;
        @NotNull
        private final KotlinType lambdaReceiverType;
        @NotNull
        private final KtFunction function;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ConversionData.class), "functionDescriptor", "getFunctionDescriptor()Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;"))};
        }

        @NotNull
        public final FunctionDescriptor getFunctionDescriptor() {
            Lazy lazy = this.functionDescriptor$delegate;
            ConversionData conversionData = this;
            KProperty kProperty = $$delegatedProperties[0];
            return (FunctionDescriptor)lazy.getValue();
        }

        public final int getFunctionParameterIndex() {
            return this.functionParameterIndex;
        }

        @NotNull
        public final KotlinType getLambdaReceiverType() {
            return this.lambdaReceiverType;
        }

        @NotNull
        public final KtFunction getFunction() {
            return this.function;
        }

        public ConversionData(int functionParameterIndex, @NotNull KotlinType lambdaReceiverType, @NotNull KtFunction function2) {
            Intrinsics.checkParameterIsNotNull((Object)lambdaReceiverType, (String)"lambdaReceiverType");
            Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
            this.functionParameterIndex = functionParameterIndex;
            this.lambdaReceiverType = lambdaReceiverType;
            this.function = function2;
            this.functionDescriptor$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FunctionDescriptor>(this){
                final /* synthetic */ ConversionData this$0;

                @NotNull
                public final FunctionDescriptor invoke() {
                    DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptor$default(this.this$0.getFunction(), null, 1, null);
                    if (declarationDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
                    }
                    return (FunctionDescriptor)declarationDescriptor;
                }
                {
                    this.this$0 = conversionData;
                    super(0);
                }
            }));
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$FunctionDefinitionInfo;", "Lorg/jetbrains/kotlin/idea/intentions/AbstractProcessableUsageInfo;", "Lorg/jetbrains/kotlin/psi/KtFunction;", "Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$ConversionData;", "element", "(Lorg/jetbrains/kotlin/psi/KtFunction;)V", "process", "", "data", "elementsToShorten", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "idea"})
    public static final class FunctionDefinitionInfo
    extends AbstractProcessableUsageInfo<KtFunction, ConversionData> {
        @Override
        public void process(@NotNull ConversionData data, @NotNull List<KtElement> elementsToShorten) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull(elementsToShorten, (String)"elementsToShorten");
            KtFunction ktFunction = (KtFunction)this.getElement();
            if (ktFunction == null) {
                return;
            }
            KtFunction function2 = ktFunction;
            KtParameter ktParameter = (KtParameter)CollectionsKt.getOrNull(function2.getValueParameters(), (int)data.getFunctionParameterIndex());
            if (ktParameter == null) {
                return;
            }
            KtParameter functionParameter = ktParameter;
            KtTypeReference ktTypeReference = functionParameter.getTypeReference();
            KtTypeElement ktTypeElement = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
            if (!(ktTypeElement instanceof KtFunctionType)) {
                ktTypeElement = null;
            }
            KtFunctionType ktFunctionType = (KtFunctionType)ktTypeElement;
            if (ktFunctionType == null) {
                return;
            }
            KtFunctionType functionType2 = ktFunctionType;
            KtParameterList ktParameterList = functionType2.getParameterList();
            if (ktParameterList == null) {
                return;
            }
            KtParameterList functionTypeParameterList = ktParameterList;
            KtTypeReference ktTypeReference2 = functionType2.getReceiverTypeReference();
            if (ktTypeReference2 == null) {
                return;
            }
            KtTypeReference functionTypeReceiver = ktTypeReference2;
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
            KtTypeReference ktTypeReference3 = functionTypeReceiver;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference3, (String)"functionTypeReceiver");
            KtParameter parameterToAdd = ktPsiFactory.createFunctionTypeParameter(ktTypeReference3);
            functionTypeParameterList.addParameterBefore(parameterToAdd, (KtParameter)CollectionsKt.firstOrNull(functionTypeParameterList.getParameters()));
            TypeRefHelpersKt.setReceiverTypeReference(functionType2, null);
        }

        public FunctionDefinitionInfo(@NotNull KtFunction element3) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            super((PsiElement)element3);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$ParameterCallInfo;", "Lorg/jetbrains/kotlin/idea/intentions/AbstractProcessableUsageInfo;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$ConversionData;", "element", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;)V", "process", "", "data", "elementsToShorten", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "idea"})
    public static final class ParameterCallInfo
    extends AbstractProcessableUsageInfo<KtCallExpression, ConversionData> {
        @Override
        public void process(@NotNull ConversionData data, @NotNull List<KtElement> elementsToShorten) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull(elementsToShorten, (String)"elementsToShorten");
            KtCallExpression ktCallExpression = (KtCallExpression)this.getElement();
            if (ktCallExpression == null) {
                return;
            }
            KtCallExpression callExpression2 = ktCallExpression;
            KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector(callExpression2);
            if (ktQualifiedExpression == null) {
                return;
            }
            KtQualifiedExpression qualifiedExpression = ktQualifiedExpression;
            KtExpression receiverExpression = qualifiedExpression.getReceiverExpression();
            KtValueArgumentList argumentList2 = KtPsiUtilKt.getOrCreateValueArgumentList(callExpression2);
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            argumentList2.addArgumentBefore(KtPsiFactory.createArgument$default(new KtPsiFactory(project, false, 2, null), receiverExpression, null, false, 6, null), (KtValueArgument)CollectionsKt.firstOrNull(argumentList2.getArguments()));
            qualifiedExpression.replace((PsiElement)callExpression2);
        }

        public ParameterCallInfo(@NotNull KtCallExpression element3) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            super((PsiElement)element3);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$LambdaInfo;", "Lorg/jetbrains/kotlin/idea/intentions/AbstractProcessableUsageInfo;", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$ConversionData;", "element", "(Lorg/jetbrains/kotlin/psi/KtLambdaExpression;)V", "process", "", "data", "elementsToShorten", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "idea"})
    public static final class LambdaInfo
    extends AbstractProcessableUsageInfo<KtLambdaExpression, ConversionData> {
        /*
         * WARNING - void declaration
         */
        @Override
        public void process(@NotNull ConversionData data, @NotNull List<KtElement> elementsToShorten) {
            void $receiver$iv;
            void $receiver$iv$iv;
            void $receiver$iv2;
            CollectingNameValidator collectingNameValidator;
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull(elementsToShorten, (String)"elementsToShorten");
            KtExpression ktExpression = (KtLambdaExpression)this.getElement();
            if (ktExpression == null || (ktExpression = ((KtLambdaExpression)ktExpression).getFunctionLiteral()) == null) {
                return;
            }
            KtExpression lambda2 = ktExpression;
            BindingContext context = ResolutionUtils.analyze(lambda2, BodyResolveMode.PARTIAL);
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
            Iterable iterable = ((KtFunctionNotStubbed)lambda2).getValueParameters();
            CollectingNameValidator collectingNameValidator2 = collectingNameValidator;
            CollectingNameValidator collectingNameValidator3 = collectingNameValidator;
            void var8_9 = $receiver$iv2;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                String string;
                Object element$iv$iv = element$iv$iv$iv;
                KtParameter it = (KtParameter)element$iv$iv;
                if (it.getName() == null) continue;
                String it$iv$iv = string;
                destination$iv$iv.add(it$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            Collection collection = list2;
            KtBlockExpression ktBlockExpression = ((KtFunctionLiteral)lambda2).getBodyExpression();
            if (ktBlockExpression == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktBlockExpression, (String)"lambda.bodyExpression!!");
            collectingNameValidator2(collection, (Function1<? super String, Boolean>)((Function1)new NewDeclarationNameValidator((PsiElement)ktBlockExpression, null, NewDeclarationNameValidator.Target.VARIABLES, null, 8, null)));
            CollectingNameValidator validator2 = collectingNameValidator3;
            String newParameterName = (String)CollectionsKt.first(KotlinNameSuggester.INSTANCE.suggestNamesByType(data.getLambdaReceiverType(), (Function1<? super String, Boolean>)((Function1)validator2), "p"));
            KtExpression newParameterRefExpression = psiFactory.createExpression(newParameterName);
            destination$iv$iv = (PsiElement)lambda2;
            Function1 action$iv = (Function1)new Function1<KtThisExpression, Unit>(this, context, (KtFunctionLiteral)lambda2, newParameterRefExpression){
                final /* synthetic */ LambdaInfo this$0;
                final /* synthetic */ BindingContext $context;
                final /* synthetic */ KtFunctionLiteral $lambda;
                final /* synthetic */ KtExpression $newParameterRefExpression;

                public final void invoke(@NotNull KtThisExpression it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.$context.get(BindingContext.REFERENCE_TARGET, it.getInstanceReference());
                    if (declarationDescriptor == null) {
                        return;
                    }
                    DeclarationDescriptor thisTarget = declarationDescriptor;
                    Project project = this.this$0.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                    DeclarationDescriptor declarationDescriptor2 = thisTarget;
                    Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor2, (String)"thisTarget");
                    if (Intrinsics.areEqual((Object)DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project, declarationDescriptor2), (Object)this.$lambda)) {
                        it.replace((PsiElement)this.$newParameterRefExpression);
                    }
                }
                {
                    this.this$0 = lambdaInfo;
                    this.$context = bindingContext2;
                    this.$lambda = ktFunctionLiteral;
                    this.$newParameterRefExpression = ktExpression;
                    super(1);
                }
            };
            void $receiver$iv$iv2 = $receiver$iv;
            $receiver$iv$iv2.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $captured_local_variable$1;
                }

                public void visitElement(@NotNull PsiElement element3) {
                    Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                    PsiElement it = element3;
                    super.visitElement(element3);
                    if (element3 instanceof KtThisExpression) {
                        this.$action.invoke((Object)element3);
                    }
                }
            });
            KtParameterList lambdaParameterList = KtPsiUtilKt.getOrCreateParameterList((KtFunctionLiteral)lambda2);
            KtParameter parameterToAdd = (KtParameter)CollectionsKt.first(psiFactory.createLambdaParameterList(newParameterName).getParameters());
            lambdaParameterList.addParameterBefore(parameterToAdd, (KtParameter)CollectionsKt.firstOrNull(lambdaParameterList.getParameters()));
        }

        public LambdaInfo(@NotNull KtLambdaExpression element3) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            super((PsiElement)element3);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0014J,\u0010\n\u001a\u00020\u00072\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0016\u0010\r\u001a\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00040\u000f0\u000eH\u0002J(\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0016\u0010\r\u001a\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00040\u000f0\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$Converter;", "Lorg/jetbrains/kotlin/idea/refactoring/CallableRefactoring;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "data", "Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$ConversionData;", "(Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention;Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$ConversionData;)V", "performRefactoring", "", "descriptorsForChange", "", "processExternalUsage", "ref", "Lorg/jetbrains/kotlin/idea/references/KtSimpleReference;", "usages", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/idea/intentions/AbstractProcessableUsageInfo;", "processInternalUsages", "callable", "Lorg/jetbrains/kotlin/psi/KtFunction;", "idea"})
    private final class Converter
    extends CallableRefactoring<CallableDescriptor> {
        private final ConversionData data;

        @Override
        protected void performRefactoring(@NotNull Collection<? extends CallableDescriptor> descriptorsForChange) {
            Intrinsics.checkParameterIsNotNull(descriptorsForChange, (String)"descriptorsForChange");
            List<PsiElement> callables = CallableRefactoringKt.getAffectedCallables(this.getProject(), descriptorsForChange);
            MultiMap conflicts2 = new MultiMap();
            ArrayList usages2 = new ArrayList();
            ProgressUtilKt.runSynchronouslyWithProgress(this.getProject(), "Looking for usages and conflicts...", true, (Function0)new Function0<Unit>(this, callables, conflicts2, usages2){
                final /* synthetic */ Converter this$0;
                final /* synthetic */ List $callables;
                final /* synthetic */ MultiMap $conflicts;
                final /* synthetic */ ArrayList $usages;

                public final void invoke() {
                    ApplicationUtilsKt.runReadAction((Function0)new Function0<Unit>(this){
                        final /* synthetic */ performRefactoring.1 this$0;

                        public final void invoke() {
                            double progressStep = 1.0 / (double)this.this$0.$callables.size();
                            for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)this.this$0.$callables)) {
                                int i = indexedValue.component1();
                                PsiElement callable2 = (PsiElement)indexedValue.component2();
                                ProgressManager.getInstance().getProgressIndicator().setFraction((double)(i + 1) * progressStep);
                                if (!(callable2 instanceof KtFunction)) continue;
                                if (!Converter.access$checkModifiable(this.this$0.this$0, callable2)) {
                                    String renderedCallable = StringsKt.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)callable2, (boolean)true));
                                    this.this$0.$conflicts.putValue((Object)callable2, (Object)("Can't modify " + renderedCallable));
                                }
                                for (PsiReference ref : UtilsKt.searchReferencesOrMethodReferences(callable2)) {
                                    if (!(ref instanceof KtSimpleReference)) continue;
                                    Converter.access$processExternalUsage(this.this$0.this$0, (KtSimpleReference)ref, this.this$0.$usages);
                                }
                                Collection collection = this.this$0.$usages;
                                Object object = new FunctionDefinitionInfo((KtFunction)callable2);
                                collection.add(object);
                                Converter.access$processInternalUsages(this.this$0.this$0, (KtFunction)callable2, this.this$0.$usages);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    });
                }
                {
                    this.this$0 = converter;
                    this.$callables = list2;
                    this.$conflicts = multiMap;
                    this.$usages = arrayList;
                    super(0);
                }
            });
            KotlinRefactoringUtilKt.checkConflictsInteractively$default(this.getProject(), conflicts2, null, (Function0)new Function0<Unit>(this, usages2){
                final /* synthetic */ Converter this$0;
                final /* synthetic */ ArrayList $usages;

                public final void invoke() {
                    ApplicationUtilsKt.executeWriteCommand(this.this$0.getProject(), this.this$0.ConvertFunctionTypeReceiverToParameterIntention.this.getText(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ performRefactoring.2 this$0;

                        public final void invoke() {
                            ArrayList<E> elementsToShorten = new ArrayList<E>();
                            Iterable $receiver$iv = this.this$0.$usages;
                            for (T element$iv : $receiver$iv) {
                                AbstractProcessableUsageInfo it = (AbstractProcessableUsageInfo)((Object)element$iv);
                                it.process(Converter.access$getData$p(this.this$0.this$0), (List<KtElement>)elementsToShorten);
                            }
                            ShortenReferences.process$default(ShortenReferences.DEFAULT, elementsToShorten, null, 2, null);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                }
                {
                    this.this$0 = converter;
                    this.$usages = arrayList;
                    super(0);
                }
            }, 2, null);
        }

        /*
         * WARNING - void declaration
         */
        private final void processExternalUsage(KtSimpleReference<?> ref, ArrayList<AbstractProcessableUsageInfo<?, ConversionData>> usages2) {
            Object object;
            Object it;
            void $receiver$iv;
            PsiElement psiElement2 = ref.getElement();
            Function1 branch$iv = processExternalUsage.callElement.1.INSTANCE;
            boolean strict$iv = false;
            void $receiver$iv$iv = $receiver$iv;
            PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv$iv, KtCallElement.class, (boolean)strict$iv);
            KtCallElement ktCallElement = (KtCallElement)(psiElement3 != null ? PsiUtilsKt.getIfChildIsInBranch(psiElement3, (PsiElement)$receiver$iv, branch$iv) : null);
            if (ktCallElement == null) {
                return;
            }
            KtCallElement callElement2 = ktCallElement;
            BindingContext context = ResolutionUtils.analyze(callElement2, BodyResolveMode.PARTIAL);
            Object object2 = (ValueArgument)CollectionsKt.singleOrNull(ResolvedCallUtilKt.getArgumentByParameterIndex(callElement2, this.data.getFunctionParameterIndex(), context));
            if (object2 == null || (object2 = object2.getArgumentExpression()) == null || (object2 = KtPsiUtil.safeDeparenthesize((KtExpression)(it = (object = object2)))) == null) {
                return;
            }
            Object expressionToProcess = object2;
            if (expressionToProcess instanceof KtLambdaExpression) {
                object = usages2;
                LambdaInfo lambdaInfo = new LambdaInfo((KtLambdaExpression)expressionToProcess);
                object.add(lambdaInfo);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processInternalUsages(KtFunction callable2, ArrayList<AbstractProcessableUsageInfo<?, ConversionData>> usages2) {
            KtElement body2;
            KtElement ktElement;
            KtFunction ktFunction = callable2;
            if (ktFunction instanceof KtConstructor) {
                KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(callable2);
                ktElement = ktClassOrObject != null ? ktClassOrObject.getBody() : null;
            } else {
                ktElement = body2 = (KtElement)callable2.getBodyExpression();
            }
            if (body2 != null) {
                KtParameter ktParameter = (KtParameter)CollectionsKt.getOrNull(callable2.getValueParameters(), (int)this.data.getFunctionParameterIndex());
                if (ktParameter == null) {
                    return;
                }
                KtParameter functionParameter = ktParameter;
                for (PsiReference ref : ReferencesSearch.search((PsiElement)functionParameter, (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)body2)))) {
                    KtCallExpression callExpression2;
                    void $receiver$iv;
                    KtSimpleNameExpression element3;
                    PsiElement psiElement2 = ref.getElement();
                    if (!(psiElement2 instanceof KtSimpleNameExpression)) {
                        psiElement2 = null;
                    }
                    if ((KtSimpleNameExpression)psiElement2 == null) {
                        continue;
                    }
                    Object object = (PsiElement)element3;
                    Function1 branch$iv = processInternalUsages.callExpression.1.INSTANCE;
                    boolean strict$iv = false;
                    void $receiver$iv$iv = $receiver$iv;
                    PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv$iv, KtCallExpression.class, (boolean)strict$iv);
                    if ((KtCallExpression)(psiElement3 != null ? PsiUtilsKt.getIfChildIsInBranch(psiElement3, (PsiElement)$receiver$iv, branch$iv) : null) == null) {
                        continue;
                    }
                    object = usages2;
                    ParameterCallInfo parameterCallInfo = new ParameterCallInfo(callExpression2);
                    object.add(parameterCallInfo);
                }
            }
        }

        public Converter(ConversionData data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Project project = data.getFunction().getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"data.function.project");
            super(project, (CallableDescriptor)data.getFunctionDescriptor(), ConvertFunctionTypeReceiverToParameterIntention.this.getText());
            this.data = data;
        }

        public static final /* synthetic */ boolean access$checkModifiable(Converter $this, @NotNull PsiElement element3) {
            return $this.checkModifiable(element3);
        }

        public static final /* synthetic */ void access$processExternalUsage(Converter $this, @NotNull KtSimpleReference ref, @NotNull ArrayList usages2) {
            $this.processExternalUsage(ref, usages2);
        }

        public static final /* synthetic */ void access$processInternalUsages(Converter $this, @NotNull KtFunction callable2, @NotNull ArrayList usages2) {
            $this.processInternalUsages(callable2, usages2);
        }

        @NotNull
        public static final /* synthetic */ ConversionData access$getData$p(Converter $this) {
            return $this.data;
        }
    }
}

